/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import de.malban.gui.components.ModalInternalFrame;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ModalPanel
extends JPanel {
    public static boolean isModal = false;
    JGlassPanel glass = new JGlassPanel();
    Component oldGlass = null;
    protected JRootPane rootPane;
    protected Component desktop;
    ActionListener al = null;
    Container cpane = null;

    protected ModalPanel() {
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        super.setVisible(false);
        this.setBackground(new Color(0, 0, 0, 0));
    }

    public void setEnvironment(JRootPane r, Component d) {
        this.rootPane = r;
        this.desktop = d;
    }

    public ModalPanel(JRootPane r, Component d) {
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        super.setVisible(false);
        this.setBackground(new Color(0, 0, 0, 0));
        this.rootPane = r;
        this.desktop = d;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }

    void repair(Container c) {
        if (c instanceof Container) {
            for (int j = 0; j < c.getComponentCount(); ++j) {
                Component mc = c.getComponent(j);
                this.repair((Container)mc);
            }
        }
        if (c instanceof JComboBox) {
            JComboBox cbo = (JComboBox)c;
            cbo.setLightWeightPopupEnabled(false);
            try {
                Class<?> cls = Class.forName("javax.swing.PopupFactory");
                Field field = cls.getDeclaredField("forceHeavyWeightPopupKey");
                field.setAccessible(true);
                cbo.putClientProperty(field.get(null), Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isCombo(Object s) {
        if (!(s instanceof Component)) {
            return false;
        }
        Component p = (Component)s;
        do {
            if (!(p instanceof JComboBox)) continue;
            return true;
        } while ((p = p.getParent()) != null);
        return false;
    }

    public void init(JRootPane rootPane, Component desktop) {
        this.repair(this);
        this.initGlass();
        this.cpane = this;
        this.al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String test;
                JButton b;
                boolean exit = true;
                if (ModalPanel.this.isCombo(evt.getSource())) {
                    exit = false;
                }
                if (evt.getSource() instanceof JButton && (b = (JButton)evt.getSource()) != null && b.getAction() != null && (test = b.getAction().toString()).toUpperCase().indexOf("PARENT") != -1) {
                    exit = false;
                }
                if (exit) {
                    ModalPanel.this.setVisible(false);
                    ModalPanel.this.glass.setVisible(false);
                    ModalPanel.this.setButtonListener(ModalPanel.this, this, false);
                }
            }
        };
        this.setButtonListener(this, this.al, true);
        this.putClientProperty("JInternalFrame.frameType", "optionDialog");
        Dimension size = this.getPreferredSize();
        Dimension rootSize = desktop.getSize();
        super.setBounds(this.getBounds().x, this.getBounds().y, size.width, size.height);
        desktop.validate();
        this.glass.add(this);
        this.oldGlass = rootPane.getGlassPane();
        rootPane.setGlassPane(this.glass);
        this.glass.setVisible(true);
    }

    void setButtonListener(Component c, ActionListener al, boolean set) {
        if (c instanceof JButton) {
            if (set) {
                ((JButton)c).addActionListener(al);
            } else {
                ((JButton)c).removeActionListener(al);
            }
        } else if (c instanceof Container) {
            for (int j = 0; j < ((Container)c).getComponentCount(); ++j) {
                Component mc = ((Container)c).getComponent(j);
                if (!(mc instanceof Container)) continue;
                this.setButtonListener(mc, al, set);
            }
        }
    }

    private void initGlass() {
        this.glass.setLayout(null);
        this.glass.setOpaque(false);
        this.glass.setName("JPortalGlass");
        MouseInputAdapter adapter = new MouseInputAdapter(){};
        this.glass.addMouseListener(adapter);
        this.glass.addMouseMotionListener(adapter);
    }

    @Override
    public void setVisible(boolean value) {
        if (this.rootPane == null) {
            return;
        }
        if (this.desktop == null) {
            return;
        }
        super.setVisible(value);
        if (value) {
            this.init(this.rootPane, this.desktop);
            this.invalidate();
            this.updateUI();
            this.validate();
            this.repaint();
            this.desktop.invalidate();
            this.desktop.validate();
            this.desktop.repaint();
            this.startModal();
        } else {
            this.stopModal();
            if (this.cpane != null && this.al != null) {
                this.setButtonListener(this.cpane, this.al, false);
            }
            if (this.glass != null) {
                this.glass.setVisible(false);
            }
            if (this.rootPane != null) {
                if (this.oldGlass != null) {
                    this.rootPane.setGlassPane(this.oldGlass);
                    if (this.oldGlass instanceof JGlassPanel) {
                        this.oldGlass.setVisible(true);
                    } else if (this.oldGlass.getName() != null && this.oldGlass.getName().equals("JPortalGlass")) {
                        this.oldGlass.setVisible(true);
                    } else {
                        this.rootPane.setGlassPane(this.oldGlass);
                    }
                } else {
                    this.rootPane.setGlassPane(this.oldGlass);
                }
            }
        }
    }

    private synchronized void startModal() {
        try {
            if (!isModal) {
                ++ModalInternalFrame.isModalCount;
            }
            isModal = true;
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = this.getToolkit().getSystemEventQueue();
                while (this.isVisible()) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object source = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (source instanceof MenuComponent) {
                        ((MenuComponent)source).dispatchEvent(event);
                        continue;
                    }
                    System.err.println("Unable to dispatch: " + event);
                }
            } else {
                while (this.isVisible()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void stopModal() {
        if (isModal) {
            --ModalInternalFrame.isModalCount;
        }
        isModal = false;
        this.notifyAll();
    }

    class JGlassPanel
    extends JPanel {
        JGlassPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Point myLoc = this.getLocationOnScreen();
            JRootPane startPoint = SwingUtilities.getRootPane(this);
            Point startLoc = startPoint.getLocationOnScreen();
            int dx = startLoc.x - myLoc.x;
            int dy = startLoc.y - myLoc.y;
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(dx, dy);
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            this.paintPopupMenus(rootPane, rootPane, g2d);
            g2d.dispose();
        }

        public void paintPopupMenus(JRootPane rootPane, Component comp, Graphics g) {
            JPopupMenu jpm;
            if (comp instanceof JPopupMenu && (jpm = (JPopupMenu)comp).isShowing() && jpm.isVisible()) {
                Graphics2D g2d = (Graphics2D)g.create();
                Point rootPaneLoc = rootPane.getLocationOnScreen();
                Point popupLoc = jpm.getLocationOnScreen();
                g2d.translate(popupLoc.x - rootPaneLoc.x, popupLoc.y - rootPaneLoc.y);
                jpm.paint(g2d);
                g2d.dispose();
            }
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                for (int i = 0; i < cont.getComponentCount(); ++i) {
                    this.paintPopupMenus(rootPane, cont.getComponent(i), g);
                }
            }
        }
    }
}

