/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import de.malban.Global;
import de.malban.gui.components.TableStateDataXMLHandler;
import de.malban.util.UtilityString;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class TableStateData {
    protected String mClass = "";
    protected String mName = "";
    protected Vector<Boolean> mColumnEnabled = new Vector();
    protected Vector<Integer> mColumnOrgNo = new Vector();
    protected Vector<Integer> mColumnViewNo = new Vector();
    protected Vector<Integer> mColumnWidth = new Vector();
    protected Vector<String> mColumnName = new Vector();
    protected String munused = "";
    private static TableStateDataXMLHandler XMLHANDLER = new TableStateDataXMLHandler();

    public Vector<Boolean> getColumnEnabled() {
        return this.mColumnEnabled;
    }

    public void setColumnEnabled(Vector<Boolean> ColumnEnabled) {
        this.mColumnEnabled = ColumnEnabled;
    }

    public Vector<Integer> getColumnOrgNo() {
        return this.mColumnOrgNo;
    }

    public void setColumnOrgNo(Vector<Integer> ColumnOrgNo) {
        this.mColumnOrgNo = ColumnOrgNo;
    }

    public Vector<Integer> getColumnViewNo() {
        return this.mColumnViewNo;
    }

    public void setColumnViewNo(Vector<Integer> ColumnViewNo) {
        this.mColumnViewNo = ColumnViewNo;
    }

    public Vector<Integer> getColumnWidth() {
        return this.mColumnWidth;
    }

    public void setColumnWidth(Vector<Integer> ColumnWidth) {
        this.mColumnWidth = ColumnWidth;
    }

    public Vector<String> getColumnName() {
        return this.mColumnName;
    }

    public void setColumnName(Vector<String> ColumnName) {
        this.mColumnName = ColumnName;
    }

    public String getunused() {
        return this.munused;
    }

    public void setunused(String unused) {
        this.munused = unused;
    }

    private String exportXML() {
        int i;
        String s = new String();
        s = s + "\t<TableStateData>\n";
        s = s + "\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n";
        s = s + "\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n";
        s = s + "\t\t<COLUMNENABLEDs>\n";
        for (i = 0; i < this.mColumnEnabled.size(); ++i) {
            s = s + "\t\t\t<COLUMNENABLED>" + this.mColumnEnabled.elementAt(i) + "</COLUMNENABLED>\n";
        }
        s = s + "\t\t</COLUMNENABLEDs>\n";
        s = s + "\t\t<COLUMNORGNOs>\n";
        for (i = 0; i < this.mColumnOrgNo.size(); ++i) {
            s = s + "\t\t\t<COLUMNORGNO>" + this.mColumnOrgNo.elementAt(i) + "</COLUMNORGNO>\n";
        }
        s = s + "\t\t</COLUMNORGNOs>\n";
        s = s + "\t\t<COLUMNVIEWNOs>\n";
        for (i = 0; i < this.mColumnViewNo.size(); ++i) {
            s = s + "\t\t\t<COLUMNVIEWNO>" + this.mColumnViewNo.elementAt(i) + "</COLUMNVIEWNO>\n";
        }
        s = s + "\t\t</COLUMNVIEWNOs>\n";
        s = s + "\t\t<COLUMNWIDTHs>\n";
        for (i = 0; i < this.mColumnWidth.size(); ++i) {
            s = s + "\t\t\t<COLUMNWIDTH>" + this.mColumnWidth.elementAt(i) + "</COLUMNWIDTH>\n";
        }
        s = s + "\t\t</COLUMNWIDTHs>\n";
        s = s + "\t\t<COLUMNNAMEs>\n";
        for (i = 0; i < this.mColumnName.size(); ++i) {
            s = s + "\t\t\t<COLUMNNAME>" + UtilityString.toXML(this.mColumnName.elementAt(i)) + "</COLUMNNAME>\n";
        }
        s = s + "\t\t</COLUMNNAMEs>\n";
        s = s + "\t\t<unused>" + UtilityString.toXML(this.munused) + "</unused>\n";
        s = s + "\t</TableStateData>\n";
        return s;
    }

    public String toString() {
        return this.mName;
    }

    public static TableStateDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<TableStateData> col) {
        try {
            PrintWriter pw = new PrintWriter(Global.mBaseDir + filename);
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllTableStateData>\n");
            for (TableStateData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllTableStateData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, TableStateData> getHashMapFromXML(String filename) {
        HashMap<String, TableStateData> filters = new HashMap<String, TableStateData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            TableStateDataXMLHandler h = TableStateData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "TableStateData Load Error...", 1);
        }
        return filters;
    }
}

