/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.components;

import de.malban.Global;
import de.malban.gui.components.TableStateData;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class TableStateDataPool {
    public static final String DEFAULT_XML_NAME = new String("TableStateData.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, TableStateData> mTableStateData = new HashMap();
    private HashMap<String, String> mKlassenMap = new HashMap();

    public TableStateDataPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public TableStateDataPool() {
        this.init();
    }

    public void setFilename(String n) {
        this.mFileName = n;
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Load Error TableStateData...", 1);
            return false;
        }
    }

    public boolean load() {
        File f = new File(Global.mBaseDir + this.mFileName);
        if (!f.exists()) {
            return false;
        }
        this.mTableStateData = TableStateData.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        TableStateData.saveCollectionAsXML(this.mFileName, this.mTableStateData.values());
        this.buildKlassenMap();
    }

    public void remove(TableStateData st) {
        this.mTableStateData.remove(st.mName);
    }

    public void put(TableStateData st) {
        this.mTableStateData.remove(st.mName);
        this.mTableStateData.put(st.mName, st);
    }

    public void putAsNew(TableStateData st) {
        this.mTableStateData.put(st.mName, st);
    }

    public TableStateData get(String key) {
        return this.mTableStateData.get(key);
    }

    public HashMap<String, TableStateData> getHashMap() {
        return this.mTableStateData;
    }

    private void buildKlassenMap() {
        this.mKlassenMap = new HashMap();
        Set<Map.Entry<String, TableStateData>> entries = this.mTableStateData.entrySet();
        for (Map.Entry<String, TableStateData> entry : entries) {
            TableStateData value = entry.getValue();
            this.mKlassenMap.put(value.mClass, value.mClass);
        }
    }

    public HashMap<String, String> getKlassenHashMap() {
        this.buildKlassenMap();
        return this.mKlassenMap;
    }

    public HashMap<String, TableStateData> getMapForKlasse(String klasse) {
        HashMap<String, TableStateData> ret = new HashMap<String, TableStateData>();
        Set<Map.Entry<String, TableStateData>> entries = this.mTableStateData.entrySet();
        for (Map.Entry<String, TableStateData> entry : entries) {
            TableStateData value = entry.getValue();
            if (!value.mClass.equalsIgnoreCase(klasse)) continue;
            ret.put(value.mName, value);
        }
        return ret;
    }
}

