/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class FontChooserComponent
extends JComponent {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    private static final Font DEFAULT_SELECTED_FONT = new Font("Serif", 0, 12);
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 10);
    private static final int[] FONT_STYLE_CODES = new int[]{0, 1, 2, 3};
    private static final String[] DEFAULT_FONT_SIZE_STRINGS = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    protected int dialogResultValue = -1;
    private String[] fontStyleNames = null;
    private String[] fontFamilyNames = null;
    private String[] fontSizeStrings = null;
    private JTextField fontFamilyTextField = null;
    private JTextField fontStyleTextField = null;
    private JTextField fontSizeTextField = null;
    private JList fontNameList = null;
    private JList fontStyleList = null;
    private JList fontSizeList = null;
    private JPanel fontNamePanel = null;
    private JPanel fontStylePanel = null;
    private JPanel fontSizePanel = null;
    private JPanel samplePanel = null;
    private JTextField sampleText = null;

    public FontChooserComponent() {
        this(DEFAULT_FONT_SIZE_STRINGS);
    }

    public void setSizeEnabled(boolean b) {
        this.fontSizeTextField.setEnabled(b);
        this.fontSizeList.setEnabled(b);
    }

    public FontChooserComponent(String[] fontSizeStrings) {
        if (fontSizeStrings == null) {
            fontSizeStrings = DEFAULT_FONT_SIZE_STRINGS;
        }
        this.fontSizeStrings = fontSizeStrings;
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new BoxLayout(selectPanel, 0));
        selectPanel.add(this.getFontFamilyPanel());
        selectPanel.add(this.getFontStylePanel());
        selectPanel.add(this.getFontSizePanel());
        JPanel contentsPanel = new JPanel();
        contentsPanel.setLayout(new GridLayout(2, 1));
        contentsPanel.add((Component)selectPanel, "North");
        contentsPanel.add((Component)this.getSamplePanel(), "Center");
        this.setLayout(new BoxLayout(this, 0));
        this.add(contentsPanel);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setSelectedFont(DEFAULT_SELECTED_FONT);
    }

    public JTextField getFontFamilyTextField() {
        if (this.fontFamilyTextField == null) {
            this.fontFamilyTextField = new JTextField();
            this.fontFamilyTextField.addFocusListener(new TextFieldFocusHandlerForTextSelection(this.fontFamilyTextField));
            this.fontFamilyTextField.addKeyListener(new TextFieldKeyHandlerForListSelectionUpDown(this.getFontFamilyList()));
            this.fontFamilyTextField.getDocument().addDocumentListener(new ListSearchTextFieldDocumentHandler(this.getFontFamilyList()));
            this.fontFamilyTextField.setFont(DEFAULT_FONT);
        }
        return this.fontFamilyTextField;
    }

    public JTextField getFontStyleTextField() {
        if (this.fontStyleTextField == null) {
            this.fontStyleTextField = new JTextField();
            this.fontStyleTextField.addFocusListener(new TextFieldFocusHandlerForTextSelection(this.fontStyleTextField));
            this.fontStyleTextField.addKeyListener(new TextFieldKeyHandlerForListSelectionUpDown(this.getFontStyleList()));
            this.fontStyleTextField.getDocument().addDocumentListener(new ListSearchTextFieldDocumentHandler(this.getFontStyleList()));
            this.fontStyleTextField.setFont(DEFAULT_FONT);
        }
        return this.fontStyleTextField;
    }

    public JTextField getFontSizeTextField() {
        if (this.fontSizeTextField == null) {
            this.fontSizeTextField = new JTextField();
            this.fontSizeTextField.addFocusListener(new TextFieldFocusHandlerForTextSelection(this.fontSizeTextField));
            this.fontSizeTextField.addKeyListener(new TextFieldKeyHandlerForListSelectionUpDown(this.getFontSizeList()));
            this.fontSizeTextField.getDocument().addDocumentListener(new ListSearchTextFieldDocumentHandler(this.getFontSizeList()));
            this.fontSizeTextField.setFont(DEFAULT_FONT);
        }
        return this.fontSizeTextField;
    }

    public JList getFontFamilyList() {
        if (this.fontNameList == null) {
            this.fontNameList = new JList<String>(this.getFontFamilies());
            this.fontNameList.setSelectionMode(0);
            this.fontNameList.addListSelectionListener(new ListSelectionHandler(this.getFontFamilyTextField()));
            this.fontNameList.setSelectedIndex(0);
            this.fontNameList.setFont(DEFAULT_FONT);
            this.fontNameList.setFocusable(false);
        }
        return this.fontNameList;
    }

    public JList getFontStyleList() {
        if (this.fontStyleList == null) {
            this.fontStyleList = new JList<String>(this.getFontStyleNames());
            this.fontStyleList.setSelectionMode(0);
            this.fontStyleList.addListSelectionListener(new ListSelectionHandler(this.getFontStyleTextField()));
            this.fontStyleList.setSelectedIndex(0);
            this.fontStyleList.setFont(DEFAULT_FONT);
            this.fontStyleList.setFocusable(false);
        }
        return this.fontStyleList;
    }

    public JList getFontSizeList() {
        if (this.fontSizeList == null) {
            this.fontSizeList = new JList<String>(this.fontSizeStrings);
            this.fontSizeList.setSelectionMode(0);
            this.fontSizeList.addListSelectionListener(new ListSelectionHandler(this.getFontSizeTextField()));
            this.fontSizeList.setSelectedIndex(0);
            this.fontSizeList.setFont(DEFAULT_FONT);
            this.fontSizeList.setFocusable(false);
        }
        return this.fontSizeList;
    }

    public String getSelectedFontFamily() {
        String fontName = (String)this.getFontFamilyList().getSelectedValue();
        return fontName;
    }

    public int getSelectedFontStyle() {
        int index = this.getFontStyleList().getSelectedIndex();
        return FONT_STYLE_CODES[index];
    }

    public int getSelectedFontSize() {
        int fontSize = 1;
        String fontSizeString = this.getFontSizeTextField().getText();
        while (true) {
            try {
                fontSize = Integer.parseInt(fontSizeString);
            }
            catch (NumberFormatException e) {
                fontSizeString = (String)this.getFontSizeList().getSelectedValue();
                this.getFontSizeTextField().setText(fontSizeString);
                continue;
            }
            break;
        }
        return fontSize;
    }

    public Font getSelectedFont() {
        Font font = new Font(this.getSelectedFontFamily(), this.getSelectedFontStyle(), this.getSelectedFontSize());
        return font;
    }

    public void setSelectedFontFamily(String name) {
        String[] names = this.getFontFamilies();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].toLowerCase().equals(name.toLowerCase())) continue;
            this.getFontFamilyList().setSelectedIndex(i);
            break;
        }
        this.updateSampleFont();
    }

    public void setSelectedFontStyle(int style) {
        for (int i = 0; i < FONT_STYLE_CODES.length; ++i) {
            if (FONT_STYLE_CODES[i] != style) continue;
            this.getFontStyleList().setSelectedIndex(i);
            break;
        }
        this.updateSampleFont();
    }

    public void setSelectedFontSize(int size) {
        String sizeString = String.valueOf(size);
        for (int i = 0; i < this.fontSizeStrings.length; ++i) {
            if (!this.fontSizeStrings[i].equals(sizeString)) continue;
            this.getFontSizeList().setSelectedIndex(i);
            break;
        }
        this.getFontSizeTextField().setText(sizeString);
        this.updateSampleFont();
    }

    public void setSelectedFont(Font font) {
        this.setSelectedFontFamily(font.getFamily());
        this.setSelectedFontStyle(font.getStyle());
        this.setSelectedFontSize(font.getSize());
    }

    public String getVersionString() {
        return "Version";
    }

    public int showDialog(Component parent) {
        this.dialogResultValue = -1;
        JDialog dialog = this.createDialog(parent);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FontChooserComponent.this.dialogResultValue = 1;
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
        dialog = null;
        return this.dialogResultValue;
    }

    protected JDialog createDialog(Component parent) {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        JDialog dialog = new JDialog(frame, "Select Font", true);
        DialogOKAction okAction = new DialogOKAction(dialog);
        DialogCancelAction cancelAction = new DialogCancelAction(dialog);
        JButton okButton = new JButton(okAction);
        okButton.setFont(DEFAULT_FONT);
        JButton cancelButton = new JButton(cancelAction);
        cancelButton.setFont(DEFAULT_FONT);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(2, 1));
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(25, 0, 10, 10));
        ActionMap actionMap = buttonsPanel.getActionMap();
        actionMap.put(cancelAction.getValue("Default"), cancelAction);
        actionMap.put(okAction.getValue("Default"), okAction);
        InputMap inputMap = buttonsPanel.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), cancelAction.getValue("Default"));
        inputMap.put(KeyStroke.getKeyStroke("ENTER"), okAction.getValue("Default"));
        JPanel dialogEastPanel = new JPanel();
        dialogEastPanel.setLayout(new BorderLayout());
        dialogEastPanel.add((Component)buttonsPanel, "North");
        dialog.getContentPane().add((Component)this, "Center");
        dialog.getContentPane().add((Component)dialogEastPanel, "East");
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        return dialog;
    }

    protected void updateSampleFont() {
        Font font = this.getSelectedFont();
        this.getSampleTextField().setFont(font);
    }

    protected JPanel getFontFamilyPanel() {
        if (this.fontNamePanel == null) {
            this.fontNamePanel = new JPanel();
            this.fontNamePanel.setLayout(new BorderLayout());
            this.fontNamePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.fontNamePanel.setPreferredSize(new Dimension(180, 130));
            JScrollPane scrollPane = new JScrollPane(this.getFontFamilyList());
            scrollPane.getVerticalScrollBar().setFocusable(false);
            scrollPane.setVerticalScrollBarPolicy(22);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)this.getFontFamilyTextField(), "North");
            p.add((Component)scrollPane, "Center");
            JLabel label = new JLabel("Font Name");
            label.setHorizontalAlignment(2);
            label.setHorizontalTextPosition(2);
            label.setLabelFor(this.getFontFamilyTextField());
            label.setDisplayedMnemonic('F');
            this.fontNamePanel.add((Component)label, "North");
            this.fontNamePanel.add((Component)p, "Center");
        }
        return this.fontNamePanel;
    }

    protected JPanel getFontStylePanel() {
        if (this.fontStylePanel == null) {
            this.fontStylePanel = new JPanel();
            this.fontStylePanel.setLayout(new BorderLayout());
            this.fontStylePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.fontStylePanel.setPreferredSize(new Dimension(140, 130));
            JScrollPane scrollPane = new JScrollPane(this.getFontStyleList());
            scrollPane.getVerticalScrollBar().setFocusable(false);
            scrollPane.setVerticalScrollBarPolicy(22);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)this.getFontStyleTextField(), "North");
            p.add((Component)scrollPane, "Center");
            JLabel label = new JLabel("Font Style");
            label.setHorizontalAlignment(2);
            label.setHorizontalTextPosition(2);
            label.setLabelFor(this.getFontStyleTextField());
            label.setDisplayedMnemonic('Y');
            this.fontStylePanel.add((Component)label, "North");
            this.fontStylePanel.add((Component)p, "Center");
        }
        return this.fontStylePanel;
    }

    protected JPanel getFontSizePanel() {
        if (this.fontSizePanel == null) {
            this.fontSizePanel = new JPanel();
            this.fontSizePanel.setLayout(new BorderLayout());
            this.fontSizePanel.setPreferredSize(new Dimension(70, 130));
            this.fontSizePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JScrollPane scrollPane = new JScrollPane(this.getFontSizeList());
            scrollPane.getVerticalScrollBar().setFocusable(false);
            scrollPane.setVerticalScrollBarPolicy(22);
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)this.getFontSizeTextField(), "North");
            p.add((Component)scrollPane, "Center");
            JLabel label = new JLabel("Font Size");
            label.setHorizontalAlignment(2);
            label.setHorizontalTextPosition(2);
            label.setLabelFor(this.getFontSizeTextField());
            label.setDisplayedMnemonic('S');
            this.fontSizePanel.add((Component)label, "North");
            this.fontSizePanel.add((Component)p, "Center");
        }
        return this.fontSizePanel;
    }

    protected JPanel getSamplePanel() {
        if (this.samplePanel == null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Sample");
            Border empty = BorderFactory.createEmptyBorder(5, 10, 10, 10);
            CompoundBorder border = BorderFactory.createCompoundBorder(titledBorder, empty);
            this.samplePanel = new JPanel();
            this.samplePanel.setLayout(new BorderLayout());
            this.samplePanel.setBorder(border);
            this.samplePanel.add((Component)this.getSampleTextField(), "Center");
        }
        return this.samplePanel;
    }

    protected JTextField getSampleTextField() {
        if (this.sampleText == null) {
            Border lowered = BorderFactory.createLoweredBevelBorder();
            this.sampleText = new JTextField("AaBbYyZz");
            this.sampleText.setBorder(lowered);
            this.sampleText.setPreferredSize(new Dimension(300, 100));
        }
        return this.sampleText;
    }

    protected String[] getFontFamilies() {
        if (this.fontFamilyNames == null) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.fontFamilyNames = env.getAvailableFontFamilyNames();
        }
        return this.fontFamilyNames;
    }

    protected String[] getFontStyleNames() {
        if (this.fontStyleNames == null) {
            int i = 0;
            this.fontStyleNames = new String[4];
            this.fontStyleNames[i++] = "Plain";
            this.fontStyleNames[i++] = "Bold";
            this.fontStyleNames[i++] = "Italic";
            this.fontStyleNames[i++] = "BoldItalic";
        }
        return this.fontStyleNames;
    }

    protected class DialogCancelAction
    extends AbstractAction {
        protected static final String ACTION_NAME = "Cancel";
        private JDialog dialog;

        protected DialogCancelAction(JDialog dialog) {
            this.dialog = dialog;
            this.putValue("Default", ACTION_NAME);
            this.putValue("ActionCommandKey", ACTION_NAME);
            this.putValue("Name", ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FontChooserComponent.this.dialogResultValue = 1;
            this.dialog.setVisible(false);
        }
    }

    protected class DialogOKAction
    extends AbstractAction {
        protected static final String ACTION_NAME = "OK";
        private JDialog dialog;

        protected DialogOKAction(JDialog dialog) {
            this.dialog = dialog;
            this.putValue("Default", ACTION_NAME);
            this.putValue("ActionCommandKey", ACTION_NAME);
            this.putValue("Name", ACTION_NAME);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FontChooserComponent.this.dialogResultValue = 0;
            this.dialog.setVisible(false);
        }
    }

    protected class ListSearchTextFieldDocumentHandler
    implements DocumentListener {
        JList targetList;

        public ListSearchTextFieldDocumentHandler(JList targetList) {
            this.targetList = targetList;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent event) {
            String newValue = "";
            try {
                Document doc = event.getDocument();
                newValue = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (newValue.length() > 0) {
                int index = this.targetList.getNextMatch(newValue, 0, Position.Bias.Forward);
                if (index < 0) {
                    index = 0;
                }
                this.targetList.ensureIndexIsVisible(index);
                String matchedName = this.targetList.getModel().getElementAt(index).toString();
                if (newValue.equalsIgnoreCase(matchedName) && index != this.targetList.getSelectedIndex()) {
                    SwingUtilities.invokeLater(new ListSelector(index));
                }
            }
        }

        public class ListSelector
        implements Runnable {
            private int index;

            public ListSelector(int index) {
                this.index = index;
            }

            @Override
            public void run() {
                ListSearchTextFieldDocumentHandler.this.targetList.setSelectedIndex(this.index);
            }
        }
    }

    protected class TextFieldKeyHandlerForListSelectionUpDown
    extends KeyAdapter {
        private JList targetList;

        public TextFieldKeyHandlerForListSelectionUpDown(JList list2) {
            this.targetList = list2;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int i = this.targetList.getSelectedIndex();
            switch (e.getKeyCode()) {
                case 38: {
                    i = this.targetList.getSelectedIndex() - 1;
                    if (i < 0) {
                        i = 0;
                    }
                    this.targetList.setSelectedIndex(i);
                    break;
                }
                case 40: {
                    int listSize = this.targetList.getModel().getSize();
                    i = this.targetList.getSelectedIndex() + 1;
                    if (i >= listSize) {
                        i = listSize - 1;
                    }
                    this.targetList.setSelectedIndex(i);
                    break;
                }
            }
        }
    }

    protected class TextFieldFocusHandlerForTextSelection
    extends FocusAdapter {
        private JTextComponent textComponent;

        public TextFieldFocusHandlerForTextSelection(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.textComponent.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.textComponent.select(0, 0);
            FontChooserComponent.this.updateSampleFont();
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        private JTextComponent textComponent;

        ListSelectionHandler(JTextComponent textComponent) {
            this.textComponent = textComponent;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JList list2 = (JList)e.getSource();
                String selectedValue = (String)list2.getSelectedValue();
                String oldValue = this.textComponent.getText();
                this.textComponent.setText(selectedValue);
                if (!oldValue.equalsIgnoreCase(selectedValue)) {
                    this.textComponent.selectAll();
                    this.textComponent.requestFocus();
                }
                FontChooserComponent.this.updateSampleFont();
            }
        }
    }
}

