/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.panels;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class GlitterPanel
extends JPanel
implements Runnable {
    public static final int RECORD_MODE = 0;
    public static final int PLAY_MODE = 1;
    int mode = 1;
    int playbackPos = 0;
    int[] playBackData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 174, 10, 0, 165, 36, 0, 158, 57, 0, 152, 78, 0, 148, 92, 0, 144, 101, 0, 143, 104, 0, 142, 105, 0, 142, 106, 0, 142, 106, 0, 143, 106, 0, 148, 104, 0, 151, 103, 1, 155, 101, 1, 163, 99, 1, 171, 96, 1, 181, 93, 1, 190, 92, 1, 203, 90, 1, 214, 89, 1, 225, 89, 1, 238, 89, 1, 255, 89, 1, 269, 89, 1, 285, 90, 1, 306, 91, 1, 320, 93, 1, 331, 97, 1, 342, 100, 1, 350, 104, 1, 359, 106, 1, 370, 109, 1, 383, 113, 1, 397, 118, 1, 416, 122, 1, 438, 123, 1, 461, 126, 1, 495, 128, 1, 521, 127, 1, 545, 122, 1, 557, 119, 1, 564, 116, 1, 568, 110, 1, 570, 105, 1, 570, 102, 1, 570, 98, 1, 567, 94, 1, 560, 87, 1, 553, 85, 1, 544, 84, 1, 536, 83, 1, 524, 83, 1, 512, 82, 1, 500, 80, 1, 489, 79, 1, 474, 79, 1, 456, 77, 1, 441, 77, 1, 424, 77, 1, 412, 77, 1, 400, 78, 1, 386, 78, 1, 371, 79, 1, 357, 80, 1, 342, 80, 1, 323, 79, 1, 304, 78, 1, 290, 78, 1, 273, 77, 1, 255, 77, 1, 241, 75, 1, 229, 73, 1, 217, 70, 1, 205, 67, 1, 199, 65, 1, 194, 62, 1, 189, 58, 1, 187, 56, 1, 186, 51, 1, 185, 45, 1, 185, 42, 1, 189, 39, 1, 196, 36, 1, 209, 33, 1, 221, 31, 1, 231, 31, 1, 240, 31, 1, 251, 32, 1, 264, 33, 1, 282, 34, 1, 301, 35, 1, 320, 37, 1, 339, 38, 1, 358, 40, 1, 377, 42, 1, 398, 43, 1, 420, 44, 1, 446, 44, 1, 474, 43, 1, 499, 44, 1, 523, 49, 1, 547, 55, 1, 569, 61, 1, 585, 68, 1, 597, 75, 1, 605, 82, 1, 608, 87, 1, 609, 97, 1, 608, 110, 1, 606, 121, 1, 601, 129, 1, 593, 135, 1, 586, 137, 1, 576, 138, 1, 563, 139, 1, 544, 138, 1, 522, 136, 1, 497, 133, 1, 472, 129, 1, 451, 126, 1, 433, 125, 1, 413, 124, 1, 397, 123, 1, 377, 123, 1, 355, 121, 1, 335, 119, 1, 312, 117, 1, 289, 114, 1, 266, 112, 1, 250, 109, 1, 236, 106, 1, 225, 103, 0, 214, 100, 0, 202, 93, 0, 193, 86, 0, 188, 79, 0, 185, 71, 0, 187, 60, 0, 199, 37, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5, 0, 221, 5};
    private static final int PARTIKEL_NO = 2000;
    private static final int SPREADING = 30;
    private static final boolean MOUSE_DYNAMIC = true;
    private static final int AGING = 25;
    private static final int FREQUENCY = 40;
    private static final int GRAVITY = 10;
    private static final String BACK_IMAGE = null;
    private static final int BRIGHTNESS = 90;
    int backShade = 200;
    int animDelay = 30;
    boolean firstUpdate = true;
    Thread animator = null;
    boolean doRun = false;
    boolean deinit = false;
    int width = 200;
    int height = 200;
    Color backColor = new Color(0, 0, 0, this.backShade);
    int row = 0;
    int workWidth;
    int workHeigth;
    int z;
    boolean u;
    int imageLoadState;
    boolean noUpdateNeeded;
    boolean mouseButtonPressed;
    boolean linkCursorSet;
    int lastXMousePos;
    int lastYMousePos;
    int xMotionEvent;
    int yMotionEvent;
    int oldLastXMousePos;
    int oldLastYMousePos;
    double q;
    double b;
    double[] x;
    double[] y;
    double[] partikelX;
    double[] partikelY;
    double[] partikelBrightness;
    double[] p;
    boolean[] partikelVisible;
    int[] partikelA;
    Color[] colorMap;
    int colorCount;
    int colorNo;
    int partikelNo;
    boolean hasMouseDynamic;
    double spreading;
    double aging;
    int frequency;
    double gravity;
    String bgImageName;
    double brightness;

    public void setBackShade(int bs) {
        this.backShade = bs;
        this.backColor = new Color(0, 0, 0, this.backShade);
    }

    public GlitterPanel() {
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        super.setVisible(false);
        this.initComponents();
    }

    public void setDelay(int d) {
        this.animDelay = d;
    }

    public void setPlaybackData(int[] d) {
        this.playBackData = d;
        this.playbackPos = 0;
    }

    public void deinit() {
        this.setVisible(false);
        this.removeAll();
        this.x = null;
        this.y = null;
        this.partikelX = null;
        this.partikelY = null;
        this.p = null;
        this.partikelBrightness = null;
        this.partikelVisible = null;
        this.partikelA = null;
        this.colorMap = null;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.width = width;
        this.height = height;
        this.workWidth = width;
        this.workHeigth = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean b) {
        if (this.deinit) {
            return;
        }
        if (b == this.isVisible()) {
            return;
        }
        super.setVisible(b);
        if (b) {
            if (this.animator == null) {
                this.animator = new Thread(this);
                this.doRun = true;
                this.playbackPos = 0;
                this.height = this.getHeight();
                this.width = this.getWidth();
                this.init();
                this.animator.start();
            }
        } else if (this.animator != null) {
            GlitterPanel glitterPanel = this;
            synchronized (glitterPanel) {
                this.doRun = false;
                this.animator.interrupt();
                this.animator = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.deinit) {
            return;
        }
        while (this.doRun) {
            try {
                Thread.sleep(this.animDelay);
                this.update();
            }
            catch (InterruptedException e) {
                break;
            }
            GlitterPanel glitterPanel = this;
            synchronized (glitterPanel) {
            }
            this.repaint();
        }
    }

    private void initComponents() {
        this.setOpaque(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void init() {
        if (this.deinit) {
            return;
        }
        this.u = true;
        this.imageLoadState = 0;
        this.noUpdateNeeded = false;
        this.mouseButtonPressed = false;
        this.linkCursorSet = false;
        this.lastXMousePos = 0;
        this.lastYMousePos = 0;
        this.xMotionEvent = 0;
        this.yMotionEvent = 0;
        this.oldLastXMousePos = 0;
        this.oldLastYMousePos = 0;
        this.q = 0.0;
        this.b = 0.05;
        this.colorCount = 256;
        this.colorNo = 0;
        this.partikelNo = 2000;
        this.hasMouseDynamic = true;
        this.spreading = 35.0;
        this.aging = 0.97;
        this.frequency = 20;
        this.gravity = 1.0;
        this.workWidth = this.width;
        this.workHeigth = this.height;
        this.partikelNo = 2000;
        this.spreading = 30.0;
        this.hasMouseDynamic = true;
        this.aging = 0.975;
        this.frequency = 40;
        this.gravity = 1.0;
        this.bgImageName = BACK_IMAGE;
        this.brightness = 2.6999999999999997;
        this.x = new double[this.partikelNo];
        this.y = new double[this.partikelNo];
        this.partikelX = new double[this.partikelNo];
        this.partikelY = new double[this.partikelNo];
        this.p = new double[this.partikelNo];
        this.partikelBrightness = new double[this.partikelNo];
        this.partikelVisible = new boolean[this.partikelNo];
        this.partikelA = new int[this.partikelNo];
        for (int i1 = 0; i1 < this.partikelNo; ++i1) {
            this.partikelVisible[i1] = false;
        }
        this.colorMap = new Color[this.colorCount];
        for (int j1 = 0; j1 < this.colorCount; ++j1) {
            int k1;
            int l1;
            int i2 = j1;
            if (i2 > 255) {
                i2 = 255;
            }
            if ((l1 = (int)(2.0 * (double)j1)) > 255) {
                l1 = 255;
            }
            if ((k1 = (int)(4.0 * (double)j1)) > 255) {
                k1 = 255;
            }
            this.colorMap[j1] = new Color(k1, l1, i2);
        }
        if (this.mode == 0) {
            this.addMouseListener(new GlitterMouseListener());
            this.addMouseMotionListener(new GlitterMouseMotionListener());
        }
        this.firstUpdate = true;
    }

    private void update() {
        if (this.firstUpdate) {
            this.imageLoadState = 1;
            this.imageLoadState = 2;
            this.firstUpdate = false;
        }
        if (this.mode == 0) {
            if (!this.mouseButtonPressed) {
                System.out.print(", 0");
            } else {
                System.out.print(", 1");
            }
            System.out.print(", " + this.xMotionEvent + ", " + this.yMotionEvent);
            ++this.row;
            if (this.row == 10) {
                System.out.println();
                this.row = 0;
            }
        }
        if (this.mode == 1) {
            this.mouseButtonPressed = this.playBackData[this.playbackPos + 0] == 1;
            this.xMotionEvent = this.playBackData[this.playbackPos + 1];
            this.yMotionEvent = this.playBackData[this.playbackPos + 2];
            this.playbackPos += 3;
            if (this.playbackPos >= this.playBackData.length) {
                this.playbackPos = 0;
            }
        }
        this.q += this.b;
        int partikelDepth = 0;
        if (!this.noUpdateNeeded || this.mouseButtonPressed) {
            this.noUpdateNeeded = true;
            for (int partikel = 0; partikel < this.partikelNo; ++partikel) {
                if (partikelDepth < this.frequency && !this.partikelVisible[partikel] && this.mouseButtonPressed) {
                    double d1 = 1.0 * (double)partikelDepth / (double)this.frequency;
                    this.x[partikel] = this.oldLastXMousePos + (int)(d1 * (double)(this.lastXMousePos - this.oldLastXMousePos)) + (int)(0.1 * this.spreading * (Math.random() - 0.5));
                    this.y[partikel] = this.oldLastYMousePos + (int)(d1 * (double)(this.lastYMousePos - this.oldLastYMousePos)) + (int)(0.1 * this.spreading * (Math.random() - 0.5));
                    this.partikelX[partikel] = this.spreading * (Math.random() - 0.5);
                    this.partikelY[partikel] = this.spreading * (Math.random() - 0.5);
                    if (this.hasMouseDynamic) {
                        int n = partikel;
                        this.partikelX[n] = this.partikelX[n] + (double)(3 * (this.lastXMousePos - this.oldLastXMousePos));
                        int n2 = partikel;
                        this.partikelY[n2] = this.partikelY[n2] + (double)(3 * (this.lastYMousePos - this.oldLastYMousePos));
                    }
                    this.partikelBrightness[partikel] = this.brightness * (0.25 + Math.random());
                    this.p[partikel] = 15.0 * Math.random();
                    this.partikelA[partikel] = (int)(1.5 * Math.random());
                    this.partikelVisible[partikel] = true;
                    ++partikelDepth;
                    this.noUpdateNeeded = false;
                    continue;
                }
                if (!this.partikelVisible[partikel]) continue;
                this.noUpdateNeeded = false;
                int n = partikel;
                this.partikelY[n] = this.partikelY[n] + this.gravity;
                int n3 = partikel;
                this.partikelX[n3] = this.partikelX[n3] * 0.97;
                int n4 = partikel;
                this.partikelY[n4] = this.partikelY[n4] * 0.97;
                int n5 = partikel;
                this.x[n5] = this.x[n5] + this.b * this.partikelX[partikel];
                int n6 = partikel;
                this.y[n6] = this.y[n6] + this.b * this.partikelY[partikel];
                int n7 = partikel;
                this.partikelBrightness[n7] = this.partikelBrightness[n7] * this.aging;
                if (!(this.y[partikel] > (double)this.workHeigth || this.x[partikel] < 0.0 || this.x[partikel] > (double)this.workWidth) && !(this.partikelBrightness[partikel] < 0.4)) continue;
                this.partikelVisible[partikel] = false;
            }
        }
        this.oldLastXMousePos = this.lastXMousePos;
        this.oldLastYMousePos = this.lastYMousePos;
        this.lastXMousePos = this.xMotionEvent;
        this.lastYMousePos = this.yMotionEvent;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g1) {
        if (this.deinit) {
            return;
        }
        if (this.imageLoadState == 2) {
            g1.setColor(this.backColor);
            g1.fillRect(0, 0, this.workWidth, this.workHeigth);
            if (!this.noUpdateNeeded) {
                for (int partikel = 0; partikel < this.partikelNo; ++partikel) {
                    if (!this.partikelVisible[partikel]) continue;
                    double partikelTailLengthDouble = this.partikelBrightness[partikel] * (1.5 + Math.sin(this.q * this.p[partikel]));
                    int currentX = (int)this.x[partikel];
                    int currentY = (int)this.y[partikel];
                    if (partikelTailLengthDouble > 1.5) {
                        int partikelTailLengthInt = (int)(partikelTailLengthDouble - 0.5);
                        this.colorNo = (int)(40.0 * partikelTailLengthDouble);
                        if (this.colorNo >= this.colorCount) {
                            this.colorNo = this.colorCount - 1;
                        }
                        g1.setColor(this.colorMap[this.colorNo]);
                        if (this.partikelA[partikel] == 0) {
                            g1.fillRect(currentX - partikelTailLengthInt, currentY, 2 * partikelTailLengthInt, 1);
                            g1.fillRect(currentX, currentY - partikelTailLengthInt, 1, 2 * partikelTailLengthInt);
                        } else {
                            g1.drawLine(currentX - partikelTailLengthInt, currentY - partikelTailLengthInt, currentX + partikelTailLengthInt, currentY + partikelTailLengthInt);
                            g1.drawLine(currentX + partikelTailLengthInt, currentY - partikelTailLengthInt, currentX - partikelTailLengthInt, currentY + partikelTailLengthInt);
                        }
                    }
                    this.colorNo = (int)(100.0 * partikelTailLengthDouble);
                    if (this.colorNo >= this.colorCount) {
                        this.colorNo = this.colorCount - 1;
                    }
                    g1.setColor(this.colorMap[this.colorNo]);
                    g1.fillRect(currentX, currentY, 1, 1);
                }
            }
        }
    }

    class GlitterMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent mouseevent) {
            GlitterPanel.this.mouseButtonPressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseevent) {
            GlitterPanel.this.mouseButtonPressed = false;
        }

        GlitterMouseListener() {
        }
    }

    class GlitterMouseMotionListener
    extends MouseMotionAdapter {
        @Override
        public void mouseMoved(MouseEvent mouseevent) {
            this.mouseDragged(mouseevent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseevent) {
            GlitterPanel.this.xMotionEvent = mouseevent.getX();
            GlitterPanel.this.yMotionEvent = mouseevent.getY();
        }

        GlitterMouseMotionListener() {
        }
    }
}

