/*
 * Decompiled with CFR 0.152.
 */
package de.malban.gui.panels;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.LogListener;
import de.malban.config.Logable;
import de.malban.config.TinyLogInterface;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.util.UtilityDate;
import de.malban.util.UtilityString;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class LogPanel
extends JPanel
implements Windowable,
Logable,
TinyLogInterface {
    public static boolean logToStd = false;
    public static final int MAX_LOG_LEN = 30000;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private String mTitel = "Log Window";
    private String mLogName;
    private boolean mFileTracking = true;
    private boolean mTimeTracking = false;
    private boolean mFileOnly = false;
    private boolean loggingControl = true;
    public static int ERROR = 0;
    public static int WARN = 1;
    public static int INFO = 2;
    public static int VERBOSE = 3;
    public static String[] LEVEL = new String[]{"ERROR", "WARN", "INFO", "VERBOSE"};
    private JScrollPane jScrollPane1;
    private JTextPane jTextPaneLog;
    String lineHead = "";
    int cc = 0;
    String add = "";
    private Vector<String> filesOfInterest = new Vector();
    private Vector<String> classesOfInterest = new Vector();
    private Vector<String> methodsOfInterest = new Vector();
    private boolean enhancedDebug = false;
    private int mDebugLevel = 5;
    String _S = "";
    private Vector<LogListener> mLogListener = new Vector();

    @Override
    public void closing() {
    }

    @Override
    public void setDebugFileOnly(boolean b) {
        this.mFileOnly = b;
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setTrackTime(boolean b) {
        this.mTimeTracking = b;
    }

    @Override
    public void setTrackInFile(boolean b) {
        this.mFileTracking = b;
    }

    public LogPanel() {
        this.initComponents();
        String time = UtilityDate.dateToStringGermanClock(new Date());
        time = UtilityString.replace(time, ".", "_");
        time = UtilityString.replace(time, ":", "_");
        time = UtilityString.replace(time, " ", "_");
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextPaneLog);
        }
        this.mLogName = time;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPaneLog = new JTextPane();
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextPaneLog.setName("jTextPaneLog");
        this.jScrollPane1.setViewportView(this.jTextPaneLog);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 300, Short.MAX_VALUE));
    }

    public void setTitle(String t) {
        this.mTitel = t;
        this.mLogName = this.mTitel + this.mLogName;
        this.mLogName = UtilityString.replace(this.mLogName, " ", "_");
    }

    @Override
    public void setFiletracking(boolean b) {
        this.mFileTracking = b;
    }

    public void fileAppend(String text) {
        if (!this.mFileTracking) {
            return;
        }
        try {
            FileWriter fstream = new FileWriter(Global.mainPathPrefix + "logs" + File.separator + this.mLogName + ".log", true);
            PrintWriter pw = new PrintWriter(fstream);
            pw.print(text);
            pw.flush();
            pw.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("LOG could not be created!");
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(this.mTitel);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setLog(String text, int level) {
        this.lineHead = "";
        if (!this.interestedInLog(level)) {
            return;
        }
        this.setLog(this.lineHead + ": " + text);
    }

    private String correctLoggingText(String text) {
        int noLogOff = text.indexOf("//++NO_LOG_OFF");
        int noLogOn = text.indexOf("//++NO_LOG_ON");
        if (noLogOff != -1 && noLogOn != -1) {
            if (noLogOff > noLogOn) {
                if (!this.loggingControl) {
                    text = text.substring(noLogOff);
                } else {
                    String h = text.substring(0, noLogOn);
                    text = h = h + text.substring(noLogOff);
                }
                this.loggingControl = true;
            } else {
                text = !this.loggingControl ? text.substring(noLogOff, noLogOn) : text.substring(0, noLogOn);
                this.loggingControl = false;
            }
        } else if (noLogOff != -1) {
            if (!this.loggingControl) {
                text = text.substring(noLogOff);
                this.loggingControl = true;
            }
        } else if (noLogOn != -1) {
            if (this.loggingControl) {
                text = text.substring(0, noLogOn);
                this.loggingControl = false;
            }
        } else if (!this.loggingControl) {
            text = "";
        }
        return text;
    }

    @Override
    public void setLog(String text) {
        if ((text = this.correctLoggingText(text)).length() > 0) {
            this.setToLog(text);
        }
    }

    private void setToLog(String text) {
        if (this.mTimeTracking) {
            text = UtilityDate.dateToStringGermanClock(new Date()) + ": " + text;
        }
        if (!this.mFileOnly) {
            this.jTextPaneLog.setText(text);
            this.jTextPaneLog.setCaretPosition(this.jTextPaneLog.getDocument().getLength());
        }
        this.fileAppend(text);
    }

    @Override
    public void addLog(String text, int level) {
        this.lineHead = "";
        if (!this.interestedInLog(level)) {
            return;
        }
        this.addLog(this.lineHead + ": " + text);
    }

    @Override
    public void addLog(String text) {
        if ((text = this.correctLoggingText(text)).length() > 0) {
            this.addToLog(text);
        }
    }

    private void addToLog(String text) {
        if (this.mTimeTracking) {
            text = UtilityDate.dateToStringGermanClock(new Date()) + ": " + text;
        }
        if (!this.mFileOnly) {
            try {
                this.jTextPaneLog.setCaretPosition(this.jTextPaneLog.getDocument().getLength());
                this.jTextPaneLog.replaceSelection(text + "\n");
                this.jTextPaneLog.setCaretPosition(this.jTextPaneLog.getDocument().getLength());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (logToStd) {
            System.out.println("LogOut:\n" + text + "");
        }
        this.fileAppend(text + "\n");
        this.fireLogAdded(text);
        this.gc();
    }

    private void gc() {
        ++this.cc;
        if (this.cc == 50) {
            this.cc = 0;
            String t = this.jTextPaneLog.getText();
            if (t.length() > 30000) {
                try {
                    this.jTextPaneLog.setText(t.substring(t.length() / 4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void addLog(Throwable e, int level) {
        this.lineHead = "";
        this.addLog(e);
    }

    @Override
    public void addLog(Throwable e) {
        this.add = "Exception!!! \n";
        PrintStream p = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                char[] c = new char[]{(char)b};
                String s = new String(c);
                LogPanel.this.add = LogPanel.this.add + s;
            }
        });
        try {
            e.printStackTrace(p);
        }
        catch (Throwable ex) {
            System.out.println("Strange");
        }
        p.flush();
        this.lineHead = ": \n" + this.add;
        this.addLog(this.lineHead);
    }

    @Override
    public boolean saveLog() {
        return false;
    }

    @Override
    public String getLog() {
        return this.jTextPaneLog.getText();
    }

    @Override
    public void clearLog() {
        this.jTextPaneLog.setText("");
        this.addLog("----");
        this.addLog("LOG CLEARED!");
        this.addLog("----");
        this.jTextPaneLog.setText("");
    }

    @Override
    public void setInterestedClasses(String c) {
        this.classesOfInterest.clear();
        boolean bl = this.enhancedDebug = !this.classesOfInterest.isEmpty() || !this.filesOfInterest.isEmpty() || !this.methodsOfInterest.isEmpty();
        if (c.trim().length() == 0) {
            return;
        }
        String[] classes = c.split(",");
        for (int i = 0; i < classes.length; ++i) {
            String string = classes[i];
            this.classesOfInterest.addElement(string.trim());
        }
        this.enhancedDebug = !this.classesOfInterest.isEmpty() || !this.filesOfInterest.isEmpty() || !this.methodsOfInterest.isEmpty();
    }

    @Override
    public void setInterestedMethods(String m) {
        this.methodsOfInterest.clear();
        boolean bl = this.enhancedDebug = !this.classesOfInterest.isEmpty() || !this.filesOfInterest.isEmpty() || !this.methodsOfInterest.isEmpty();
        if (m.trim().length() == 0) {
            return;
        }
        String[] methods = m.split(",");
        for (int i = 0; i < methods.length; ++i) {
            String string = methods[i];
            this.methodsOfInterest.addElement(string.trim());
        }
        this.enhancedDebug = !this.classesOfInterest.isEmpty() || !this.filesOfInterest.isEmpty() || !this.methodsOfInterest.isEmpty();
    }

    @Override
    public void setInterestedFiles(String f) {
        this.filesOfInterest.clear();
        boolean bl = this.enhancedDebug = !this.classesOfInterest.isEmpty() || !this.filesOfInterest.isEmpty() || !this.methodsOfInterest.isEmpty();
        if (f.trim().length() == 0) {
            return;
        }
        String[] files = f.split(",");
        for (int i = 0; i < files.length; ++i) {
            String string = files[i];
            this.filesOfInterest.addElement(string.trim());
        }
        this.enhancedDebug = !this.classesOfInterest.isEmpty() || !this.filesOfInterest.isEmpty() || !this.methodsOfInterest.isEmpty();
    }

    private boolean interestedInLog(int level) {
        if (this.enhancedDebug) {
            Thread T = Thread.currentThread();
            StackTraceElement[] tracers = Thread.getAllStackTraces().get(T);
            for (int i = 0; i < tracers.length; ++i) {
                StackTraceElement traceElement = tracers[i];
                String _file = traceElement.getFileName();
                String _class = traceElement.getClassName();
                String _method = traceElement.getMethodName();
                this._S = "";
                if (this.vectorElementsFoundInString(this.filesOfInterest, _file)) {
                    this.lineHead = "" + this._S;
                    return true;
                }
                if (this.vectorElementsFoundInString(this.classesOfInterest, _class)) {
                    this.lineHead = "" + this._S;
                    return true;
                }
                if (!this.vectorElementsFoundInString(this.methodsOfInterest, _method)) continue;
                this.lineHead = "" + this._S;
                return true;
            }
        }
        if (this.mDebugLevel < level) {
            return false;
        }
        this.lineHead = level < LEVEL.length ? "" + LEVEL[level] + "" : "LEVEL " + level + ":";
        return true;
    }

    private boolean vectorElementsFoundInString(Vector<String> search, String where) {
        if (where == null) {
            return false;
        }
        for (int i = 0; i < search.size(); ++i) {
            String string = search.elementAt(i);
            if (string.trim().length() == 0) continue;
            this._S = string;
            if (where.indexOf(string) == -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDebugLevel(int l) {
        this.mDebugLevel = l;
    }

    @Override
    public void addLogListener(LogListener listener) {
        this.mLogListener.removeElement(listener);
        this.mLogListener.addElement(listener);
    }

    @Override
    public void removeLogListener(LogListener listener) {
        this.mLogListener.removeElement(listener);
    }

    public void fireLogAdded(String addTest) {
        for (int i = 0; i < this.mLogListener.size(); ++i) {
            this.mLogListener.elementAt(i).logAddedChanged(addTest);
        }
    }

    @Override
    public void printMessage(String s) {
        this.addLog(s, INFO);
    }

    @Override
    public void printWarning(String s) {
        this.addLog(s, WARN);
    }

    @Override
    public void printError(String s) {
        this.addLog(s, ERROR);
    }

    @Override
    public void printMessageSU(String s) {
        this.addLog(s, INFO);
    }

    @Override
    public void printWarningSU(String s) {
        this.addLog(s, WARN);
    }

    @Override
    public void printErrorSU(String s) {
        this.addLog(s, ERROR);
    }

    @Override
    public void deIconified() {
    }
}

