/*
 * Decompiled with CFR 0.152.
 */
package de.malban.jdbc;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.components.ModalInternalFrame;
import de.malban.gui.dialogs.ShowInfoDialog;
import de.malban.jdbc.DBConnectionData;
import de.malban.jdbc.DBConnectionDataPool;
import de.malban.jdbc.PoolFactory;
import de.malban.util.Utility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class DBConnectionEdit
extends JPanel {
    private DBConnectionDataPool mConnectionPool;
    private int mInSetting = 0;
    ModalInternalFrame modal = null;
    private JButton jButtonFileSelect1;
    private JButton jButtonHelp;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JButton jButtonTest;
    private JComboBox jComboBoxConnection;
    private JComboBox jComboBoxType1;
    private JLabel jLabelClass;
    private JLabel jLabelConnection;
    private JLabel jLabelConnectionsString;
    private JLabel jLabelDBName;
    private JLabel jLabelHost;
    private JLabel jLabelName;
    private JLabel jLabelPassword;
    private JLabel jLabelPort;
    private JLabel jLabelPort1;
    private JLabel jLabelResult;
    private JLabel jLabelServer;
    private JLabel jLabelStringExample;
    private JLabel jLabelType;
    private JLabel jLabelURL;
    private JLabel jLabelUser;
    private JLabel jLabelisTested;
    public JTextField jTextFieldClass;
    public JTextField jTextFieldCurrent;
    public JTextField jTextFieldDBName;
    private JTextField jTextFieldDir;
    public JTextField jTextFieldExample;
    private JTextField jTextFieldHost;
    public JTextField jTextFieldName;
    public JTextField jTextFieldPassword;
    private JTextField jTextFieldPort;
    public JTextField jTextFieldServer;
    public JTextField jTextFieldURL;
    public JTextField jTextFieldUser;

    public static void showDBConnectionEditDialog() {
        Configuration C = Configuration.getConfiguration();
        if (C.getMainFrame() == null) {
            return;
        }
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        DBConnectionEdit dialog = new DBConnectionEdit();
        dialog.modal = new ModalInternalFrame("DB Connection", frame.getRootPane(), (Component)frame, (Container)dialog, dialog.jButtonSave);
        dialog.modal.setResizable(true);
        dialog.modal.setVisible(true);
    }

    private DBConnectionEdit() {
        this.initComponents();
        this.jLabelPort1.setVisible(false);
        this.jTextFieldDir.setVisible(false);
        this.jButtonFileSelect1.setVisible(false);
        this.mConnectionPool = PoolFactory.POOL.getConnectionPool();
        this.setVisible(true);
    }

    private void setFields(DBConnectionData c) {
        if (c == null) {
            this.jTextFieldDBName.setText("");
            this.jTextFieldName.setText("");
            this.jTextFieldPassword.setText("");
            this.jComboBoxType1.setSelectedIndex(-1);
            this.jTextFieldServer.setText("");
            this.jTextFieldUser.setText("");
            this.jTextFieldHost.setText("");
            this.jTextFieldPort.setText("");
            this.jTextFieldClass.setText("");
            this.jTextFieldURL.setText("");
            this.setDriverStatus();
            return;
        }
        this.jTextFieldDBName.setText(c.mDBName);
        this.jTextFieldName.setText(c.mName);
        this.jTextFieldPassword.setText(c.mPasswd);
        this.jComboBoxType1.setSelectedItem(c.mType);
        this.jTextFieldServer.setText(c.mServer);
        this.jTextFieldUser.setText(c.mUser);
        this.jTextFieldHost.setText(c.mHost);
        this.jTextFieldPort.setText(c.mPort);
        this.jTextFieldURL.setText(c.mURL);
        this.jTextFieldClass.setText(c.mClass);
        this.setDriverStatus();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Collection<DBConnectionData> col = this.mConnectionPool.getHashMap().values();
            Iterator<DBConnectionData> iter = col.iterator();
            int i = 0;
            ++this.mInSetting;
            this.jComboBoxConnection.removeAllItems();
            while (iter.hasNext()) {
                DBConnectionData item = iter.next();
                this.jComboBoxConnection.addItem(item);
                if (i == 0) {
                    this.jComboBoxConnection.setSelectedIndex(0);
                    this.setFields(item);
                }
                ++i;
            }
            --this.mInSetting;
            this.jLabelResult.setText("");
        }
        super.setVisible(b);
    }

    private void initComponents() {
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelType = new JLabel();
        this.jTextFieldUser = new JTextField();
        this.jLabelUser = new JLabel();
        this.jTextFieldPassword = new JTextField();
        this.jLabelPassword = new JLabel();
        this.jLabelDBName = new JLabel();
        this.jTextFieldDBName = new JTextField();
        this.jTextFieldServer = new JTextField();
        this.jLabelServer = new JLabel();
        this.jButtonSave = new JButton();
        this.jButtonNew = new JButton();
        this.jComboBoxConnection = new JComboBox();
        this.jLabelConnection = new JLabel();
        this.jButtonTest = new JButton();
        this.jTextFieldHost = new JTextField();
        this.jLabelHost = new JLabel();
        this.jLabelPort = new JLabel();
        this.jTextFieldPort = new JTextField();
        this.jLabelResult = new JLabel();
        this.jComboBoxType1 = new JComboBox();
        this.jLabelisTested = new JLabel();
        this.jLabelConnectionsString = new JLabel();
        this.jLabelStringExample = new JLabel();
        this.jTextFieldExample = new JTextField();
        this.jTextFieldCurrent = new JTextField();
        this.jLabelURL = new JLabel();
        this.jTextFieldURL = new JTextField();
        this.jButtonHelp = new JButton();
        this.jLabelClass = new JLabel();
        this.jTextFieldClass = new JTextField();
        this.jTextFieldDir = new JTextField();
        this.jLabelPort1 = new JLabel();
        this.jButtonFileSelect1 = new JButton();
        this.jLabelName.setText("Name");
        this.jLabelType.setText("Type");
        this.jLabelUser.setText("User");
        this.jLabelPassword.setText("Password");
        this.jLabelDBName.setText("DBName");
        this.jLabelServer.setText("Server/Instanz");
        this.jButtonSave.setText("Accept");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBConnectionEdit.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonNew.setLabel("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBConnectionEdit.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jComboBoxConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBConnectionEdit.this.jComboBoxConnectionActionPerformed(evt);
            }
        });
        this.jLabelConnection.setText("Connection");
        this.jButtonTest.setLabel("Test");
        this.jButtonTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBConnectionEdit.this.jButtonTestActionPerformed(evt);
            }
        });
        this.jTextFieldHost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBConnectionEdit.this.jTextFieldHostActionPerformed(evt);
            }
        });
        this.jLabelHost.setText("Host");
        this.jLabelPort.setText("Port");
        this.jLabelResult.setText("result ");
        this.jComboBoxType1.setModel(new DefaultComboBoxModel<String>(new String[]{"Oracle", "MySQL", "Derby (Java DB)", "Informix", "Postgre", "MSSQL", "Generic PW", "Generic Total"}));
        this.jComboBoxType1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBConnectionEdit.this.jComboBoxType1ActionPerformed(evt);
            }
        });
        this.jLabelisTested.setText("test");
        this.jLabelConnectionsString.setText("Current");
        this.jLabelStringExample.setText("Example");
        this.jTextFieldExample.setEditable(false);
        this.jTextFieldCurrent.setEditable(false);
        this.jLabelURL.setText("URL");
        this.jButtonHelp.setText("Type Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBConnectionEdit.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabelClass.setText("Class");
        this.jTextFieldClass.setEnabled(false);
        this.jTextFieldDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBConnectionEdit.this.jTextFieldDirActionPerformed(evt);
            }
        });
        this.jLabelPort1.setText("Dir");
        this.jButtonFileSelect1.setText("...");
        this.jButtonFileSelect1.setToolTipText("Chose directory");
        this.jButtonFileSelect1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DBConnectionEdit.this.jButtonFileSelect1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelPassword).addComponent(this.jLabelUser).addComponent(this.jLabelServer).addComponent(this.jLabelURL).addComponent(this.jLabelStringExample).addComponent(this.jLabelConnectionsString)).addGap(18, 18, 18)).addComponent(this.jLabelConnection)).addComponent(this.jLabelName).addComponent(this.jLabelType).addComponent(this.jLabelHost).addComponent(this.jLabelPort).addComponent(this.jLabelDBName).addComponent(this.jLabelClass)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldCurrent, -1, 367, Short.MAX_VALUE).addComponent(this.jTextFieldURL, -1, 367, Short.MAX_VALUE).addComponent(this.jTextFieldExample, -1, 367, Short.MAX_VALUE).addComponent(this.jLabelResult, -1, 367, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jButtonTest).addGap(18, 18, 18).addComponent(this.jButtonNew).addGap(18, 18, 18).addComponent(this.jButtonSave).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldPassword, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldUser, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldServer, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPort, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldHost, GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxType1, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldName, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldDBName, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldClass, -1, 123, Short.MAX_VALUE).addComponent(this.jComboBoxConnection, GroupLayout.Alignment.LEADING, 0, 185, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelisTested)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelPort1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldDir, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonFileSelect1)))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelConnection).addComponent(this.jComboBoxConnection, -2, -1, -2)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldClass, -2, -1, -2).addComponent(this.jLabelClass)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabelName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxType1, -2, -1, -2).addComponent(this.jLabelType).addComponent(this.jButtonHelp).addComponent(this.jLabelisTested)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldHost, -2, -1, -2).addComponent(this.jLabelHost)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPort, -2, -1, -2).addComponent(this.jLabelPort)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDBName).addComponent(this.jTextFieldDBName, -2, -1, -2).addComponent(this.jLabelPort1).addComponent(this.jTextFieldDir, -2, -1, -2).addComponent(this.jButtonFileSelect1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelServer).addComponent(this.jTextFieldServer, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelUser).addComponent(this.jTextFieldUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelPassword).addComponent(this.jTextFieldPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelURL).addComponent(this.jTextFieldURL, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldExample, -2, -1, -2).addComponent(this.jLabelStringExample)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCurrent, -2, -1, -2).addComponent(this.jLabelConnectionsString)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonTest).addComponent(this.jButtonNew).addComponent(this.jButtonSave)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelResult).addContainerGap(14, Short.MAX_VALUE)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        DBConnectionData c = new DBConnectionData();
        this.mConnectionPool.put(c.mName, c);
        ++this.mInSetting;
        this.jComboBoxConnection.addItem(c);
        this.jComboBoxConnection.setSelectedIndex(this.mConnectionPool.getSize() - 1);
        --this.mInSetting;
        this.setFields(c);
        this.jLabelResult.setText("");
    }

    private void jComboBoxConnectionActionPerformed(ActionEvent evt) {
        if (this.mInSetting > 0) {
            return;
        }
        DBConnectionData c = (DBConnectionData)this.jComboBoxConnection.getSelectedItem();
        this.setFields(c);
        this.jLabelResult.setText("");
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        int index = this.jComboBoxConnection.getSelectedIndex();
        DBConnectionData c = this.mConnectionPool.get(this.jTextFieldName.getText());
        if (c == null) {
            c = new DBConnectionData();
        }
        c.mDBName = this.jTextFieldDBName.getText();
        c.mName = this.jTextFieldName.getText();
        c.mPasswd = this.jTextFieldPassword.getText();
        c.mType = this.jComboBoxType1.getSelectedItem().toString();
        c.mServer = this.jTextFieldServer.getText();
        c.mUser = this.jTextFieldUser.getText();
        c.mHost = this.jTextFieldHost.getText();
        c.mPort = this.jTextFieldPort.getText();
        c.mURL = this.jTextFieldURL.getText();
        c.mClass = this.jTextFieldClass.getText();
        this.mConnectionPool.put(c.mName, c);
        this.mConnectionPool.save();
    }

    private void jButtonTestActionPerformed(ActionEvent evt) {
        DBConnectionData c = new DBConnectionData();
        c.mDBName = this.jTextFieldDBName.getText();
        c.mName = this.jTextFieldName.getText();
        c.mPasswd = this.jTextFieldPassword.getText();
        c.mType = this.jComboBoxType1.getSelectedItem().toString();
        c.mServer = this.jTextFieldServer.getText();
        c.mUser = this.jTextFieldUser.getText();
        c.mHost = this.jTextFieldHost.getText();
        c.mPort = this.jTextFieldPort.getText();
        c.mURL = this.jTextFieldURL.getText();
        c.mClass = this.jTextFieldClass.getText();
        String sel = "";
        sel = this.jComboBoxType1.getSelectedItem() == null ? new String() : this.jComboBoxType1.getSelectedItem().toString();
        if ("Derby (Java DB)".equalsIgnoreCase(sel) && this.jTextFieldDir.getText().trim().length() > 0) {
            c.mDBName = this.jTextFieldDir.getText() + File.pathSeparator + c.mDBName;
        }
        this.jTextFieldCurrent.setText(c.getConnectionString());
        this.jLabelResult.setText("");
        c.openConnection();
        Connection dbc = c.getConnection();
        if (dbc != null) {
            this.jLabelResult.setForeground(Color.GREEN);
            this.jLabelResult.setText("OK!");
            c.closeConnection();
        } else {
            this.jLabelResult.setForeground(Color.RED);
            this.jLabelResult.setText("ERROR! :\n" + c.mLastException.toString());
            System.out.println(Utility.getStackTrace(c.mLastException));
        }
    }

    private void jTextFieldHostActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxType1ActionPerformed(ActionEvent evt) {
        this.setDriverStatus();
        if (this.jComboBoxType1.getSelectedItem() != null) {
            String example = DBConnectionData.getExample(this.jComboBoxType1.getSelectedItem().toString());
            this.jTextFieldExample.setText(example);
        } else {
            this.jTextFieldExample.setText("");
        }
        this.jTextFieldCurrent.setText("");
        this.jLabelResult.setText("");
    }

    private void korrektVisibility() {
        this.jLabelPort1.setVisible(false);
        this.jTextFieldDir.setVisible(false);
        this.jButtonFileSelect1.setVisible(false);
        String sel = this.jComboBoxType1.getSelectedItem() == null ? new String() : this.jComboBoxType1.getSelectedItem().toString();
        if ("Derby (Java DB)".equalsIgnoreCase(sel)) {
            this.jTextFieldServer.setEditable(false);
            this.jTextFieldHost.setEditable(false);
            this.jTextFieldPort.setEditable(false);
            this.jTextFieldClass.setEditable(false);
            this.jTextFieldServer.setEnabled(false);
            this.jTextFieldHost.setEnabled(false);
            this.jTextFieldPort.setEnabled(false);
            this.jTextFieldClass.setEnabled(false);
            this.jLabelPort1.setVisible(true);
            this.jTextFieldDir.setVisible(true);
            this.jButtonFileSelect1.setVisible(true);
        } else if ("generic total".equalsIgnoreCase(sel)) {
            this.jTextFieldDBName.setEditable(false);
            this.jTextFieldPassword.setEditable(false);
            this.jTextFieldServer.setEditable(false);
            this.jTextFieldUser.setEditable(false);
            this.jTextFieldHost.setEditable(false);
            this.jTextFieldPort.setEditable(false);
            this.jTextFieldClass.setEditable(true);
            this.jTextFieldDBName.setEnabled(false);
            this.jTextFieldPassword.setEnabled(false);
            this.jTextFieldServer.setEnabled(false);
            this.jTextFieldUser.setEnabled(false);
            this.jTextFieldHost.setEnabled(false);
            this.jTextFieldPort.setEnabled(false);
            this.jTextFieldClass.setEnabled(true);
        } else if ("generic pw".equalsIgnoreCase(sel)) {
            this.jTextFieldDBName.setEditable(false);
            this.jTextFieldPassword.setEditable(true);
            this.jTextFieldServer.setEditable(false);
            this.jTextFieldUser.setEditable(true);
            this.jTextFieldHost.setEditable(false);
            this.jTextFieldPort.setEditable(false);
            this.jTextFieldClass.setEditable(true);
            this.jTextFieldDBName.setEnabled(false);
            this.jTextFieldPassword.setEnabled(true);
            this.jTextFieldServer.setEnabled(false);
            this.jTextFieldUser.setEnabled(true);
            this.jTextFieldHost.setEnabled(false);
            this.jTextFieldPort.setEnabled(false);
            this.jTextFieldClass.setEnabled(true);
        } else {
            this.jTextFieldDBName.setEditable(true);
            this.jTextFieldPassword.setEditable(true);
            this.jTextFieldServer.setEditable(true);
            this.jTextFieldUser.setEditable(true);
            this.jTextFieldHost.setEditable(true);
            this.jTextFieldPort.setEditable(true);
            this.jTextFieldClass.setEditable(false);
            this.jTextFieldDBName.setEnabled(true);
            this.jTextFieldPassword.setEnabled(true);
            this.jTextFieldServer.setEnabled(true);
            this.jTextFieldUser.setEnabled(true);
            this.jTextFieldHost.setEnabled(true);
            this.jTextFieldPort.setEnabled(true);
            this.jTextFieldClass.setEnabled(false);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        DBConnectionData c = (DBConnectionData)this.jComboBoxConnection.getSelectedItem();
        if (c != null) {
            c.mType = this.jComboBoxType1.getSelectedItem().toString();
            ShowInfoDialog.showInfoDialog("Hilfe", c.getHelpText());
        }
    }

    private void jTextFieldDirActionPerformed(ActionEvent evt) {
    }

    private void jButtonFileSelect1ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(1);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        String name = fc.getSelectedFile().getName();
        this.jTextFieldDir.setText(name);
    }

    private void setDriverStatus() {
        this.jLabelisTested.setText("");
        if (this.jComboBoxType1.getSelectedItem() == null) {
            return;
        }
        String sel = this.jComboBoxType1.getSelectedItem().toString();
        if (sel.equalsIgnoreCase("postgre")) {
            this.jLabelisTested.setText("Driver untested");
        }
        if (sel.equalsIgnoreCase("Generic PW")) {
            this.jLabelisTested.setText("Own Risc!");
        }
        if (sel.equalsIgnoreCase("Generic Total")) {
            this.jLabelisTested.setText("Own Risc!");
        }
        this.korrektVisibility();
    }
}

