/*
 * Decompiled with CFR 0.152.
 */
package de.malban.jdbc;

import de.malban.jdbc.DBConnectionDataPool;
import de.malban.jdbc.UserSQLStatementPool;
import java.util.HashMap;

public final class PoolFactory {
    private HashMap<String, DBConnectionDataPool> mDBConnections = new HashMap();
    private HashMap<String, UserSQLStatementPool> mStatementPool = new HashMap();
    public static PoolFactory POOL = new PoolFactory();

    private PoolFactory() {
    }

    public DBConnectionDataPool getConnectionPool() {
        DBConnectionDataPool pool = this.mDBConnections.get(DBConnectionDataPool.DEFAULT_XML_NAME);
        if (pool == null) {
            pool = new DBConnectionDataPool();
            this.mDBConnections.put(DBConnectionDataPool.DEFAULT_XML_NAME, pool);
        }
        return pool;
    }

    public UserSQLStatementPool getStatementPool() {
        UserSQLStatementPool pool = this.mStatementPool.get(UserSQLStatementPool.DEFAULT_XML_NAME);
        if (pool == null) {
            pool = new UserSQLStatementPool();
            this.mStatementPool.put(UserSQLStatementPool.DEFAULT_XML_NAME, pool);
        }
        return pool;
    }

    public DBConnectionDataPool getConnectionPool(String name) {
        DBConnectionDataPool pool = this.mDBConnections.get(name);
        if (pool == null) {
            pool = new DBConnectionDataPool(name);
            this.mDBConnections.put(name, pool);
        }
        return pool;
    }

    public UserSQLStatementPool getStatementPool(String name) {
        UserSQLStatementPool pool = this.mStatementPool.get(name);
        if (pool == null) {
            pool = new UserSQLStatementPool(name);
            this.mStatementPool.put(name, pool);
        }
        return pool;
    }
}

