/*
 * Decompiled with CFR 0.152.
 */
package de.malban.jdbc;

import de.malban.gui.dialogs.ShowWarningDialog;
import de.malban.jdbc.UserSQLStatement;
import java.util.Collection;
import java.util.HashMap;

public class UserSQLStatementPool {
    public static final String DEFAULT_XML_NAME = new String("sqlStatements.xml");
    private String mFileName = DEFAULT_XML_NAME;
    private HashMap<String, UserSQLStatement> mUserSQLStatement = new HashMap();

    public UserSQLStatementPool(String name) {
        this.mFileName = name;
        this.init();
    }

    public UserSQLStatementPool() {
        this.init();
    }

    private boolean init() {
        try {
            return this.load();
        }
        catch (Throwable e) {
            ShowWarningDialog.showWarningDialog("Statements Lade Problem...", e.toString());
            return false;
        }
    }

    public boolean load() {
        this.mUserSQLStatement = UserSQLStatement.getHashMapFromXML(this.mFileName);
        return true;
    }

    public void save() {
        UserSQLStatement.saveCollectionAsXML(this.mFileName, this.mUserSQLStatement.values());
    }

    public void put(UserSQLStatement st) {
        this.mUserSQLStatement.remove(st.mName);
        this.mUserSQLStatement.put(st.mName, st);
    }

    public UserSQLStatement get(String key) {
        return this.mUserSQLStatement.get(key);
    }

    public HashMap<String, String> getClasses() {
        HashMap<String, String> mClasses = new HashMap<String, String>();
        Collection<UserSQLStatement> col = this.mUserSQLStatement.values();
        for (UserSQLStatement item : col) {
            mClasses.put(item.mKlasse, item.mKlasse);
        }
        return mClasses;
    }

    public HashMap<String, UserSQLStatement> getClassStatements(String filter) {
        HashMap<String, UserSQLStatement> mFilteredStatement = new HashMap<String, UserSQLStatement>();
        Collection<UserSQLStatement> col = this.mUserSQLStatement.values();
        for (UserSQLStatement item : col) {
            if (!item.mKlasse.equalsIgnoreCase(filter)) continue;
            mFilteredStatement.put(item.mName, item);
        }
        return mFilteredStatement;
    }
}

