/*
 * Decompiled with CFR 0.152.
 */
package de.malban.jogl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class JOGLSupport {
    public int updateEachMs = 20;
    boolean init = false;
    boolean isSupported = false;
    public volatile boolean exit = false;
    public GLProfile glprofile = null;
    public GLCapabilities glcapabilities = null;
    private static JOGLSupport support = null;
    private static Map<Integer, String> GL_CONSTANTS;
    static String DINFO;
    public static String glVersion;
    public static int maxSample;
    public static int multiSample;

    public static JOGLSupport getJOGLSupport() {
        if (support == null) {
            support = new JOGLSupport();
        }
        return support;
    }

    private JOGLSupport() {
    }

    public static boolean isVBOSupported() {
        return true;
    }

    public static boolean isGL4Supported() {
        return false;
    }

    public static boolean isJOGLSupported() {
        if (!Global.JOGL_ENABLE) {
            return false;
        }
        if (!VideConfig.getConfig().tryJOGL) {
            Configuration.getConfiguration().getDebugEntity().addLog("JOGL: configured off", LogPanel.INFO);
            return false;
        }
        boolean canJOGL = JOGLSupport.getJOGLSupport().isInit();
        return canJOGL;
    }

    public static void setJOGLSupported(boolean b) {
        JOGLSupport.getJOGLSupport().isSupported = b;
    }

    private boolean isInit() {
        if (!Global.JOGL_ENABLE) {
            Configuration.getConfiguration().getDebugEntity().addLog("JOGL: forbidden globally", LogPanel.INFO);
            this.isSupported = false;
            return false;
        }
        if (!this.init) {
            this.init = true;
            try {
                this.glprofile = GLProfile.getDefault();
                this.glcapabilities = new GLCapabilities(this.glprofile);
            }
            catch (Throwable e) {
                Configuration.getConfiguration().getDebugEntity().addLog("JOGL: is not supported", LogPanel.ERROR);
                this.isSupported = false;
                return false;
            }
            this.isSupported = true;
            Configuration.getConfiguration().getDebugEntity().addLog("JOGL is supported", LogPanel.INFO);
        }
        return this.isSupported;
    }

    public static int createShader(GL2 gl2, int programId, String shaderCode, int shaderType) throws Exception {
        int shaderId = gl2.glCreateShader(shaderType);
        if (shaderId == 0) {
            throw new Exception("Error creating shader. Shader id is zero.");
        }
        gl2.glShaderSource(shaderId, 1, new String[]{shaderCode}, null);
        gl2.glCompileShader(shaderId);
        IntBuffer intBuffer = IntBuffer.allocate(1);
        gl2.glGetShaderiv(shaderId, 35713, intBuffer);
        if (intBuffer.get(0) != 1) {
            gl2.glGetShaderiv(shaderId, 35716, intBuffer);
            int size = intBuffer.get(0);
            if (size > 0) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(size);
                gl2.glGetShaderInfoLog(shaderId, size, intBuffer, byteBuffer);
            }
            throw new Exception("Error compiling shader!");
        }
        gl2.glAttachShader(programId, shaderId);
        return shaderId;
    }

    public static void link(GL2 gl2, int programId) throws Exception {
        gl2.glLinkProgram(programId);
        IntBuffer intBuffer = IntBuffer.allocate(1);
        gl2.glGetProgramiv(programId, 35714, intBuffer);
        if (intBuffer.get(0) != 1) {
            gl2.glGetProgramiv(programId, 35716, intBuffer);
            int size = intBuffer.get(0);
            if (size > 0) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(size);
                gl2.glGetProgramInfoLog(programId, size, intBuffer, byteBuffer);
            }
            throw new Exception("Error linking shader program!");
        }
        gl2.glValidateProgram(programId);
        intBuffer = IntBuffer.allocate(1);
        gl2.glGetProgramiv(programId, 35715, intBuffer);
        if (intBuffer.get(0) != 1) {
            gl2.glGetProgramiv(programId, 35716, intBuffer);
            int size = intBuffer.get(0);
            if (size > 0) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(size);
                gl2.glGetProgramInfoLog(programId, size, intBuffer, byteBuffer);
            }
            throw new Exception("Error validating shader program!");
        }
    }

    public static boolean checkFramebufferStatus(GL2 gl2, int fbo, String which) {
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        gl2.glBindFramebuffer(36160, fbo);
        int status = gl2.glCheckFramebufferStatus(36160);
        gl2.glBindFramebuffer(36160, 0);
        switch (status) {
            case 36053: {
                return true;
            }
            case 36054: {
                log.addLog("[ERROR] " + which + ": Framebuffer incomplete: Attachment is NOT complete.", LogPanel.ERROR);
                return false;
            }
            case 36055: {
                log.addLog("[ERROR] " + which + ": Framebuffer incomplete: No image is attached to FBO.", LogPanel.ERROR);
                return false;
            }
            case 36057: {
                log.addLog("[ERROR] " + which + ": Framebuffer incomplete: Attached images have different dimensions.", LogPanel.ERROR);
                return false;
            }
            case 36058: {
                log.addLog("[ERROR] " + which + ": Framebuffer incomplete: Color attached images have different internal formats.", LogPanel.ERROR);
                return false;
            }
            case 36059: {
                log.addLog("[ERROR] " + which + ": Framebuffer incomplete: Draw buffer.", LogPanel.ERROR);
                return false;
            }
            case 36060: {
                log.addLog("[ERROR] " + which + ": Framebuffer incomplete: Read buffer.", LogPanel.ERROR);
                return false;
            }
            case 36182: {
                log.addLog("[ERROR] " + which + ": Framebuffer incomplete: Multisample.", LogPanel.ERROR);
                return false;
            }
            case 36061: {
                log.addLog("[ERROR] " + which + ": Framebuffer incomplete: Unsupported by FBO implementation.", LogPanel.ERROR);
                return false;
            }
        }
        log.addLog("[ERROR] " + which + ": Framebuffer incomplete: Unknown error.", LogPanel.ERROR);
        return false;
    }

    public static boolean checkError(GL2 gl2, String where) {
        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
        int errorCode = gl2.glGetError();
        switch (errorCode) {
            case 0: {
                return true;
            }
            case 1280: {
                log.addLog(where + ": JOGL GL_INVALID_ENUM", LogPanel.ERROR);
                return false;
            }
            case 1281: {
                log.addLog(where + ": JOGL GL_INVALID_VALUE", LogPanel.ERROR);
                return false;
            }
            case 1282: {
                log.addLog(where + ": JOGL GL_INVALID_OPERATION", LogPanel.ERROR);
                return false;
            }
            case 1286: {
                log.addLog(where + ": JOGL GL_INVALID_FRAMEBUFFER_OPERATION", LogPanel.ERROR);
                return false;
            }
            case 1285: {
                log.addLog(where + ": JOGL GL_OUT_OF_MEMORY", LogPanel.ERROR);
                return false;
            }
            case 1284: {
                log.addLog(where + ": JOGL GL_STACK_UNDERFLOW", LogPanel.ERROR);
                return false;
            }
            case 1283: {
                log.addLog(where + ": JOGL GL_STACK_OVERFLOW", LogPanel.ERROR);
                return false;
            }
        }
        log.addLog(where + ": JOGL ERROR: " + errorCode, LogPanel.ERROR);
        return false;
    }

    public static String getJOGLInfo() {
        if (!JOGLSupport.isJOGLSupported()) {
            DINFO = "JOGL not supported";
            return DINFO;
        }
        try {
            GLProfile glprofile = null;
            Object glcapabilities = null;
            glprofile = GLProfile.getDefault();
            GLCapabilities gLCapabilities = new GLCapabilities(glprofile);
        }
        catch (Throwable e) {
            DINFO = "JOGL not supported";
            return DINFO;
        }
        return DINFO;
    }

    public static String dumpExtensions(GL gl) {
        StringBuilder b = new StringBuilder();
        String str = gl.glGetString(7939);
        StringTokenizer localStringTokenizer = new StringTokenizer(str, " ", false);
        b.append("OpenGL extensions :\n");
        while (localStringTokenizer.hasMoreTokens()) {
            b.append("> " + localStringTokenizer.nextToken() + "\n");
        }
        b.append("\n");
        return b.toString();
    }

    public static String dumpInfos(GL gl) {
        if (!DINFO.equals("Not initialized!")) {
            return DINFO;
        }
        StringBuilder b = new StringBuilder();
        glVersion = JOGLSupport.getString(gl, 7938);
        b.append("OpenGL version ..... [" + glVersion + "]\n");
        b.append("OpenGL vendor ...... [" + JOGLSupport.getString(gl, 7936) + "]\n");
        b.append("OpenGL renderer .... [" + JOGLSupport.getString(gl, 7937) + "]\n");
        b.append("OpenGL GLSL ........ [" + JOGLSupport.getString(gl, 35724) + "]\n");
        b.append(" \n");
        b.append("MAX_TEXTURE_UNITS = " + JOGLSupport.getInt(gl, 34018) + "\n");
        b.append("MAX_TEXTURE_IMAGE_UNITS = " + JOGLSupport.getInt(gl, 34930) + "\n");
        b.append("MAX_COMBINED_TEXTURE_IMAGE_UNITS = " + JOGLSupport.getInt(gl, 35661) + "\n");
        b.append("MAX_VERTEX_TEXTURE_IMAGE_UNITS = " + JOGLSupport.getInt(gl, 35660) + "\n");
        b.append("MAX_TEXTURE_COORDS = " + JOGLSupport.getInt(gl, 34929) + "\n");
        b.append("MAX_TEXTURE_SIZE = " + JOGLSupport.getInt(gl, 3379) + "\n");
        b.append("MAX_VIEWPORT_DIMS = " + JOGLSupport.getInt(gl, 3386) + "\n");
        b.append("MAX_RENDERBUFFER_SIZE = " + JOGLSupport.getInt(gl, 34024) + "\n");
        b.append(" \n");
        b.append("MAX_ATTRIB_STACK_DEPTH = " + JOGLSupport.getInt(gl, 3381) + "\n");
        b.append("MAX_CLIENT_ATTRIB_STACK_DEPTH = " + JOGLSupport.getInt(gl, 3387) + "\n");
        b.append("MAX_MODELVIEW_STACK_DEPTH = " + JOGLSupport.getInt(gl, 3382) + "\n");
        b.append("MAX_PROJECTION_STACK_DEPTH = " + JOGLSupport.getInt(gl, 3384) + "\n");
        b.append("MAX_COLOR_ATTACHMENTS = " + JOGLSupport.getInt(gl, 36063) + "\n");
        b.append("MAX_DRAW_BUFFERS = " + JOGLSupport.getInt(gl, 34852) + "\n");
        b.append("AUX_BUFFERS = " + JOGLSupport.getInt(gl, 3072) + "\n");
        b.append(" \n");
        b.append("ALIASED_POINT_SIZE_RANGE = " + JOGLSupport.getRange(gl, 33901) + "\n");
        b.append("SMOOTH_POINT_SIZE_RANGE = " + JOGLSupport.getRange(gl, 2834) + "\n");
        b.append("POINT_SIZE_RANGE = " + JOGLSupport.getRange(gl, 2834) + "\n");
        b.append("POINT_SIZE_GRANULARITY = " + JOGLSupport.getInt(gl, 2835) + "\n");
        b.append("SMOOTH_POINT_SIZE_GRANULARITY = " + JOGLSupport.getInt(gl, 2835) + "\n");
        b.append(" \n");
        b.append("ALIASED_LINE_WIDTH_RANGE = " + JOGLSupport.getRange(gl, 33902) + "\n");
        b.append("SMOOTH_LINE_WIDTH_RANGE = " + JOGLSupport.getRange(gl, 2850) + "\n");
        b.append("LINE_WIDTH_RANGE = " + JOGLSupport.getRange(gl, 2850) + "\n");
        b.append("LINE_WIDTH_GRANULARITY = " + JOGLSupport.getInt(gl, 2851) + "\n");
        b.append("SMOOTH_LINE_WIDTH_GRANULARITY = " + JOGLSupport.getInt(gl, 2851) + "\n");
        b.append(" \n");
        b.append("GL_rgba_BITS = (R" + JOGLSupport.getInt(gl, 3410) + ", G" + JOGLSupport.getInt(gl, 3411) + ", B" + JOGLSupport.getInt(gl, 3412) + ", A" + JOGLSupport.getInt(gl, 3413) + ")\n");
        b.append("GL_ACCUM_rgba_BITS = (R" + JOGLSupport.getInt(gl, 3416) + ", G" + JOGLSupport.getInt(gl, 3417) + ", B" + JOGLSupport.getInt(gl, 3418) + ", A" + JOGLSupport.getInt(gl, 3419) + ")\n");
        b.append("GL_DEPTH_BITS = " + JOGLSupport.getInt(gl, 3414) + "\n");
        b.append("GL_STENCIL_BITS = " + JOGLSupport.getInt(gl, 3415) + "\n");
        b.append("GL_SUBPIXEL_BITS = " + JOGLSupport.getInt(gl, 3408) + "\n");
        b.append("GL_STEREO = " + JOGLSupport.getBool(gl, 3123) + "\n");
        b.append(" \n");
        maxSample = UtilityString.Int0(JOGLSupport.getInt(gl, 36183));
        b.append("MAX_SAMPLES = " + maxSample + "\n");
        multiSample = UtilityString.Int0(JOGLSupport.getInt(gl, 32937));
        b.append("SAMPLES = " + multiSample + "\n");
        b.append("M VERSION = " + JOGLSupport.getVersion() + "\n");
        b.append(" \n");
        b.append(JOGLSupport.dumpExtensions(gl));
        DINFO = b.toString();
        return DINFO;
    }

    public static boolean isMultiSampleSupported() {
        return maxSample > 1;
    }

    public static int getVersion() {
        String t;
        if (glVersion.trim().length() == 0) {
            return 0;
        }
        int pos = 0;
        int times = 100;
        int v = UtilityString.Int0(glVersion.substring(pos++, pos)) * times;
        times /= 10;
        if (!(t = glVersion.substring(pos++, pos)).equals(".")) {
            v += UtilityString.Int0(t) * times;
            times /= 10;
        } else {
            v += UtilityString.Int0(glVersion.substring(pos++, pos)) * times;
            times /= 10;
        }
        return v;
    }

    public static String getBool(GL paramGL, int paramInt) {
        int[] arrayOfInt = new int[3];
        paramGL.glGetIntegerv(paramInt, arrayOfInt, 0);
        return arrayOfInt[0] != 0 ? "true" : (1280 == paramGL.glGetError() ? "n/a" : "false");
    }

    public static String getInt(GL paramGL, int paramInt) {
        int[] arrayOfInt = new int[]{-1, -1, -1};
        paramGL.glGetIntegerv(paramInt, arrayOfInt, 0);
        return 1280 == paramGL.glGetError() ? "n/a" : Integer.toString(arrayOfInt[0]);
    }

    public static String getString(GL paramGL, int paramInt) {
        String str = paramGL.glGetString(paramInt);
        return 1280 == paramGL.glGetError() ? "n/a" : str;
    }

    public static String getRange(GL paramGL, int paramInt) {
        int[] arrayOfInt = new int[]{-1, -1, -1};
        paramGL.glGetIntegerv(paramInt, arrayOfInt, 0);
        return "[" + arrayOfInt[0] + ".." + arrayOfInt[1] + "]";
    }

    public static final String getNonNullConstantName(int paramInt) {
        String str = JOGLSupport.getConstantName(paramInt);
        return "0x" + Integer.toHexString(paramInt).toUpperCase();
    }

    public static final synchronized String getConstantName(int paramInt) {
        if (GL_CONSTANTS == null) {
            GL_CONSTANTS = JOGLSupport.fetchConstants();
        }
        return GL_CONSTANTS.get(paramInt);
    }

    private static final Map<Integer, String> fetchConstants() {
        HashMap<Integer, String> localHashMap = new HashMap<Integer, String>();
        for (Field localField : GL.class.getDeclaredFields()) {
            String str = localField.getName();
            try {
                int k;
                if (!str.startsWith("GL_") || !Modifier.isStatic(k = localField.getModifiers()) || !Modifier.isPublic(k) || !localField.getType().isAssignableFrom(Integer.TYPE)) continue;
                Object localObject = localField.get(null);
                localHashMap.put((Integer)localObject, str.substring(3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return localHashMap;
    }

    static {
        DINFO = "Not initialized!";
        glVersion = "";
        maxSample = 0;
        multiSample = 0;
    }
}

