/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound;

import de.malban.config.Configuration;
import de.malban.config.Logable;
import de.malban.sound.AudioPlayable;
import de.malban.sound.PlayClip;
import de.malban.sound.PlayMP3;
import de.malban.sound.PlaySound;
import de.malban.util.UtilityString;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.EnumControl;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;

public class Audio {
    public static boolean mSoundEnabled = true;
    public static int mVol = 100;
    private static final Port.Info[] EMPTY_PORT_INFO_ARRAY = new Port.Info[0];

    public static void resetCaches() {
        PlayClip.resetCache();
    }

    public static AudioPlayable play(String name) {
        if (!mSoundEnabled) {
            return null;
        }
        if (Configuration.getConfiguration().isSoundQuiet()) {
            return null;
        }
        File f = new File(name = UtilityString.cleanFileString(name));
        if (!f.exists()) {
            return null;
        }
        if (name.endsWith("3")) {
            PlayMP3 player = new PlayMP3(name);
            player.play();
            player.setLoop(false);
            return player;
        }
        if (f.length() > 100000L) {
            PlaySound player = new PlaySound(name);
            player.play();
            return player;
        }
        PlayClip player = new PlayClip(name, true);
        player.play();
        return player;
    }

    public static void playCached(String name) {
        if (!mSoundEnabled) {
            return;
        }
        if (Configuration.getConfiguration().isSoundQuiet()) {
            return;
        }
        File f = new File(name = UtilityString.cleanFileString(name));
        if (!f.exists()) {
            return;
        }
        if (name.endsWith("3")) {
            PlayMP3 player = new PlayMP3(name);
            player.play();
            player.setLoop(false);
            return;
        }
        if (f.length() > 100000L) {
            PlaySound player = new PlaySound(name);
            player.play();
            return;
        }
        PlayClip.playClip(name);
    }

    public static void mixerTest() throws LineUnavailableException {
        Mixer.Info[] mixerInfos;
        for (Mixer.Info mixerInfo : mixerInfos = AudioSystem.getMixerInfo()) {
            Line portLine;
            Port.Info pi;
            Line.Info[] lineInfos;
            System.out.println("\n" + mixerInfo);
            Mixer m = AudioSystem.getMixer(mixerInfo);
            for (Line.Info li : lineInfos = m.getSourceLineInfo()) {
                if (!(li instanceof Port.Info)) continue;
                pi = (Port.Info)li;
                portLine = m.getLine(pi);
                Audio.printPortControls(portLine);
            }
            for (Line.Info li : lineInfos = m.getTargetLineInfo()) {
                if (!(li instanceof Port.Info) || !(li instanceof Port.Info)) continue;
                pi = (Port.Info)li;
                portLine = m.getLine(pi);
                Audio.printPortControls(portLine);
            }
        }
    }

    private static void printPortControls(Line portLine) throws LineUnavailableException {
        Control[] pCtrls;
        portLine.open();
        for (Control memberControl : pCtrls = portLine.getControls()) {
            Audio.printControl(memberControl);
        }
        portLine.close();
    }

    public static void printControl(Control memberControl) {
        if (memberControl instanceof BooleanControl) {
            BooleanControl bc = (BooleanControl)memberControl;
            System.out.println(bc + ": " + bc.getValue());
        } else if (memberControl instanceof FloatControl) {
            FloatControl fc = (FloatControl)memberControl;
            System.out.println(fc + ": " + fc.getValue());
        } else if (memberControl instanceof EnumControl) {
            EnumControl ec = (EnumControl)memberControl;
            System.out.println(ec + ": " + ec.getValue());
        } else if (memberControl instanceof CompoundControl) {
            CompoundControl cc = (CompoundControl)memberControl;
            System.out.println(cc);
            for (Control compControl : cc.getMemberControls()) {
                Audio.printControl(compControl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAllVolumneWindows(int vol) {
        mVol = vol;
        try {
            Mixer.Info[] mixers;
            for (Mixer.Info info : mixers = AudioSystem.getMixerInfo()) {
                Mixer mixer = AudioSystem.getMixer(info);
                if (!mixer.isLineSupported(Port.Info.SPEAKER)) continue;
                Port port = (Port)mixer.getLine(Port.Info.SPEAKER);
                boolean openPortNeeded = !port.isOpen();
                try {
                    if (openPortNeeded) {
                        port.open();
                    }
                    if (!port.isControlSupported(FloatControl.Type.VOLUME)) continue;
                    FloatControl volumeControl = (FloatControl)port.getControl(FloatControl.Type.VOLUME);
                    float min = volumeControl.getMinimum();
                    float max = volumeControl.getMaximum();
                    float current = volumeControl.getValue();
                    double percent = 100.0 * (double)(current - min) / (double)(max - min);
                    float v = (max - min) / 2.0f + min;
                    v = (max - min) / 100.0f * (float)vol + min;
                    volumeControl.setValue(v);
                }
                finally {
                    if (openPortNeeded && port.isOpen()) {
                        port.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setAllVolumne(int vol) {
        String os = System.getProperty("os.name");
        if (os.toUpperCase().indexOf("WINDOW") != -1) {
            Audio.setAllVolumneWindows(vol);
        } else if (os.toUpperCase().indexOf("MAC") != -1) {
            Audio.setAllVolumneMac(vol);
        } else {
            Audio.setAllVolumneLinux(vol);
        }
    }

    public static void setAllVolumneLinux(int vol) {
        Logable D = Configuration.getConfiguration().getDebugEntity();
        boolean volumeSet = false;
        List<Mixer> portMixers = Audio.getPortMixers();
        if (portMixers.isEmpty()) {
            D.addLog("There are no mixers that support Port lines. Sound volume can not be set!", 0);
        }
        for (Mixer mixer : portMixers) {
            String strMixerName = mixer.getMixerInfo().getName();
            Port.Info[] infosToCheck = Audio.getPortInfo(mixer);
            for (int i = 0; i < infosToCheck.length; ++i) {
                String strPortName;
                Line port = null;
                try {
                    port = (Port)mixer.getLine(infosToCheck[i]);
                    port.open();
                }
                catch (LineUnavailableException lineUnavailableException) {
                    // empty catch block
                }
                if (port == null || (strPortName = ((Port.Info)port.getLineInfo()).getName()).toUpperCase().indexOf("MASTER") == -1) continue;
                Control[] aControls = port.getControls();
                for (int t = 0; t < aControls.length; ++t) {
                    Control control;
                    if (aControls[t] instanceof FloatControl) {
                        control = (FloatControl)aControls[t];
                        Control.Type type = control.getType();
                        String strControlName = type.toString();
                        if (!Audio.isVolumne((FloatControl)control)) continue;
                        Control volumeControl = control;
                        float min = ((FloatControl)volumeControl).getMinimum();
                        float max = ((FloatControl)volumeControl).getMaximum();
                        float current = ((FloatControl)volumeControl).getValue();
                        double percent = 100.0 * (double)(current - min) / (double)(max - min);
                        volumeSet = true;
                        float v = (max - min) / 2.0f + min;
                        v = (max - min) / 100.0f * (float)vol + min;
                        ((FloatControl)volumeControl).setValue(v);
                    }
                    if (!(aControls[t] instanceof CompoundControl)) continue;
                    control = (CompoundControl)aControls[t];
                    String strControlName = control.getType().toString();
                    Control[] subControls = ((CompoundControl)control).getMemberControls();
                    for (int s = 0; s < subControls.length; ++s) {
                        Control con = subControls[s];
                        if (!(con instanceof FloatControl)) continue;
                        FloatControl subCon = (FloatControl)con;
                        String strControlSubName = subCon.getType().toString();
                        if (!Audio.isVolumne(subCon)) continue;
                        FloatControl volumeControl = subCon;
                        float min = volumeControl.getMinimum();
                        float max = volumeControl.getMaximum();
                        float current = volumeControl.getValue();
                        double percent = 100.0 * (double)(current - min) / (double)(max - min);
                        float v = (max - min) / 2.0f + min;
                        v = (max - min) / 100.0f * (float)vol + min;
                        volumeControl.setValue(v);
                        volumeSet = true;
                    }
                }
            }
        }
        if (!volumeSet) {
            D.addLog("Volume was not set, please contact auhtor, this should be easy to fix, once known what to look for!", 0);
        }
    }

    private static boolean isBalanceOrPan(FloatControl control) {
        Control.Type type = control.getType();
        return type.equals(FloatControl.Type.PAN) || type.equals(FloatControl.Type.BALANCE);
    }

    private static boolean isVolumne(FloatControl control) {
        Control.Type type = control.getType();
        return type.equals(FloatControl.Type.VOLUME) || type.equals(FloatControl.Type.MASTER_GAIN);
    }

    private static List<Mixer> getPortMixers() {
        ArrayList<Mixer> supportingMixers = new ArrayList<Mixer>();
        Mixer.Info[] aMixerInfos = AudioSystem.getMixerInfo();
        Line.Info portInfo = new Line.Info(Port.class);
        for (int i = 0; i < aMixerInfos.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(aMixerInfos[i]);
            boolean bSupportsPorts = Audio.arePortsSupported(mixer);
            if (!bSupportsPorts) continue;
            supportingMixers.add(mixer);
        }
        return supportingMixers;
    }

    private static boolean arePortsSupported(Mixer mixer) {
        int i;
        Line.Info[] infos = mixer.getSourceLineInfo();
        for (i = 0; i < infos.length; ++i) {
            if (!(infos[i] instanceof Port.Info)) continue;
            return true;
        }
        infos = mixer.getTargetLineInfo();
        for (i = 0; i < infos.length; ++i) {
            if (!(infos[i] instanceof Port.Info)) continue;
            return true;
        }
        return false;
    }

    private static Port.Info[] getPortInfo(Mixer mixer) {
        int i;
        ArrayList<Port.Info> portInfoList = new ArrayList<Port.Info>();
        Line.Info[] infos = mixer.getSourceLineInfo();
        for (i = 0; i < infos.length; ++i) {
            if (!(infos[i] instanceof Port.Info)) continue;
            portInfoList.add((Port.Info)infos[i]);
        }
        infos = mixer.getTargetLineInfo();
        for (i = 0; i < infos.length; ++i) {
            if (!(infos[i] instanceof Port.Info)) continue;
            portInfoList.add((Port.Info)infos[i]);
        }
        Port.Info[] portInfos = portInfoList.toArray(EMPTY_PORT_INFO_ARRAY);
        return portInfos;
    }

    public static void setAllVolumneMac(int vol) {
        Mixer.Info[] mixerInfos;
        Logable D = Configuration.getConfiguration().getDebugEntity();
        if (D != null) {
            return;
        }
        boolean volumeSet = false;
        for (Mixer.Info mixerInfo : mixerInfos = AudioSystem.getMixerInfo()) {
            Line.Info[] lineInfos;
            System.out.println("\n" + mixerInfo);
            Mixer m = AudioSystem.getMixer(mixerInfo);
            Control[] c1 = m.getControls();
            for (Line.Info li : lineInfos = m.getSourceLineInfo()) {
                try {
                    Line line = m.getLine(li);
                    Control[] c = line.getControls();
                    FloatControl volume = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                    float max = volume.getMaximum();
                    float min = volume.getMinimum();
                    float dist = max - min;
                    float v = dist / 100.0f * (float)vol;
                    volume.setValue(min + v);
                }
                catch (Throwable ex) {
                    Logger.getLogger(Audio.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

