/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound;

import de.malban.config.Configuration;
import de.malban.sound.AudioPlayable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class PlayClip
implements AudioPlayable {
    public static final int MAX_LINES_DEFAULT = 1;
    final int maxLines;
    boolean autoClose = false;
    Clip[] clips = null;
    AudioInputStream sound = null;
    int nextClip = 0;
    public static HashMap<String, PlayClip> mClipMap = new HashMap();
    static boolean soundNotAvailable = false;

    public static void resetCache() {
        Set<Map.Entry<String, PlayClip>> entries = mClipMap.entrySet();
        for (Map.Entry<String, PlayClip> entry : entries) {
            PlayClip playClip = entry.getValue();
            playClip.deinit();
        }
        mClipMap = new HashMap();
    }

    public static void playClip(String name) {
        if (Configuration.getConfiguration().isSoundQuiet()) {
            return;
        }
        PlayClip p = mClipMap.get(name);
        if (p == null && (p = new PlayClip(name)) != null) {
            mClipMap.put(name, p);
        }
        if (p != null) {
            p.play();
        }
    }

    public PlayClip(String name, boolean autoClose) {
        this(name, 1, autoClose);
    }

    public PlayClip(String name) {
        this(name, 1, false);
    }

    public PlayClip(String name, int ml) {
        this(name, ml, false);
    }

    public PlayClip(String name, int ml, boolean autoClose) {
        this.maxLines = ml;
        this.clips = new Clip[this.maxLines];
        if (Configuration.getConfiguration().isSoundQuiet()) {
            return;
        }
        File soundFile = new File(name);
        try {
            for (int i = 0; i < this.clips.length; ++i) {
                this.sound = AudioSystem.getAudioInputStream(soundFile);
                DataLine.Info info = new DataLine.Info(Clip.class, this.sound.getFormat());
                this.clips[i] = (Clip)AudioSystem.getLine(info);
                this.clips[i].open(this.sound);
                if (!autoClose) continue;
                this.clips[i].addLineListener(new LineListener(){

                    @Override
                    public void update(LineEvent event) {
                        if (event.getType() == LineEvent.Type.STOP) {
                            event.getLine().close();
                            PlayClip.this.deinit();
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            if (!soundNotAvailable) {
                Configuration.getConfiguration().getDebugEntity().addLog("" + e, 1);
            }
            soundNotAvailable = true;
            this.deinit();
        }
    }

    @Override
    public final void deinit() {
        for (int i = 0; i < this.clips.length; ++i) {
            Clip clip = this.clips[i];
            if (clip == null) continue;
            clip.close();
            this.clips[i] = null;
        }
        this.sound = null;
    }

    @Override
    public synchronized boolean play() {
        if (this.clips == null) {
            return false;
        }
        if (this.clips[this.nextClip] == null) {
            return false;
        }
        this.clips[this.nextClip].setFramePosition(0);
        this.clips[this.nextClip].start();
        this.nextClip = (this.nextClip + 1) % this.maxLines;
        return true;
    }
}

