/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound;

import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class VideAudio {
    LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
    public transient byte[] soundBytes = new byte[882];
    SourceDataLine line = null;
    boolean init = false;

    public static VideAudio getAudio() {
        return new VideAudio();
    }

    private VideAudio() {
    }

    public SourceDataLine getLine() {
        if (!this.init) {
            this.init = this.initAudioLine();
        }
        return this.line;
    }

    private boolean initAudioLine() {
        if (this.line != null) {
            return true;
        }
        try {
            AudioFormat format = new AudioFormat(22050.0f, 8, 1, false, true);
            this.line = null;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                // empty if block
            }
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(format, this.soundBytes.length);
                this.line.start();
            }
            catch (LineUnavailableException ex) {
                this.log.addLog(ex, LogPanel.WARN);
                this.line = null;
            }
        }
        catch (Throwable e) {
            this.log.addLog(e, LogPanel.WARN);
            this.line = null;
        }
        return this.line != null;
    }

    public void deinit() {
        try {
            this.deinitAudioLine();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deinitAudioLine() {
        if (!this.init) {
            return;
        }
        SourceDataLine sourceDataLine = this.line;
        synchronized (sourceDataLine) {
            if (this.line != null) {
                this.line.drain();
                this.line.stop();
                this.line.close();
                this.line = null;
            }
        }
        this.init = false;
    }
}

