/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound.tinysound.internal;

import de.malban.sound.tinysound.internal.MusicReference;
import de.malban.sound.tinysound.internal.SoundReference;
import de.malban.sound.tinysound.internal.StreamReference;
import java.util.ArrayList;
import java.util.List;

public class Mixer {
    private List<MusicReference> musics = new ArrayList<MusicReference>();
    private List<SoundReference> sounds = new ArrayList<SoundReference>();
    private List<StreamReference> streams = new ArrayList<StreamReference>();
    private double globalVolume = 1.0;
    private int[] dataBuf = new int[2];

    public synchronized double getVolume() {
        return this.globalVolume;
    }

    public synchronized void setVolume(double volume) {
        if (volume >= 0.0) {
            this.globalVolume = volume;
        }
    }

    public synchronized void registerMusicReference(MusicReference music) {
        this.musics.add(music);
    }

    public synchronized void registerSoundReference(SoundReference sound) {
        this.sounds.add(sound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStreamReference(StreamReference s) {
        List<StreamReference> list2 = this.streams;
        synchronized (list2) {
            this.streams.add(s);
        }
    }

    public synchronized void unRegisterMusicReference(MusicReference music) {
        this.musics.remove(music);
    }

    public synchronized void unRegisterSoundReference(int soundID) {
        for (int i = this.sounds.size() - 1; i >= 0; --i) {
            if (this.sounds.get(i).getSoundID() != soundID) continue;
            this.sounds.remove(i).dispose();
        }
    }

    public synchronized void unRegisterStreamReference(int id) {
        for (int i = this.streams.size() - 1; i >= 0; --i) {
            if (this.streams.get(i).getSoundID() != id) continue;
            this.streams.remove(i).dispose();
        }
    }

    public synchronized void clearMusic() {
        this.musics.clear();
    }

    public synchronized void clearSounds() {
        for (SoundReference s : this.sounds) {
            s.dispose();
        }
        this.sounds.clear();
    }

    public synchronized void clearStreams() {
        for (StreamReference s : this.streams) {
            s.dispose();
        }
        this.streams.clear();
    }

    public synchronized int read(byte[] data2, int offset, int length) {
        int numRead = 0;
        boolean start = true;
        boolean bytesRead = true;
        for (int i = offset; i < length + offset && bytesRead; i += 4) {
            Object sound;
            int s;
            double tmpR;
            double tmpL;
            double rr;
            double rl;
            double lr;
            double ll;
            double pan;
            double rightCurr;
            double leftCurr;
            double volume;
            bytesRead = false;
            double leftValue = 0.0;
            double rightValue = 0.0;
            for (int m = 0; m < this.musics.size(); ++m) {
                MusicReference music = this.musics.get(m);
                if (!music.getPlaying() || music.bytesAvailable() <= 0L) continue;
                music.nextTwoBytes(this.dataBuf, false);
                volume = music.getVolume() * this.globalVolume;
                leftCurr = (double)this.dataBuf[0] * volume;
                rightCurr = (double)this.dataBuf[1] * volume;
                pan = music.getPan();
                if (pan != 0.0) {
                    ll = pan <= 0.0 ? 1.0 : 1.0 - pan;
                    lr = pan <= 0.0 ? Math.abs(pan) : 0.0;
                    rl = pan >= 0.0 ? pan : 0.0;
                    rr = pan >= 0.0 ? 1.0 : 1.0 - Math.abs(pan);
                    tmpL = ll * leftCurr + lr * rightCurr;
                    tmpR = rl * leftCurr + rr * rightCurr;
                    leftCurr = tmpL;
                    rightCurr = tmpR;
                }
                leftValue += leftCurr;
                rightValue += rightCurr;
                bytesRead = true;
            }
            for (s = this.sounds.size() - 1; s >= 0; --s) {
                sound = this.sounds.get(s);
                if (sound.bytesAvailable() > 0L) {
                    sound.nextTwoBytes(this.dataBuf, false);
                    volume = sound.getVolume() * this.globalVolume;
                    leftCurr = (double)this.dataBuf[0] * volume;
                    rightCurr = (double)this.dataBuf[1] * volume;
                    pan = sound.getPan();
                    if (pan != 0.0) {
                        ll = pan <= 0.0 ? 1.0 : 1.0 - pan;
                        lr = pan <= 0.0 ? Math.abs(pan) : 0.0;
                        rl = pan >= 0.0 ? pan : 0.0;
                        rr = pan >= 0.0 ? 1.0 : 1.0 - Math.abs(pan);
                        tmpL = ll * leftCurr + lr * rightCurr;
                        tmpR = rl * leftCurr + rr * rightCurr;
                        leftCurr = tmpL;
                        rightCurr = tmpR;
                    }
                    leftValue += leftCurr;
                    rightValue += rightCurr;
                    bytesRead = true;
                    if (sound.bytesAvailable() > 0L) continue;
                    this.sounds.remove(s).dispose();
                    continue;
                }
                this.sounds.remove(s).dispose();
            }
            for (s = this.streams.size() - 1; s >= 0; --s) {
                sound = this.streams.get(s);
                if (start) {
                    sound.prepareRead(length);
                }
                if (sound.bytesAvailable() <= 0L) continue;
                sound.nextTwoBytes(this.dataBuf, false);
                volume = sound.getVolume() * this.globalVolume;
                leftCurr = (double)this.dataBuf[0] * volume;
                rightCurr = (double)this.dataBuf[1] * volume;
                pan = sound.getPan();
                if (pan != 0.0) {
                    ll = pan <= 0.0 ? 1.0 : 1.0 - pan;
                    lr = pan <= 0.0 ? Math.abs(pan) : 0.0;
                    rl = pan >= 0.0 ? pan : 0.0;
                    rr = pan >= 0.0 ? 1.0 : 1.0 - Math.abs(pan);
                    tmpL = ll * leftCurr + lr * rightCurr;
                    tmpR = rl * leftCurr + rr * rightCurr;
                    leftCurr = tmpL;
                    rightCurr = tmpR;
                }
                leftValue += leftCurr;
                rightValue += rightCurr;
                bytesRead = true;
            }
            if (bytesRead) {
                int finalLeftValue = (int)leftValue;
                int finalRightValue = (int)rightValue;
                if (finalLeftValue > Short.MAX_VALUE) {
                    finalLeftValue = Short.MAX_VALUE;
                } else if (finalLeftValue < Short.MIN_VALUE) {
                    finalLeftValue = Short.MIN_VALUE;
                }
                if (finalRightValue > Short.MAX_VALUE) {
                    finalRightValue = Short.MAX_VALUE;
                } else if (finalRightValue < Short.MIN_VALUE) {
                    finalRightValue = Short.MIN_VALUE;
                }
                data2[i + 1] = (byte)(finalLeftValue >> 8 & 0xFF);
                data2[i] = (byte)(finalLeftValue & 0xFF);
                data2[i + 3] = (byte)(finalRightValue >> 8 & 0xFF);
                data2[i + 2] = (byte)(finalRightValue & 0xFF);
                numRead += 4;
            }
            start = false;
        }
        return numRead;
    }

    public synchronized void skip(int numBytes) {
        Object sound;
        int s;
        for (int m = 0; m < this.musics.size(); ++m) {
            MusicReference music = this.musics.get(m);
            if (!music.getPlaying() || music.bytesAvailable() <= 0L) continue;
            music.skipBytes(numBytes);
        }
        for (s = this.sounds.size() - 1; s >= 0; --s) {
            sound = this.sounds.get(s);
            if (sound.bytesAvailable() > 0L) {
                sound.skipBytes(numBytes);
                if (sound.bytesAvailable() > 0L) continue;
                this.sounds.remove(s).dispose();
                continue;
            }
            this.sounds.remove(s).dispose();
        }
        for (s = this.streams.size() - 1; s >= 0; --s) {
            sound = this.streams.get(s);
            if (sound.bytesAvailable() <= 0L) continue;
            sound.skipBytes(numBytes);
        }
    }
}

