/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound.tinysound.internal;

import de.malban.sound.tinysound.Music;
import de.malban.sound.tinysound.TinySound;
import de.malban.sound.tinysound.internal.Mixer;
import de.malban.sound.tinysound.internal.MusicReference;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class StreamMusic
implements Music {
    private URL dataURL;
    private Mixer mixer;
    private MusicReference reference;

    public StreamMusic(URL dataURL, long numBytesPerChannel, Mixer mixer) throws IOException {
        this.dataURL = dataURL;
        this.mixer = mixer;
        this.reference = new StreamMusicReference(this.dataURL, false, false, 0L, 0L, numBytesPerChannel, 1.0, 0.0);
        this.mixer.registerMusicReference(this.reference);
    }

    @Override
    public void play(boolean loop) {
        this.reference.setLoop(loop);
        this.reference.setPlaying(true);
    }

    @Override
    public void play(boolean loop, double volume) {
        this.setLoop(loop);
        this.setVolume(volume);
        this.reference.setPlaying(true);
    }

    @Override
    public void play(boolean loop, double volume, double pan) {
        this.setLoop(loop);
        this.setVolume(volume);
        this.setPan(pan);
        this.reference.setPlaying(true);
    }

    @Override
    public void stop() {
        this.reference.setPlaying(false);
        this.rewind();
    }

    @Override
    public void pause() {
        this.reference.setPlaying(false);
    }

    @Override
    public void resume() {
        this.reference.setPlaying(true);
    }

    @Override
    public void rewind() {
        this.reference.setPosition(0L);
    }

    @Override
    public void rewindToLoopPosition() {
        long byteIndex = this.reference.getLoopPosition();
        this.reference.setPosition(byteIndex);
    }

    @Override
    public boolean playing() {
        return this.reference.getPlaying();
    }

    @Override
    public boolean done() {
        return this.reference.done();
    }

    @Override
    public boolean loop() {
        return this.reference.getLoop();
    }

    @Override
    public void setLoop(boolean loop) {
        this.reference.setLoop(loop);
    }

    @Override
    public int getLoopPositionByFrame() {
        int bytesPerChannelForFrame = TinySound.FORMAT.getFrameSize() / TinySound.FORMAT.getChannels();
        long byteIndex = this.reference.getLoopPosition();
        return (int)(byteIndex / (long)bytesPerChannelForFrame);
    }

    @Override
    public double getLoopPositionBySeconds() {
        int bytesPerChannelForFrame = TinySound.FORMAT.getFrameSize() / TinySound.FORMAT.getChannels();
        long byteIndex = this.reference.getLoopPosition();
        return (float)byteIndex / (TinySound.FORMAT.getFrameRate() * (float)bytesPerChannelForFrame);
    }

    @Override
    public void setLoopPositionByFrame(int frameIndex) {
        int bytesPerChannelForFrame = TinySound.FORMAT.getFrameSize() / TinySound.FORMAT.getChannels();
        long byteIndex = frameIndex * bytesPerChannelForFrame;
        this.reference.setLoopPosition(byteIndex);
    }

    @Override
    public void setLoopPositionBySeconds(double seconds) {
        int bytesPerChannelForFrame = TinySound.FORMAT.getFrameSize() / TinySound.FORMAT.getChannels();
        long byteIndex = (long)(seconds * (double)TinySound.FORMAT.getFrameRate()) * (long)bytesPerChannelForFrame;
        this.reference.setLoopPosition(byteIndex);
    }

    @Override
    public double getVolume() {
        return this.reference.getVolume();
    }

    @Override
    public void setVolume(double volume) {
        if (volume >= 0.0) {
            this.reference.setVolume(volume);
        }
    }

    @Override
    public double getPan() {
        return this.reference.getPan();
    }

    @Override
    public void setPan(double pan) {
        if (pan >= -1.0 && pan <= 1.0) {
            this.reference.setPan(pan);
        }
    }

    @Override
    public void unload() {
        this.mixer.unRegisterMusicReference(this.reference);
        this.reference.dispose();
        this.mixer = null;
        this.dataURL = null;
        this.reference = null;
    }

    private static class StreamMusicReference
    implements MusicReference {
        private URL url;
        private InputStream data;
        private long numBytesPerChannel;
        private byte[] buf;
        private byte[] skipBuf;
        private boolean playing;
        private boolean loop;
        private long loopPosition;
        private long position;
        private double volume;
        private double pan;

        public StreamMusicReference(URL dataURL, boolean playing, boolean loop, long loopPosition, long position, long numBytesPerChannel, double volume, double pan) throws IOException {
            this.url = dataURL;
            this.playing = playing;
            this.loop = loop;
            this.loopPosition = loopPosition;
            this.position = position;
            this.numBytesPerChannel = numBytesPerChannel;
            this.volume = volume;
            this.pan = pan;
            this.buf = new byte[4];
            this.skipBuf = new byte[50];
            this.data = this.url.openStream();
        }

        @Override
        public synchronized boolean getPlaying() {
            return this.playing;
        }

        @Override
        public synchronized boolean getLoop() {
            return this.loop;
        }

        @Override
        public synchronized long getPosition() {
            return this.position;
        }

        @Override
        public synchronized long getLoopPosition() {
            return this.loopPosition;
        }

        @Override
        public synchronized double getVolume() {
            return this.volume;
        }

        @Override
        public synchronized double getPan() {
            return this.pan;
        }

        @Override
        public synchronized void setPlaying(boolean playing) {
            this.playing = playing;
        }

        @Override
        public synchronized void setLoop(boolean loop) {
            this.loop = loop;
        }

        @Override
        public synchronized void setPosition(long position) {
            if (position >= 0L && position < this.numBytesPerChannel) {
                if (position >= this.position) {
                    this.skipBytes(position - this.position);
                } else {
                    try {
                        this.data.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.data = this.url.openStream();
                        this.position = 0L;
                        this.skipBytes(position);
                    }
                    catch (IOException e) {
                        System.err.println("Failed to open stream for StreamMusic");
                        this.playing = false;
                    }
                }
            }
        }

        @Override
        public synchronized void setLoopPosition(long loopPosition) {
            if (loopPosition >= 0L && loopPosition < this.numBytesPerChannel) {
                this.loopPosition = loopPosition;
            }
        }

        @Override
        public synchronized void setVolume(double volume) {
            this.volume = volume;
        }

        @Override
        public synchronized void setPan(double pan) {
            this.pan = pan;
        }

        @Override
        public synchronized long bytesAvailable() {
            return this.numBytesPerChannel - this.position;
        }

        @Override
        public synchronized boolean done() {
            long available = this.numBytesPerChannel - this.position;
            return available <= 0L && !this.playing;
        }

        @Override
        public synchronized void skipBytes(long num) {
            if (this.position + num >= this.numBytesPerChannel) {
                if (!this.loop) {
                    this.position += num;
                    this.playing = false;
                    return;
                }
                long loopLength = this.numBytesPerChannel - this.loopPosition;
                long bytesOver = this.position + num - this.numBytesPerChannel;
                long nextPosition = this.loopPosition + bytesOver % loopLength;
                this.setPosition(nextPosition);
                return;
            }
            long numSkip = num * 2L;
            int tmpRead = 0;
            int numRead = 0;
            try {
                while ((long)numRead < numSkip && tmpRead != -1) {
                    long remaining = numSkip - (long)numRead;
                    int len = remaining > (long)this.skipBuf.length ? this.skipBuf.length : (int)remaining;
                    tmpRead = this.data.read(this.skipBuf, 0, len);
                    numRead += tmpRead;
                }
            }
            catch (IOException e) {
                this.position = this.numBytesPerChannel;
                this.playing = false;
            }
            if (tmpRead == -1) {
                this.position = this.numBytesPerChannel;
                this.playing = false;
            } else {
                this.position += num;
            }
        }

        @Override
        public synchronized void nextTwoBytes(int[] data2, boolean bigEndian) {
            int tmpRead = 0;
            try {
                for (int numRead = 0; numRead < this.buf.length && tmpRead != -1; numRead += tmpRead) {
                    tmpRead = this.data.read(this.buf, numRead, this.buf.length - numRead);
                }
            }
            catch (IOException e) {
                this.position = this.numBytesPerChannel;
                System.err.println("Failed reading bytes for stream sound");
            }
            if (bigEndian) {
                data2[0] = this.buf[0] << 8 | this.buf[1] & 0xFF;
                data2[1] = this.buf[2] << 8 | this.buf[3] & 0xFF;
            } else {
                data2[0] = this.buf[1] << 8 | this.buf[0] & 0xFF;
                data2[1] = this.buf[3] << 8 | this.buf[2] & 0xFF;
            }
            this.position = tmpRead == -1 ? this.numBytesPerChannel : (this.position += 2L);
            if (this.position >= this.numBytesPerChannel) {
                if (this.loop) {
                    this.setPosition(this.loopPosition);
                } else {
                    this.playing = false;
                }
            }
        }

        @Override
        public synchronized void dispose() {
            this.playing = false;
            this.position = this.numBytesPerChannel;
            this.url = null;
            try {
                this.data.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

