/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound.tinysound.internal;

import de.malban.sound.tinysound.Sound;
import de.malban.sound.tinysound.internal.Mixer;
import de.malban.sound.tinysound.internal.SoundReference;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class StreamSound
implements Sound {
    private URL dataURL;
    private long numBytesPerChannel;
    private Mixer mixer;
    private final int ID;

    public StreamSound(URL dataURL, long numBytesPerChannel, Mixer mixer, int id) throws IOException {
        this.dataURL = dataURL;
        this.numBytesPerChannel = numBytesPerChannel;
        this.mixer = mixer;
        this.ID = id;
        InputStream temp = this.dataURL.openStream();
        temp.close();
    }

    @Override
    public void play() {
        this.play(1.0);
    }

    @Override
    public void play(double volume) {
        this.play(volume, 0.0);
    }

    @Override
    public void play(double volume, double pan) {
        try {
            StreamSoundReference ref = new StreamSoundReference(this.dataURL.openStream(), this.numBytesPerChannel, volume, pan, this.ID);
            this.mixer.registerSoundReference(ref);
        }
        catch (IOException e) {
            System.err.println("Failed to open stream for Sound");
        }
    }

    @Override
    public void stop() {
        this.mixer.unRegisterSoundReference(this.ID);
    }

    @Override
    public void unload() {
        this.mixer.unRegisterSoundReference(this.ID);
        this.mixer = null;
        this.dataURL = null;
    }

    private static class StreamSoundReference
    implements SoundReference {
        public final int SOUND_ID;
        private InputStream data;
        private long numBytesPerChannel;
        private long position;
        private double volume;
        private double pan;
        private byte[] buf;
        private byte[] skipBuf;

        public StreamSoundReference(InputStream data2, long numBytesPerChannel, double volume, double pan, int soundID) {
            this.data = data2;
            this.numBytesPerChannel = numBytesPerChannel;
            this.volume = volume >= 0.0 ? volume : 1.0;
            this.pan = pan >= -1.0 && pan <= 1.0 ? pan : 0.0;
            this.position = 0L;
            this.buf = new byte[4];
            this.skipBuf = new byte[20];
            this.SOUND_ID = soundID;
        }

        @Override
        public int getSoundID() {
            return this.SOUND_ID;
        }

        @Override
        public double getVolume() {
            return this.volume;
        }

        @Override
        public double getPan() {
            return this.pan;
        }

        @Override
        public long bytesAvailable() {
            return this.numBytesPerChannel - this.position;
        }

        @Override
        public void skipBytes(long num) {
            if (this.position + num >= this.numBytesPerChannel) {
                this.position = this.numBytesPerChannel;
                return;
            }
            long numSkip = num * 2L;
            int tmpRead = 0;
            try {
                for (long numRead = 0L; numRead < numSkip && tmpRead != -1; numRead += (long)tmpRead) {
                    long remaining = numSkip - numRead;
                    int len = remaining > (long)this.skipBuf.length ? this.skipBuf.length : (int)remaining;
                    tmpRead = this.data.read(this.skipBuf, 0, len);
                }
            }
            catch (IOException e) {
                this.position = this.numBytesPerChannel;
            }
            this.position = tmpRead == -1 ? this.numBytesPerChannel : (this.position += num);
        }

        @Override
        public void nextTwoBytes(int[] data2, boolean bigEndian) {
            int tmpRead = 0;
            try {
                for (int numRead = 0; numRead < this.buf.length && tmpRead != -1; numRead += tmpRead) {
                    tmpRead = this.data.read(this.buf, numRead, this.buf.length - numRead);
                }
            }
            catch (IOException e) {
                this.position = this.numBytesPerChannel;
                System.err.println("Failed reading bytes for stream sound");
            }
            if (bigEndian) {
                data2[0] = this.buf[0] << 8 | this.buf[1] & 0xFF;
                data2[1] = this.buf[2] << 8 | this.buf[3] & 0xFF;
            } else {
                data2[0] = this.buf[1] << 8 | this.buf[0] & 0xFF;
                data2[1] = this.buf[3] << 8 | this.buf[2] & 0xFF;
            }
            this.position = tmpRead == -1 ? this.numBytesPerChannel : (this.position += 2L);
        }

        @Override
        public void dispose() {
            this.position = this.numBytesPerChannel;
            try {
                this.data.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.buf = null;
            this.skipBuf = null;
        }
    }
}

