/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound.tinysound.internal;

import de.malban.sound.tinysound.Stream;
import de.malban.sound.tinysound.internal.Mixer;
import de.malban.sound.tinysound.internal.StreamReference;

public class StreamStreamVectrex
implements Stream {
    private Mixer mixer;
    private final int ID;
    private int inputFormat;
    StreamStreamReference ref = null;
    private double volume = 1.0;

    public StreamStreamVectrex(Mixer mixer, int id, int inputFormat) {
        this.mixer = mixer;
        this.ID = id;
        this.inputFormat = inputFormat;
        this.ref = new StreamStreamReference(this.volume, 0.0, this.ID, inputFormat);
    }

    @Override
    public synchronized void start() {
        this.mixer.registerStreamReference(this.ref);
    }

    @Override
    public int available() {
        return this.ref.available();
    }

    @Override
    public int write(byte[] soundBytes, int offset, int soundLength) {
        return this.ref.write(soundBytes, offset, soundLength);
    }

    @Override
    public synchronized void stop() {
        this.mixer.unRegisterStreamReference(this.ID);
    }

    @Override
    public void unload() {
        this.mixer.unRegisterStreamReference(this.ID);
        this.mixer = null;
        this.ref = null;
    }

    @Override
    public void setVolume(double v) {
        this.volume = v;
        if (this.ref == null) {
            return;
        }
        this.ref.setVolume(this.volume);
    }

    public class StreamStreamReference
    implements StreamReference {
        public final int SOUND_ID;
        private double volume;
        private double pan;
        private byte[] buf;
        private byte[] inbuffer = new byte[3528];
        byte[] outBuffer = new byte[4408];
        int outBufferAvailable = 0;
        int inbufferUsed = 0;
        private int bytesInBuffer;
        int posInOutBuffer;
        static final int TINYSOUND_FRAME_LENGTH = 4;
        static final int VECTERX_FRAME_LENGTH = 1;

        @Override
        public synchronized int available() {
            return this.inbuffer.length - this.inbufferUsed;
        }

        @Override
        public synchronized int write(byte[] soundBytes, int offset, int soundLength) {
            if (soundLength == 0) {
                return 0;
            }
            if (soundLength + this.inbufferUsed > this.inbuffer.length) {
                soundLength = this.inbuffer.length - this.inbufferUsed;
            }
            if (soundLength == 0) {
                return 0;
            }
            System.arraycopy(soundBytes, offset, this.inbuffer, this.inbufferUsed, soundLength - 1);
            this.inbufferUsed += soundLength;
            return soundLength;
        }

        public void setVolume(double v) {
            this.volume = v;
        }

        @Override
        public int prepareRead(int countInTinySoundFramesBytes) {
            int countInVectrexFrames = countInTinySoundFramesBytes / 4;
            if (countInVectrexFrames * 1 > this.outBuffer.length) {
                countInVectrexFrames = this.outBuffer.length / 1;
            }
            if (countInVectrexFrames * 1 > this.inbufferUsed) {
                countInVectrexFrames = this.inbufferUsed / 1;
            }
            if (countInVectrexFrames == 0) {
                return 0;
            }
            for (int i = 0; i < countInVectrexFrames * 1; ++i) {
                double floatVal;
                byte inBufferByte = this.inbuffer[i];
                if ((floatVal /= (floatVal = (double)inBufferByte) < 0.0 ? 128.0 : 127.0) < -1.0) {
                    floatVal = -1.0;
                } else if (floatVal > 1.0) {
                    floatVal = 1.0;
                }
                int val = (int)(floatVal * 32767.0);
                this.outBuffer[0 + i * 4] = (byte)(val & 0xFF);
                this.outBuffer[1 + i * 4] = (byte)(val >> 8 & 0xFF);
                this.outBuffer[2 + i * 4] = (byte)(val & 0xFF);
                this.outBuffer[3 + i * 4] = (byte)(val >> 8 & 0xFF);
            }
            this.posInOutBuffer = 0;
            this.outBufferAvailable = countInVectrexFrames * 4;
            try {
                System.arraycopy(this.inbuffer, countInVectrexFrames * 1, this.inbuffer, 0, this.inbuffer.length - countInVectrexFrames * 1 - 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.inbufferUsed -= countInVectrexFrames * 1;
            return countInVectrexFrames;
        }

        public StreamStreamReference(double volume, double pan, int soundID, int inputFormat) {
            this.volume = volume >= 0.0 ? volume : 1.0;
            this.pan = pan >= -1.0 && pan <= 1.0 ? pan : 0.0;
            this.buf = new byte[4];
            this.SOUND_ID = soundID;
            this.bytesInBuffer = 0;
        }

        @Override
        public int getSoundID() {
            return this.SOUND_ID;
        }

        @Override
        public double getVolume() {
            return this.volume;
        }

        @Override
        public double getPan() {
            return this.pan;
        }

        @Override
        public long bytesAvailable() {
            return (this.outBufferAvailable - this.posInOutBuffer) / 2;
        }

        @Override
        public void skipBytes(long num) {
            if (num > (long)this.inbufferUsed) {
                this.inbufferUsed = 0;
                return;
            }
            System.arraycopy(this.inbuffer, (int)num, this.inbuffer, 0, this.inbuffer.length - (int)num - 1);
            this.inbufferUsed = (int)((long)this.inbufferUsed - num);
        }

        @Override
        public synchronized void nextTwoBytes(int[] data2, boolean bigEndian) {
            this.buf[0] = this.outBuffer[this.posInOutBuffer++];
            this.buf[1] = this.outBuffer[this.posInOutBuffer++];
            this.buf[2] = this.outBuffer[this.posInOutBuffer++];
            this.buf[3] = this.outBuffer[this.posInOutBuffer++];
            if (bigEndian) {
                data2[0] = this.buf[0] << 8 | this.buf[1] & 0xFF;
                data2[1] = this.buf[2] << 8 | this.buf[3] & 0xFF;
            } else {
                data2[0] = this.buf[1] << 8 | this.buf[0] & 0xFF;
                data2[1] = this.buf[3] << 8 | this.buf[2] & 0xFF;
            }
        }

        @Override
        public void dispose() {
        }
    }
}

