/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound.tinysound.internal;

import de.malban.sound.tinysound.Stream;
import de.malban.sound.tinysound.internal.Mixer;
import de.malban.sound.tinysound.internal.StreamReference;
import de.malban.vide.vedi.sound.ibxm.IBXM;

public class StreamStreamWav1Channel
implements Stream {
    private Mixer mixer;
    private final int ID;
    private int inputFormat;
    double volume = 1.0;
    StreamStreamReference ref;

    public StreamStreamWav1Channel(Mixer mixer, int id, int inputFormat) {
        this.mixer = mixer;
        this.ID = id;
        this.inputFormat = inputFormat;
        this.ref = new StreamStreamReference(this.volume, 0.0, this.ID, inputFormat);
    }

    @Override
    public void start() {
        this.mixer.registerStreamReference(this.ref);
    }

    @Override
    public int available() {
        return this.ref.available();
    }

    @Override
    public int write(byte[] soundBytes, int offset, int soundLength) {
        return this.ref.write(soundBytes, offset, soundLength);
    }

    @Override
    public void stop() {
        this.mixer.unRegisterStreamReference(this.ID);
    }

    @Override
    public void unload() {
        this.mixer.unRegisterStreamReference(this.ID);
        this.mixer = null;
    }

    @Override
    public void setVolume(double v) {
        this.volume = v;
        if (this.ref == null) {
            return;
        }
        this.ref.setVolume(this.volume);
    }

    public class StreamStreamReference
    implements StreamReference {
        public final int SOUND_ID;
        private double volume;
        private double pan;
        private byte[] buf;
        private byte[] inbuffer = new byte[IBXM.IBXM_MAXBUFFER / 2];
        byte[] outBuffer = new byte[IBXM.IBXM_MAXBUFFER / 2];
        int inbufferUsed = 0;
        private int bytesInBuffer;
        int posInOutBuffer;
        int outBufferAvailable = 0;
        static final int TINYSOUND_FRAME_LENGTH = 4;
        static final int MOD_FRAME_LENGTH = 2;

        @Override
        public synchronized int available() {
            return this.inbuffer.length - this.inbufferUsed;
        }

        @Override
        public synchronized int write(byte[] soundBytes, int offset, int soundLength) {
            if (soundLength == 0) {
                return 0;
            }
            if (soundLength + this.inbufferUsed > this.inbuffer.length) {
                soundLength = this.inbuffer.length - this.inbufferUsed;
            }
            if (soundLength == 0) {
                return 0;
            }
            System.arraycopy(soundBytes, offset, this.inbuffer, this.inbufferUsed, soundLength);
            this.inbufferUsed += soundLength;
            return soundLength;
        }

        @Override
        public int prepareRead(int bytesToCopy) {
            if ((bytesToCopy /= 2) > this.outBuffer.length) {
                bytesToCopy = this.outBuffer.length;
            }
            if (bytesToCopy > this.inbufferUsed) {
                bytesToCopy = this.inbufferUsed;
            }
            if (bytesToCopy == 0) {
                return 0;
            }
            System.arraycopy(this.inbuffer, 0, this.outBuffer, 0, bytesToCopy);
            this.posInOutBuffer = 0;
            this.outBufferAvailable = bytesToCopy * 2;
            try {
                System.arraycopy(this.inbuffer, bytesToCopy, this.inbuffer, 0, this.inbuffer.length - bytesToCopy);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.inbufferUsed -= bytesToCopy;
            return bytesToCopy * 2;
        }

        public StreamStreamReference(double volume, double pan, int soundID, int inputFormat) {
            this.volume = volume >= 0.0 ? volume : 1.0;
            this.pan = pan >= -1.0 && pan <= 1.0 ? pan : 0.0;
            this.buf = new byte[4];
            this.SOUND_ID = soundID;
            this.bytesInBuffer = 0;
        }

        @Override
        public int getSoundID() {
            return this.SOUND_ID;
        }

        @Override
        public double getVolume() {
            return this.volume;
        }

        public void setVolume(double v) {
            this.volume = v;
        }

        @Override
        public double getPan() {
            return this.pan;
        }

        @Override
        public long bytesAvailable() {
            return (this.outBufferAvailable - this.posInOutBuffer) / 2;
        }

        @Override
        public void skipBytes(long num) {
            if ((num /= 2L) > (long)this.inbufferUsed) {
                this.inbufferUsed = 0;
                return;
            }
            System.arraycopy(this.inbuffer, (int)num, this.inbuffer, 0, this.inbuffer.length - (int)num);
            this.inbufferUsed = (int)((long)this.inbufferUsed - num);
        }

        @Override
        public synchronized void nextTwoBytes(int[] data2, boolean bigEndian) {
            this.buf[0] = this.outBuffer[this.posInOutBuffer + 0];
            this.buf[1] = this.outBuffer[this.posInOutBuffer + 1];
            this.buf[2] = this.outBuffer[this.posInOutBuffer + 0];
            this.buf[3] = this.outBuffer[this.posInOutBuffer + 1];
            this.posInOutBuffer += 2;
            if (bigEndian) {
                data2[0] = this.buf[0] << 8 | this.buf[1] & 0xFF;
                data2[1] = this.buf[2] << 8 | this.buf[3] & 0xFF;
            } else {
                data2[0] = this.buf[1] << 8 | this.buf[0] & 0xFF;
                data2[1] = this.buf[3] << 8 | this.buf[2] & 0xFF;
            }
        }

        @Override
        public void dispose() {
        }
    }
}

