/*
 * Decompiled with CFR 0.152.
 */
package de.malban.sound.tinysound.internal;

import de.malban.sound.tinysound.TinySound;
import de.malban.sound.tinysound.internal.Mixer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.SourceDataLine;

public class UpdateRunner
implements Runnable {
    private AtomicBoolean running = new AtomicBoolean();
    private SourceDataLine outLine;
    private Mixer mixer;

    public UpdateRunner(Mixer mixer, SourceDataLine outLine) {
        this.mixer = mixer;
        this.outLine = outLine;
    }

    public void stop() {
        this.running.set(false);
    }

    @Override
    public void run() {
        this.running.set(true);
        int bufSize = (int)TinySound.FORMAT.getFrameRate() * TinySound.FORMAT.getFrameSize();
        byte[] audioBuffer = new byte[bufSize];
        int maxFramesPerUpdate = (int)(TinySound.FORMAT.getFrameRate() / 1000.0f * 25.0f);
        int numBytesRead = 0;
        double framesAccrued = 0.0;
        long lastUpdate = System.nanoTime();
        while (this.running.get()) {
            try {
                long currTime = System.nanoTime();
                double delta = currTime - lastUpdate;
                double secDelta = delta / 1.0E9;
                int framesToRead = (int)(framesAccrued += secDelta * (double)TinySound.FORMAT.getFrameRate());
                int framesToSkip = 0;
                if (framesToRead > maxFramesPerUpdate) {
                    framesToSkip = framesToRead - maxFramesPerUpdate;
                    framesToRead = maxFramesPerUpdate;
                }
                if (framesToSkip > 0) {
                    int bytesToSkip = framesToSkip * TinySound.FORMAT.getFrameSize();
                    this.mixer.skip(bytesToSkip);
                }
                if (framesToRead > 0) {
                    int bytesToRead = framesToRead * TinySound.FORMAT.getFrameSize();
                    int tmpBytesRead = this.mixer.read(audioBuffer, numBytesRead, bytesToRead);
                    numBytesRead += tmpBytesRead;
                    int remaining = bytesToRead - tmpBytesRead;
                    for (int i = 0; i < remaining; ++i) {
                        audioBuffer[numBytesRead + i] = 0;
                    }
                    numBytesRead += remaining;
                }
                framesAccrued -= (double)(framesToRead + framesToSkip);
                if (numBytesRead > 0) {
                    this.outLine.write(audioBuffer, 0, numBytesRead);
                    numBytesRead = 0;
                }
                lastUpdate = currTime;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

