/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.Global;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;

public class UtilityImage {
    public static BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() == 6) {
            return (BufferedImage)image;
        }
        if (image instanceof VolatileImage && ((VolatileImage)image).getSnapshot().getType() == 6) {
            return ((VolatileImage)image).getSnapshot();
        }
        UtilityImage.loadImage(image);
        BufferedImage buffImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D g2 = buffImg.createGraphics();
        g2.drawImage(image, null, null);
        g2.dispose();
        return buffImg;
    }

    public static BufferedImage copyImage(Image image) {
        if (image == null) {
            return null;
        }
        UtilityImage.loadImage(image);
        BufferedImage buffImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D g2 = buffImg.createGraphics();
        g2.drawImage(image, null, null);
        g2.dispose();
        return buffImg;
    }

    public static BufferedImage toAlpha(Image image) {
        if (image == null) {
            return null;
        }
        UtilityImage.loadImage(image);
        BufferedImage buffImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D g2 = buffImg.createGraphics();
        g2.drawImage(image, null, null);
        g2.dispose();
        return buffImg;
    }

    public static BufferedImage toNonAlpha(Image image) {
        if (image == null) {
            return null;
        }
        UtilityImage.loadImage(image);
        BufferedImage buffImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
        Graphics2D g2 = buffImg.createGraphics();
        g2.drawImage(image, null, null);
        g2.dispose();
        return buffImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadImage(Image image) {
        if (image == null) {
            return;
        }
        class StatusObserver
        implements ImageObserver {
            boolean imageLoaded = false;

            StatusObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if (infoflags == 32) {
                    StatusObserver statusObserver = this;
                    synchronized (statusObserver) {
                        this.imageLoaded = true;
                        this.notify();
                    }
                    return true;
                }
                return false;
            }
        }
        StatusObserver imageStatus = new StatusObserver();
        if (image == null) {
            return;
        }
        StatusObserver statusObserver = imageStatus;
        synchronized (statusObserver) {
            if (image.getWidth(imageStatus) == -1 || image.getHeight(imageStatus) == -1) {
                while (!imageStatus.imageLoaded) {
                    try {
                        imageStatus.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public static BufferedImage loadImage(URL name) {
        boolean interrupt;
        Image dImage = Toolkit.getDefaultToolkit().createImage(name);
        MediaTracker tracker = new MediaTracker(Global.mMainWindow);
        tracker.addImage(dImage, 1);
        do {
            try {
                interrupt = false;
                tracker.waitForAll();
            }
            catch (InterruptedException e) {
                interrupt = true;
                return null;
            }
        } while (interrupt);
        return UtilityImage.toBufferedImage(dImage);
    }

    public static BufferedImage loadImage(String name) {
        BufferedImage dImage;
        name = UtilityString.cleanFileString(name);
        File file = new File(name = UtilityFiles.convertSeperator(name));
        if (!file.exists()) {
            return null;
        }
        try {
            dImage = ImageIO.read(file);
        }
        catch (Throwable e) {
            return null;
        }
        return UtilityImage.toBufferedImage(dImage);
    }

    public static BufferedImage loadImage_old(String name) {
        Image dImage = null;
        File file = new File(name = UtilityString.cleanFileString(name));
        if (file.exists()) {
            boolean interrupt;
            dImage = Toolkit.getDefaultToolkit().createImage(name);
            MediaTracker tracker = new MediaTracker(Global.mMainWindow);
            tracker.addImage(dImage, 1);
            do {
                try {
                    interrupt = false;
                    tracker.waitForAll();
                }
                catch (InterruptedException e) {
                    interrupt = true;
                    return null;
                }
            } while (interrupt);
        }
        return UtilityImage.toBufferedImage(dImage);
    }

    public static BufferedImage imageScale(Image image, int width, int height) {
        if (image == null) {
            return null;
        }
        if (width == 0) {
            return UtilityImage.toBufferedImage(image);
        }
        if (height == 0) {
            return UtilityImage.toBufferedImage(image);
        }
        return UtilityImage.getScaledInstance(UtilityImage.toBufferedImage(image), width, height, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    public static BufferedImage imageScale(Image image, int percent) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth(null) * percent / 100;
        int height = image.getHeight(null) * percent / 100;
        return UtilityImage.imageScale(image, width, height);
    }

    public static BufferedImage getNewImage(int w, int h) {
        return UtilityImage.getNewImage(w, h, true);
    }

    public static BufferedImage getNewImage(int w, int h, boolean hasAlpha) {
        int type = hasAlpha ? 2 : 1;
        if (w <= 0) {
            return null;
        }
        if (h <= 0) {
            return null;
        }
        BufferedImage tmp = new BufferedImage(w, h, type);
        Graphics2D g2 = tmp.createGraphics();
        g2.clearRect(0, 0, w, h);
        g2.dispose();
        return tmp;
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        boolean hqw = higherQuality;
        boolean hqh = higherQuality;
        if (targetWidth >= img.getWidth()) {
            hqw = false;
        }
        if (targetHeight >= img.getHeight()) {
            hqh = false;
        }
        int w = hqw ? img.getWidth() : targetWidth;
        int h = hqh ? img.getHeight() : targetHeight;
        do {
            if (hqw && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (hqh && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public static int colorToInt(Color col) {
        return col.getRGB();
    }

    public static Color intToColor(int c) {
        return new Color(c);
    }

    public static Color intToColor(int r, int g, int b) {
        return new Color(r, g, b, 255);
    }

    public static Color intToColor(int r, int g, int b, int a) {
        return new Color(r, g, b, a);
    }
}

