/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.config.Configuration;
import de.malban.config.Logable;
import de.malban.gui.panels.LogPanel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;

public class UtilityString {
    public static String toHTML(String in) {
        String out = UtilityString.toXML(in);
        out = UtilityString.replace(out, "&apos;", "&#39;");
        return out;
    }

    public static String onlyXMLVisibleASCII(String in) {
        String ret = "";
        char[] c = in.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] >= ' ') {
                if (c[i] <= '~') {
                    ret = ret + c[i];
                    continue;
                }
                ret = ret + '.';
                continue;
            }
            ret = ret + '.';
        }
        return ret;
    }

    public static String toXML2(String in) {
        String out = in;
        if (in.equals(" ")) {
            return "&#x20;";
        }
        if (out.startsWith(" ")) {
            out = "&#x20;" + out.substring(1);
            return UtilityString.toXML(out);
        }
        if (out.endsWith(" ")) {
            out = out.substring(0, out.length() - 1) + "&#x20;";
            return UtilityString.toXML(out);
        }
        out = UtilityString.replace(out, "&", "___TO#OT#OO__amp;");
        out = UtilityString.replace(out, "___TO#OT#OO__amp;", "&amp;");
        out = UtilityString.replace(out, "'", "&apos;");
        out = UtilityString.replace(out, "'", "&apos;");
        out = UtilityString.replace(out, "\u00b4", "&apos;");
        out = UtilityString.replace(out, "`", "&apos;");
        out = UtilityString.replace(out, "\t", "&#009;");
        out = UtilityString.replace(out, "<", "&lt;");
        out = UtilityString.replace(out, ">", "&gt;");
        out = UtilityString.replace(out, "\u2264", "&le;");
        out = UtilityString.replace(out, "\u2265", "&ge;");
        out = UtilityString.replace(out, "\"", "&quot;");
        out = UtilityString.replace(out, "\u00c4", "&#196;");
        out = UtilityString.replace(out, "\u00d6", "&#214;");
        out = UtilityString.replace(out, "\u00dc", "&#220;");
        out = UtilityString.replace(out, "\u00e4", "&#228;");
        out = UtilityString.replace(out, "\u00f6", "&#246;");
        out = UtilityString.replace(out, "\u00fc", "&#252;");
        out = UtilityString.replace(out, "\u00df", "&#223;");
        return out;
    }

    public static String toXML(String in) {
        String out = in;
        if (in.equals(" ")) {
            return "&#x20;";
        }
        if (out.startsWith(" ")) {
            out = "&#x20;" + out.substring(1);
            return UtilityString.toXML(out);
        }
        if (out.endsWith(" ")) {
            out = out.substring(0, out.length() - 1) + "&#x20;";
            return UtilityString.toXML(out);
        }
        out = UtilityString.replace(out, "&", "___TO#OT#OO__amp;");
        out = UtilityString.replace(out, "___TO#OT#OO__amp;", "&amp;");
        out = UtilityString.replace(out, "'", "&apos;");
        out = UtilityString.replace(out, "'", "&apos;");
        out = UtilityString.replace(out, "\u00b4", "&apos;");
        out = UtilityString.replace(out, "`", "&apos;");
        out = UtilityString.replace(out, "\t", "&#009;");
        out = UtilityString.replace(out, "<", "&lt;");
        out = UtilityString.replace(out, ">", "&gt;");
        out = UtilityString.replace(out, "\u2264", "&le;");
        out = UtilityString.replace(out, "\u2265", "&ge;");
        out = UtilityString.replace(out, "\"", "&quot;");
        out = UtilityString.replace(out, "\u00c4", "&#196;");
        out = UtilityString.replace(out, "\u00d6", "&#214;");
        out = UtilityString.replace(out, "\u00dc", "&#220;");
        out = UtilityString.replace(out, "\u00e4", "&#228;");
        out = UtilityString.replace(out, "\u00f6", "&#246;");
        out = UtilityString.replace(out, "\u00fc", "&#252;");
        out = UtilityString.replace(out, "\u00df", "&#223;");
        return out;
    }

    public static String fromXML(String in) {
        String out = in;
        out = UtilityString.replace(out, "&amp;", "&");
        out = UtilityString.replace(out, "&#009;", "\t");
        out = UtilityString.replace(out, "&#x20;", " ");
        out = UtilityString.replace(out, "&apos;", "'");
        out = UtilityString.replace(out, "&apos;", "\u00b4");
        out = UtilityString.replace(out, "&apos;", "`");
        out = UtilityString.replace(out, "&lt;", "<");
        out = UtilityString.replace(out, "&gt;", ">");
        out = UtilityString.replace(out, "&le;", "\u2264");
        out = UtilityString.replace(out, "&ge;", "\u2265");
        out = UtilityString.replace(out, "&quot;", "\"");
        return out;
    }

    public static Vector<String> vectorReplace(Vector<String> col, String search, String with) {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < col.size(); ++i) {
            String t = col.elementAt(i);
            t = UtilityString.replace(t, search, with);
            result.addElement(t);
        }
        return result;
    }

    public static String replaceLastOccurrence(String name, String search, String with) {
        int lastPos = name.lastIndexOf(search);
        if (lastPos == -1) {
            return name;
        }
        if (lastPos < with.length()) {
            return UtilityString.replace(name, search, with);
        }
        if (lastPos == 0) {
            return UtilityString.replace(name, search, with);
        }
        String beginString = name.substring(0, lastPos);
        String endString = name.substring(lastPos);
        String endStringDone = UtilityString.replace(endString, search, with);
        return beginString + endStringDone;
    }

    public static String replaceFirst(String name, String search, String with) {
        int startSearch;
        if (name == null) {
            return name;
        }
        if (search == null || search.length() == 0) {
            return name;
        }
        if (with == null) {
            with = "";
        }
        if (name.substring(startSearch = 0).indexOf(search) != -1) {
            boolean wholeWord = true;
            int p = name.substring(startSearch).indexOf(search);
            String n1 = new String();
            String n2 = new String();
            try {
                n1 = name.substring(0, startSearch + p);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                n2 = name.substring(startSearch + p + search.length());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            name = n1 + with + n2;
        }
        return name;
    }

    public static String replace(String name, String search, String with) {
        return UtilityString.replace(name, search, with, false);
    }

    public static String replaceCI(String name, String search, String with) {
        return UtilityString.replaceCI(name, search, with, false);
    }

    public static boolean isWordBoundry(char s) {
        if (s == '_') {
            return false;
        }
        if (s >= 'a' && s <= 'z') {
            return false;
        }
        if (s >= 'A' && s <= 'Z') {
            return false;
        }
        return s < '0' || s > '9';
    }

    public static boolean isIntBoundry(char s) {
        if (s == '$') {
            return false;
        }
        if (s == '%') {
            return false;
        }
        if (s >= 'a' && s <= 'f') {
            return false;
        }
        if (s >= 'A' && s <= 'F') {
            return false;
        }
        return s < '0' || s > '9';
    }

    public static boolean isHexNumber(String a) {
        if (a.startsWith("+")) {
            a = a.substring(1);
        }
        if (a.startsWith("-")) {
            a = a.substring(1);
        }
        if (a.startsWith("$")) {
            a = a.substring(1);
        }
        if (a.startsWith("0x")) {
            a = a.substring(2);
        }
        a = a.toLowerCase();
        for (int i = 0; i < a.length(); ++i) {
            char c = a.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(char c) {
        boolean ret = false;
        if (c >= '0' && c <= '9') {
            ret = true;
        }
        if (c >= 'A' && c <= 'Z') {
            ret = true;
        }
        if (c >= 'a' && c <= 'z') {
            ret = true;
        }
        if (c == '_') {
            ret = true;
        }
        return ret;
    }

    public static boolean isDecNumber(String a) {
        if (a.startsWith("+")) {
            a = a.substring(1);
        }
        if (a.startsWith("-")) {
            a = a.substring(1);
        }
        a = a.toLowerCase();
        for (int i = 0; i < a.length(); ++i) {
            char c = a.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String replace(String name, String search, String with, boolean onlyWholeWords) {
        if (name == null) {
            return name;
        }
        if (search == null || search.length() == 0) {
            return name;
        }
        if (with == null) {
            with = "";
        }
        String[] keys = new String[]{"!**!", "<-->", "\u00a7$$\u00a7", "%&&%"};
        String orgSearch = search;
        String orgwith = with;
        int i = 0;
        while (with.indexOf(search) != -1) {
            with = keys[i];
            if (++i != 5) continue;
            return "ERROR";
        }
        if (i != 0) {
            name = UtilityString.replace(name, search, with, onlyWholeWords);
            search = with;
            with = orgwith;
        }
        int startSearch = 0;
        while (name.substring(startSearch).indexOf(search) != -1) {
            boolean wholeWord = true;
            int p = name.substring(startSearch).indexOf(search);
            if (p > 0) {
                boolean bl = wholeWord = wholeWord && UtilityString.isWordBoundry(name.substring(startSearch).charAt(p - 1));
            }
            if (p + search.length() < name.length()) {
                boolean bl = wholeWord = wholeWord && UtilityString.isWordBoundry(name.substring(startSearch).charAt(p + search.length()));
            }
            if (onlyWholeWords && !wholeWord) {
                startSearch += p + search.length();
                continue;
            }
            String n1 = new String();
            String n2 = new String();
            try {
                n1 = name.substring(0, startSearch + p);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                n2 = name.substring(startSearch + p + search.length());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            name = n1 + with + n2;
        }
        return name;
    }

    public static String replaceCI(String name, String search, String with, boolean onlyWholeWords) {
        if (name == null) {
            return name;
        }
        if (search == null || search.length() == 0) {
            return name;
        }
        if (with == null) {
            with = "";
        }
        String[] keys = new String[]{"!**!", "<-->", "\u00a7$$\u00a7", "%&&%"};
        String orgSearch = search;
        String orgwith = with;
        int i = 0;
        while (with.toLowerCase().indexOf(search.toLowerCase()) != -1) {
            with = keys[i];
            if (++i != 5) continue;
            return "ERROR";
        }
        if (i != 0) {
            name = UtilityString.replaceCI(name, search, with, onlyWholeWords);
            search = with;
            with = orgwith;
        }
        String lowerName = name.toLowerCase();
        String lowerSearch = search.toLowerCase();
        int startSearch = 0;
        while (lowerName.substring(startSearch).indexOf(lowerSearch) != -1) {
            boolean wholeWord = true;
            int p = lowerName.substring(startSearch).indexOf(lowerSearch);
            if (p > 0) {
                boolean bl = wholeWord = wholeWord && UtilityString.isWordBoundry(name.substring(startSearch).charAt(p - 1));
            }
            if (p + search.length() < name.length()) {
                boolean bl = wholeWord = wholeWord && UtilityString.isWordBoundry(name.substring(startSearch).charAt(p + search.length()));
            }
            if (onlyWholeWords && !wholeWord) {
                startSearch += p + search.length();
                continue;
            }
            String n1 = new String();
            String n2 = new String();
            try {
                n1 = name.substring(0, startSearch + p);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            try {
                n2 = name.substring(startSearch + p + search.length());
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            name = n1 + with + n2;
            lowerName = name.toLowerCase();
        }
        return name;
    }

    public static String replaceWhiteSpaces(String in, String with) {
        String out = in;
        out = UtilityString.replace(out, " ", with);
        out = UtilityString.replace(out, "\u00a0", with);
        out = UtilityString.replace(out, "\u2007", with);
        out = UtilityString.replace(out, "\u202f", with);
        out = UtilityString.replace(out, "\t", with);
        out = UtilityString.replace(out, "\u000b", with);
        out = UtilityString.replace(out, "\f", with);
        out = UtilityString.replace(out, "\t", with);
        out = UtilityString.replace(out, "\r", with);
        out = UtilityString.replace(out, "\n", with);
        return out;
    }

    public static String reverse(String in) {
        String ret = "";
        for (int i = 0; i < in.length(); ++i) {
            String c = in.substring(i, i + 1);
            ret = c + ret;
        }
        return ret;
    }

    public static String cleanSQLString(String in) {
        String out = in;
        out = UtilityString.replace(out, "'", "\u00b4");
        return out;
    }

    public static String[] cleanCSV(String in) {
        ArrayList<String> result1 = new ArrayList<String>();
        String[] parts = in.split(",");
        for (int i = 0; i < parts.length; ++i) {
            String t = parts[i].trim();
            if (t.length() == 0) continue;
            result1.add(t);
        }
        String[] r = new String[result1.size()];
        for (int i = 0; i < result1.size(); ++i) {
            r[i] = (String)result1.get(i);
        }
        return r;
    }

    public static String cleanStringSpace(String in) {
        String out = UtilityString.replaceWhiteSpaces(in, " ");
        out = UtilityString.replace(out, "&", "");
        out = UtilityString.replace(out, "'", "");
        out = UtilityString.replace(out, "\u00b4", "");
        out = UtilityString.replace(out, "`", "");
        out = UtilityString.replace(out, "<", "");
        out = UtilityString.replace(out, ">", "");
        out = UtilityString.replace(out, "\u2265", "");
        out = UtilityString.replace(out, "\u2264", "");
        out = UtilityString.replace(out, "\"", "");
        out = UtilityString.replace(out, "/", "");
        out = UtilityString.replace(out, "-", "");
        out = UtilityString.replace(out, " ", " ");
        out = UtilityString.replace(out, "(", "");
        out = UtilityString.replace(out, ")", "");
        out = UtilityString.replace(out, ".", "");
        out = UtilityString.replace(out, "\u2026", "");
        out = UtilityString.replace(out, "\u00c4", "Ae");
        out = UtilityString.replace(out, "\u00d6", "Oe");
        out = UtilityString.replace(out, "\u00dc", "Ue");
        out = UtilityString.replace(out, "\u00e4", "ae");
        out = UtilityString.replace(out, "\u00f6", "oe");
        out = UtilityString.replace(out, "\u00fc", "ue");
        out = UtilityString.replace(out, "\u00df", "ss");
        out = UtilityString.replace(out, "  ", " ");
        out = out.toUpperCase();
        return out.trim();
    }

    public static String cleanStringSpaceDotOk(String in) {
        String out = UtilityString.replaceWhiteSpaces(in, " ");
        out = UtilityString.replace(out, "&", "");
        out = UtilityString.replace(out, "'", "");
        out = UtilityString.replace(out, "\u00b4", "");
        out = UtilityString.replace(out, "`", "");
        out = UtilityString.replace(out, "<", "");
        out = UtilityString.replace(out, ">", "");
        out = UtilityString.replace(out, "\u2265", "");
        out = UtilityString.replace(out, "\u2264", "");
        out = UtilityString.replace(out, "\"", "");
        out = UtilityString.replace(out, "/", "");
        out = UtilityString.replace(out, "-", "");
        out = UtilityString.replace(out, " ", " ");
        out = UtilityString.replace(out, "(", "");
        out = UtilityString.replace(out, ")", "");
        out = UtilityString.replace(out, "\u2026", "");
        out = UtilityString.replace(out, "\u00c4", "Ae");
        out = UtilityString.replace(out, "\u00d6", "Oe");
        out = UtilityString.replace(out, "\u00dc", "Ue");
        out = UtilityString.replace(out, "\u00e4", "ae");
        out = UtilityString.replace(out, "\u00f6", "oe");
        out = UtilityString.replace(out, "\u00fc", "ue");
        out = UtilityString.replace(out, "\u00df", "ss");
        out = UtilityString.replace(out, "  ", " ");
        out = out.toUpperCase();
        return out.trim();
    }

    public static String cleanString(String in) {
        String out = UtilityString.replaceWhiteSpaces(in, "");
        out = UtilityString.replace(out, "&", "");
        out = UtilityString.replace(out, "'", "");
        out = UtilityString.replace(out, "\u00b4", "");
        out = UtilityString.replace(out, "`", "");
        out = UtilityString.replace(out, "<", "");
        out = UtilityString.replace(out, ">", "");
        out = UtilityString.replace(out, "\u2265", "");
        out = UtilityString.replace(out, "\u2264", "");
        out = UtilityString.replace(out, "\"", "");
        out = UtilityString.replace(out, "/", "");
        out = UtilityString.replace(out, "-", "");
        out = UtilityString.replace(out, " ", "");
        out = UtilityString.replace(out, "(", "");
        out = UtilityString.replace(out, ")", "");
        out = UtilityString.replace(out, ".", "");
        out = UtilityString.replace(out, "\u2026", "");
        out = UtilityString.replace(out, "\u00c4", "Ae");
        out = UtilityString.replace(out, "\u00d6", "Oe");
        out = UtilityString.replace(out, "\u00dc", "Ue");
        out = UtilityString.replace(out, "\u00e4", "ae");
        out = UtilityString.replace(out, "\u00f6", "oe");
        out = UtilityString.replace(out, "\u00fc", "ue");
        out = UtilityString.replace(out, "\u00df", "ss");
        out = out.toUpperCase();
        return out.trim();
    }

    public static String onlyUpperASCIIAndConvertedSpace(String in) {
        String ret = "";
        in = UtilityString.replaceWhiteSpaces(in, " ");
        char[] c = in.toUpperCase().toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == new Character(' ').charValue()) {
                ret = ret + c[i];
                continue;
            }
            if (c[i] <= '@' || c[i] > 'Z') continue;
            ret = ret + c[i];
        }
        return ret;
    }

    public static String onlyUpperASCII(String in) {
        String ret = "";
        char[] c = in.toUpperCase().toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] <= '@' || c[i] > 'Z') continue;
            ret = ret + c[i];
        }
        return ret;
    }

    public static String onlyUpperASCIINo(String in) {
        String ret = "";
        char[] c = in.toUpperCase().toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] > '@' && c[i] <= 'Z') {
                ret = ret + c[i];
            }
            if (c[i] < '0' || c[i] > '9') continue;
            ret = ret + c[i];
        }
        return ret;
    }

    public static final boolean isContained(Vector<String> v, String w) {
        for (int i = 0; i < v.size(); ++i) {
            String string = v.elementAt(i);
            if (!string.equals(w)) continue;
            return true;
        }
        return false;
    }

    public static final int whereContainedUpperTrim(Vector<String> v, String w) {
        for (int i = 0; i < v.size(); ++i) {
            String string = v.elementAt(i).toUpperCase().trim();
            if (string.length() == 0 || !string.equals(w.toUpperCase().trim())) continue;
            return i;
        }
        return -1;
    }

    public static String dbConform(String in) {
        String out = in;
        out = UtilityString.replace(out, "'", "\u00b4");
        out = UtilityString.replace(out, "\\", "");
        out = UtilityString.replace(out, "\u2013", "-");
        out = UtilityString.replace(out, "\u0096", "-");
        out = UtilityString.replace(out, "\u001a", " ");
        out = UtilityString.replace(out, "\u0019", " ");
        out = UtilityString.replace(out, "\u001c", " ");
        out = UtilityString.replace(out, "\u001e", " ");
        out = UtilityString.replace(out, "\u201a", "\"");
        out = UtilityString.replace(out, "\u2019", "\"");
        out = UtilityString.replace(out, "\u201c", "\"");
        out = UtilityString.replace(out, "\u201e", "\"");
        out = UtilityString.replace(out, "\u00b4", "\"");
        out = UtilityString.replace(out, "\u20ac", "Euro");
        out = UtilityString.replace(out, "\u00b5", "Mikro");
        out = UtilityString.replace(out, "\u2026", "...");
        out = UtilityString.replace(out, "?", " ");
        out = UtilityString.replace(out, "\u0095", " ");
        out = UtilityString.replace(out, "?", " ");
        out = UtilityString.replace(out, "\u0095", " ");
        return out;
    }

    public static String formatDouble(Double d) {
        DecimalFormat f = new DecimalFormat("#0,0");
        if (d == null) {
            return "";
        }
        return f.format(d);
    }

    public static String escapeRegExp(String s) {
        s = UtilityString.replace(s, "\\", "OO!!11!!OO");
        s = UtilityString.replace(s, "[", "\\[");
        s = UtilityString.replace(s, "^", "\\^");
        s = UtilityString.replace(s, "$", "\\$");
        s = UtilityString.replace(s, ".", "\\.");
        s = UtilityString.replace(s, "|", "\\|");
        s = UtilityString.replace(s, "?", "\\?");
        s = UtilityString.replace(s, "*", "\\*");
        s = UtilityString.replace(s, "+", "\\+");
        s = UtilityString.replace(s, "(", "\\(");
        s = UtilityString.replace(s, ")", "\\)");
        s = UtilityString.replace(s, "{", "\\{");
        s = UtilityString.replace(s, "}", "\\}");
        s = UtilityString.replace(s, "OO!!11!!OO", "\\\\");
        return s;
    }

    public static String cleanFileString(String path) {
        String ret = UtilityString.replace(path, "\\", File.separator);
        String ret2 = UtilityString.replace(ret, "/", File.separator);
        return ret2;
    }

    public static int countChars(String s, String c) {
        int count = 0;
        int pos = -1;
        do {
            if ((pos = s.indexOf(c, pos + 1)) < 0) continue;
            ++count;
        } while (pos >= 0);
        return count;
    }

    public static int countStrings(String string, String what) {
        int index;
        int count = 0;
        do {
            if ((index = string.indexOf(what)) == -1) continue;
            ++count;
            String partA = string.substring(0, index);
            String partB = string.substring(index + what.length());
            string = partA + partB;
        } while (index != -1);
        return count;
    }

    public static String getFileName(String file) {
        File f = new File(UtilityString.cleanFileString(file));
        return f.getName();
    }

    public static String getPath(String file) {
        String path = "";
        File f = (file = UtilityString.cleanFileString(file)).length() == 0 ? new File("." + File.separator) : new File(file);
        String aPath = f.getAbsolutePath();
        path = UtilityString.makeRelative(aPath);
        int i = path.lastIndexOf(File.separator);
        if (i == -1) {
            i = path.length() - 1;
        }
        if (i == -1) {
            i = 0;
        }
        path = path.substring(0, i) + File.separator;
        return path;
    }

    public static String makeRelative(String path) {
        File f;
        String here;
        if ((path = UtilityString.cleanFileString(path)).equals(here = (f = new File("." + File.separator)).getAbsolutePath())) {
            return "." + File.separator;
        }
        if (path.indexOf((here = here.substring(0, here.length() - 1)).substring(0, here.length() - 1)) != -1) {
            path = path.substring(path.indexOf(here) + here.length());
        } else {
            int len = 1;
            while (here.regionMatches(0, path, 0, len)) {
                ++len;
            }
            if ((len -= 2) <= 1) {
                return path;
            }
            while (!path.substring(len).startsWith(File.separator) && len >= 1) {
                --len;
            }
            String rPath = path.substring(len + 1);
            String rHere = here.substring(len + 1);
            int up = UtilityString.countStrings(rHere, File.separator);
            for (int i = 0; i < up; ++i) {
                rPath = ".." + File.separator + rPath;
            }
            path = rPath;
        }
        return path;
    }

    public static Vector<String> readTextFileToString(File file) {
        return UtilityString.readTextFileToString(file, false);
    }

    public static Vector<String> readTextFileToStringNoTab(File file) {
        return UtilityString.readTextFileToString(file, true);
    }

    public static Vector<String> readTextFileToString(File file, boolean destroyWhitespaces) {
        Vector<String> strings = new Vector<String>();
        try {
            InputStreamReader r = new InputStreamReader(new FileInputStream(file));
            BufferedReader reader = new BufferedReader(r);
            String zeile = null;
            do {
                if ((zeile = reader.readLine()) == null) continue;
                if (destroyWhitespaces) {
                    zeile = UtilityString.replaceWhiteSpaces(zeile, " ");
                }
                strings.addElement(zeile);
            } while (zeile != null);
            reader.close();
        }
        catch (IOException e) {
            Logable log = Configuration.getConfiguration().getLogEntity();
            if (log != null) {
                log.addLog(e, LogPanel.WARN);
            }
            System.err.println("Error reading file.");
            e.printStackTrace();
        }
        return strings;
    }

    public static String readTextFileToOneString(File file) {
        StringBuilder ret = new StringBuilder();
        try {
            InputStreamReader r = new InputStreamReader(new FileInputStream(file));
            BufferedReader reader = new BufferedReader(r);
            String zeile = null;
            do {
                if ((zeile = reader.readLine()) == null) continue;
                ret.append(zeile).append("\n");
            } while (zeile != null);
            reader.close();
        }
        catch (IOException e) {
            Logable log = Configuration.getConfiguration().getLogEntity();
            if (log != null) {
                log.addLog(e, LogPanel.WARN);
            }
            System.err.println("Error reading file: " + file.getAbsolutePath());
            e.printStackTrace();
        }
        return ret.toString();
    }

    public static boolean writeToTextFile(String string, File file) {
        try {
            OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(file));
            BufferedWriter writer = new BufferedWriter(w);
            writer.write(string);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            Logable log = Configuration.getConfiguration().getLogEntity();
            if (log != null) {
                log.addLog(e, LogPanel.WARN);
            } else {
                System.err.println("Error writing file.");
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static boolean writeToTextFile(Vector<String> strings, File file) {
        try {
            OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(file));
            BufferedWriter writer = new BufferedWriter(w);
            for (int i = 0; i < strings.size(); ++i) {
                String zeile = strings.elementAt(i);
                writer.write(zeile + "\n");
                writer.flush();
            }
            writer.close();
        }
        catch (IOException e) {
            Logable log = Configuration.getConfiguration().getLogEntity();
            if (log != null) {
                log.addLog(e, LogPanel.WARN);
            } else {
                System.err.println("Error writing file.");
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    public static boolean replaceToNewFile(File from, File to, Vector<String> searchFor, Vector<String> replaceWith) {
        Vector<String> stringFile = UtilityString.readTextFileToString(from);
        for (int i = 0; i < searchFor.size(); ++i) {
            stringFile = UtilityString.vectorReplace(stringFile, searchFor.elementAt(i), replaceWith.elementAt(i));
        }
        return UtilityString.writeToTextFile(stringFile, to);
    }

    public static String convertToHexWord(int value) {
        return String.format("%04X", value);
    }

    public static String convertToHex(int[] data2, int start, int end2, String divider) {
        if (start < 0) {
            start = 0;
        }
        if (end2 > data2.length - 1) {
            end2 = data2.length - 1;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end2; ++i) {
            int halfbyte = data2[i] >>> 4 & 0xF;
            int two_halfs = 0;
            if (i != start) {
                buf.append(divider);
            }
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data2[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    private static String convertToHex(byte[] data2) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data2.length; ++i) {
            int halfbyte = data2[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data2[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static int getReturnLengthOfStringFile(File file) {
        BufferedReader f;
        FileReader reader2;
        String line1 = "";
        String line2 = "";
        int ret = 2;
        try {
            reader2 = new FileReader(file);
            f = new BufferedReader(reader2);
            line1 = f.readLine();
            line2 = f.readLine();
            f.close();
        }
        catch (Throwable reader2) {
            // empty catch block
        }
        try {
            reader2 = new FileReader(file);
            f = new BufferedReader(reader2);
            f.skip(line1.length() + 2);
            String line22 = f.readLine();
            if (!line22.equals(line2)) {
                ret = 1;
            }
            f.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static int Int0(String t) {
        return UtilityString.IntX(t, 0);
    }

    public static int IntX(String t, int x) {
        if (t == null) {
            return x;
        }
        int ret = x;
        try {
            ret = Integer.parseInt(t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static long LongX(String t, int x) {
        long ret = x;
        try {
            ret = Long.parseLong(t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static float FloatX(String t, float x) {
        float ret = x;
        t = UtilityString.replace(t, ",", ".");
        try {
            ret = Float.parseFloat(t);
        }
        catch (Throwable e) {
            System.out.println(e);
        }
        return ret;
    }

    public static double DoubleX(String t, double x) {
        double ret = x;
        t = UtilityString.replace(t, ",", ".");
        try {
            ret = Double.parseDouble(t);
        }
        catch (Throwable e) {
            System.out.println(e);
        }
        return ret;
    }

    public static Vector<Integer> intVector(String s) {
        return UtilityString.intVector(s, ",");
    }

    public static Vector<Integer> intVector(String s, String seperator) {
        Vector<Integer> ret = new Vector<Integer>();
        String[] ss = s.split(seperator);
        for (int i = 0; i < ss.length; ++i) {
            ret.addElement(UtilityString.Int0(ss[i].trim()));
        }
        return ret;
    }

    public static String trimEnd(String s) {
        int i;
        if (s == null || s.length() == 0) {
            return s;
        }
        for (i = s.length(); i > 0 && Character.isWhitespace(s.charAt(i - 1)); --i) {
        }
        if (i == s.length()) {
            return s;
        }
        return s.substring(0, i);
    }

    public static String deleteLinesBefore(String input, String search) {
        String[] splitter = input.split("\n");
        StringBuilder result = new StringBuilder();
        boolean add = false;
        for (String line : splitter) {
            if (add) {
                result.append(line).append("\n");
                continue;
            }
            if (!line.startsWith(search)) continue;
            add = true;
            result.append(line).append("\n");
        }
        return result.toString();
    }

    public static String deleteLinesAfter(String input, String search) {
        String[] splitter = input.split("\n");
        StringBuilder result = new StringBuilder();
        boolean add = true;
        for (String line : splitter) {
            if (add) {
                result.append(line).append("\n");
            }
            if (!line.startsWith(search)) continue;
            add = false;
            result.append(line).append("\n");
            break;
        }
        return result.toString();
    }

    public static String[] cleanSplitNL(String in) {
        int i;
        String t = UtilityString.replace(in, "\t", " ");
        t = UtilityString.replace(t, "  ", " ");
        t = UtilityString.replace(t, "\r", "\n");
        t = UtilityString.replace(t, "\n\n", "\n");
        String[] s = t.split("\n");
        boolean count = false;
        ArrayList<String> ss = new ArrayList<String>();
        for (i = 0; i < s.length; ++i) {
            String tt = s[i].trim();
            if (tt.length() <= 0) continue;
            ss.add(tt);
        }
        s = new String[ss.size()];
        for (i = 0; i < ss.size(); ++i) {
            s[i] = (String)ss.get(i);
        }
        return s;
    }

    public static String[] cleanStringArray(String[] in) {
        ArrayList<String> ss = new ArrayList<String>();
        for (int i = 0; i < in.length; ++i) {
            String tt = in[i].trim();
            if (tt.length() <= 0) continue;
            ss.add(tt);
        }
        String[] s = new String[ss.size()];
        for (int i = 0; i < ss.size(); ++i) {
            s[i] = (String)ss.get(i);
        }
        return s;
    }
}

