/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util;

import de.malban.Global;
import de.malban.util.UtilityString;
import de.malban.util.XMLClassBuilderDataXMLHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class XMLClassBuilderData {
    protected String mClass = "";
    protected String mName = "";
    protected String mPackageName = "";
    protected String mClassName = "";
    protected Vector<String> mFieldname = new Vector();
    protected Vector<String> mXMLName = new Vector();
    protected Vector<String> mType = new Vector();
    private static XMLClassBuilderDataXMLHandler XMLHANDLER = new XMLClassBuilderDataXMLHandler();

    public String getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(String PackageName) {
        this.mPackageName = PackageName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public void setClassName(String ClassName) {
        this.mClassName = ClassName;
    }

    public Vector<String> getFieldname() {
        return this.mFieldname;
    }

    public void setFieldname(Vector<String> Fieldname) {
        this.mFieldname = Fieldname;
    }

    public Vector<String> getXMLName() {
        return this.mXMLName;
    }

    public void setXMLName(Vector<String> XMLName) {
        this.mXMLName = XMLName;
    }

    public Vector<String> getType() {
        return this.mType;
    }

    public void setType(Vector<String> Type2) {
        this.mType = Type2;
    }

    private String exportXML() {
        int i;
        String s = new String();
        s = s + "\t<XMLClassBuilderData>\n";
        s = s + "\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n";
        s = s + "\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n";
        s = s + "\t\t<PACKAGENAME>" + UtilityString.toXML(this.mPackageName) + "</PACKAGENAME>\n";
        s = s + "\t\t<CLASSNAME>" + UtilityString.toXML(this.mClassName) + "</CLASSNAME>\n";
        s = s + "\t\t<FIELDNAMEs>";
        for (i = 0; i < this.mFieldname.size(); ++i) {
            s = s + "\t\t<FIELDNAME>" + UtilityString.toXML(this.mFieldname.elementAt(i)) + "</FIELDNAME>\n";
        }
        s = s + "\t\t</FIELDNAMEs>";
        s = s + "\t\t<XMLNAMEs>";
        for (i = 0; i < this.mXMLName.size(); ++i) {
            s = s + "\t\t<XMLNAME>" + UtilityString.toXML(this.mXMLName.elementAt(i)) + "</XMLNAME>\n";
        }
        s = s + "\t\t</XMLNAMEs>";
        s = s + "\t\t<TYPEs>";
        for (i = 0; i < this.mType.size(); ++i) {
            s = s + "\t\t<TYPE>" + UtilityString.toXML(this.mType.elementAt(i)) + "</TYPE>\n";
        }
        s = s + "\t\t</TYPEs>";
        s = s + "\t</XMLClassBuilderData>\n";
        return s;
    }

    public String toString() {
        return this.mName;
    }

    public static XMLClassBuilderDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<XMLClassBuilderData> col) {
        try {
            PrintWriter pw = new PrintWriter(Global.mBaseDir + filename);
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllXMLClassBuilderData>\n");
            for (XMLClassBuilderData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllXMLClassBuilderData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, XMLClassBuilderData> getHashMapFromXML(String filename) {
        HashMap<String, XMLClassBuilderData> filters = new HashMap<String, XMLClassBuilderData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLClassBuilderDataXMLHandler h = XMLClassBuilderData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "XMLClassBuilderData Load Error...", 1);
        }
        return filters;
    }
}

