/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.Syntax;

import java.io.Reader;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;

class DocumentReader
extends Reader {
    private long position = 0L;
    private long mark = -1L;
    private AbstractDocument document;

    public void update(int position, int adjustment) {
        if ((long)position < this.position) {
            this.position = this.position < (long)(position - adjustment) ? (long)position : (this.position += (long)adjustment);
        }
    }

    public DocumentReader(AbstractDocument document) {
        this.document = document;
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.position < (long)this.document.getLength()) {
            try {
                char c = this.document.getText((int)this.position, 1).charAt(0);
                ++this.position;
                return c;
            }
            catch (BadLocationException x) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public int read(char[] cbuf) {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.position < (long)this.document.getLength()) {
            int length = len;
            if (this.position + (long)length >= (long)this.document.getLength()) {
                length = this.document.getLength() - (int)this.position;
            }
            if (off + length >= cbuf.length) {
                length = cbuf.length - off;
            }
            try {
                String s = this.document.getText((int)this.position, length);
                this.position += (long)length;
                for (int i = 0; i < length; ++i) {
                    cbuf[off + i] = s.charAt(i);
                }
                return length;
            }
            catch (BadLocationException x) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void reset() {
        this.position = this.mark == -1L ? 0L : this.mark;
        this.mark = -1L;
    }

    @Override
    public long skip(long n) {
        if (this.position + n <= (long)this.document.getLength()) {
            this.position += n;
            return n;
        }
        long oldPos = this.position;
        this.position = this.document.getLength();
        return (long)this.document.getLength() - oldPos;
    }

    public void seek(long n) {
        this.position = n <= (long)this.document.getLength() ? n : (long)this.document.getLength();
    }
}

