/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.Syntax;

import de.malban.config.Configuration;
import de.malban.gui.panels.LogPanel;
import de.malban.util.Utility;
import de.malban.util.syntax.Syntax.Colorer;
import de.malban.util.syntax.Syntax.DocumentReader;
import de.malban.util.syntax.Syntax.Lexer.BASICLexer;
import de.malban.util.syntax.Syntax.Lexer.CLexer;
import de.malban.util.syntax.Syntax.Lexer.HTMLLexer;
import de.malban.util.syntax.Syntax.Lexer.HTMLLexer1;
import de.malban.util.syntax.Syntax.Lexer.JavaLexer;
import de.malban.util.syntax.Syntax.Lexer.JavaScriptLexer;
import de.malban.util.syntax.Syntax.Lexer.LatexLexer;
import de.malban.util.syntax.Syntax.Lexer.Lexer;
import de.malban.util.syntax.Syntax.Lexer.M6809Lexer;
import de.malban.util.syntax.Syntax.Lexer.PlainLexer;
import de.malban.util.syntax.Syntax.Lexer.PropertiesLexer;
import de.malban.util.syntax.Syntax.Lexer.SQLLexer;
import de.malban.util.syntax.Syntax.TokenStyles;
import de.malban.util.syntax.entities.ASM6809File;
import de.malban.util.syntax.entities.ASM6809FileMaster;
import de.malban.util.syntax.entities.C6809File;
import de.malban.util.syntax.entities.C6809FileMaster;
import de.malban.vide.VideConfig;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public class HighlightedDocument
extends DefaultStyledDocument {
    public static final Object BASIC_STYLE = BASICLexer.class;
    public static final Object C_STYLE = CLexer.class;
    public static final Object HTML_STYLE = HTMLLexer.class;
    public static final Object HTML_KEY_STYLE = HTMLLexer1.class;
    public static final Object JAVA_STYLE = JavaLexer.class;
    public static final Object JAVASCRIPT_STYLE = JavaScriptLexer.class;
    public static final Object LATEX_STYLE = LatexLexer.class;
    public static final Object PLAIN_STYLE = PlainLexer.class;
    public static final Object PROPERTIES_STYLE = PropertiesLexer.class;
    public static final Object SQL_STYLE = SQLLexer.class;
    public static final Object GRAYED_OUT_STYLE = new Object();
    public static final Object M6809_STYLE = M6809Lexer.class;
    ASM6809File asmFileInfo = null;
    C6809File cFileInfo = null;
    String knownFilename = null;
    private final DocumentReader documentReader;
    private AttributeSet globalStyle = null;
    private Lexer syntaxLexer;
    private Colorer colorer;
    private final Object docLock = new Object();
    int vediId = -1;

    public HighlightedDocument(int id) {
        this.vediId = id;
        this.colorer = VideConfig.syntaxHighliteEnabled ? new Colorer(this) : null;
        this.documentReader = new DocumentReader(this);
        this.syntaxLexer = new JavaLexer(this.documentReader);
    }

    public HighlightedDocument(int id, String filename) {
        this.vediId = id;
        this.knownFilename = filename;
        this.colorer = VideConfig.syntaxHighliteEnabled ? new Colorer(this) : null;
        this.documentReader = new DocumentReader(this);
        this.syntaxLexer = new JavaLexer(this.documentReader);
    }

    public void start() {
        this.start(null);
    }

    public void start(String filename) {
        if (filename != null) {
            LogPanel log;
            String text;
            this.knownFilename = filename;
            if (filename.toLowerCase().endsWith(".asm") || filename.toLowerCase().endsWith(".s") || filename.toLowerCase().endsWith(".template") || filename.toLowerCase().endsWith(".i") || filename.toLowerCase().endsWith(".a69") || filename.toLowerCase().endsWith(".as9") || filename.toLowerCase().endsWith(".h")) {
                try {
                    text = this.getText(0, this.getLength());
                    if (ASM6809FileMaster.getInfo(this.vediId) == null) {
                        // empty if block
                    }
                    this.asmFileInfo = ASM6809FileMaster.getInfo(this.vediId).handleFile(filename, text);
                }
                catch (Throwable e) {
                    log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
                    log.addLog(Utility.getStackTrace(e), LogPanel.INFO);
                }
            }
            if (filename.toLowerCase().endsWith(".c") || filename.toLowerCase().endsWith(".cxx") || filename.toLowerCase().endsWith(".c++") || filename.toLowerCase().endsWith(".h")) {
                try {
                    text = this.getText(0, this.getLength());
                    this.cFileInfo = C6809FileMaster.getInfo(this.vediId).handleFile(filename, text);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
                    log.addLog(Utility.getStackTrace(e), LogPanel.INFO);
                }
            }
        }
        if (VideConfig.syntaxHighliteEnabled && !this.colorer.isStarted()) {
            this.colorAllDirect();
            this.colorer.start();
        }
    }

    public void deinit() {
        if (!VideConfig.syntaxHighliteEnabled) {
            return;
        }
        this.colorer.stopIt();
    }

    public void stopColoring() {
        if (!VideConfig.syntaxHighliteEnabled) {
            return;
        }
        this.colorer.stopIt();
    }

    public void startColoring() {
        if (!VideConfig.syntaxHighliteEnabled) {
            return;
        }
        if (this.colorer != null) {
            this.colorer.stopIt();
        }
        this.colorer = new Colorer(this);
        this.colorAllDirect();
        this.colorer.start();
    }

    public void colorAll() {
        if (!VideConfig.syntaxHighliteEnabled) {
            return;
        }
        if (this.colorer.isStarted()) {
            this.colorer.colorAll();
        }
    }

    public void colorAllDirect() {
        if (!VideConfig.syntaxHighliteEnabled) {
            return;
        }
        if (!this.colorer.isStarted()) {
            this.colorer.colorAllDirect();
        }
    }

    public void colordbg(int position, int adjustment) {
        if (!VideConfig.syntaxHighliteEnabled) {
            return;
        }
        if (this.colorer.isStarted()) {
            this.colorer.colordbg(position, adjustment);
        }
    }

    public void color(int position, int adjustment) {
        if (!VideConfig.syntaxHighliteEnabled) {
            return;
        }
        if (this.colorer.isStarted()) {
            this.colorer.color(position, adjustment);
        }
    }

    public void setGlobalStyle(AttributeSet value) {
        this.globalStyle = value;
    }

    public void setHighlightStyle(Object value) {
        this.setHighlightStyle(value, false);
    }

    public void setHighlightStyle(Object value, boolean colorAll) {
        if (value == GRAYED_OUT_STYLE) {
            this.setGlobalStyle(TokenStyles.getStyle("grayedOut"));
            return;
        }
        if (!(value instanceof Class)) {
            value = PLAIN_STYLE;
        }
        Class source = (Class)value;
        Class[] parms = new Class[]{Reader.class};
        Object[] args = new Object[]{this.documentReader};
        try {
            Constructor cons = source.getConstructor(parms);
            this.syntaxLexer = (Lexer)cons.newInstance(args);
            this.globalStyle = null;
            if (this.syntaxLexer instanceof M6809Lexer) {
                ((M6809Lexer)this.syntaxLexer).setVediId(this.vediId);
            }
            if (colorAll) {
                this.colorAll();
            }
        }
        catch (SecurityException e) {
            System.err.println("HighlightEditor.SecurityException");
        }
        catch (NoSuchMethodException e) {
            System.err.println("HighlightEditor.NoSuchMethod");
        }
        catch (InstantiationException e) {
            System.err.println("HighlightEditor.InstantiationException");
        }
        catch (InvocationTargetException e) {
            System.err.println("HighlightEditor.InvocationTargetException");
        }
        catch (IllegalAccessException e) {
            System.err.println("HighlightEditor.IllegalAccessException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        Object object = this.docLock;
        synchronized (object) {
            try {
                super.insertString(offs, str, a);
                this.color(offs, str.length());
                this.documentReader.update(offs, str.length());
            }
            catch (Throwable e) {
                LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
                log.addLog("Insert String - probably not mega bad", LogPanel.INFO);
                log.addLog(Utility.getStackTrace(e), LogPanel.INFO);
                log.addLog("offs: " + offs, LogPanel.INFO);
                log.addLog("str: " + str, LogPanel.INFO);
            }
        }
    }

    @Override
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        if (length < 0) {
            length = 0;
        }
        super.getText(offset, length, txt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (Math.abs(len) > 100) {
            boolean restartColorer = false;
            if (VideConfig.syntaxHighliteEnabled) {
                restartColorer = this.colorer.isStarted();
            }
            if (restartColorer) {
                this.stopColoring();
            }
            try {
                super.remove(offs, len);
            }
            catch (Throwable e) {
                LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
                log.addLog("Remove 1", LogPanel.INFO);
            }
            if (restartColorer) {
                this.startColoring();
            }
            return;
        }
        int lenOrg = len;
        Object object = this.docLock;
        synchronized (object) {
            int len2;
            do {
                Element elem = this.getParagraphElement(offs);
                int start = elem.getStartOffset();
                len2 = Math.min(elem.getEndOffset() - offs, len);
                if (len2 > 0) {
                    try {
                        super.remove(offs, len2);
                    }
                    catch (Throwable e) {
                        LogPanel log = (LogPanel)Configuration.getConfiguration().getDebugEntity();
                        log.addLog("Remove 2", LogPanel.INFO);
                    }
                    this.color(offs, -len2);
                    this.documentReader.update(offs, -len2);
                }
                if (len2 > 0) continue;
                len2 = 1;
            } while ((len -= len2) > 0);
        }
    }

    DocumentReader getDocumentReader() {
        return this.documentReader;
    }

    public Object getDocumentLock() {
        return this.docLock;
    }

    Lexer getSyntaxLexer() {
        return this.syntaxLexer;
    }

    AttributeSet getGlobalStyle() {
        return this.globalStyle;
    }
}

