/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.Syntax.Lexer;

import de.malban.util.syntax.Syntax.Lexer.Token;

public class BASICToken
extends Token {
    public static final int RESERVED_WORD = 256;
    public static final int RESERVED_REGISTER = 272;
    public static final int IDENTIFIER = 512;
    public static final int LINE_LABEL = 592;
    public static final int LITERAL_BOOLEAN = 768;
    public static final int LITERAL_INTEGER = 784;
    public static final int LITERAL_INTEGER_DECIMAL = 784;
    public static final int LITERAL_LONG_DECIMAL = 784;
    public static final int LITERAL_DOUBLE = 784;
    public static final int LITERAL_FLOATING_POINT = 784;
    public static final int LITERAL_INTEGER_HEXIDECIMAL = 784;
    public static final int LITERAL_LONG_HEXIDECIMAL = 784;
    public static final int IMMEDIATE_NUMBER = 832;
    public static final int LITERAL_CHARACTER = 848;
    public static final int LITERAL_STRING = 864;
    public static final int LITERAL_NULL = 880;
    public static final int LITERAL_VARIABLE = 896;
    public static final int SEPARATOR_LPAREN = 1024;
    public static final int SEPARATOR_RPAREN = 1025;
    public static final int SEPARATOR_LBRACE = 1040;
    public static final int SEPARATOR_RBRACE = 1041;
    public static final int SEPARATOR_LBRACKET = 1056;
    public static final int SEPARATOR_RBRACKET = 1057;
    public static final int SEPARATOR_SEMICOLON = 1072;
    public static final int SEPARATOR_COMMA = 1088;
    public static final int SEPARATOR_PERIOD = 1104;
    public static final int RESERVED_OPERATOR = 1280;
    public static final int OPERATOR_BITWISE_OR = 1280;
    public static final int OPERATOR_DIVIDE = 1280;
    public static final int OPERATOR_ADD = 1280;
    public static final int OPERATOR_ASSIGN = 1280;
    public static final int OPERATOR_GREATER_THAN = 1280;
    public static final int OPERATOR_LESS_THAN = 1280;
    public static final int OPERATOR_LOGICAL_NOT = 1280;
    public static final int OPERATOR_BITWISE_COMPLIMENT = 1280;
    public static final int OPERATOR_QUESTION = 1280;
    public static final int OPERATOR_COLON = 1280;
    public static final int OPERATOR_MULTIPLY = 1280;
    public static final int OPERATOR_BITWISE_AND = 1280;
    public static final int OPERATOR_BITWISE_XOR = 1280;
    public static final int OPERATOR_MOD = 1280;
    public static final int OPERATOR_LOGICAL_OR = 1280;
    public static final int OPERATOR_EQUAL = 1280;
    public static final int OPERATOR_GREATER_THAN_OR_EQUAL = 1280;
    public static final int OPERATOR_LESS_THAN_OR_EQUAL = 1280;
    public static final int OPERATOR_NOT_EQUAL = 1280;
    public static final int OPERATOR_SUBTRACT = 1280;
    public static final int RESERVED_ASMWORD = 1536;
    public static final int COMMENT_LINE = 3328;
    public static final int COMMENT_END_OF_LINE = 3344;
    public static final int WHITE_SPACE = 3584;
    public static final int ERROR_IDENTIFIER = 3840;
    public static final int ERROR_UNCLOSED_STRING = 3856;
    public static final int ERROR_MALFORMED_STRING = 3857;
    public static final int ERROR_MALFORMED_UNCLOSED_STRING = 3858;
    public static final int ERROR_UNCLOSED_CHARACTER = 3872;
    public static final int ERROR_MALFORMED_CHARACTER = 3873;
    public static final int ERROR_MALFORMED_UNCLOSED_CHARACTER = 3874;
    public static final int ERROR_INTEGER_DECIMIAL_SIZE = 3888;
    public static final int ERROR_INTEGER_OCTAL_SIZE = 3889;
    public static final int ERROR_INTEGER_HEXIDECIMAL_SIZE = 3890;
    public static final int ERROR_LONG_DECIMIAL_SIZE = 3891;
    public static final int ERROR_LONG_OCTAL_SIZE = 3892;
    public static final int ERROR_LONG_HEXIDECIMAL_SIZE = 3893;
    public static final int ERROR_FLOAT_SIZE = 3894;
    public static final int ERROR_DOUBLE_SIZE = 3895;
    public static final int ERROR_FLOAT = 3896;
    public static final int ERROR_UNCLOSED_COMMENT = 3904;
    public static final int RESERVED_WORD_ABSTRACT = 257;
    public static final int RESERVED_WORD_AUTO = 258;
    public static final int RESERVED_WORD_BREAK = 259;
    public static final int RESERVED_WORD_CASE = 260;
    public static final int RESERVED_WORD_CONST = 261;
    public static final int RESERVED_WORD_CONTINUE = 262;
    public static final int RESERVED_WORD_DEFAULT = 263;
    public static final int RESERVED_WORD_DO = 264;
    public static final int RESERVED_WORD_ELSE = 265;
    public static final int RESERVED_WORD_ENUM = 266;
    public static final int RESERVED_WORD_EXTERN = 267;
    public static final int RESERVED_WORD_FOR = 268;
    public static final int RESERVED_WORD_GOTO = 269;
    public static final int RESERVED_WORD_IF = 270;
    public static final int RESERVED_WORD_REGISTER = 271;
    public static final int RESERVED_WORD_RETURN = 272;
    public static final int RESERVED_WORD_SIZEOF = 273;
    public static final int RESERVED_WORD_STATIC = 274;
    public static final int RESERVED_WORD_STRUCT = 275;
    public static final int RESERVED_WORD_SWITCH = 276;
    public static final int RESERVED_WORD_TYPEDEF = 277;
    public static final int RESERVED_WORD_UNION = 278;
    public static final int RESERVED_WORD_VOLATILE = 279;
    public static final int RESERVED_WORD_WHILE = 280;
    public static final int RESERVED_WORD_CATCH = 281;
    public static final int RESERVED_WORD_CLASS = 282;
    public static final int RESERVED_WORD_CONST_CAST = 283;
    public static final int RESERVED_WORD_DELETE = 284;
    public static final int RESERVED_WORD_DYNAMIC_CAST = 285;
    public static final int RESERVED_WORD_FRIEND = 286;
    public static final int RESERVED_WORD_INLINE = 287;
    public static final int RESERVED_WORD_MUTABLE = 288;
    public static final int RESERVED_WORD_NAMESPACE = 289;
    public static final int RESERVED_WORD_NEW = 290;
    public static final int RESERVED_WORD_OPERATOR = 291;
    public static final int RESERVED_WORD_OVERLOAD = 292;
    public static final int RESERVED_WORD_PRIVATE = 293;
    public static final int RESERVED_WORD_PROTECTED = 294;
    public static final int RESERVED_WORD_PUBLIC = 295;
    public static final int RESERVED_WORD_REINTERPRET_CAST = 296;
    public static final int RESERVED_WORD_STATIC_CAST = 297;
    public static final int RESERVED_WORD_TEMPLATE = 298;
    public static final int RESERVED_WORD_THIS = 299;
    public static final int RESERVED_WORD_TRY = 300;
    public static final int RESERVED_WORD_VIRTUAL = 301;
    public static final int RESERVED_WORD_BOOL = 302;
    public static final int RESERVED_WORD_CHAR = 303;
    public static final int RESERVED_WORD_DOUBLE = 304;
    public static final int RESERVED_WORD_FLOAT = 305;
    public static final int RESERVED_WORD_INT = 306;
    public static final int RESERVED_WORD_LONG = 307;
    public static final int RESERVED_WORD_SHORT = 308;
    public static final int RESERVED_WORD_SIGNED = 309;
    public static final int RESERVED_WORD_UNSIGNED = 310;
    public static final int RESERVED_WORD_VOID = 311;
    public static final int RESERVED_WORD_ASM = 312;
    public static final int RESERVED_WORD_TYPENAME = 313;
    public static final int RESERVED_WORD_EXPLICIT = 314;
    public static final int RESERVED_WORD_USING = 315;
    public static final int RESERVED_WORD_THROW = 316;
    public static final int RESERVED_WORD_WCHAR_T = 317;
    public static final int RESERVED_WORD_TYPEID = 318;
    public static final int LITERAL_INTEGER_OCTAL = 785;
    public static final int LITERAL_LONG_OCTAL = 801;
    public static final int SEPARATOR_ARROW = 1120;
    public static final int OPERATOR_LOGICAL_AND = 1297;
    public static final int OPERATOR_SHIFT_LEFT = 1344;
    public static final int OPERATOR_SHIFT_RIGHT = 1345;
    public static final int OPERATOR_ADD_ASSIGN = 1376;
    public static final int OPERATOR_SUBTRACT_ASSIGN = 1377;
    public static final int OPERATOR_MULTIPLY_ASSIGN = 1378;
    public static final int OPERATOR_DIVIDE_ASSIGN = 1379;
    public static final int OPERATOR_MOD_ASSIGN = 1380;
    public static final int OPERATOR_BITWISE_AND_ASSIGN = 1393;
    public static final int OPERATOR_BITWISE_OR_ASSIGN = 1394;
    public static final int OPERATOR_BITWISE_XOR_ASSIGN = 1395;
    public static final int OPERATOR_SHIFT_LEFT_ASSIGN = 1408;
    public static final int OPERATOR_SHIFT_RIGHT_ASSIGN = 1409;
    public static final int OPERATOR_INCREMENT = 1424;
    public static final int OPERATOR_DECREMENT = 1425;
    public static final int PREPROCESSOR_DIRECTIVE = 3072;
    public static final int COMMENT_TRADITIONAL = 3328;
    public static final int COMMENT_DOCUMENTATION = 3360;
    public static final int ERROR_MALFORMED_PREPROCESSOR_DIRECTIVE = 3920;
    private int ID;
    private String contents;
    private int lineNumber;
    private int charBegin;
    private int charEnd;
    private int state;
    public boolean isMacroName = false;
    public boolean isMacroLabelName = false;
    public boolean isMacroParameterName = false;

    public BASICToken(int ID, String contents, int lineNumber, int charBegin, int charEnd) {
        this(ID, contents, lineNumber, charBegin, charEnd, -1);
    }

    public BASICToken(int ID, String contents, int lineNumber, int charBegin, int charEnd, int state) {
        this.ID = ID;
        this.contents = new String(contents);
        this.lineNumber = lineNumber;
        this.charBegin = charBegin;
        this.charEnd = charEnd;
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public String getContents() {
        return new String(this.contents);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getCharBegin() {
        return this.charBegin;
    }

    @Override
    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isReservedWord() {
        return this.ID >> 8 == 1;
    }

    public boolean isRegister() {
        return this.ID == 272;
    }

    public boolean isASMWord() {
        return this.ID >= 1536 && this.ID <= 1791;
    }

    public boolean isIdentifier() {
        return this.ID >> 8 == 2;
    }

    public boolean isName() {
        return (this.ID & 0x250) == 592;
    }

    public boolean isLiteral() {
        return this.ID >> 8 == 3;
    }

    public boolean isLiteralString() {
        return this.ID == 864;
    }

    public boolean isLiteralVariable() {
        return this.ID == 896;
    }

    public boolean isSeparator() {
        return this.ID >> 8 == 4;
    }

    public boolean isOperator() {
        return this.ID >> 8 == 5;
    }

    @Override
    public boolean isComment() {
        return this.ID >> 8 == 13;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.ID >> 8 == 14;
    }

    @Override
    public boolean isError() {
        return this.ID >> 8 == 15;
    }

    @Override
    public String getDescription() {
        if (this.isRegister()) {
            return "register";
        }
        if (this.isReservedWord()) {
            return "reservedWord";
        }
        if (this.isASMWord()) {
            return "preprocessor";
        }
        if (this.isIdentifier()) {
            return "identifier";
        }
        if (this.isLiteralVariable()) {
            return "literalVariable";
        }
        if (this.isLiteralString()) {
            return "literalstring";
        }
        if (this.isLiteral()) {
            return "literal";
        }
        if (this.isSeparator()) {
            return "separator";
        }
        if (this.isOperator()) {
            return "operator";
        }
        if (this.isComment()) {
            return "comment";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        if (this.isName()) {
            return "name";
        }
        if (this.isError()) {
            return "error";
        }
        return "unknown";
    }

    @Override
    public String errorString() {
        String s;
        if (this.isError()) {
            s = "Error on line " + this.lineNumber + ": ";
            switch (this.ID) {
                case 3840: {
                    s = s + "Unrecognized Identifier: " + this.contents;
                    break;
                }
                case 3856: {
                    s = s + "'\"' expected after " + this.contents;
                    break;
                }
                case 3857: 
                case 3858: {
                    s = s + "Illegal character in " + this.contents;
                    break;
                }
                case 3872: {
                    s = s + "\"'\" expected after " + this.contents;
                    break;
                }
                case 3873: 
                case 3874: {
                    s = s + "Illegal character in " + this.contents;
                    break;
                }
                case 3888: 
                case 3889: 
                case 3896: {
                    s = s + "Illegal character in " + this.contents;
                    break;
                }
                case 3890: 
                case 3891: 
                case 3892: 
                case 3893: 
                case 3894: 
                case 3895: {
                    s = s + "Literal out of bounds: " + this.contents;
                    break;
                }
                case 3904: {
                    s = s + "*/ expected after " + this.contents;
                }
            }
        } else {
            s = null;
        }
        return s;
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.ID) + ": " + this.getDescription() + " Line " + this.lineNumber + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

