/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.Syntax.Lexer;

import de.malban.util.syntax.Syntax.Lexer.Token;

public class PlainToken
extends Token {
    public static final int TEXT = 512;
    public static final int WHITE_SPACE = 3584;
    private int ID;
    private String contents;
    private int lineNumber;
    private int charBegin;
    private int charEnd;
    private int state;

    public PlainToken(int ID, String contents, int lineNumber, int charBegin, int charEnd) {
        this(ID, contents, lineNumber, charBegin, charEnd, -1);
    }

    public PlainToken(int ID, String contents, int lineNumber, int charBegin, int charEnd, int state) {
        this.ID = ID;
        this.contents = new String(contents);
        this.lineNumber = lineNumber;
        this.charBegin = charBegin;
        this.charEnd = charEnd;
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public String getContents() {
        return new String(this.contents);
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getCharBegin() {
        return this.charBegin;
    }

    @Override
    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isText() {
        return this.ID >> 8 == 2;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.ID >> 8 == 14;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isComment() {
        return false;
    }

    @Override
    public String getDescription() {
        if (this.isText()) {
            return "text";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        return "unknown";
    }

    @Override
    public String errorString() {
        return "";
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.ID) + ": " + this.getDescription() + " Line " + this.lineNumber + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

