/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.Syntax;

import de.malban.gui.dialogs.FontChooserComponent;
import de.malban.gui.dialogs.FontChooserPanel;
import de.malban.gui.dialogs.InternalColorChooserDialog;
import de.malban.util.syntax.Syntax.TokenStyles;
import de.malban.vide.ConfigJPanel;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class StyleJPanel
extends JPanel {
    KeyTableModel model;
    SimpleAttributeSet currentStyle;
    String currentName = "";
    int mClassSetting = 0;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButtonFontMinus;
    private JButton jButtonFontPlus;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JTable jTable1;
    private JTextField jTextField1;
    private JTextPane jTextPane1;
    int selectedRow = -1;

    public StyleJPanel() {
        this.initComponents();
        this.jButtonFontPlus.setVisible(false);
        this.jButtonFontMinus.setVisible(false);
        this.model = new KeyTableModel();
        this.jTable1.setModel(this.model);
        ListSelectionModel cellSelectionModel = this.jTable1.getSelectionModel();
        cellSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StyleJPanel.this.tableSelectionChanged();
            }
        });
        String text = this.jTextPane1.getText();
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.jTextPane1.setDocument(doc);
        this.jTextPane1.setText(text);
        TableColumnModel cModel = this.jTable1.getColumnModel();
        cModel.getColumn(0).setWidth(200);
        cModel.getColumn(1).setWidth(100);
        cModel.getColumn(2).setWidth(100);
        cModel.getColumn(3).setWidth(100);
        cModel.getColumn(4).setWidth(10);
        cModel.getColumn(5).setWidth(10);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1 = new JButton();
        this.jTextField1 = new JTextField();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jButtonFontPlus = new JButton();
        this.jButtonFontMinus = new JButton();
        this.jLabel1 = new JLabel();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setSelectionMode(0);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                StyleJPanel.this.jTable1MousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButton1.setText("use");
        this.jButton1.setEnabled(false);
        this.jButton1.setMargin(new Insets(0, 2, 0, 2));
        this.jButton1.setPreferredSize(new Dimension(25, 21));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTextField1.setEnabled(false);
        this.jTextField1.setPreferredSize(new Dimension(6, 21));
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/font.png")));
        this.jButton2.setEnabled(false);
        this.jButton2.setMargin(new Insets(0, 0, 0, 0));
        this.jButton2.setPreferredSize(new Dimension(19, 19));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/color_swatch.png")));
        this.jButton3.setText("FG");
        this.jButton3.setEnabled(false);
        this.jButton3.setMargin(new Insets(0, 0, 0, 0));
        this.jButton3.setPreferredSize(new Dimension(19, 19));
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleJPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/color_swatch.png")));
        this.jButton4.setText("BG");
        this.jButton4.setEnabled(false);
        this.jButton4.setMargin(new Insets(0, 0, 0, 0));
        this.jButton4.setPreferredSize(new Dimension(19, 19));
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleJPanel.this.jButton4ActionPerformed(evt);
            }
        });
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.setVerticalScrollBarPolicy(21);
        this.jTextPane1.setText("Lorem ipsum dolor sit amet, ...");
        this.jScrollPane3.setViewportView(this.jTextPane1);
        this.jButtonFontPlus.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/add.png")));
        this.jButtonFontPlus.setToolTipText("update size of all fonts");
        this.jButtonFontPlus.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonFontPlus.setPreferredSize(new Dimension(19, 19));
        this.jButtonFontPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleJPanel.this.jButtonFontPlusActionPerformed(evt);
            }
        });
        this.jButtonFontMinus.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/delete.png")));
        this.jButtonFontMinus.setToolTipText("update size of all fonts");
        this.jButtonFontMinus.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonFontMinus.setPreferredSize(new Dimension(19, 19));
        this.jButtonFontMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StyleJPanel.this.jButtonFontMinusActionPerformed(evt);
            }
        });
        this.jLabel1.setForeground(new Color(102, 102, 102));
        this.jLabel1.setText("New bindings are activated with the next recoloring. Not immediate!");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 479, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 233, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextField1, -2, 137, -2).addGroup(layout.createSequentialGroup().addComponent(this.jButton3, -1, -1, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.jButton4, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton2, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton1, -2, 44, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonFontPlus, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonFontMinus, -2, 19, -2)))).addComponent(this.jLabel1)).addContainerGap(24, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jButton1, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonFontMinus, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButton2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButton3, -2, -1, -2).addComponent(this.jButton4, -2, -1, -2).addComponent(this.jButtonFontPlus, -2, -1, -2))).addComponent(this.jScrollPane3, -2, 42, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 202, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.selectedRow == -1) {
            return;
        }
        TokenStyles.addStyle(this.currentName, StyleConstants.getBackground(this.currentStyle), StyleConstants.getForeground(this.currentStyle), StyleConstants.isBold(this.currentStyle), StyleConstants.isItalic(this.currentStyle), StyleConstants.getFontSize(this.currentStyle), StyleConstants.getFontFamily(this.currentStyle));
        this.jTable1.repaint();
        ConfigJPanel.changeTab();
        this.jTable1.setRowSelectionInterval(0, 0);
        this.tableSelectionChanged();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.currentStyle == null) {
            return;
        }
        boolean enableSize = this.currentName.toLowerCase().contains("edit");
        FontChooserComponent fontChooser = FontChooserPanel.showFontChoserDialog("Font Chooser", this.currentStyle, enableSize);
        if (fontChooser == null) {
            return;
        }
        this.jTextField1.setText(fontChooser.getSelectedFontFamily());
        StyleConstants.setFontFamily(this.currentStyle, fontChooser.getSelectedFontFamily());
        StyleConstants.setFontSize(this.currentStyle, fontChooser.getSelectedFontSize());
        StyleConstants.setBold(this.currentStyle, (fontChooser.getSelectedFontStyle() & 1) == 1);
        StyleConstants.setItalic(this.currentStyle, (fontChooser.getSelectedFontStyle() & 2) == 2);
        this.restyle();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        if (this.currentStyle == null) {
            return;
        }
        Color c = InternalColorChooserDialog.showDialog("Color", StyleConstants.getForeground(this.currentStyle));
        if (c == null) {
            return;
        }
        StyleConstants.setForeground(this.currentStyle, c);
        this.restyle();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        if (this.currentStyle == null) {
            return;
        }
        Color c = InternalColorChooserDialog.showDialog("Color", StyleConstants.getBackground(this.currentStyle));
        if (c == null) {
            return;
        }
        StyleConstants.setBackground(this.currentStyle, c);
        this.restyle();
    }

    private void jButtonFontPlusActionPerformed(ActionEvent evt) {
        this.increaseFontSize();
        this.restyle();
        this.jTable1.repaint();
    }

    private void jButtonFontMinusActionPerformed(ActionEvent evt) {
        this.decreaseFontSize();
        this.restyle();
        this.jTable1.repaint();
    }

    private void jTable1MousePressed(MouseEvent evt) {
    }

    String getColor(Color c) {
        String cc = "";
        cc = cc + c.getRed() + ", ";
        cc = cc + c.getGreen() + ", ";
        cc = cc + c.getBlue();
        return cc;
    }

    void tableSelectionChanged() {
        if (this.mClassSetting > 0) {
            return;
        }
        this.selectedRow = this.jTable1.getSelectedRow();
        if (this.selectedRow == -1) {
            return;
        }
        ++this.mClassSetting;
        this.currentStyle = (SimpleAttributeSet)TokenStyles.styleList.get(this.selectedRow).clone();
        this.currentName = TokenStyles.styleList.get((int)this.selectedRow).name;
        this.jTextField1.setText(StyleConstants.getFontFamily(this.currentStyle));
        this.restyle();
        --this.mClassSetting;
        this.jTextField1.setEnabled(true);
        this.jButton1.setEnabled(true);
        this.jButton2.setEnabled(true);
        this.jButton3.setEnabled(true);
        this.jButton4.setEnabled(true);
    }

    void restyle() {
        String text = this.jTextPane1.getText();
        DefaultStyledDocument doc = (DefaultStyledDocument)this.jTextPane1.getDocument();
        this.jTextPane1.setText(text);
        int e = doc.getLength();
        int s = 0;
        if (this.currentStyle != null) {
            doc.setCharacterAttributes(s, e, this.currentStyle, true);
        }
        this.jTextPane1.repaint();
    }

    void increaseFontSize() {
        ArrayList<TokenStyles.MyStyle> cloneStyleList = TokenStyles.styleList;
        TokenStyles.reset();
        for (TokenStyles.MyStyle style : cloneStyleList) {
            TokenStyles.addStyle(style.name, StyleConstants.getBackground(style), StyleConstants.getForeground(style), StyleConstants.isBold(style), StyleConstants.isItalic(style), StyleConstants.getFontSize(style) + 1, StyleConstants.getFontFamily(style));
        }
        if (this.currentStyle != null) {
            this.currentStyle = (TokenStyles.MyStyle)TokenStyles.getStyle(this.currentName);
        }
    }

    void decreaseFontSize() {
        ArrayList<TokenStyles.MyStyle> cloneStyleList = TokenStyles.styleList;
        TokenStyles.reset();
        for (TokenStyles.MyStyle style : cloneStyleList) {
            TokenStyles.addStyle(style.name, StyleConstants.getBackground(style), StyleConstants.getForeground(style), StyleConstants.isBold(style), StyleConstants.isItalic(style), StyleConstants.getFontSize(style) - 1, StyleConstants.getFontFamily(style));
        }
        if (this.currentStyle != null) {
            this.currentStyle = (TokenStyles.MyStyle)TokenStyles.getStyle(this.currentName);
        }
    }

    public void updateMyUI() {
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 3;
        this.jTable1.setRowHeight(rowHeight);
    }

    public void refresh() {
        this.jTable1.tableChanged(null);
        this.jTextPane1.repaint();
    }

    public class KeyTableModel
    extends AbstractTableModel {
        String[] columns = new String[]{"Name", "FG color", "BG Color", "Font", "bold", "italic"};

        @Override
        public String getColumnName(int col) {
            return this.columns[col];
        }

        @Override
        public int getRowCount() {
            return TokenStyles.styleList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return TokenStyles.styleList.get((int)row).name;
            }
            if (col == 1) {
                return StyleJPanel.this.getColor(StyleConstants.getForeground(TokenStyles.styleList.get(row)));
            }
            if (col == 2) {
                return StyleJPanel.this.getColor(StyleConstants.getBackground(TokenStyles.styleList.get(row)));
            }
            if (col == 3) {
                return StyleConstants.getFontFamily(TokenStyles.styleList.get(row));
            }
            if (col == 4) {
                return StyleConstants.isBold(TokenStyles.styleList.get(row));
            }
            if (col == 5) {
                return StyleConstants.isItalic(TokenStyles.styleList.get(row));
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return String.class;
            }
            if (col == 1) {
                return Color.class;
            }
            if (col == 2) {
                return Color.class;
            }
            if (col == 3) {
                return String.class;
            }
            if (col == 4) {
                return Boolean.class;
            }
            if (col == 5) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
        }
    }
}

