/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.Syntax;

import de.malban.vide.VideConfig;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

public class TokenStyles {
    public static HashMap styles;
    public static int FONT_SIZE;
    public static ArrayList<MyStyle> styleList;

    private TokenStyles() {
    }

    static void resetStyles() {
        TokenStyles.declareStyles();
    }

    private static void declareStyles() {
        styles = new HashMap();
        styleList = new ArrayList();
        Color maroon = new Color(11546720);
        Color darkBlue = new Color(128);
        Color darkGreen = Color.GREEN.darker();
        Color orange = new Color(0xFF8000);
        Color darkerGreen = new Color(0x105010);
        TokenStyles.addStyle("register", Color.WHITE, Color.BLACK, true, false);
        TokenStyles.addStyle("tag", Color.WHITE, Color.BLUE, true, false);
        TokenStyles.addStyle("reference", Color.WHITE, Color.BLACK, false, false);
        TokenStyles.addStyle("name", Color.WHITE, darkerGreen, true, false);
        TokenStyles.addStyle("value", Color.WHITE, maroon, false, true);
        TokenStyles.addStyle("text", Color.WHITE, Color.BLACK, true, false);
        TokenStyles.addStyle("default", Color.WHITE, Color.BLACK, true, false);
        TokenStyles.addStyle("reservedWord", Color.WHITE, Color.BLUE, false, false);
        TokenStyles.addStyle("identifier", Color.WHITE, darkerGreen, false, false);
        TokenStyles.addStyle("literal", Color.WHITE, maroon, false, false);
        TokenStyles.addStyle("literalstring", Color.WHITE, orange, false, false);
        TokenStyles.addStyle("separator", Color.WHITE, darkBlue, false, false);
        TokenStyles.addStyle("operator", Color.WHITE, Color.BLACK, false, false);
        TokenStyles.addStyle("comment", Color.WHITE, darkGreen, false, false);
        TokenStyles.addStyle("preprocessor", Color.WHITE, darkBlue, false, false);
        TokenStyles.addStyle("whitespace", Color.WHITE, Color.BLACK, false, false);
        TokenStyles.addStyle("error", Color.WHITE, Color.RED, false, false);
        TokenStyles.addStyle("unknown", Color.WHITE, Color.RED.darker(), true, false);
        TokenStyles.addStyle("grayedOut", Color.WHITE, Color.GRAY, false, false);
        TokenStyles.addStyle("literalVariable", Color.WHITE, darkerGreen, false, false);
        TokenStyles.addStyle("editLogMessage", Color.WHITE, Color.BLACK, false, false);
        TokenStyles.addStyle("editLogWarning", Color.WHITE, Color.BLUE, false, false);
        TokenStyles.addStyle("editLogComment", Color.WHITE, darkGreen, false, false);
        TokenStyles.addStyle("editLogError", Color.WHITE, Color.RED, false, false);
        TokenStyles.addStyle("breakpoint", Color.red, darkGreen, false, false);
        TokenStyles.addStyle("bookmark", Color.BLUE, darkGreen, false, false);
    }

    private static void addStyle(String name, Color bg, Color fg, boolean bold, boolean italic) {
        TokenStyles.addStyle(name, bg, fg, bold, italic, 12, "Monospaced");
    }

    public static void addStyle(String name, Color bg, Color fg, boolean bold, boolean italic, int size, String family) {
        FONT_SIZE = size * 2 / 3;
        VideConfig config = VideConfig.getConfig();
        int TAB_WIDTH = 8;
        if (config != null) {
            TAB_WIDTH = config.tab_width;
        }
        int TAB_COUNT = 100;
        TabStop[] tabs = new TabStop[TAB_COUNT];
        for (int i = 0; i < TAB_COUNT; ++i) {
            tabs[i] = new TabStop((i + 1) * TAB_WIDTH * FONT_SIZE, 0, 0);
        }
        TabSet tabset = new TabSet(tabs);
        MyStyle style = new MyStyle();
        StyleConstants.setFontFamily(style, family);
        StyleConstants.setFontSize(style, size);
        StyleConstants.setBackground(style, bg);
        StyleConstants.setForeground(style, fg);
        StyleConstants.setBold(style, bold);
        StyleConstants.setItalic(style, italic);
        StyleConstants.setTabSet(style, tabset);
        style.name = name;
        styles.put(name, style);
        TokenStyles.addToList(style);
    }

    public static void addToList(MyStyle style) {
        for (int i = 0; i < styleList.size(); ++i) {
            if (!TokenStyles.styleList.get((int)i).name.equals(style.name)) continue;
            styleList.remove(i);
            break;
        }
        styleList.add(style);
    }

    public static AttributeSet getStyle(String styleName) {
        return (AttributeSet)styles.get(styleName);
    }

    public static void reset() {
        styles = new HashMap();
        styleList = new ArrayList();
    }

    static {
        FONT_SIZE = 12;
        TokenStyles.declareStyles();
    }

    public static class MyStyle
    extends SimpleAttributeSet {
        public String name = "";
    }
}

