/*
 * Decompiled with CFR 0.152.
 */
package de.malban.util.syntax.entities;

import de.malban.util.UtilityString;
import de.malban.util.syntax.entities.ASM6809File;
import de.malban.util.syntax.entities.C6809File;
import de.malban.vide.dissy.DASM6809;
import java.util.ArrayList;

public class EntityDefinition {
    private static int _UID = 0;
    private final int uid = _UID++;
    public static int TYP_MACRO = 1;
    public static int TYP_LABEL = 2;
    public static int TYP_INCLUDE = 3;
    public static int TYP_MACRO_PARAM = 4;
    public static int TYP_CFUNCTION = 5;
    public static int TYP_LIB_INCLUDE = 6;
    public static int SUBTYPE_NO_LABEL = 0;
    public static int SUBTYPE_EQU_LABEL = 1;
    public static int SUBTYPE_DEFINED_LABEL = 2;
    public static int SUBTYPE_SET_LABEL = 3;
    public static int SUBTYPE_STRUCT_LABEL = 4;
    public static int SUBTYPE_INSTRUCT_LABEL = 5;
    public static int SUBTYPE_LINE_LABEL = 6;
    public static int SUBTYPE_DATA_LABEL = 7;
    public static int SUBTYPE_INNER_MACRO_LABEL = 8;
    public static int SUBTYPE_FUNCTION_LABEL = 9;
    public static int SUBTYPE_VERIFIED_FUNCTION_LABEL = 10;
    public static int SUBTYPE_MACRO_DEFINITION_LABEL = 11;
    public static int SUBTYPE_MACRO_PARAMETER_LABEL = 12;
    public static String[] SUBTYPE_NAMES = new String[]{"unkown", "equ", "=", "set", "struct", "in struct", "line", "data", "macro", "function", "user", "macro def", "macro par"};
    private int status = -1;
    ASM6809File file;
    C6809File cfile;
    int lineNumber = -1;
    String orgLine;
    String name = "";
    String value;
    ArrayList<String> parameter;
    ArrayList<String> previousParameter;
    int type;
    int subtype = SUBTYPE_NO_LABEL;
    String previousOrgLine;
    String previousName;
    String previousValue;
    int previousType;
    boolean isStructStart = false;
    boolean isStructEnd = false;
    boolean isMacroStart = false;
    boolean isMacroEnd = false;
    static final int PURE = 0;
    static final int HALF_PURE = 1;
    static final int NORMAL = 2;
    static final int REALLY_PURE = 3;

    private EntityDefinition() {
    }

    int getUID() {
        return this.uid;
    }

    public C6809File getCFile() {
        return this.cfile;
    }

    public ASM6809File getFile() {
        return this.file;
    }

    public int getLineNumber() {
        String ln = this.orgLine.substring(this.orgLine.lastIndexOf(";") + 1);
        return Integer.parseInt(ln) + 1;
    }

    public String getOrgLine() {
        return this.orgLine.substring(0, this.orgLine.lastIndexOf(";"));
    }

    public String getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    public int getSubType() {
        return this.subtype;
    }

    public String getName() {
        return this.name;
    }

    public static EntityDefinition scanLine(ASM6809File _file, String _orgLine) {
        if (_orgLine == null) {
            return null;
        }
        EntityDefinition entity = new EntityDefinition();
        entity.file = _file;
        entity.processLine(_orgLine);
        return entity;
    }

    public static EntityDefinition scanLine(C6809File _file, String _orgLine) {
        if (_orgLine == null) {
            return null;
        }
        EntityDefinition entity = new EntityDefinition();
        entity.cfile = _file;
        entity.processCLine(_orgLine);
        return entity;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public int updateEntity(String line) {
        this.status = 0;
        if (this.cfile != null) {
            this.processCLine(line);
        } else {
            this.processLine(line);
        }
        return this.status;
    }

    private void processLine(String line) {
        this.previousOrgLine = this.orgLine;
        this.previousName = this.name;
        this.previousValue = this.value;
        this.previousType = this.type;
        this.previousParameter = this.parameter;
        boolean done = false;
        this.type = 0;
        this.name = "";
        this.parameter = null;
        this.isStructStart = false;
        this.isStructEnd = false;
        this.isMacroStart = false;
        this.isMacroEnd = false;
        this.orgLine = line;
        line = EntityDefinition.removeComment(line, ";");
        if ((line = EntityDefinition.removeComment(line, "*")).trim().length() != 0) {
            String lineRest;
            int pos = this.macroPos(line);
            if (pos != -1) {
                done = true;
                this.type = TYP_MACRO;
                String[] split = line.trim().split("[ \\t,]");
                this.name = split[0].trim();
                if (this.name != null) {
                    if (pos + 5 < line.length()) {
                        this.value = line.substring(pos + 5).trim();
                    }
                } else {
                    this.name = "";
                }
                if (split.length > 1) {
                    this.parameter = new ArrayList();
                    for (int p = 2; p < split.length; ++p) {
                        String parm = split[p].trim();
                        if (parm.length() <= 0) continue;
                        this.parameter.add(parm);
                    }
                }
            }
            if (!done && (pos = this.includePos(line)) != -1) {
                done = true;
                this.type = TYP_INCLUDE;
                lineRest = line.substring(pos + 7).trim();
                this.name = this.getFirstFilename(lineRest);
                if (this.name == null) {
                    this.name = "";
                }
            }
            if (!done && (pos = this.equPos(line)) != -1) {
                done = true;
                this.type = TYP_LABEL;
                this.subtype = SUBTYPE_EQU_LABEL;
                lineRest = line.substring(pos + 3).trim();
                this.value = lineRest.trim();
                String lineStart = line.substring(0, pos).trim();
                this.name = this.getLastName(lineStart);
                if (this.name == null) {
                    this.name = "";
                }
                if (this.name.endsWith(":")) {
                    this.name = this.name.substring(0, this.name.length() - 1);
                }
            }
            if (!done && (pos = this.equalPos(line)) != -1) {
                done = true;
                this.type = TYP_LABEL;
                this.subtype = SUBTYPE_DEFINED_LABEL;
                lineRest = line.substring(pos + 1).trim();
                this.value = lineRest.trim();
                String lineStart = line.substring(0, pos).trim();
                this.name = this.getLastName(lineStart);
                if (this.name == null) {
                    this.name = "";
                }
            }
            if (!done && (pos = this.setPos(line)) != -1) {
                done = true;
                this.type = TYP_LABEL;
                this.subtype = SUBTYPE_SET_LABEL;
                lineRest = line.substring(pos + 3).trim();
                this.value = lineRest.trim();
                String lineStart = line.substring(0, pos).trim();
                this.name = this.getLastName(lineStart);
                if (this.name == null) {
                    this.name = "";
                }
            }
            if (!done && (pos = this.structPos(line)) != -1) {
                done = true;
                this.type = TYP_LABEL;
                this.subtype = SUBTYPE_STRUCT_LABEL;
                lineRest = line.substring(pos + 6).trim();
                this.value = "struct - value not identified";
                String[] splitter = lineRest.split(" ");
                if (splitter.length > 0) {
                    this.name = splitter[0];
                }
                if (this.name == null) {
                    this.name = "";
                }
            }
            if (!done && this.inStruct()) {
                pos = this.dbPos(line);
                if (pos == -1) {
                    pos = this.dwPos(line);
                }
                if (pos == -1) {
                    pos = this.dsPos(line);
                }
                if (pos != -1) {
                    done = true;
                    lineRest = line.substring(pos + 2).trim();
                    String[] splitter = lineRest.split("[ \\t,]");
                    if (splitter.length > 0) {
                        this.name = splitter[0];
                        int number = DASM6809.toNumber(this.name);
                        if (number != 0) {
                            this.name = null;
                            done = false;
                        } else {
                            this.type = TYP_LABEL;
                            this.subtype = SUBTYPE_INSTRUCT_LABEL;
                            this.value = "struct - value not identified";
                        }
                    }
                    if (this.name == null) {
                        this.name = "";
                    }
                }
            }
            if (!done && this.inMacro()) {
                char start;
                line = this.orgLine;
                line = EntityDefinition.removeComment(line, ";");
                if ((line = EntityDefinition.removeComment(line, "*")).length() > 0 && (start = line.charAt(0)) != ' ' && start != '*' && start != ';' && start != '\t') {
                    done = true;
                    this.type = TYP_LABEL;
                    this.subtype = SUBTYPE_INNER_MACRO_LABEL;
                    this.value = "line label";
                    this.name = this.getFirstName(line);
                    if (this.name == null) {
                        this.name = "";
                    }
                    line = UtilityString.replaceWhiteSpaces(line.toLowerCase(), " ");
                }
            }
            if (!done) {
                char start;
                line = this.orgLine;
                line = EntityDefinition.removeComment(line, ";");
                if ((line = EntityDefinition.removeComment(line, "*")).length() > 0 && (start = line.charAt(0)) != ' ' && start != '*' && start != ';' && start != '\t') {
                    done = true;
                    this.type = TYP_LABEL;
                    this.subtype = SUBTYPE_LINE_LABEL;
                    this.value = "line label";
                    this.name = this.getFirstName(line);
                    if (this.name == null) {
                        this.name = "";
                    }
                    if ((line = UtilityString.replaceWhiteSpaces(line.toLowerCase(), " ")).contains("\\? ")) {
                        this.subtype = SUBTYPE_INNER_MACRO_LABEL;
                    }
                    if (line.contains("&@ ")) {
                        this.subtype = SUBTYPE_INNER_MACRO_LABEL;
                    }
                    if (line.contains("\\?: ")) {
                        this.subtype = SUBTYPE_INNER_MACRO_LABEL;
                    }
                    if (line.contains("&@: ")) {
                        this.subtype = SUBTYPE_INNER_MACRO_LABEL;
                    }
                    if (this.subtype == SUBTYPE_LINE_LABEL && this.isDataLabel()) {
                        this.subtype = SUBTYPE_DATA_LABEL;
                    }
                    if (this.subtype == SUBTYPE_LINE_LABEL && this.isPureFunctionCallLabel()) {
                        this.subtype = SUBTYPE_FUNCTION_LABEL;
                    }
                    if (this.orgLine.toLowerCase().contains("#isfunction")) {
                        this.subtype = SUBTYPE_VERIFIED_FUNCTION_LABEL;
                    }
                }
            }
        }
        if (this.name.trim().length() == 0 && !this.isStructEnd && !this.isMacroEnd) {
            this.status = -1;
            return;
        }
        this.status = this.name.equals(this.previousName) ? 0 : 1;
    }

    private int cincludePos(String line) {
        return EntityDefinition.searchPos(line.toLowerCase(), "#include", 2);
    }

    private int includePos(String line) {
        int pos = EntityDefinition.searchPos(line.toLowerCase(), "include", 1);
        if (!line.contains("\"") && !line.contains("'")) {
            return -1;
        }
        return pos;
    }

    private int macroPos(String line) {
        this.isMacroStart = false;
        int pos = EntityDefinition.searchPos(line.toLowerCase(), "macro", 3);
        this.isMacroEnd = false;
        int pos2 = EntityDefinition.searchPos(line.toLowerCase(), "endm", 0);
        if (pos2 >= 0) {
            this.isMacroEnd = true;
            return -1;
        }
        if (pos < 0) {
            return -1;
        }
        this.isMacroStart = true;
        return pos;
    }

    private int equPos(String line) {
        return EntityDefinition.searchPos(line.toLowerCase(), "equ", 3);
    }

    private int equalPos(String line) {
        int pos = EntityDefinition.searchPos(line.toLowerCase(), "=", 2);
        int ifPos = line.toLowerCase().indexOf(" if ");
        if (ifPos >= 0 && pos > ifPos) {
            return -1;
        }
        return pos;
    }

    private int setPos(String line) {
        return EntityDefinition.searchPos(line.toLowerCase(), "set", 3);
    }

    private int structPos(String line) {
        this.isStructStart = false;
        int pos = EntityDefinition.searchPos(line.toLowerCase(), "struct", 0);
        this.isStructEnd = false;
        int pos2 = EntityDefinition.searchPos(line.toLowerCase(), "end", 0);
        if (pos >= 0 && pos2 >= 0) {
            this.isStructEnd = true;
            return -1;
        }
        if (pos < 0) {
            return -1;
        }
        this.isStructStart = true;
        return pos;
    }

    private int dbPos(String line) {
        return EntityDefinition.searchPos(line.toLowerCase(), "db", 3);
    }

    private int dsPos(String line) {
        return EntityDefinition.searchPos(line.toLowerCase(), "ds", 3);
    }

    private int dwPos(String line) {
        return EntityDefinition.searchPos(line.toLowerCase(), "dw", 3);
    }

    public static String removeComment(String s, String commentString) {
        int commentStart = EntityDefinition.searchPos(s.toLowerCase(), commentString, 2);
        if (commentStart < 0) {
            return s;
        }
        s = s.substring(0, commentStart);
        return s;
    }

    private static String removeOneQuote(String wc) {
        int posDouble = wc.indexOf("\"");
        int posSingle = wc.indexOf("'");
        if (posSingle < 0) {
            posSingle = Integer.MAX_VALUE;
        }
        if (posDouble < 0) {
            posDouble = Integer.MAX_VALUE;
        }
        char quoteChar = '\u0000';
        quoteChar = posDouble < posSingle ? (char)'\"' : '\'';
        wc = wc.substring(wc.indexOf("" + quoteChar) + 1, wc.length());
        int i = 0;
        boolean found = false;
        boolean escapeFound = false;
        while (i < wc.length()) {
            char c = wc.charAt(i);
            if (c == '\\') {
                escapeFound = !escapeFound;
                ++i;
                continue;
            }
            if (c == quoteChar && !escapeFound) {
                found = true;
                break;
            }
            ++i;
            escapeFound = false;
        }
        if (!found) {
            return null;
        }
        return wc.substring(i + 1);
    }

    private static int reallyPurePos(String line, String search) {
        int cpos;
        int pos = line.indexOf(" " + search + " ");
        if (pos < 0) {
            pos = line.indexOf("\t" + search + " ");
        }
        if (pos < 0) {
            pos = line.indexOf("\t" + search + "\t");
        }
        if (pos < 0) {
            pos = line.indexOf(" " + search + "\t");
        }
        if (pos < 0) {
            pos = line.indexOf("\t" + search + "\n");
        }
        if (pos < 0) {
            pos = line.indexOf(" " + search + "\n");
        }
        if (pos < 0 && (cpos = line.indexOf(search)) >= 0 && cpos + search.length() == line.length()) {
            cpos = line.indexOf(" " + search);
            if (cpos < 0) {
                cpos = line.indexOf("\t" + search);
            }
            pos = cpos;
        }
        if (pos < 0) {
            return -1;
        }
        return pos + 1;
    }

    private static int purePos(String line, String search) {
        int pos = line.indexOf(" " + search + " ");
        if (pos < 0) {
            pos = line.indexOf("\t" + search + " ");
        }
        if (pos < 0) {
            pos = line.indexOf("\t" + search + "\t");
        }
        if (pos < 0) {
            pos = line.indexOf(" " + search + "\t");
        }
        if (pos < 0) {
            pos = line.indexOf("\t" + search + "\n");
        }
        if (pos < 0) {
            pos = line.indexOf(" " + search + "\n");
        }
        if (pos < 0) {
            pos = line.indexOf("\t" + search + "");
        }
        if (pos < 0) {
            pos = line.indexOf(" " + search + "");
        }
        if (pos < 0) {
            return -1;
        }
        return pos + 1;
    }

    private static int halfpurePos(String line, String search) {
        int pos = line.indexOf(" " + search);
        if (pos < 0) {
            pos = line.indexOf("\t" + search);
        }
        if (pos < 0) {
            return -1;
        }
        return pos + 1;
    }

    private int purehalfPos(String line, String search) {
        int pos = line.indexOf(search + " ");
        if (pos < 0) {
            pos = line.indexOf(search + "\t");
        }
        if (pos < 0) {
            return -1;
        }
        return pos;
    }

    private static int searchPos(String line, String search, int purePos) {
        String s = line;
        int posSemicolon = -1;
        if (purePos == 3) {
            posSemicolon = EntityDefinition.reallyPurePos(s, search);
        }
        if (purePos == 0) {
            posSemicolon = EntityDefinition.purePos(s, search);
        }
        if (purePos == 1) {
            posSemicolon = EntityDefinition.halfpurePos(s, search);
        } else if (purePos == 2) {
            posSemicolon = s.indexOf(search);
        }
        if (posSemicolon < 0) {
            posSemicolon = Integer.MAX_VALUE;
        }
        if (posSemicolon == Integer.MAX_VALUE) {
            return -1;
        }
        int posDouble = s.substring(0).indexOf("\"");
        int posSingle = s.substring(0).indexOf("'");
        if (posSingle < 0) {
            posSingle = Integer.MAX_VALUE;
        }
        if (posDouble < 0) {
            posDouble = Integer.MAX_VALUE;
        }
        if (posSemicolon < posDouble && posSemicolon < posSingle) {
            return posSemicolon;
        }
        String wc = s.substring(0);
        boolean enough = false;
        do {
            if ((wc = EntityDefinition.removeOneQuote(wc)) == null) {
                return -1;
            }
            posDouble = wc.indexOf("\"");
            posSingle = wc.indexOf("'");
            posSemicolon = wc.indexOf(search);
            if (posSemicolon < 0) {
                posSemicolon = Integer.MAX_VALUE;
            }
            if (posSemicolon == Integer.MAX_VALUE) {
                return -1;
            }
            if (posSingle < 0) {
                posSingle = Integer.MAX_VALUE;
            }
            if (posDouble >= 0) continue;
            posDouble = Integer.MAX_VALUE;
        } while (!(enough = posSemicolon < posDouble && posSemicolon < posSingle));
        String semiString = wc.substring(wc.indexOf(search));
        return s.indexOf(semiString);
    }

    private String getFirstFilename(String line) {
        try {
            boolean hasQuotes;
            boolean hasDoubleQuotes = line.indexOf("\"") != -1;
            boolean bl = hasQuotes = line.indexOf("'") != -1;
            if (hasDoubleQuotes) {
                String[] split = line.split("\"");
                if (split.length < 2) {
                    return "";
                }
                return split[1];
            }
            if (hasQuotes) {
                String[] split = line.split("'");
                if (split.length < 2) {
                    return "";
                }
                return split[1];
            }
            String[] split = line.split(" ");
            return split[0];
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getFirstCLibFilename(String line) {
        try {
            if (!line.contains("<")) {
                return "";
            }
            if (!line.contains(">")) {
                return "";
            }
            line = line.substring(line.indexOf("<") + 1);
            line = line.substring(0, line.indexOf(">"));
            return line;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getLastName(String lineStart) {
        String[] split = lineStart.trim().split("[ \\t\\n]");
        String n = split[split.length - 1];
        if (n.endsWith(":")) {
            this.name = n.substring(0, n.length() - 1);
        }
        return n.trim();
    }

    private String getFirstName(String lineStart) {
        String[] split = lineStart.trim().split("[ \\t\\n:=]");
        if (split.length == 0) {
            return null;
        }
        String n = split[0];
        return n.trim();
    }

    private boolean inStruct() {
        return this.file.inStruct(this);
    }

    private boolean inMacro() {
        return this.file.inMacro(this);
    }

    private boolean inCCommentMacro() {
        return false;
    }

    private boolean isPureFunctionCallLabel() {
        return this.file.isPureFunctionCallLabel(this);
    }

    private boolean isDataLabel() {
        return this.file.isDataLabel(this);
    }

    String removeLineNumber(String l) {
        int pos = l.lastIndexOf(";");
        if (pos <= 0) {
            return l;
        }
        if (l.trim().endsWith(";")) {
            return l;
        }
        l = l.substring(0, pos);
        return l;
    }

    private void processCLine(String line) {
        int pos;
        String[] split;
        boolean nothingDisturbing;
        boolean startWithType;
        this.previousOrgLine = this.orgLine;
        this.previousName = this.name;
        this.previousValue = this.value;
        this.previousType = this.type;
        this.previousParameter = this.parameter;
        boolean done = false;
        this.type = 0;
        this.name = "";
        this.parameter = null;
        this.isStructStart = false;
        this.isStructEnd = false;
        this.isMacroStart = false;
        this.isMacroEnd = false;
        this.orgLine = line;
        line = this.removeLineNumber(line);
        line = EntityDefinition.removeComment(line, "//");
        if ((line = EntityDefinition.removeComment(line, "/*")).trim().length() == 0) {
            done = true;
        }
        if (!done) {
            startWithType = false;
            if (line.trim().startsWith("char ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("unsigned ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("signed ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("static ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("final ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("extern ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("int ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("short ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("const ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("long ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("volatile ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("inline ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("__INLINE ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("void ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("FUNCTION_TYPE ")) {
                startWithType = true;
            }
            nothingDisturbing = true;
            if (line.contains("=")) {
                nothingDisturbing = false;
            }
            if (line.contains("[")) {
                nothingDisturbing = false;
            }
            if (line.contains("]")) {
                nothingDisturbing = false;
            }
            boolean hasBrackets = false;
            if (line.contains("(")) {
                hasBrackets = true;
            }
            boolean hasSemicolon = false;
            if (line.endsWith(";")) {
                hasSemicolon = true;
            }
            if (startWithType && hasBrackets && nothingDisturbing && !hasSemicolon && !this.inCCommentMacro()) {
                line = UtilityString.replace(line, "char", "", true);
                line = UtilityString.replace(line, "unsigned", "", true);
                line = UtilityString.replace(line, "signed", "", true);
                line = UtilityString.replace(line, "static", "", true);
                line = UtilityString.replace(line, "int", "", true);
                line = UtilityString.replace(line, "const", "", true);
                line = UtilityString.replace(line, "short", "", true);
                line = UtilityString.replace(line, "final", "", true);
                line = UtilityString.replace(line, "extern", "", true);
                line = UtilityString.replace(line, "long", "", true);
                line = UtilityString.replace(line, "volatile", "", true);
                line = UtilityString.replace(line, "inline", "", true);
                line = UtilityString.replace(line, "__INLINE", "", true);
                line = UtilityString.replace(line, "void", "", true);
                split = (line = UtilityString.replace(line, "FUNCTION_TYPE", "", true)).trim().split("\\(");
                if (!split[0].trim().contains("__attri")) {
                    this.name = split[0].trim();
                    done = true;
                    this.type = TYP_CFUNCTION;
                    this.subtype = SUBTYPE_FUNCTION_LABEL;
                } else {
                    line = this.orgLine;
                }
            }
        }
        if (!done) {
            boolean endsOpen;
            startWithType = false;
            if (line.trim().startsWith("char ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("unsigned ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("signed ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("short ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("void ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("extern ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("final ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("int ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("long ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("static ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("const ")) {
                startWithType = true;
            }
            if (line.trim().startsWith("volatile ")) {
                startWithType = true;
            }
            nothingDisturbing = true;
            if (line.contains("struct ")) {
                nothingDisturbing = false;
            }
            if (line.contains("#define ")) {
                nothingDisturbing = false;
            }
            if (line.contains("#include ")) {
                nothingDisturbing = false;
            }
            if (line.contains("#if ")) {
                nothingDisturbing = false;
            }
            if (line.contains("#endif ")) {
                nothingDisturbing = false;
            }
            if (line.contains("#else ")) {
                nothingDisturbing = false;
            }
            if (line.contains("#else ")) {
                nothingDisturbing = false;
            }
            boolean hasSemicolon = line.contains(";");
            boolean bl = endsOpen = line.trim().endsWith("=") || line.trim().endsWith("={") || line.trim().endsWith("= {");
            if (startWithType && nothingDisturbing && (hasSemicolon || endsOpen) && !this.inCCommentMacro()) {
                line = UtilityString.replace(line, "const", "", true);
                line = UtilityString.replace(line, "extern", "", true);
                line = UtilityString.replace(line, "static", "", true);
                line = UtilityString.replace(line, "volatile", "", true);
                line = UtilityString.replace(line, "unsigned", "", true);
                line = UtilityString.replace(line, "signed", "", true);
                line = UtilityString.replace(line, "short", "", true);
                line = UtilityString.replace(line, "char", "", true);
                line = UtilityString.replace(line, "int", "", true);
                line = UtilityString.replace(line, "final", "", true);
                line = UtilityString.replace(line, "long", "", true);
                line = UtilityString.replace(line, "void", "", true);
                line = UtilityString.replace(line, "volatile", "", true);
                line = UtilityString.replace(line, "&", " ").trim();
                line = UtilityString.replace(line, "*", " ").trim();
                line = UtilityString.replace(line, ";", " ").trim();
                line = UtilityString.replace(line, ",", " ").trim();
                line = UtilityString.replace(line, "[", " ").trim();
                line = UtilityString.replace(line, "\t", " ").trim();
                split = line.trim().split(" ");
                this.name = line.contains(" ") ? split[0].trim() : line;
                done = true;
                this.type = TYP_LABEL;
                this.subtype = SUBTYPE_DATA_LABEL;
            }
        }
        if (!done) {
            boolean startWithDefine = false;
            if (line.trim().startsWith("#define")) {
                startWithDefine = true;
            }
            if (startWithDefine && !this.inCCommentMacro()) {
                line = UtilityString.replace(line, "#define", "", true).trim();
                line = UtilityString.replace(line, "\t", " ").trim();
                line = UtilityString.replace(line, "(", " ").trim();
                String[] split2 = line.trim().split(" ");
                this.name = line.contains(" ") ? split2[0].trim() : line;
                done = true;
                this.type = TYP_MACRO;
                this.subtype = SUBTYPE_MACRO_DEFINITION_LABEL;
            }
        }
        if (!done && (pos = this.cincludePos(line)) != -1) {
            done = true;
            String lineRest = line.substring(pos + 8).trim();
            if (lineRest.contains("<")) {
                this.type = TYP_LIB_INCLUDE;
                this.name = this.getFirstCLibFilename(lineRest);
            } else {
                this.type = TYP_INCLUDE;
                this.name = this.getFirstFilename(lineRest);
            }
            if (this.name == null) {
                this.name = "";
            }
        }
        if (this.name.trim().length() == 0) {
            this.status = -1;
            return;
        }
        this.status = this.name.equals(this.previousName) ? 0 : 1;
    }
}

