/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.util.UtilityString;
import de.malban.vide.assy.Comment;
import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.SourceLine;
import de.malban.vide.assy.exceptions.AlreadyExistsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class Macro {
    static final String digits = "0123456789";
    static final String escape1 = "&";
    static final String escape2 = "\\";
    static Vector allMacros;
    static int macroInvocationNum;
    Vector source;
    String name;
    int firstLineNum;
    HashMap<String, Integer> nameToIntSymbol = new HashMap();
    HashMap<Integer, String> intToNameSymbol = new HashMap();
    ArrayList<String> macroSymbols = new ArrayList();
    ArrayList<String> localSymbols = new ArrayList();
    boolean hasArgsDefined = false;

    public static void reset() {
        allMacros = new Vector();
        macroInvocationNum = 0;
    }

    public static Macro find(String name) {
        for (int i = 0; i < allMacros.size(); ++i) {
            Macro m = (Macro)allMacros.elementAt(i);
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static Macro set(String n, int ln, SourceLine sn) {
        Macro m = Macro.find(n);
        if (m == null) {
            try {
                m = new Macro(n, ln);
            }
            catch (AlreadyExistsException alreadyExistsException) {}
        } else {
            m.firstLineNum = ln;
            m.source = new Vector();
        }
        String[] symbols = sn.rest.split(",");
        for (int i = 0; i < symbols.length; ++i) {
            String sym = symbols[i].trim();
            m.nameToIntSymbol.put(sym, i + 1);
            m.intToNameSymbol.put(i + 1, sym);
            m.macroSymbols.add(sym);
            m.hasArgsDefined = true;
        }
        return m;
    }

    public Macro(String n, int ln) throws AlreadyExistsException {
        Macro m = Macro.find(n);
        if (m != null) {
            throw new AlreadyExistsException(n);
        }
        this.name = n;
        this.firstLineNum = ln;
        this.source = new Vector();
        allMacros.addElement(this);
    }

    public String getName() {
        return this.name;
    }

    public void addLine(Object x) {
        SourceLine pl = (SourceLine)x;
        String line = pl.inputLine;
        int i = (line = Comment.removeEndOfLineComment(line)).toLowerCase().indexOf(" local ");
        if (i < 0) {
            i = line.toLowerCase().indexOf("\tlocal ");
        }
        if (i < 0) {
            i = line.toLowerCase().indexOf("\tlocal\t");
        }
        if (i < 0) {
            i = line.toLowerCase().indexOf(" local\t");
        }
        if (i >= 0) {
            String[] locals;
            String sym = line.substring(i + 7).trim();
            for (String ls : locals = sym.split(",")) {
                if (this.localSymbols.contains(ls.trim())) continue;
                this.localSymbols.add(ls.trim());
            }
            return;
        }
        for (int ii = 0; ii < this.localSymbols.size(); ++ii) {
            String sym = this.localSymbols.get(ii);
            String line2 = UtilityString.replace(line, sym, sym + "\\?", true);
            if (line2.equals(line)) continue;
            pl.inputLine = UtilityString.replace(pl.inputLine, sym, sym + "\\?", true);
            pl.label = UtilityString.replace(pl.label, sym, sym + "\\?", true);
            pl.op = UtilityString.replace(pl.op, sym, sym + "\\?", true);
            pl.rest = UtilityString.replace(pl.rest, sym, sym + "\\?", true);
        }
        this.source.addElement(x);
    }

    public Vector expandSource(SourceLine p) {
        Vector<String> args2;
        String label;
        ++macroInvocationNum;
        int depth = p.getMacroDepth() + 1;
        Vector<SourceLine> exp = new Vector<SourceLine>();
        String argList = label = p.label != null ? p.label : "";
        if (p.rest.length() > 0 && !Character.isWhitespace(p.rest.charAt(0))) {
            argList = argList + "," + p.rest;
        }
        Vector<String> args = ParseString.parseArgs(argList);
        if (argList.trim().startsWith(",")) {
            args2 = new Vector<String>();
            args2.addElement("");
            for (Object e : args) {
                args2.add((String)e);
            }
            args = args2;
        }
        if (args.size() == 0) {
            args.add("");
        }
        if (p.rest.trim().startsWith(",")) {
            args2 = new Vector();
            int c = 0;
            for (Object e : args) {
                if (++c == 2) {
                    args2.add("," + e);
                    continue;
                }
                args2.add((String)e);
            }
            args = args2;
        }
        for (int i = 0; i < this.source.size(); ++i) {
            SourceLine p0 = (SourceLine)this.source.elementAt(i);
            SourceLine p1 = this.expandSourceLine(p0, args);
            p1.setMacroDepth(depth);
            p1.endOfLineComment = p0.endOfLineComment;
            p1.fullLineComment = p0.fullLineComment;
            p1.setFilename("MACRO-EXPAND from " + p1.fileName);
            exp.addElement(p1);
        }
        return exp;
    }

    private SourceLine expandSourceLine(SourceLine p0, Vector args) {
        SourceLine p1 = new SourceLine(p0);
        p1.setInputLine(this.expand(p0.getInputLine(), args));
        p1.setLabel(this.expand(p0.getLabel(), args));
        p1.setOp(this.expand(p0.getOp(), args));
        p1.setRest(this.expand(p0.getRest(), args));
        return p1;
    }

    private String expand(String s, Vector args) {
        int p1;
        if (s == null) {
            return s;
        }
        String allArgs = "";
        for (int i = 1; i < args.size(); ++i) {
            if (i != 1) {
                allArgs = allArgs + ",";
            }
            allArgs = allArgs + (String)args.elementAt(i);
        }
        StringBuffer b = new StringBuffer();
        int p0 = 0;
        String escape = escape1;
        if (s.indexOf(escape1) > 0) {
            escape = escape1;
        }
        if (s.indexOf(escape2) > 0) {
            escape = escape2;
        }
        if (this.hasArgsDefined) {
            escape = escape2;
            for (int ms = 0; ms < this.macroSymbols.size(); ++ms) {
                s = UtilityString.replace(s, this.macroSymbols.get(ms), escape2 + (ms + 1), true);
            }
        }
        if (escape.equals(escape1)) {
            while (p0 < s.length()) {
                p1 = (s + escape).indexOf(escape, p0);
                b.append(s.substring(p0, p1));
                if (p1 < s.length()) {
                    String arg;
                    char ch = s.charAt(p1 + 1);
                    if (ch == '@') {
                        arg = "" + macroInvocationNum;
                        p0 = p1 + 2;
                    } else if (ch == ',') {
                        arg = "";
                        p0 = p1 + 2;
                    } else if (ch == '*') {
                        arg = allArgs;
                        p0 = p1 + 2;
                    } else if (ch == '#') {
                        arg = "" + (args.size() - 1);
                        p0 = p1 + 2;
                    } else if (digits.indexOf(ch) >= 0) {
                        int d;
                        int n = 0;
                        for (p0 = p1 + 1; p0 < s.length() && (d = digits.indexOf(ch = s.charAt(p0))) >= 0; ++p0) {
                            n = 10 * n + d;
                        }
                        arg = n < args.size() ? (String)args.elementAt(n) : "";
                    } else {
                        arg = "" + ch;
                        p0 = p1 + 2;
                    }
                    b.append(arg);
                    continue;
                }
                break;
            }
        } else {
            while (p0 < s.length()) {
                p1 = (s + escape).indexOf(escape, p0);
                b.append(s.substring(p0, p1));
                if (p1 < s.length()) {
                    String arg;
                    char ch = s.charAt(p1 + 1);
                    if (ch == '?') {
                        arg = "" + macroInvocationNum;
                        p0 = p1 + 2;
                    } else if (ch == ',') {
                        arg = "";
                        p0 = p1 + 2;
                    } else if (ch == '*') {
                        arg = allArgs;
                        p0 = p1 + 2;
                    } else if (ch == '0') {
                        arg = "" + (args.size() - 1);
                        p0 = p1 + 2;
                    } else if (digits.indexOf(ch) >= 0) {
                        int d;
                        int n = 0;
                        for (p0 = p1 + 1; p0 < s.length() && (d = digits.indexOf(ch = s.charAt(p0))) >= 0; ++p0) {
                            n = 10 * n + d;
                        }
                        arg = n < args.size() ? (String)args.elementAt(n) : "";
                    } else {
                        arg = "" + ch;
                        p0 = p1 + 2;
                    }
                    b.append(arg);
                    continue;
                }
                break;
            }
        }
        return b.toString();
    }

    static {
        macroInvocationNum = 0;
    }
}

