/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.vide.assy.DynamicFile;
import de.malban.vide.assy.exceptions.AlreadyExistsException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class Option {
    static Vector allOptions = new Vector();
    String name;
    boolean unique;
    boolean valueOK;
    boolean valueNeeded;
    boolean negativeValueOK;
    boolean parsed;
    boolean sign;
    boolean default_sign;
    String value;
    String default_value;
    OutputStream stream;

    public Option(String name, boolean ds, String dv) {
        this.name = name;
        this.default_sign = ds;
        this.default_value = dv;
        this.stream = null;
        this.unique = true;
        this.valueOK = true;
        this.valueNeeded = false;
        this.negativeValueOK = false;
        this.sign = false;
        this.value = null;
        this.parsed = false;
        allOptions.addElement(this);
    }

    public boolean getSign() {
        return this.parsed ? this.sign : this.default_sign;
    }

    public String getValue() {
        return this.parsed ? this.value : this.default_value;
    }

    public OutputStream getOutputStream() throws IOException {
        this.stream = null;
        if (!this.getSign()) {
            return null;
        }
        if (this.getValue() == null) {
            return System.out;
        }
        this.stream = DynamicFile.getOutputStream(this.getValue());
        return this.stream;
    }

    public PrintStream getPrintStream() throws IOException {
        this.stream = null;
        if (!this.getSign()) {
            return null;
        }
        if (this.getValue() == null) {
            return System.out;
        }
        this.stream = DynamicFile.getPrintStream(this.getValue());
        return (PrintStream)this.stream;
    }

    public void closeStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    public boolean parse(String arg) throws AlreadyExistsException, IllegalArgumentException {
        boolean opt_sign;
        String opt2 = arg;
        if (opt2.startsWith("-")) {
            opt_sign = false;
        } else if (opt2.startsWith("+")) {
            opt_sign = true;
        } else {
            return false;
        }
        opt2 = opt2.substring(1);
        if (!opt2.startsWith(this.name)) {
            return false;
        }
        opt2 = opt2.substring(this.name.length());
        if (this.parsed) {
            if (this.unique) {
                throw new AlreadyExistsException(this.name);
            }
            Option another = new Option(this.name, this.default_sign, this.default_value);
            another.unique = this.unique;
            another.valueOK = this.valueOK;
            another.valueNeeded = this.valueNeeded;
            another.negativeValueOK = this.negativeValueOK;
            return another.parse(arg);
        }
        this.sign = opt_sign;
        this.parsed = true;
        if (opt2.length() == 0) {
            if (this.valueNeeded) {
                throw new IllegalArgumentException("missing value for option " + this.name);
            }
            return true;
        }
        if (!this.valueOK) {
            throw new IllegalArgumentException("value not allowed");
        }
        if (opt2.charAt(0) == '=') {
            if (opt2.length() <= 1) {
                throw new IllegalArgumentException("missing value for option " + this.name);
            }
            opt2 = opt2.substring(1);
        }
        this.value = opt2;
        return true;
    }

    public static Option parseAny(String arg) throws AlreadyExistsException, IllegalArgumentException {
        for (int i = 0; i < allOptions.size(); ++i) {
            Option x = (Option)allOptions.elementAt(i);
            if (!x.parse(arg)) continue;
            return x;
        }
        return null;
    }
}

