/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy;

import de.malban.vide.VideConfig;
import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.SourceLine;
import de.malban.vide.assy.expressions.Expression;
import de.malban.vide.assy.expressions.ExpressionSymbol;
import de.malban.vide.assy.instructions.Instruction;
import java.util.Vector;

public class Symbol {
    String name;
    String line_Comment = "";
    int value;
    int defining_line;
    int dp_estimate = -1;
    boolean used = false;
    boolean isDefined = true;
    SourceLine source;
    public static final int SYMBOL_USAGE_UNKOWN = 0;
    public static final int SYMBOL_USAGE_CONSTANT = 1;
    public static final int SYMBOL_USAGE_CONSTANT_8 = 2;
    public static final int SYMBOL_USAGE_CONSTANT_16 = 4;
    public static final int SYMBOL_USAGE_LABEL_16 = 8;
    public static final int SYMBOL_USAGE_LABEL_OFFSET_8 = 16;
    public static final int SYMBOL_USAGE_DIRECT_8 = 32;
    public static final int SYMBOL_USAGE_DIRECT_16 = 64;
    public static final int SYMBOL_USAGE_EXPRESSION = 128;
    public static final int SYMBOL_DEFINE_UNKOWN = 0;
    public static final int SYMBOL_DEFINE_EQU = 1;
    public static final int SYMBOL_DEFINE_CODE = 2;
    public static final int SYMBOL_DEFINE_STRUCT = 3;
    int definedHow = 0;
    boolean labelUsage = false;
    int usageType = 0;
    Vector undefinedReferences;

    public boolean isUsed() {
        return this.used;
    }

    public boolean isLabel() {
        return this.labelUsage;
    }

    public boolean isConstant() {
        return !this.labelUsage;
    }

    public int getUsageType() {
        return this.usageType;
    }

    public static void addUsage(Expression offsetExpression, int type, int dp) {
        ExpressionSymbol es;
        Symbol sym;
        if (offsetExpression != null && offsetExpression instanceof ExpressionSymbol && (sym = (es = (ExpressionSymbol)offsetExpression).getSymbol()) != null) {
            sym.used = true;
            if (!sym.labelUsage) {
                if (sym.definedHow == 2) {
                    sym.labelUsage = true;
                }
                if ((type & 0x40) == 64) {
                    sym.labelUsage = true;
                }
                if ((type & 8) == 8) {
                    sym.labelUsage = true;
                }
            }
            if ((type & 0x20) == 32 || (type & 0x40) == 64) {
                int value = Math.abs(sym.getValue());
                if (dp != -1) {
                    sym.dp_estimate = Math.abs(dp & 0xFFFF) > 256 ? dp >> 8 & 0xFF : dp & 0xFF;
                }
                if (value > 256) {
                    sym.dp_estimate = value >> 8 & 0xFF;
                }
            }
        }
    }

    public static void addUsage(Expression offsetExpression, int type) {
        Symbol.addUsage(offsetExpression, type, -1);
    }

    public Symbol(String n) {
        this(n, 0, -1, null);
        this.isDefined = false;
    }

    public Symbol(String n, int v, int l, SourceLine s) {
        this.source = s;
        this.name = n;
        this.value = v;
        this.defining_line = l;
        this.undefinedReferences = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int v) {
        this.value = v;
    }

    public boolean defined() {
        return this.defining_line != -1;
    }

    public void define(int v, int dl, SourceLine s) {
        if (!this.name.startsWith("*") && VideConfig.getConfig().warnOnDoubleDefine && this.isDefined && !s.endOfLineComment.toLowerCase().contains("#nodoublewarn") && v != this.value) {
            String w = "Symbol: \"" + this.name + "\" was already defined.";
            if (s != null) {
                w = w + " Source: " + s.fileName + " (" + dl + ")";
            }
            if (this.source != null) {
                w = w + ", old define: " + this.source.fileName + " (" + this.defining_line + ")";
            }
            Asmj.warning(s, w);
        }
        this.isDefined = true;
        this.source = s;
        this.value = v;
        this.defining_line = dl;
        int nur = this.undefinedReferences.size();
        for (int urx = nur - 1; urx >= 0; --urx) {
            Instruction ur = (Instruction)this.undefinedReferences.elementAt(urx);
            ur.eval();
            this.undefinedReferences.removeElementAt(urx);
            this.labelUsage = true;
            this.used = true;
        }
    }

    public void addUndefinedReference(Instruction ur) {
        this.undefinedReferences.addElement(ur);
    }

    public void removeUndefinedReference(Instruction ur) {
        this.undefinedReferences.removeElement(ur);
    }
}

