/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.arguments;

import de.malban.util.UtilityString;
import de.malban.vide.VideConfig;
import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.AsmjDeath;
import de.malban.vide.assy.LineContext;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.Register;
import de.malban.vide.assy.RegisterSet;
import de.malban.vide.assy.Symbol;
import de.malban.vide.assy.SymbolTable;
import de.malban.vide.assy.arguments.Argument6809;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.expressions.Expression;
import de.malban.vide.assy.expressions.ExpressionNumber;
import de.malban.vide.assy.instructions.Instruction;
import de.malban.vide.assy.instructions.InstructionGroup;

public class ArgumentMemoryLocation
extends Argument6809 {
    public Expression offsetExpression;
    int offset;
    boolean constantOffset;
    boolean registerOffset;
    boolean autoincrement;
    boolean indirect;
    boolean reallyShort;
    boolean prettyShort;
    boolean force16bit = false;
    boolean force8bit = false;
    boolean force5bit = false;
    boolean force0bit = false;
    int num_postbytes;
    Register register;
    Register offsetReg;

    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getNumPostbytes() {
        return this.num_postbytes;
    }

    public ArgumentMemoryLocation(String s, SymbolTable st, Instruction instr) throws ParseException {
        this(new ParseString(s), st, instr);
    }

    boolean correctStartWithIndexRegister(ParseString s, Instruction instr) {
        int len = 0;
        String reg = "";
        String l = s.getCurrentString();
        int startInsert = 0;
        if (l.startsWith("[")) {
            l = l.substring(1);
            startInsert = 1;
        }
        if (l.startsWith("-")) {
            l = l.substring(1);
        }
        if (l.startsWith("-")) {
            l = l.substring(1);
        }
        if (l.toLowerCase().trim().startsWith("y")) {
            reg = "y";
            len = 1;
        } else if (l.toLowerCase().trim().startsWith("x")) {
            reg = "x";
            len = 1;
        } else if (l.toLowerCase().trim().startsWith("s")) {
            reg = "s";
            len = 1;
        } else if (l.toLowerCase().trim().startsWith("u")) {
            reg = "u";
            len = 1;
        } else if (l.toLowerCase().trim().startsWith("pcr")) {
            reg = "pcr";
            len = 3;
        } else if (l.toLowerCase().trim().startsWith("pc")) {
            reg = "pc";
            len = 2;
        }
        if (len == 0) {
            return false;
        }
        String rest = l.substring(len);
        if (rest.length() > 0 && UtilityString.isAlphaNumeric(rest.charAt(0))) {
            return false;
        }
        s.insert(startInsert, ",");
        Asmj.warning(instr.getSource(), "Indexed addressing without \",\" found - inserted!");
        return true;
    }

    public ArgumentMemoryLocation(ParseString s, SymbolTable st, Instruction instr) throws ParseException {
        boolean forceDirect = false;
        boolean forceExtended = false;
        this.mode = 0;
        this.register = null;
        this.indirect = false;
        this.prettyShort = false;
        this.reallyShort = false;
        this.autoincrement = false;
        this.registerOffset = false;
        this.constantOffset = false;
        this.num_postbytes = 1;
        this.correctStartWithIndexRegister(s, instr);
        if (s.toString().contains("+") && s.toString().contains(",") && s.toString().startsWith("0")) {
            s.skip("0");
            Asmj.warning(instr.getSource(), "0 offset with increment found, 0 removed!");
        }
        if (s.toString().contains("-") && s.toString().contains(",") && s.toString().startsWith("0")) {
            s.skip("0");
            Asmj.warning(instr.getSource(), "0 offset with decrement found, 0 removed!");
        }
        if (s.startsWith("#")) {
            this.mode = this.checkMode(instr, this.mode, 1);
            s.skip(1);
            if (this.mode != 0) {
                this.offsetExpression = Expression.parse(s, st);
                Symbol.addUsage(this.offsetExpression, 1);
                ArgumentMemoryLocation.parseEndOfExpression(s);
                return;
            }
        }
        if (s.toString().contains(",")) {
            if (s.startsWith("<<")) {
                this.mode = this.checkMode(instr, this.mode, 4);
                this.reallyShort = true;
                this.force5bit = true;
                s.skip(2);
                Symbol.addUsage(this.offsetExpression, 18);
            } else if (s.startsWith("<")) {
                this.mode = this.checkMode(instr, this.mode, 4);
                this.prettyShort = true;
                this.force8bit = true;
                s.skip(1);
                Symbol.addUsage(this.offsetExpression, 18);
            } else if (s.startsWith(">")) {
                this.mode = this.checkMode(instr, this.mode, 4);
                this.force16bit = true;
                this.prettyShort = false;
                this.reallyShort = false;
                s.skip(1);
                Symbol.addUsage(this.offsetExpression, 12);
            }
        } else if (s.startsWith("<")) {
            this.mode = this.checkMode(instr, this.mode, 2);
            this.prettyShort = true;
            forceDirect = true;
            s.skip(1);
        }
        if (s.startsWith(">")) {
            forceExtended = true;
            s.skip(1);
            Symbol.addUsage(this.offsetExpression, 12);
        }
        if (s.startsWith("[")) {
            this.mode = this.checkMode(instr, this.mode, 4);
            this.indirect = true;
            s.skip(1);
            if (this.reallyShort) {
                this.reallyShort = false;
                this.prettyShort = true;
                if (this.force5bit) {
                    this.force5bit = false;
                    this.force8bit = true;
                }
            }
            if (s.startsWith(">")) {
                this.reallyShort = false;
                this.prettyShort = false;
                this.force16bit = true;
                Symbol.addUsage(this.offsetExpression, 12);
                s.skip(1);
            }
            if (s.startsWith("<<")) {
                this.reallyShort = false;
                this.prettyShort = true;
                this.force8bit = true;
                s.skip(2);
                Symbol.addUsage(this.offsetExpression, 18);
            }
            if (s.startsWith("<")) {
                this.reallyShort = false;
                this.prettyShort = true;
                this.force8bit = true;
                s.skip(1);
                Symbol.addUsage(this.offsetExpression, 18);
            }
        }
        int p0 = s.getPosition();
        this.offsetReg = RegisterSet.parseReg(s, "", 1);
        if (this.offsetReg != null) {
            if (s.charAt(0) == ',') {
                this.registerOffset = true;
            } else {
                s.setPosition(p0);
                this.offsetReg = null;
            }
        }
        try {
            this.offsetExpression = Expression.parse(s, st);
            this.constantOffset = true;
        }
        catch (ParseException x) {
            if (!x.isSevere()) {
                throw x;
            }
            this.offsetExpression = null;
        }
        if (s.toLowerCase().startsWith(",dp")) {
            this.mode = this.checkMode(instr, this.mode, 2);
            int dp = LineContext.directRegister;
            if (instr.getSource().getDP() != -1) {
                dp = instr.getSource().getDP();
            } else if (dp != -1) {
                instr.getSource().setDP(dp);
            }
            Symbol.addUsage(this.offsetExpression, 32, dp);
            s.skip(3);
            ArgumentMemoryLocation.parseEndOfExpression(s);
            return;
        }
        if (s.startsWith("]")) {
            if (this.mode != 4 || !this.indirect) {
                throw new ParseException("unexpected ']'");
            }
            this.constantOffset = true;
            this.register = null;
            Symbol.addUsage(this.offsetExpression, 8);
            s.skip(1);
            ArgumentMemoryLocation.parseEndOfExpression(s);
            this.num_postbytes += 2;
            return;
        }
        if (!s.startsWith(",")) {
            int v;
            InstructionGroup ig;
            if (this.offsetExpression != null && !forceExtended && LineContext.directRegister != -1) {
                int knownDP = LineContext.directRegister;
                try {
                    this.offset = this.offsetExpression.eval(st);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.offsetExpression.getValue() >> 8 == knownDP || (this.offsetExpression.getValue() & 0xFF) == this.offsetExpression.getValue() && this.mode == 2 || forceDirect) {
                    boolean doIt = true;
                    if (VideConfig.getConfig().excludeJumpsToDirect && instr instanceof InstructionGroup) {
                        ig = (InstructionGroup)instr;
                        if (ig.getMnemonic().toLowerCase().equals("jmp")) {
                            doIt = false;
                        }
                        if (ig.getMnemonic().toLowerCase().equals("jsr")) {
                            doIt = false;
                        }
                    }
                    if (doIt) {
                        this.mode = this.checkMode(instr, this.mode, 2);
                        int dp = LineContext.directRegister;
                        if (instr.getSource().getDP() != -1) {
                            dp = instr.getSource().getDP();
                        } else if (dp != -1) {
                            instr.getSource().setDP(dp);
                        }
                        Symbol.addUsage(this.offsetExpression, 64, dp);
                        ArgumentMemoryLocation.parseEndOfExpression(s);
                        return;
                    }
                }
            }
            if (this.offsetExpression != null && !forceDirect && ((v = this.offsetExpression.getValue()) & 0xFFFF) < 256 && VideConfig.getConfig().enable8bitExtendedToDirect) {
                boolean doIt = true;
                if (VideConfig.getConfig().excludeJumpsToDirect && instr instanceof InstructionGroup) {
                    ig = (InstructionGroup)instr;
                    if (ig.getMnemonic().toLowerCase().equals("jmp")) {
                        doIt = false;
                    }
                    if (ig.getMnemonic().toLowerCase().equals("jsr")) {
                        doIt = false;
                    }
                }
                if (doIt) {
                    this.mode = this.checkMode(instr, this.mode, 2);
                    if (this.mode == 2) {
                        Asmj.warning(instr.getSource(), "8bit extended addressing found, changing to direct addressing!");
                        forceDirect = true;
                        Symbol.addUsage(this.offsetExpression, 32);
                    }
                }
            }
            if (this.mode != 2 || !forceDirect) {
                this.mode = this.checkMode(instr, this.mode, 3);
            }
            if (this.offsetExpression == null) {
                throw new ParseException("missing argument");
            }
            Symbol.addUsage(this.offsetExpression, 8);
            ArgumentMemoryLocation.parseEndOfExpression(s);
            return;
        }
        s.skip(1);
        s.skipSpaces();
        this.mode = this.checkMode(instr, this.mode, 4);
        String pcr = s.nextSymbol();
        if (pcr != null && pcr.equals("pcr")) {
            this.constantOffset = true;
            this.register = RegisterSet.pc;
            s.skip(3);
        } else if (pcr != null && pcr.equals("pc")) {
            this.constantOffset = true;
            this.register = RegisterSet.pc;
            s.skip(2);
        } else {
            if (s.startsWith("-")) {
                this.autoincrement = true;
                this.offset = s.startsWith("--") ? 2 : 1;
                s.skip(this.offset);
                this.offset = -this.offset;
            }
            this.register = RegisterSet.parseReg(s, instr.getRestrictions(), 0);
            if (this.register == null) {
                throw new ParseException("illegal index register");
            }
            if (s.startsWith("+")) {
                if (this.autoincrement) {
                    throw new ParseException("Cannot have both autoincrement and autodecrement");
                }
                this.autoincrement = true;
                this.offset = s.startsWith("++") ? 2 : 1;
                s.skip(this.offset);
            }
            if (!this.autoincrement && !this.registerOffset && this.offsetExpression == null) {
                this.offsetExpression = ExpressionNumber.create(0);
                this.constantOffset = true;
            }
        }
        if (this.indirect) {
            if (!s.startsWith("]")) {
                throw new ParseException("missing ']'");
            }
            s.skip(1);
        }
        ArgumentMemoryLocation.parseEndOfExpression(s);
        if (this.constantOffset) {
            block79: {
                try {
                    if (this.offsetExpression == null) {
                        throw new SymbolDoesNotExistException("invalid offset expression");
                    }
                    int x = this.offsetExpression.eval(st);
                    if (this.register == RegisterSet.pc) {
                        if (x >= -128 && x <= 127) {
                            this.prettyShort = true;
                        }
                        int pc = instr.getAddress() + instr.getOpcodeLength() + 2;
                        x -= pc;
                    }
                    if (x > Short.MAX_VALUE) {
                        x -= 65536;
                    }
                    if (x == 0 && this.register != RegisterSet.pc) {
                        this.reallyShort = true;
                    } else if (x >= -16 && x <= 15 && !this.indirect && this.register != RegisterSet.pc) {
                        this.reallyShort = true;
                    } else if (x >= -128 && x <= 127 && this.register != RegisterSet.pc) {
                        this.prettyShort = true;
                    }
                }
                catch (SymbolDoesNotExistException x) {
                    if (this.reallyShort || this.force8bit || this.force16bit || this.prettyShort) break block79;
                    Asmj.warning(instr.getSource(), "Symbol with undefined size found, using 16bit per default - can be perhaps manually be shortend!");
                }
            }
            if (this.force8bit && this.reallyShort) {
                this.reallyShort = false;
                this.prettyShort = true;
            }
            if (this.force16bit && this.reallyShort) {
                this.reallyShort = false;
                this.prettyShort = false;
            }
            if (this.force16bit && this.prettyShort) {
                this.reallyShort = false;
                this.prettyShort = false;
            }
            this.num_postbytes += this.reallyShort ? 0 : (this.prettyShort ? 1 : 2);
        }
        if ((this.registerOffset ? 1 : 0) + (this.constantOffset ? 1 : 0) + (this.autoincrement ? 1 : 0) != 1) {
            throw new ParseException("ambiguous indexed mode");
        }
        if ((this.reallyShort || this.prettyShort) && (this.indirect && this.register == null || this.autoincrement || this.registerOffset)) {
            throw new ParseException("illegal short addressing");
        }
    }

    private int checkMode(Instruction instr, int m0, int m1) throws ParseException {
        String r = null;
        String n0 = modeName[m0];
        String n1 = modeName[m1];
        if (m0 != 0 && m0 != m1) {
            throw new ParseException("ambiguous mode " + n0 + "::" + n1);
        }
        switch (m1) {
            case 1: {
                r = "i";
                break;
            }
            case 4: {
                r = "x";
                break;
            }
            case 2: {
                r = "d";
                break;
            }
            case 3: {
                r = "e";
            }
        }
        if (r != null && instr.getRestrictions().indexOf(r) >= 0) {
            if (VideConfig.getConfig().beLaxWithHashTagAndImmediate && m1 == 1 && m0 == 0) {
                Asmj.warning(instr.getSource(), "\"#\" suggests immediate mode, but instruction does not allow immediate...");
                return 0;
            }
            throw new ParseException("bad mode - cannot be " + n1);
        }
        return m1;
    }

    public void eval(SymbolTable st) throws SymbolDoesNotExistException {
        if (this.offsetExpression != null) {
            this.offset = this.offsetExpression.eval(st);
        }
    }

    public void codegen(Memory mm, SymbolTable st, int address, int len) {
        if (this.mode == 1) {
            mm.write(address, this.offset, len, true, 2);
        } else if (this.mode == 2) {
            mm.write(address, this.offset & 0xFF, 2);
        } else if (this.mode == 3) {
            mm.write(address, this.offset, 2, true, 2);
        } else if (this.mode == 4) {
            int pb1 = 128;
            if (this.indirect) {
                pb1 |= 0x10;
            }
            if (this.register != null) {
                pb1 |= this.register.getCode(0);
            }
            if (this.constantOffset) {
                if (this.register == RegisterSet.pc) {
                    int n = st.getValue("*");
                }
                if (this.reallyShort) {
                    if (this.offset == 0) {
                        if (this.force5bit) {
                            pb1 &= 0x60;
                            pb1 |= this.offset & 0x1F;
                        } else {
                            pb1 |= 4;
                        }
                    } else {
                        pb1 &= 0x60;
                        pb1 |= this.offset & 0x1F;
                    }
                    mm.write(address, pb1, 2);
                } else if (this.prettyShort) {
                    mm.write(address, pb1 |= 8, 2);
                    mm.write(address + 1, this.offset & 0xFF, 2);
                } else {
                    pb1 |= 9;
                    if (this.register == null) {
                        pb1 |= 0xF;
                    }
                    mm.write(address, pb1, 2);
                    mm.write(address + 1, this.offset, 2, true, 2);
                }
            } else if (this.registerOffset) {
                mm.write(address, pb1 |= this.offsetReg.getCode(1), 2);
            } else if (this.autoincrement) {
                switch (this.offset) {
                    case 1: {
                        pb1 |= 0;
                        break;
                    }
                    case 2: {
                        pb1 |= 1;
                        break;
                    }
                    case -1: {
                        pb1 |= 2;
                        break;
                    }
                    case -2: {
                        pb1 |= 3;
                    }
                }
                mm.write(address, pb1, 2);
            } else {
                throw new AsmjDeath("Asmj bug: unrecognized indexed mode");
            }
        }
    }
}

