/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.expressions;

import de.malban.util.UtilityString;
import de.malban.vide.assy.AsmjDeath;
import de.malban.vide.assy.ParseString;
import de.malban.vide.assy.Symbol;
import de.malban.vide.assy.SymbolTable;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.expressions.Expression;
import de.malban.vide.assy.expressions.ExpressionNumber;

public class ExpressionOp
extends Expression {
    private static final int BEGIN = 0;
    private static final int MUL = 1;
    private static final int DIV = 2;
    private static final int MOD = 3;
    private static final int ADD = 4;
    private static final int SUB = 5;
    private static final int LEFT = 6;
    private static final int RIGHT = 7;
    private static final int LE = 8;
    private static final int LT = 9;
    private static final int GE = 10;
    private static final int GT = 11;
    private static final int EQ = 12;
    private static final int EQ2 = 13;
    private static final int NE = 14;
    private static final int AND = 15;
    private static final int XOR = 16;
    private static final int OR = 17;
    private static final int END = 18;
    private static final String[] op_tab = new String[]{"{", "*", "/", "%", "+", "-", "<<", ">>", "<=", "<", ">=", ">", "==", "=", "!=", "&", "^", "|", "}"};
    private static final int[] prec_tab = new int[]{-1, 13, 13, 13, 12, 12, 11, 11, 10, 10, 10, 10, 9, 9, 9, 8, 7, 6, 0};
    private static final int PREFIX_OFFSET = 100;
    private static final int LOW = 100;
    private static final int HI = 101;
    private static final int NEG = 102;
    private static final int NOT = 103;
    private static final int COMP = 104;
    private static final int PLUS = 105;
    private static final int HASH = 106;
    private static final String[] prefix_op_tab = new String[]{"lo", "hi", "-", "!", "~", "+", "#"};
    int op;
    Expression e1;
    Expression e2;

    @Override
    public boolean isNumber() {
        return this.e1.isNumber() & this.e2.isNumber();
    }

    public static ExpressionOp create(Expression e1, int op, Expression e2) {
        return new ExpressionOp(e1, op, e2);
    }

    private ExpressionOp(Expression e1, int op, Expression e2) {
        this.e1 = e1;
        this.op = op;
        this.e2 = e2;
        this.sourceStart = e1.sourceStart;
        this.sourceEnd = e2.sourceEnd;
    }

    @Override
    public int eval(SymbolTable t, boolean treatAsZero) throws SymbolDoesNotExistException {
        int n1 = this.e1.eval(t, treatAsZero);
        int n2 = this.e2.eval(t, treatAsZero);
        switch (this.op) {
            case 1: {
                this.value = n1 * n2;
                break;
            }
            case 2: {
                this.value = n1 / n2;
                break;
            }
            case 3: {
                this.value = n1 % n2;
                break;
            }
            case 4: {
                this.value = n1 + n2;
                break;
            }
            case 5: {
                this.value = n1 - n2;
                break;
            }
            case 6: {
                this.value = n1 << n2;
                break;
            }
            case 7: {
                this.value = n1 >>> n2;
                break;
            }
            case 8: {
                this.value = n1 <= n2 ? 1 : 0;
                break;
            }
            case 9: {
                this.value = n1 < n2 ? 1 : 0;
                break;
            }
            case 10: {
                this.value = n1 >= n2 ? 1 : 0;
                break;
            }
            case 11: {
                this.value = n1 > n2 ? 1 : 0;
                break;
            }
            case 12: {
                this.value = n1 == n2 ? 1 : 0;
                break;
            }
            case 13: {
                this.value = n1 == n2 ? 1 : 0;
                break;
            }
            case 14: {
                this.value = n1 != n2 ? 1 : 0;
                break;
            }
            case 15: {
                this.value = n1 & n2;
                break;
            }
            case 16: {
                this.value = n1 ^ n2;
                break;
            }
            case 17: {
                int t1 = 0;
                int t2 = 0;
                if (Math.abs(n1) <= 128) {
                    t1 = n1 & 0xFF;
                } else if (Math.abs(n1) <= 32768) {
                    t1 = n1 & 0xFFFF;
                }
                if (Math.abs(n2) <= 128) {
                    t2 = n2 & 0xFF;
                } else if (Math.abs(n2) <= 32768) {
                    t2 = n2 & 0xFFFF;
                }
                this.value = n1 | n2;
                break;
            }
            case 102: {
                this.value = -n2;
                break;
            }
            case 105: {
                this.value = n2;
                break;
            }
            case 103: {
                this.value = n2 == 0 ? 1 : 0;
                break;
            }
            case 104: {
                this.value = ~n2;
                break;
            }
            case 100: {
                this.value = n2 & 0xFF;
                break;
            }
            case 101: {
                this.value = n2 >> 8 & 0xFF;
                break;
            }
            case 106: {
                this.value = n2;
                break;
            }
            default: {
                throw new AsmjDeath("Asmj bug: no such op: '" + this.op + "'");
            }
        }
        return this.value;
    }

    @Override
    public int eval(SymbolTable t) throws SymbolDoesNotExistException {
        return this.eval(t, false);
    }

    public static Expression parse(String s, SymbolTable st) throws ParseException {
        return ExpressionOp.parse(new ParseString(s), st);
    }

    public static Expression parse(ParseString s, SymbolTable st) throws ParseException {
        Expression[] exprs = new Expression[128];
        int[] opers = new int[128];
        int[] precs = new int[128];
        int n = 0;
        exprs[n] = null;
        opers[n] = 0;
        precs[n] = ExpressionOp.getOpPrecedence(opers[0]);
        ++n;
        while (opers[n - 1] != 18) {
            s.skipSpaces();
            int op = ExpressionOp.getPrefixOp(s.toString());
            if (op >= 0) {
                exprs[n] = ExpressionNumber.create(0);
            } else {
                exprs[n] = ExpressionOp.parseTerm(s, st);
                Symbol.addUsage(exprs[n], 128);
                s.skipSpaces();
                op = ExpressionOp.getOp(s.toString());
            }
            if (s.length() > 0 && op >= 0) {
                opers[n] = op;
                s.skip(ExpressionOp.getOpLength(op));
            } else {
                opers[n] = 18;
            }
            precs[n] = ExpressionOp.getOpPrecedence(opers[n]);
            ++n;
            while (n > 2 && precs[n - 2] >= precs[n - 1]) {
                exprs[n - 2] = ExpressionOp.create(exprs[n - 2], opers[n - 2], exprs[n - 1]);
                opers[n - 2] = opers[n - 1];
                precs[n - 2] = precs[n - 1];
                --n;
            }
        }
        return exprs[1];
    }

    private static int getPrefixOp(String s) {
        int op = ExpressionOp.arrayIndex(s, prefix_op_tab);
        if (op == 0) {
            if (s.length() <= 2) {
                return -1;
            }
            if (!UtilityString.isWordBoundry(s.charAt(2))) {
                return -1;
            }
        }
        if (op == 1) {
            if (s.length() <= 2) {
                return -1;
            }
            if (!UtilityString.isWordBoundry(s.charAt(2))) {
                return -1;
            }
        }
        return op >= 0 ? op + 100 : op;
    }

    private static int getOp(String s) {
        return ExpressionOp.arrayIndex(s, op_tab);
    }

    private static int getOpLength(int op) {
        return op < 100 ? op_tab[op].length() : prefix_op_tab[op - 100].length();
    }

    private static int getOpPrecedence(int i) {
        return i < 100 ? prec_tab[i] : i;
    }

    private static int arrayIndex(String s, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || !s.startsWith(array[i])) continue;
            return i;
        }
        return -1;
    }
}

