/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.instructions;

import de.malban.util.Utility;
import de.malban.vide.VideConfig;
import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.expressions.Expression;
import de.malban.vide.assy.instructions.Instruction;
import de.malban.vide.assy.instructions.InstructionGroup;

public class Branch
extends InstructionGroup {
    Expression destExpr;
    int offset;
    int len;
    int pc;
    SymbolDoesNotExistException x;

    @Override
    public boolean parse(String arg) throws ParseException {
        this.destExpr = Expression.parse(arg, this.symtab);
        this.setLength(this.getOpcodeLength() + this.getDataLength());
        this.pc = this.symtab.getValue("*");
        return true;
    }

    @Override
    public boolean evalArgs() throws SymbolDoesNotExistException {
        int dest = this.destExpr.eval(this.symtab);
        this.offset = this.destExpr.isNumber() ? dest : dest - this.pc;
        this.len = this.getDataLength();
        if (this.source.isOptimize()) {
            boolean isNegative;
            boolean isShort = false;
            boolean bl = isNegative = this.offset < 0;
            if (isNegative && this.offset >= -128) {
                isShort = true;
            }
            if (!isNegative && this.offset < 126) {
                isShort = true;
            }
            if (isShort && this.source.op.toLowerCase().startsWith("l")) {
                if (this.source.op.toLowerCase().equals("lbra")) {
                    String old = this.source.op;
                    this.source.op = this.source.op.substring(1);
                    Instruction i = (Instruction)Asmj.processor.instructionSet.get(this.source.op);
                    this.source.setInstruction(i);
                    i.source = this.source;
                    i.pass1(this.address, this.symtab);
                    Asmj.optimize(this.source, "Optimization changing \"" + old + "\" to \"" + this.source.op + "\" (NOP inserted)");
                    return true;
                }
                Asmj.warning(this.source, "Optimization possible, long branch can be changed to short:  \"" + this.source.op + "\" offset:  " + this.offset);
            }
            if (this.source.op.toLowerCase().equals("lbra")) {
                String old = this.source.op;
                this.source.op = "JMP";
                Instruction i = (Instruction)Asmj.processor.instructionSet.get(this.source.op);
                this.source.setInstruction(i);
                i.source = this.source;
                i.pass1(this.address, this.symtab);
                Asmj.optimize(this.source, "Optimization changing \"" + old + "\" to \"" + this.source.op + "\"");
                return true;
            }
            if (this.source.op.toLowerCase().equals("lbrs")) {
                String old = this.source.op;
                this.source.op = "JSR";
                Instruction i = (Instruction)Asmj.processor.instructionSet.get(this.source.op);
                this.source.setInstruction(i);
                i.source = this.source;
                i.pass1(this.address, this.symtab);
                Asmj.optimize(this.source, "Optimization changing \"" + old + "\" to \"" + this.source.op + "\"");
                return true;
            }
        }
        if (this.source.op.toLowerCase().startsWith("l")) {
            return true;
        }
        int mask = (1 << this.len * 8 - 1) - 1;
        if (this.offset > 0 && (this.offset & ~mask) != 0 || this.offset < 0 && (~this.offset & ~mask) != 0) {
            if (VideConfig.getConfig().expandBranches) {
                String stackTrace = Utility.getCurrentStackTrace();
                if (stackTrace.contains("Symbol.define")) {
                    throw new SymbolDoesNotExistException("target out of range(from: $" + String.format("%04X", this.pc & 0xFFFF) + " to: $" + String.format("%04X", dest & 0xFFFF) + ", length: -$" + String.format("%02X", 65536 - (this.offset & 0xFFFF)) + " ), forward reference code should not be altered automatically!");
                }
                Asmj.warning(this.source, "Expanding branch, target out of range(from: $" + String.format("%04X", this.pc & 0xFFFF) + " to: $" + String.format("%04X", dest & 0xFFFF) + ", length: -$" + String.format("%02X", 65536 - (this.offset & 0xFFFF)) + " )");
                this.source.op = "L" + this.source.op;
                Instruction i = (Instruction)Asmj.processor.instructionSet.get(this.source.op);
                this.source.setInstruction(i);
                i.source = this.source;
                i.pass1(this.address, this.symtab);
                return true;
            }
            if ((this.offset & 0xFFFF) >= 32768) {
                throw new SymbolDoesNotExistException("target out of range(from: $" + String.format("%04X", this.pc & 0xFFFF) + " to: $" + String.format("%04X", dest & 0xFFFF) + ", length: -$" + String.format("%02X", 65536 - (this.offset & 0xFFFF)) + " )");
            }
            throw new SymbolDoesNotExistException("target out of range(from: $" + String.format("%04X", this.pc & 0xFFFF) + " to: $" + String.format("%04X", dest & 0xFFFF) + ", length: $" + String.format("%02X", this.offset & 0xFFFF) + " )");
        }
        return true;
    }

    @Override
    public boolean codegen(Memory mm) {
        this.writeOpcode(mm);
        int dataAddr = this.address + this.getOpcodeLength();
        mm.write(dataAddr, this.offset, this.len, true, 1);
        return true;
    }
}

