/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.instructions;

import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.SourceLine;
import de.malban.vide.assy.Symbol;
import de.malban.vide.assy.SymbolTable;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;

public abstract class Instruction {
    int address;
    int length;
    int opcode;
    int opcodelength;
    int datalength;
    SourceLine source;
    Asmj control;
    SymbolTable symtab;
    boolean parseOK;
    boolean evalOK;
    boolean genOK;
    SymbolDoesNotExistException missingSymbolEx;

    public void setEvalOk() {
        this.evalOK = true;
        this.missingSymbolEx = null;
    }

    public int getAddress() {
        return this.address;
    }

    public static Instruction create(Asmj asmj, SourceLine p) {
        if (p == null) {
            return null;
        }
        Instruction i = (Instruction)Asmj.processor.instructionSet.get(p.getOp());
        if (i == null) {
            Asmj.error(p, "unrecognized opcode '" + p.op + "'");
            return null;
        }
        i.setControl(asmj);
        i.setSource(p);
        return i;
    }

    public Instruction() {
        this.length = 0;
        this.genOK = false;
        this.parseOK = false;
        this.evalOK = false;
        this.missingSymbolEx = null;
    }

    public Instruction(Instruction i) {
        this.address = i.address;
        this.length = i.length;
        this.opcode = i.opcode;
        this.opcodelength = i.opcodelength;
        this.source = i.source;
        this.control = i.control;
        this.evalOK = i.evalOK;
        this.parseOK = i.parseOK;
        this.genOK = i.genOK;
        this.missingSymbolEx = i.missingSymbolEx;
    }

    public SourceLine getSource() {
        return this.source;
    }

    public void setSource(SourceLine p) {
        this.source = p;
    }

    public Asmj getControl() {
        return this.control;
    }

    public void setControl(Asmj c) {
        this.control = c;
    }

    private void error(String msg) {
        Asmj.error(this.source, msg);
    }

    public int getOpcodeLength() {
        return this.opcodelength;
    }

    public void writeOpcode(Memory mm) {
        mm.write(this.address, this.opcode, this.opcodelength, true, 1);
    }

    public String getLabel() {
        return this.source.getLabel();
    }

    public int getLineNumber() {
        return this.source.getLineNumber();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int i) {
        this.length = i;
        this.symtab.define("*", this.address + i, -2, null, 0, null);
    }

    public void pass1(int address, SymbolTable st) {
        this.symtab = st;
        Symbol star = this.symtab.find("*");
        if (star != null) {
            this.symtab.undefine(star);
        }
        this.address = address;
        try {
            this.parseOK = this.parse(this.source.rest);
        }
        catch (ParseException x) {
            Asmj.error(this.source, x.getMessage());
        }
        this.eval();
    }

    public void eval() {
        if (this.evalOK || !this.parseOK) {
            return;
        }
        try {
            this.evalOK = this.evalArgs();
            this.missingSymbolEx = null;
        }
        catch (SymbolDoesNotExistException x) {
            Symbol sym;
            String name = x.getItemName();
            if (name != null && (sym = this.symtab.find(name)) != null) {
                sym.addUndefinedReference(this);
                this.missingSymbolEx = x;
            } else {
                Asmj.error(this.source, x.getMessage());
            }
        }
        catch (ParseException x) {
            Asmj.error(this.source, x.getMessage());
        }
    }

    public void pass2(Memory mem, SymbolTable st) {
        if (this.missingSymbolEx != null) {
            Asmj.error(this.source, this.missingSymbolEx.getMessage());
        }
        if (!this.evalOK) {
            for (int a = this.address; a < this.address + this.getLength(); ++a) {
                mem.write(a, 0, 1, true, 0);
            }
        }
        if (this.genOK || !this.evalOK) {
            return;
        }
        this.genOK = this.codegen(mem);
    }

    public abstract boolean parse(String var1) throws ParseException;

    public abstract boolean evalArgs() throws SymbolDoesNotExistException, ParseException;

    public abstract boolean codegen(Memory var1);

    public int getDataLength() {
        return this.datalength;
    }

    public boolean generatedCode() {
        return true;
    }

    public String getRestrictions() {
        return "";
    }

    public boolean isEnd() {
        return false;
    }

    public boolean definesLabel() {
        return false;
    }

    public boolean isInclude() {
        return false;
    }

    public String includeFilename() throws ParseException {
        return null;
    }

    public boolean isBeginMacro() {
        return false;
    }

    public boolean isEndMacro() {
        return false;
    }

    public boolean isExitMacro() {
        return false;
    }

    public String macroName() throws ParseException {
        return null;
    }

    public boolean isIf() {
        return false;
    }

    public boolean isElseIf() {
        return false;
    }

    public boolean isElse() {
        return false;
    }

    public boolean isEndIf() {
        return false;
    }

    public boolean getCondition() {
        return true;
    }

    public boolean isStructStart() {
        return false;
    }

    public boolean isStructEnd() {
        return false;
    }

    public boolean isCMAP() {
        return false;
    }
}

