/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.instructions;

import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.arguments.ArgumentMemoryLocation;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.instructions.Instruction;
import de.malban.vide.assy.instructions.InstructionGroup;

public class RegArg
extends InstructionGroup {
    public ArgumentMemoryLocation m;

    @Override
    public boolean parse(String arg) throws ParseException {
        this.m = new ArgumentMemoryLocation(arg, this.symtab, (Instruction)this);
        switch (this.m.getMode()) {
            case 1: {
                this.setLength(this.getOpcodeLength() + this.getDataLength());
                break;
            }
            case 2: {
                this.setLength(this.getOpcodeLength() + 1);
                this.opcode += 16;
                break;
            }
            case 4: {
                this.setLength(this.getOpcodeLength() + this.m.getNumPostbytes());
                this.opcode += 32;
                break;
            }
            case 3: {
                this.setLength(this.getOpcodeLength() + 2);
                this.opcode += 48;
                break;
            }
            default: {
                throw new ParseException("bad mode");
            }
        }
        return true;
    }

    @Override
    public boolean evalArgs() throws SymbolDoesNotExistException {
        this.m.eval(this.symtab);
        if (this.m.getMode() == 3) {
            int pc = this.address + 2;
            int dest = this.m.getOffset();
            int offset = dest - pc;
            if (this.source.isOptimize()) {
                boolean isNegative;
                boolean isShort = false;
                boolean bl = isNegative = offset < 0;
                if (isNegative && offset >= -128) {
                    isShort = true;
                }
                if (!isNegative && offset < 127) {
                    isShort = true;
                }
                if (isShort && this.source.op.toLowerCase().equals("jsr")) {
                    Asmj.warning(this.source, "Optimization possible, (long) jsr can be changed to short (bsr):  \"" + this.source.op + "\" offset:  " + offset);
                }
            }
        }
        return true;
    }

    @Override
    public boolean codegen(Memory mm) {
        this.writeOpcode(mm);
        this.m.codegen(mm, this.symtab, this.address + this.getOpcodeLength(), this.getDataLength());
        return true;
    }
}

