/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.instructions;

import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.Symbol;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.expressions.Expression;
import de.malban.vide.assy.expressions.ExpressionList;
import de.malban.vide.assy.expressions.ExpressionSymbol;
import de.malban.vide.assy.instructions.PseudoOp;

public class fdb
extends PseudoOp {
    Expression data;
    boolean isBSS = false;

    public void setBSS(boolean b) {
        this.isBSS = b;
    }

    @Override
    public boolean parse(String paramString) throws ParseException {
        this.data = ExpressionList.parse(paramString, this.symtab);
        this.setLength(this.data.numItems() * 2);
        this.isBSS = Asmj.inBSS;
        return true;
    }

    public Symbol getSymbol() {
        ExpressionList ldata;
        if (this.data instanceof ExpressionSymbol) {
            ExpressionSymbol sdata = (ExpressionSymbol)this.data;
            return sdata.getSymbol();
        }
        if (this.data instanceof ExpressionList && (ldata = (ExpressionList)this.data).size() > 0 && ldata.elementAt(0) instanceof ExpressionSymbol) {
            ExpressionSymbol sdata = (ExpressionSymbol)ldata.elementAt(0);
            return sdata.getSymbol();
        }
        return null;
    }

    @Override
    public boolean evalArgs() throws SymbolDoesNotExistException {
        this.data.eval(this.symtab);
        return true;
    }

    @Override
    public boolean codegen(Memory paramMemory) {
        int i = this.data.numItems();
        if (this.isBSS) {
            return true;
        }
        for (int j = 0; j < i; ++j) {
            paramMemory.write(this.address + 2 * j, this.data.getItem(j), 2, true, 16);
        }
        Asmj.addLineInfo(this.address, i * 2, Asmj.LI_WORD);
        return true;
    }

    @Override
    public boolean generatedCode() {
        return true;
    }
}

