/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.assy.instructions;

import de.malban.vide.assy.Asmj;
import de.malban.vide.assy.Memory;
import de.malban.vide.assy.Symbol;
import de.malban.vide.assy.exceptions.ParseException;
import de.malban.vide.assy.exceptions.SymbolDoesNotExistException;
import de.malban.vide.assy.expressions.Expression;
import de.malban.vide.assy.expressions.ExpressionList;
import de.malban.vide.assy.expressions.ExpressionSymbol;
import de.malban.vide.assy.instructions.PseudoOp;
import de.malban.vide.dissy.DASM6809;

public class rmb
extends PseudoOp {
    Expression data;
    ExpressionSymbol symbolExpression = null;
    boolean isBSS = false;
    byte fillByte = 0;

    public Symbol getSymbol() {
        ExpressionList ldata;
        if (this.symbolExpression != null) {
            return this.symbolExpression.getSymbol();
        }
        if (this.data instanceof ExpressionSymbol) {
            ExpressionSymbol sdata = (ExpressionSymbol)this.data;
            return sdata.getSymbol();
        }
        if (this.data instanceof ExpressionList && (ldata = (ExpressionList)this.data).size() > 0 && ldata.elementAt(0) instanceof ExpressionSymbol) {
            ExpressionSymbol sdata = (ExpressionSymbol)ldata.elementAt(0);
            return sdata.getSymbol();
        }
        return null;
    }

    @Override
    public boolean parse(String paramString) throws ParseException {
        this.isBSS = this.control.currentSegment == 2;
        this.data = Expression.parse(paramString, this.symtab);
        this.fillByte = 0;
        if (this.data instanceof ExpressionSymbol && paramString.contains(",")) {
            this.symbolExpression = (ExpressionSymbol)this.data;
            paramString = paramString.trim();
            paramString = paramString.substring(this.symbolExpression.getSymbol().getName().length());
            paramString = paramString.trim();
            paramString = paramString.substring(1);
            paramString = paramString.trim();
            this.data = Expression.parse(paramString, this.symtab);
        } else if (paramString.contains(",")) {
            String param = paramString.substring(paramString.indexOf(",") + 1);
            param = param.trim();
            int value = DASM6809.toNumber(param);
            this.fillByte = (byte)(value &= 0xFF);
        }
        this.setLength(0);
        int i = 0;
        try {
            i = this.data.eval(this.symtab);
        }
        catch (SymbolDoesNotExistException localSymbolDoesNotExistException) {
            throw new ParseException(localSymbolDoesNotExistException.getMessage());
        }
        this.setLength(i);
        return true;
    }

    @Override
    public boolean codegen(Memory paramMemory) {
        if (this.isBSS) {
            return true;
        }
        for (int i = 0; i < this.length; ++i) {
            paramMemory.write(this.address + i, this.fillByte, 8);
        }
        Asmj.addLineInfo(this.address, this.length, Asmj.LI_BYTE);
        return true;
    }

    @Override
    public boolean generatedCode() {
        return !this.isBSS;
    }
}

