/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.codi;

import de.malban.Global;
import de.malban.config.Configuration;
import de.malban.config.TinyLogInterface;
import de.malban.graphics.SingleImagePanel;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.util.Utility;
import de.malban.util.UtilityFiles;
import de.malban.util.UtilityString;
import de.malban.util.syntax.Syntax.TokenStyles;
import de.malban.vide.VideConfig;
import de.malban.vide.assy.Asmj;
import de.malban.vide.script.ExecutionDescriptor;
import de.malban.vide.script.ScriptDataPanel;
import de.malban.vide.vecx.VecXPanel;
import de.malban.vide.vecx.cartridge.Cartridge;
import de.malban.vide.vecx.cartridge.CartridgeProperties;
import de.malban.vide.vedi.EditorEvent;
import de.malban.vide.vedi.EditorListener;
import de.malban.vide.vedi.EditorPanel;
import de.malban.vide.vedi.VEdiFoundationPanel;
import de.malban.vide.vedi.project.ProjectProperties;
import de.malban.vide.vedi.project.ProjectPropertiesPool;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CodeLibraryPanel
extends VEdiFoundationPanel
implements TinyLogInterface,
EditorListener {
    VideConfig config = VideConfig.getConfig();
    String treeName = null;
    String fileName = null;
    boolean init = false;
    private String lastPath = "";
    public static String SID = "Code Examples";
    int HTML_LAYER = 0;
    int CODE_LAYER = 1;
    int IMAGE_LAYER = 2;
    int EMPTY_LAYER = 3;
    int DISPLAY_LAYER = 4;
    Thread one = null;
    public boolean asmStarted = false;
    public boolean stop = false;
    public boolean running = false;
    public boolean pausing = false;
    int TAB_EQU = 30;
    int TAB_EQU_VALUE = 40;
    int TAB_MNEMONIC = 20;
    int TAB_OP = 30;
    int TAB_COMMENT = 50;
    private EditorPanel codeEditorPanel;
    private JEditorPane htmlEditorPane;
    private JScrollPane htmlScrollPane3;
    private JButton jButtonAssemble;
    private JButton jButtonCopy;
    private JButton jButtonIgnoreCase;
    private JButton jButtonSearchNext;
    private JButton jButtonSearchPrevious;
    private JCheckBox jCheckBoxIgnoreCase;
    private JEditorPane jEditorLog;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JLayeredPane jLayeredPane1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane;
    private JTextField jTextFieldSearch;
    private JTree jTree1;
    private SingleImagePanel singleImagePanel;
    public static final int DIR = 0;
    public static final int FILE = 1;

    @Override
    public JFrame getFrame() {
        return (CSAMainFrame)this.mParent;
    }

    @Override
    public void printASMList(String s, int type) {
    }

    @Override
    public void printASMMessage(String s, int type) {
        try {
            if (type == 0) {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogMessage"));
            } else if (type == 1) {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogError"));
            } else if (type == 2) {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogWarning"));
            } else if (type == 3) {
                this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s, TokenStyles.getStyle("editLogComment"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", "");
    }

    public CodeLibraryPanel() {
        this.initComponents();
        this.jEditorLog.setEditable(false);
        this.jEditorLog.setContentType("text/html");
        this.init();
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldSearch);
            HotKey.addMacDefaults(this.jEditorLog);
        }
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(this.getID());
    }

    @Override
    protected boolean closeRequested(String tabName) {
        return true;
    }

    @Override
    public void deinit() {
        this.saveSettings();
        this.init = false;
    }

    @Override
    public void init() {
        this.initSyntax();
        this.loadSettings();
        this.fillTree();
        this.init = true;
    }

    void repaintLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeLibraryPanel.this.codeEditorPanel.correctLineNumbers(true);
                CodeLibraryPanel.this.invalidate();
                CodeLibraryPanel.this.validate();
                CodeLibraryPanel.this.repaint();
            }
        });
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonAssemble = new JButton();
        this.jButtonCopy = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jLayeredPane1 = new JLayeredPane();
        this.codeEditorPanel = new EditorPanel();
        this.singleImagePanel = new SingleImagePanel();
        this.htmlScrollPane3 = new JScrollPane();
        this.htmlEditorPane = new JEditorPane();
        this.jPanel4 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldSearch = new JTextField();
        this.jButtonSearchNext = new JButton();
        this.jButtonSearchPrevious = new JButton();
        this.jButtonIgnoreCase = new JButton();
        this.jCheckBoxIgnoreCase = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jTabbedPane = new JTabbedPane();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorLog = new JEditorPane();
        this.setName("regi");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonAssemble.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/control_play_blue.png")));
        this.jButtonAssemble.setToolTipText("Redo");
        this.jButtonAssemble.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonAssemble.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeLibraryPanel.this.jButtonAssembleActionPerformed(evt);
            }
        });
        this.jButtonCopy.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_copy.png")));
        this.jButtonCopy.setToolTipText("Copy");
        this.jButtonCopy.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeLibraryPanel.this.jButtonCopyActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setMinimumSize(new Dimension(224, 164));
        this.jSplitPane1.setPreferredSize(new Dimension(576, 700));
        this.jSplitPane2.setDividerLocation(200);
        this.jSplitPane2.setPreferredSize(new Dimension(964, 100));
        this.jScrollPane1.setPreferredSize(new Dimension(145, 50));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("CodeLibrary");
        DefaultMutableTreeNode treeNode2 = new DefaultMutableTreeNode("BIOS replacements");
        DefaultMutableTreeNode treeNode3 = new DefaultMutableTreeNode("blue");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("violet");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("red");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("yellow");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("sports");
        treeNode3 = new DefaultMutableTreeNode("basketball");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("soccer");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("football");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("hockey");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        treeNode2 = new DefaultMutableTreeNode("food");
        treeNode3 = new DefaultMutableTreeNode("hot dogs");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("pizza");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("ravioli");
        treeNode2.add(treeNode3);
        treeNode3 = new DefaultMutableTreeNode("bananas");
        treeNode2.add(treeNode3);
        treeNode1.add(treeNode2);
        this.jTree1.setModel(new DefaultTreeModel(treeNode1));
        this.jTree1.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                CodeLibraryPanel.this.jTree1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.jSplitPane2.setLeftComponent(this.jScrollPane1);
        this.jLayeredPane1.setPreferredSize(new Dimension(810, 50));
        this.jLayeredPane1.setLayout(new OverlayLayout(this.jLayeredPane1));
        this.codeEditorPanel.setPreferredSize(new Dimension(584, 50));
        this.jLayeredPane1.add(this.codeEditorPanel);
        this.jLayeredPane1.setLayer(this.codeEditorPanel, 1);
        this.singleImagePanel.setPreferredSize(new Dimension(810, 50));
        GroupLayout singleImagePanelLayout = new GroupLayout(this.singleImagePanel);
        this.singleImagePanel.setLayout(singleImagePanelLayout);
        singleImagePanelLayout.setHorizontalGroup(singleImagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 810, Short.MAX_VALUE));
        singleImagePanelLayout.setVerticalGroup(singleImagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 297, Short.MAX_VALUE));
        this.jLayeredPane1.add(this.singleImagePanel);
        this.jLayeredPane1.setLayer(this.singleImagePanel, 2);
        this.htmlScrollPane3.setViewportView(this.htmlEditorPane);
        this.jLayeredPane1.add(this.htmlScrollPane3);
        this.jLayeredPane1.setLayer(this.htmlScrollPane3, 3);
        this.jPanel4.setPreferredSize(new Dimension(810, 50));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 810, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 297, Short.MAX_VALUE));
        this.jLayeredPane1.add(this.jPanel4);
        this.jSplitPane2.setRightComponent(this.jLayeredPane1);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("search:");
        this.jTextFieldSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeLibraryPanel.this.jTextFieldSearchActionPerformed(evt);
            }
        });
        this.jTextFieldSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                CodeLibraryPanel.this.jTextFieldSearchKeyPressed(evt);
            }
        });
        this.jButtonSearchNext.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_next.png")));
        this.jButtonSearchNext.setToolTipText("search forward");
        this.jButtonSearchNext.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSearchNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeLibraryPanel.this.jButtonSearchNextActionPerformed(evt);
            }
        });
        this.jButtonSearchPrevious.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_previous.png")));
        this.jButtonSearchPrevious.setToolTipText("search backwards");
        this.jButtonSearchPrevious.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSearchPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeLibraryPanel.this.jButtonSearchPreviousActionPerformed(evt);
            }
        });
        this.jButtonIgnoreCase.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/text_uppercase.png")));
        this.jButtonIgnoreCase.setToolTipText("ignore case (if selected)");
        this.jButtonIgnoreCase.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonIgnoreCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeLibraryPanel.this.jButtonIgnoreCaseActionPerformed(evt);
            }
        });
        this.jCheckBoxIgnoreCase.setSelected(true);
        this.jCheckBoxIgnoreCase.setToolTipText("ignore case (if selected)");
        this.jLabel5.setForeground(new Color(255, 0, 0));
        this.jLabel5.setToolTipText("");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jCheckBoxIgnoreCase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonIgnoreCase).addGap(23, 23, 23).addComponent(this.jLabel1).addGap(2, 2, 2).addComponent(this.jTextFieldSearch, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearchPrevious).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearchNext).addGap(301, 301, 301).addComponent(this.jLabel5, -2, 97, -2).addContainerGap(303, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSearchNext).addComponent(this.jButtonSearchPrevious).addGroup(jPanel3Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSearch, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel5, -2, 19, -2)).addComponent(this.jCheckBoxIgnoreCase).addComponent(this.jButtonIgnoreCase)))).addGap(2, 2, 2)));
        this.jScrollPane2.setViewportView(this.jEditorLog);
        this.jTabbedPane.addTab("Messages", this.jScrollPane2);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTabbedPane).addGap(1, 1, 1).addComponent(this.jPanel3, -2, -1, -2)));
        this.jSplitPane1.setBottomComponent(this.jPanel2);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jSplitPane1, -1, -1, Short.MAX_VALUE).addGap(1, 1, 1)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonCopy).addGap(190, 190, 190).addComponent(this.jButtonAssemble).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCopy).addComponent(this.jButtonAssemble)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 730, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
    }

    private void jButtonSearchNextActionPerformed(ActionEvent evt) {
        this.jLabel5.setText("");
        boolean found = this.codeEditorPanel.goNext(this.jTextFieldSearch.getText(), this.jCheckBoxIgnoreCase.isSelected());
        if (!found) {
            this.jLabel5.setText("not found!");
        }
    }

    private void jButtonSearchPreviousActionPerformed(ActionEvent evt) {
        this.jLabel5.setText("");
        boolean found = this.codeEditorPanel.goPrevious(this.jTextFieldSearch.getText(), this.jCheckBoxIgnoreCase.isSelected());
        if (!found) {
            this.jLabel5.setText("not found!");
        }
    }

    private void jButtonIgnoreCaseActionPerformed(ActionEvent evt) {
        this.jCheckBoxIgnoreCase.setSelected(!this.jCheckBoxIgnoreCase.isSelected());
    }

    private void jTextFieldSearchKeyPressed(KeyEvent evt) {
        this.jLabel5.setText("");
    }

    private void jTextFieldSearchActionPerformed(ActionEvent evt) {
        this.jButtonSearchNextActionPerformed(null);
    }

    void resetLayers() {
        this.jLayeredPane1.setLayer(this.codeEditorPanel, this.CODE_LAYER);
        this.jLayeredPane1.setLayer(this.htmlScrollPane3, this.HTML_LAYER);
        this.jLayeredPane1.setLayer(this.singleImagePanel, this.IMAGE_LAYER);
        this.jLayeredPane1.setLayer(this.jPanel4, this.EMPTY_LAYER);
    }

    private void jTree1ValueChanged(TreeSelectionEvent evt) {
        String text;
        if (!(((DefaultMutableTreeNode)evt.getPath().getLastPathComponent()).getUserObject() instanceof TreeEntry)) {
            return;
        }
        TreeEntry entry = (TreeEntry)((DefaultMutableTreeNode)evt.getPath().getLastPathComponent()).getUserObject();
        if (entry.type == 0) {
            return;
        }
        this.jLayeredPane1.getComponentsInLayer(3);
        this.fileName = null;
        this.treeName = entry.path.toString();
        this.resetLayers();
        if (entry.name.toLowerCase().endsWith(".asm") || entry.name.toLowerCase().endsWith(".s") || entry.name.toLowerCase().endsWith(".as9") || entry.name.toLowerCase().endsWith(".i") || entry.name.toLowerCase().endsWith(".inc")) {
            this.jLayeredPane1.setLayer(this.codeEditorPanel, this.DISPLAY_LAYER);
            this.codeEditorPanel.deinit();
            this.codeEditorPanel.setFilename(entry.path.toString());
            this.codeEditorPanel.reload(false);
            this.codeEditorPanel.setup(null);
            this.fileName = entry.path.toString();
            this.repaintLater();
        }
        if (entry.name.toLowerCase().endsWith(".jpg") || entry.name.toLowerCase().endsWith(".png") || entry.name.toLowerCase().endsWith(".gif") || entry.name.toLowerCase().endsWith(".bmp")) {
            this.jLayeredPane1.setLayer(this.singleImagePanel, this.DISPLAY_LAYER);
            this.singleImagePanel.setImage(entry.path.toString());
        }
        if (entry.name.toLowerCase().endsWith(".htm") || entry.name.toLowerCase().endsWith(".html")) {
            this.jLayeredPane1.setLayer(this.htmlScrollPane3, this.DISPLAY_LAYER);
            this.htmlEditorPane.setContentType("text/html");
            text = UtilityString.readTextFileToOneString(new File(entry.path.toString()));
            this.htmlEditorPane.setText(text);
        }
        if (entry.name.toLowerCase().endsWith(".txt")) {
            this.jLayeredPane1.setLayer(this.htmlScrollPane3, this.DISPLAY_LAYER);
            this.htmlEditorPane.setContentType("text/plain");
            text = UtilityString.readTextFileToOneString(new File(entry.path.toString()));
            this.htmlEditorPane.setText(text);
        }
    }

    private void jButtonAssembleActionPerformed(ActionEvent evt) {
        if (this.isProject()) {
            return;
        }
        if (this.fileName == null) {
            return;
        }
        if (this.fileName.trim().length() == 0) {
            return;
        }
        Path p = Paths.get(this.fileName, new String[0]);
        UtilityFiles.cleanDirectory(Global.mainPathPrefix + "tmp" + File.separator);
        UtilityFiles.copyDirectoryAllFiles(p.getParent().toString(), Global.mainPathPrefix + "tmp" + File.separator);
        p = Paths.get(Global.mainPathPrefix + "tmp" + File.separator + p.getFileName(), new String[0]);
        this.jEditorLog.setText("");
        this.startASM(p.toString());
    }

    public void startASM(final String filenameASM) {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonAssemble.setEnabled(false);
        if (this.one != null) {
            return;
        }
        this.one = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                    try {
                        Asmj asm = new Asmj(filenameASM, CodeLibraryPanel.this.asmErrorOut, CodeLibraryPanel.this.asmListOut, CodeLibraryPanel.this.asmSymbolOut, CodeLibraryPanel.this.asmMessagesOut, "", null);
                        String info = asm.getInfo();
                        final boolean asmOk = info.indexOf("0 errors detected.") >= 0;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CodeLibraryPanel.this.asmResult(asmOk, filenameASM);
                            }
                        });
                    }
                    catch (Throwable e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CodeLibraryPanel.this.printASMMessage("Exception while assembling: " + e.getMessage(), 1);
                                CodeLibraryPanel.this.printASMMessage(Utility.getStackTrace(e), 1);
                                CodeLibraryPanel.this.asmResult(false, filenameASM);
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CodeLibraryPanel.this.one = null;
                CodeLibraryPanel.this.jButtonAssemble.setEnabled(true);
                CodeLibraryPanel.this.asmStarted = false;
            }
        };
        this.one.setName("Run ASMJ with: " + filenameASM);
        this.one.start();
    }

    protected void asmResult(boolean asmOk, String filenameASM) {
        if (asmOk) {
            if (this.config.invokeEmulatorAfterAssembly) {
                VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
                ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
                String fname = "";
                if (filenameASM.toLowerCase().endsWith(".asm")) {
                    fname = filenameASM.substring(0, filenameASM.length() - 4);
                } else {
                    int li = filenameASM.lastIndexOf(".");
                    if (li >= 0) {
                        fname = filenameASM.substring(0, li);
                    }
                }
                fname = fname + ".bin";
                vec.startUp(fname, false);
                this.printMessage("Assembly successful, starting emulation...");
                UtilityFiles.cleanDirectory(Global.mainPathPrefix + "tmp" + File.separator);
            } else {
                this.printMessage("Assembly successful...");
            }
        } else {
            this.printError("Assembly not successful, see ASM output...");
        }
    }

    int spaceTo(StringBuilder s, int posNow, int upTo) {
        s.append(" ");
        while (true) {
            int n = ++posNow;
            ++posNow;
            if (n >= upTo) break;
            s.append(" ");
        }
        return posNow;
    }

    String prettyQuoteLine(String line) {
        int endQuote;
        String quoteChar = "\"";
        int startQuote = line.indexOf("\"");
        if (line.indexOf("'") > startQuote) {
            quoteChar = "'";
            startQuote = line.indexOf("'");
        }
        if ((endQuote = line.lastIndexOf(quoteChar)) <= startQuote) {
            return line;
        }
        String preQuote = line.substring(0, startQuote);
        String quote = line.substring(startQuote, endQuote + 1);
        String postQuote = line.substring(endQuote + 1);
        StringBuilder b = new StringBuilder();
        String[] words = preQuote.split(" ");
        int w = 0;
        int c = 0;
        if (!UtilityString.isWordBoundry(line.charAt(0))) {
            b.append(words[w]).append(" ");
            c += words[w].length() + 1;
            ++w;
        }
        c = this.spaceTo(b, c, this.TAB_MNEMONIC);
        if (w >= words.length) {
            b.append(quote);
            c += quote.length();
            c = this.spaceTo(b, c, this.TAB_OP);
            b.append(postQuote);
            return b.toString();
        }
        while (words[w].length() == 0) {
            ++w;
        }
        b.append(words[w]).append(" ");
        c += words[w].length() + 1;
        ++w;
        c = this.spaceTo(b, c, this.TAB_OP);
        while (w < words.length) {
            if (words[w].length() != 0) {
                b.append(words[w]).append(" ");
                c += words[w].length() + 1;
            }
            ++w;
        }
        b.append(quote);
        c += quote.length();
        b.append(postQuote);
        return b.toString();
    }

    int getFirstnonQuoteComment(String line) {
        int endQuote;
        String quoteChar = "\"";
        int startQuote = line.indexOf("\"");
        if (line.indexOf("'") > startQuote) {
            quoteChar = "'";
            startQuote = line.indexOf("'");
        }
        if ((endQuote = line.lastIndexOf(quoteChar)) <= startQuote) {
            return -1;
        }
        String preQuote = line.substring(0, startQuote);
        String quote = line.substring(startQuote, endQuote + 1);
        String postQuote = line.substring(endQuote + 1);
        int ind = postQuote.indexOf(";");
        if (ind == -1) {
            return -1;
        }
        return ind + preQuote.length() + quote.length();
    }

    public String getLine(JEditorPane comp, int pos) {
        try {
            return comp.getDocument().getText(0, comp.getDocument().getLength()).split("\n")[pos];
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    int getLineOfPos(JEditorPane comp, int pos) {
        int ret = -1;
        try {
            String[] lines = comp.getDocument().getText(0, comp.getDocument().getLength()).split("\n");
            int c = -1;
            for (int count = 0; count <= pos; count += lines[++c].length() + 1) {
            }
            if (c < lines.length) {
                ret = c;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public void editorChanged(EditorEvent ev) {
    }

    @Override
    public void printMessage(String s) {
        try {
            this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s + "\n", TokenStyles.getStyle("editLogMessage"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public void printWarning(String s) {
        try {
            this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s + "\n", TokenStyles.getStyle("editLogWarning"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public void printError(String s) {
        try {
            this.jEditorLog.getDocument().insertString(this.jEditorLog.getDocument().getLength(), s + "\n", TokenStyles.getStyle("editLogError"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.jEditorLog.setCaretPosition(this.jEditorLog.getDocument().getLength());
    }

    @Override
    public void printMessageSU(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeLibraryPanel.this.printMessage(s);
            }
        });
    }

    @Override
    public void printWarningSU(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeLibraryPanel.this.printWarning(s);
            }
        });
    }

    @Override
    public void printErrorSU(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeLibraryPanel.this.printError(s);
            }
        });
    }

    @Override
    public void requestSearchFocus() {
        this.jTextFieldSearch.requestFocusInWindow();
    }

    void fillTree() {
        Path startpath = Paths.get(Global.mainPathPrefix, "codelib");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new TreeEntry(startpath));
        this.addChildren(root);
        this.jTree1.setModel(new DefaultTreeModel(root));
    }

    boolean addChildren(DefaultMutableTreeNode node) {
        File[] fList;
        TreeEntry entry = (TreeEntry)node.getUserObject();
        if (entry.type == 1) {
            return false;
        }
        Path basePath = entry.path;
        File directory = basePath.toFile();
        for (File file : fList = directory.listFiles()) {
            TreeEntry newEntry = new TreeEntry(Paths.get(basePath.toString(), file.getName()));
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(newEntry);
            node.add(child);
            this.addChildren(child);
        }
        return true;
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        SplitterLocation sl = new SplitterLocation();
        sl.pos = this.jSplitPane1.getDividerLocation();
        return sl;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
        SplitterLocation sl = (SplitterLocation)ser;
        this.jSplitPane1.setDividerLocation(sl.pos);
    }

    ProjectProperties getProjectFile(String dir) {
        File[] fList;
        File directory = new File(dir);
        for (File file : fList = directory.listFiles()) {
            if (!file.getName().contains("ProjectProperty.xml")) continue;
            String ppath = Utility.makeVideRelative(file.getParent());
            if (ppath.length() != 0) {
                ppath = ppath + File.separator;
            }
            ProjectPropertiesPool pool = new ProjectPropertiesPool(ppath, file.getName());
            ProjectProperties project = pool.get(file.getName().substring(0, file.getName().length() - "ProjectProperty.xml".length()));
            return project;
        }
        return null;
    }

    private boolean isProject() {
        ExecutionDescriptor ed;
        String preName;
        if (this.treeName == null) {
            return false;
        }
        Path p = Paths.get(this.treeName, new String[0]);
        String dir = p.getParent().toString();
        ProjectProperties project = this.getProjectFile(dir);
        if (project == null) {
            return false;
        }
        String preClass = project.getProjectPreScriptClass();
        boolean ok = ScriptDataPanel.executeScript(preClass, preName = project.getProjectPreScriptName(), this, ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_PRE, project.getProjectName(), "", "CodeLibraryPanel", dir));
        if (!ok) {
            return true;
        }
        this.startBuild(project);
        return true;
    }

    public void startBuild(final ProjectProperties project) {
        if (this.asmStarted) {
            return;
        }
        this.asmStarted = true;
        this.jButtonAssemble.setEnabled(false);
        if (this.one != null) {
            return;
        }
        this.one = new Thread(){

            @Override
            public void run() {
                boolean asmOk = true;
                try {
                    for (int b = 0; b < project.getNumberOfBanks(); ++b) {
                        File test;
                        String filenameASM = project.getBankMainFiles().elementAt(b);
                        if (filenameASM.length() == 0) continue;
                        if (project.projectPrefix.length() == 0) {
                            Path p = Paths.get(CodeLibraryPanel.this.treeName, new String[0]);
                            String dir = p.getParent().toString();
                            project.projectPrefix = Utility.makeVideRelative(dir);
                        }
                        if (!(test = new File(filenameASM = Utility.makeVideAbsolute(project.projectPrefix) + File.separator + filenameASM)).exists()) continue;
                        String define = project.getBankDefines().elementAt(b);
                        CodeLibraryPanel.this.printMessage("Assembling: " + filenameASM);
                        Asmj asm = new Asmj(filenameASM, CodeLibraryPanel.this.asmErrorOut, null, null, CodeLibraryPanel.this.asmMessagesOut, define, null);
                        CodeLibraryPanel.this.printASMList(asm.getListing(), 2);
                        String info = asm.getInfo();
                        boolean bl = asmOk = info.indexOf("0 errors detected.") >= 0;
                        if (asmOk) {
                            String filename = project.getBankMainFiles().elementAt(b);
                            filename = project.projectPrefix + File.separator + filename;
                            int li = filename.lastIndexOf(".");
                            if (li >= 0) {
                                filename = filename.substring(0, li);
                            }
                            String org2 = filename + ".bin";
                            String banked = filename + "_" + b + ".bin";
                            UtilityFiles.move(org2, banked);
                            org2 = filename + ".cnt";
                            banked = filename + "_" + b + ".cnt";
                            Vector<String> what = new Vector<String>();
                            Vector<String> with = new Vector<String>();
                            what.add("BANK 0");
                            with.add("BANK " + b);
                            UtilityString.replaceToNewFile(new File(org2), new File(banked), what, with);
                            UtilityFiles.deleteFile(org2);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CodeLibraryPanel.this.printASMMessage("Exception while building: " + e.getMessage(), 1);
                            CodeLibraryPanel.this.printASMMessage(Utility.getStackTrace(e), 1);
                            CodeLibraryPanel.this.buildResult(false, project);
                        }
                    });
                    CodeLibraryPanel.this.one = null;
                    CodeLibraryPanel.this.jButtonAssemble.setEnabled(true);
                    CodeLibraryPanel.this.asmStarted = false;
                    return;
                }
                if (!asmOk) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CodeLibraryPanel.this.buildResult(false, project);
                        }
                    });
                    CodeLibraryPanel.this.one = null;
                    CodeLibraryPanel.this.jButtonAssemble.setEnabled(true);
                    CodeLibraryPanel.this.asmStarted = false;
                    return;
                }
                String postClass = project.getProjectPostScriptClass();
                String postName = project.getProjectPostScriptName();
                String pp = project.projectPrefix;
                ExecutionDescriptor ed = new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_PROJECT_POST, project.getProjectName(), "", "CodeLibraryPanel", pp);
                boolean ok = ScriptDataPanel.executeScript(postClass, postName, CodeLibraryPanel.this, ed);
                final boolean asmOk2 = asmOk;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CodeLibraryPanel.this.buildResult(asmOk2, project);
                    }
                });
                CodeLibraryPanel.this.one = null;
                CodeLibraryPanel.this.jButtonAssemble.setEnabled(true);
                CodeLibraryPanel.this.asmStarted = false;
            }
        };
        this.one.setName("Build: " + project.getProjectName());
        this.one.start();
    }

    protected void buildResult(boolean buildOk, ProjectProperties project) {
        if (buildOk) {
            if (this.config.invokeEmulatorAfterAssembly) {
                VecXPanel vec = ((CSAMainFrame)this.mParent).getVecxy();
                ((CSAMainFrame)this.mParent).getInternalFrame(vec).toFront();
                CartridgeProperties cartProp = this.buildCart(project);
                vec.startCartridge(cartProp, 2);
                this.printMessage("Assembly successful, starting emulation...");
            } else {
                this.printMessage("Assembly successful...");
            }
        } else {
            this.printError("Assembly not successful, see ASM output...");
        }
    }

    CartridgeProperties buildCart(ProjectProperties project) {
        CartridgeProperties cart = new CartridgeProperties();
        for (int b = 0; b < project.getNumberOfBanks(); ++b) {
            File test;
            String filename = project.getBankMainFiles().elementAt(b);
            filename = project.projectPrefix.length() == 0 ? project.getOldPath() + File.separator + project.mName + File.separator + filename : project.projectPrefix + File.separator + filename;
            int li = filename.lastIndexOf(".");
            if (li >= 0) {
                filename = filename.substring(0, li);
            }
            if (!(test = new File(Utility.makeVideAbsolute(filename = filename + "_" + b + ".bin"))).exists()) {
                cart.getFullFilename().add("");
                continue;
            }
            cart.getFullFilename().add(filename);
        }
        cart.setCartName(project.getProjectName());
        cart.setAuthor(project.getAuthor());
        String bs = project.getBankswitching();
        int typeFlags = project.getExtras();
        if (!bs.equals("none")) {
            if (bs.contains("standard")) {
                typeFlags += Cartridge.FLAG_BANKSWITCH_DONDZILA;
            } else if (bs.contains("VecFlash")) {
                typeFlags += Cartridge.FLAG_BANKSWITCH_VECFLASH;
            }
        }
        if ((typeFlags & Cartridge.FLAG_IMAGER) == Cartridge.FLAG_IMAGER) {
            cart.setWheelName(project.getWheelName());
        }
        cart.setTypeFlags(typeFlags);
        return cart;
    }

    @Override
    public void run() {
    }

    @Override
    public void debug() {
    }

    @Override
    public void doQuickHelp(String s, String f2) {
    }

    @Override
    public void tabChanged(boolean b) {
    }

    @Override
    public void changeFileName(String s, String f2) {
    }

    @Override
    public void processIncludeLine(String s) {
    }

    @Override
    public void processWord(String s) {
    }

    @Override
    protected void deselectInTree(String tabName) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        TreeEntry entry = (TreeEntry)node.getUserObject();
        if (entry == null) {
            return;
        }
        if (tabName.equals(tabName)) {
            ++this.mClassSetting;
            this.jTree1.clearSelection();
            --this.mClassSetting;
        }
    }

    @Override
    public void deIconified() {
    }

    static class SplitterLocation
    implements Serializable {
        int pos = 0;

        SplitterLocation() {
        }
    }

    class TreeEntry {
        int type;
        String name;
        Path path;

        public TreeEntry(Path p) {
            this.path = p;
            this.type = p.toFile().isDirectory() ? 0 : 1;
            this.name = this.path.getFileName().toString();
        }

        public String toString() {
            return this.name;
        }
    }
}

