/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.dissy;

public class Command {
    public static final int D_CMD_RESET = 0;
    public static final int D_CMD_GO = 1;
    public static final int D_CMD_CYCLES = 2;
    public static final int D_CMD_PRINT = 3;
    public static final int D_CMD_WATCH = 4;
    public static final int D_CMD_BREAKPOINT = 5;
    public static final int D_CMD_BREAKPOINT_RESET = 6;
    public static final int D_CMD_HELP = 7;
    public static final int D_CMD_LABEL_RESET = 8;
    public static final int D_CMD_INFO = 9;
    public static final int D_CMD_BANKSWITCH = 10;
    public static final int D_CMD_REMOVE_DISSI_COMMENTS = 11;
    public static final int D_CMD_BANKSWITCH_INFO = 12;
    public static final int D_CMD_CLEAR_SCREEN = 13;
    public static final int D_CMD_RUN_CYCLES = 14;
    public static final int D_CMD_CYCLES_MEASURE = 15;
    public static final int D_CMD_POKE = 16;
    public static final int D_CMD_SOFTRESET = 17;
    public static final int D_CMD_SYNC_BANK_COMMENTS = 18;
    public static final int D_CMD_CARTRIDGE = 19;
    public static final int D_CMD_JOYPORT_DEVICE = 20;
    public static final int D_CMD_BANKSWITCH_DEBUG = 21;
    public static final int D_CMD_SET = 22;
    public static final int D_CMD_REMOVE_WATCH = 23;
    public static final int D_CMD_REDRAW = 24;
    public static final int D_CMD_CLEAR = 25;
    public static final int D_CMD_QUIET = 26;
    public static final int D_CMD_TO_FEVER = 27;
    public static final int D_CMD_DONOT_FOLLOW = 28;
    public static final int D_CMD_DUMP_JOGL = 29;
    public static final int D_CMD_TOGGLE_DISASM_RAM = 30;
    public static final int D_CMD_DO_NMI = 31;
    public static final int D_CMD_STACK_WATCH = 32;
    public static final int D_CMD_EXPORT_DATA = 33;
    public static final int D_CMD_JUMP_DATA = 34;
    public static final int D_CMD_TO_PITREX = 35;
    public static final int D_CMD_DUMP_BIN = 36;
    public static final Command[] commands = new Command[]{new Command(0, "HardReset", "hr", 0, 0, "\"HardReset\"\t\tvectrex, start with currently loaded cartridge (reloaded, HARD reset)", ""), new Command(17, "SoftReset", "sr", 0, 0, "\"SoftReset\"\t\tvectrex, start with currently loaded cartridge (not reloaded, SOFT reset)", ""), new Command(1, "Go [xxxx]", "g", 0, 0, "\"Go\"\t\t\tleave debugging, and run the emulator [go from, meaning pc = xxxx than go]", "G"), new Command(2, "Cycles", "c", 0, 1, "\"Cycles [#number]\"\t\tprint current cycle count of running vectrex, \n\t\t\t#number sets the current cycle count", ""), new Command(14, "RunCycles", "rc", 0, 0, "\"RunCycles ####\"\t\tRun program untill at least #### cycles have been processed\n\t\t\t(all instructions are fully processed) ", ""), new Command(15, "CountCycles", "cc", 0, 0, "\"CountCycles $xxxx $yyyy\"\tnext time pc executed $xxxx it starts counting cycles \n\t\t\tand prints out the count after $yyyy is executed(only in currently emulated bank!) ", ""), new Command(3, "Print", "p", 1, 1, "\"Print $xxxx|$label [8|16]\"\tprint content of an address or label, \n\t\t\t8 as 8bit (default), 16 as 16bit", ""), new Command(4, "Watch", "w", 1, 1, "\"Watch $xxxx|$label [0|1|2|3|4|5 x]\"\twatch content of an address or label, \n\t\t\t0 - binary\n\t\t\t1 - byte\n\t\t\t2 - word\n\t\t\t3 - string\n\t\t\t4 - byte pair\n\t\t\t5,x - byte sequence", ""), new Command(5, "Breakpoint", "b", 1, 0, "\"Breakpoint $xxxx\"\t\ttoggle breakpoint to address\n\t\t\tROM\n\t\t\tPC\n\t\t\tNZ [,compareValue]\n\t\t\tSTACK, compareValue\n\t\t\tbankswitch\n\t\t\tVIA_ORB $0-7 (bit )\n\t\t\tWEIRD_AUX (!= $80 & != $98)\n\t\t\tT2 (write)\n\t\t\tREAD (from / to)", "SPACE"), new Command(6, "ClearBreakpoint", "cb", 0, 0, "\"ClearBreakpoint\"\tclears all breakpoints", ""), new Command(8, "LabelReset", "lr", 0, 0, "\"LabelReset\"\t\tResets all automatically build labels", ""), new Command(9, "Info", "i", 0, 0, "\"Info\"\t\t\tPrint information about current cartridge", ""), new Command(10, "Bankswitch", "bs", 0, 0, "\"Bankswitch $00\"\tSwitch debugger to bank x (%maxBanks for cartridge)", ""), new Command(7, "Help", "h", 0, 0, "\"Help\"\t\t\toutput list of commands", ""), new Command(11, "RMD", "", 0, 0, "\"RMD\"\t\t\tremove automatically generated dissi comments", ""), new Command(12, "BankswitchInfo", "bi", 0, 0, "\"BankswitchInfo\"\tDisplay a textmessage upon bankswitch (toggle)", ""), new Command(13, "CLS", "", 0, 0, "\"CLS\"\t\t\tClear messages", ""), new Command(16, "POKE", "", 0, 0, "\"POKE\"\t\t\t$xxxx $yy write value to address", ""), new Command(18, "SyncBankComments", "sbc", 0, 0, "\"SyncBankComments\"\tSynchronizes comments in different banks, if code/data is equal.", ""), new Command(19, "carti", "", 0, 0, "\"carti\"\t\t\tOpens a cartridge device debug window.", ""), new Command(20, "joyi", "", 0, 0, "\"joyi\"\t\t\tOpens a joyport device debug window.", ""), new Command(21, "BankswitchDebug", "bsd", 0, 0, "\"BankswitchDebug\"\tAll memory breakpoints are set/deleted in all banks.", ""), new Command(22, "set", "", 0, 0, "\"set XX YY\"\t\tSet a 6809 register to a value (e.g. 'set d $1000').", ""), new Command(23, "RemoveWatch", "rw", 1, 1, "\"RemoveWatch $xxxx|$label\"\tremoves a watch", ""), new Command(24, "Redraw", "rd", 1, 1, "\"Redraw\"\t\t\tcurrent screen", ""), new Command(25, "Clear", "cl", 1, 1, "\"Clear\"\t\t\tcurrent screen (not implemented)", ""), new Command(26, "Quiet", "q", 1, 1, "\"Quiet\"\t\t\tBreakpoints are handled more quietly (toggle - default not quiet)", ""), new Command(27, "ToFever", "tf", 1, 1, "\"ToFever\"\t\t\tpush the current active ROM to the development mode of VecFever (config in configuration)", ""), new Command(28, "DoNotFollow", "df", 1, 1, "\"DoNotFollow\"\t\tIf update is switched - do not follow within table (just update columns).\n\t\t\t\tAlso sets print final track values to true.", ""), new Command(29, "DumpJOGL", "dj", 1, 1, "\"DumpJOGL\"\t\tDump JOGL OpenGL infos.", ""), new Command(30, "DisasmRAM", "dr", 1, 1, "\"DisasmRAM\"\t\tActively disassemble RAM memory.", ""), new Command(31, "NMI", "NMI", 1, 1, "\"NMI\"\t\t\tDo one NMI.", ""), new Command(34, "VIEW", "v", 1, 1, "\"VIEW\"\t\t\tJump view to address $xxxx.", ""), new Command(35, "ToPiTrex", "tp", 1, 1, "\"ToPiTrex\"\t\tpush the current active ROM to the development mode of PiTrex (config in configuration)", ""), new Command(36, "DumpBin", "dp", 1, 1, "\"DumpBin\"\t\t\tDump current cartridge ROM to a bin file", ""), new Command(32, "StackWatch", "sw", 1, 1, "\"StackWatch\"\t\tWatch $xxxx $value for stack changes.", ""), new Command(33, "ExportData", "ed", 5, 0, "\"ExportData\"\t\tExport memory range as DB statements.\n\t\t\t\tfilename\n\t\t\t\tstartaddress\n\t\t\t\tendaddress\n\t\t\t\tformat(as in watch)\n\t\t\t\titems per line", "")};
    public String fullname = "";
    public String abreviation = "";
    public String shortkey = "";
    public String help = "";
    public int numNeededArguments = 0;
    public int numOptionalArguments = 0;
    public int ID = 0;

    private Command(int i, String fn, String ab, int na, int oa, String sy, String sk) {
        this.ID = i;
        this.fullname = fn;
        this.abreviation = ab;
        this.numNeededArguments = na;
        this.numOptionalArguments = oa;
        this.shortkey = sk;
        this.help = sy;
    }

    public static Command getCommand(String s) {
        for (Command c : commands) {
            if (s.toLowerCase().equals(c.fullname.toLowerCase())) {
                return c;
            }
            if (!s.toLowerCase().equals(c.abreviation.toLowerCase())) continue;
            return c;
        }
        return null;
    }

    public static String getHelp() {
        StringBuilder s = new StringBuilder();
        s.append("List of all dissi commands:\n");
        for (Command c : commands) {
            s.append(c.help).append(" [").append(c.abreviation).append("]\n");
        }
        return s.toString();
    }
}

