/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.dissy;

import de.malban.config.Configuration;
import de.malban.gui.CSAMainFrame;
import de.malban.gui.HotKey;
import de.malban.gui.Stateable;
import de.malban.gui.Windowable;
import de.malban.gui.components.CSAView;
import de.malban.gui.dialogs.InternalFrameFileChoser;
import de.malban.util.UtilityString;
import de.malban.util.syntax.Syntax.TokenStyles;
import de.malban.vide.VideConfig;
import de.malban.vide.dissy.DASM6809;
import de.malban.vide.dissy.DisCompareFileStrings;
import de.malban.vide.dissy.Memory;
import de.malban.vide.dissy.MemoryInformation;
import de.malban.vide.dissy.MemoryInformationTableModelSmall;
import de.malban.vide.vecx.Updatable;
import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;

public class CompareDissiPanel
extends JPanel
implements Windowable,
Stateable,
Updatable {
    VideConfig config = VideConfig.getConfig();
    public static final String MESSAGE_INFO = "editLogMessage";
    public static final String MESSAGE_WARN = "editLogWarning";
    public static final String MESSAGE_ERR = "error";
    String lastDir1;
    String lastDir2;
    private CSAView mParent = null;
    private JMenuItem mParentMenuItem = null;
    private int mClassSetting = 0;
    MemoryInformationTableModelSmall model = null;
    DASM6809 dasm = new DASM6809();
    MemoryInformationTableModelSmall model1 = null;
    DASM6809 dasm1 = new DASM6809();
    boolean init = false;
    boolean init1 = false;
    JTable popupSource = null;
    ArrayList<Integer> byteDifs = new ArrayList();
    public static ArrayList<CompareDissiPanel> panels = new ArrayList();
    int activeDif = -1;
    int allDifCount = 0;
    ArrayList<TableColumn> allColumns1 = null;
    ArrayList<TableColumn> allColumns2 = null;
    ArrayList<Integer> rowStack = new ArrayList();
    int rowStackPosition = -1;
    ArrayList<String> commandHistory = new ArrayList();
    int commandHistoryPosition = -1;
    private JButton jButtonDifNext;
    private JButton jButtonDifPrevious;
    private JButton jButtonFileSelect1;
    private JButton jButtonFileSelect2;
    private JButton jButtonSearchNext;
    private JButton jButtonSearchPrevious;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBoxSourceMode;
    private JCheckBox jCheckBoxSync;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelDifsFound;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItemByte;
    private JMenuItem jMenuItemC9;
    private JMenuItem jMenuItemChar;
    private JMenuItem jMenuItemCode;
    private JMenuItem jMenuItemJoin;
    private JMenuItem jMenuItemRemove;
    private JMenuItem jMenuItemUngroup;
    private JMenuItem jMenuItemWord;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JTable jTableSource;
    private JTable jTableSource1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextFieldCurrentDifAdr;
    private JTextField jTextFieldSearch;
    private JTextField jTextFieldTileFile;
    private JTextField jTextFieldTileFile1;
    boolean assumeVectrex = true;
    boolean createUnkownLabels = false;
    String loadedName = "";
    String loadedName1 = "";
    FileWatcher watchLeft = null;
    FileWatcher watchRight = null;
    BoundedRangeModel sBar1Model;
    BoundedRangeModel sBar2Model;
    public static String SID = "Compare Disassembled";
    boolean keyEventsAreSet = false;
    private boolean updateEnabled = false;
    private PropertyChangeListener pListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CompareDissiPanel.this.updateMyUI();
        }
    };
    DisCompareFileStrings s = new DisCompareFileStrings();

    @Override
    public boolean isLoadSettings() {
        return true;
    }

    @Override
    public void closing() {
        this.deinit();
    }

    @Override
    public boolean isIcon() {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return false;
        }
        return frame.getInternalFrame(this).isIcon();
    }

    @Override
    public void setIcon(boolean b) {
        CSAMainFrame frame = Configuration.getConfiguration().getMainFrame();
        if (frame.getInternalFrame(this) == null) {
            return;
        }
        try {
            frame.getInternalFrame(this).setIcon(b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setParentWindow(CSAView jpv) {
        this.mParent = jpv;
    }

    @Override
    public void setMenuItem(JMenuItem item) {
        this.mParentMenuItem = item;
        this.mParentMenuItem.setText(SID);
    }

    @Override
    public JMenuItem getMenuItem() {
        return this.mParentMenuItem;
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    public void deinit() {
        if (this.watchLeft != null) {
            this.watchLeft.stopThread();
        }
        if (this.watchRight != null) {
            this.watchRight.stopThread();
        }
        this.watchLeft = null;
        this.watchRight = null;
        this.init = false;
        panels.remove(this);
        this.removeUIListerner();
    }

    public static void configChanged() {
        for (CompareDissiPanel p : panels) {
            p.setUpTableColumns();
        }
    }

    public void setUpTableColumns() {
        int i;
        ((MemoryInformationTableModelSmall)this.jTableSource.getModel()).initVisibity();
        while (this.jTableSource.getColumnCount() > 0) {
            this.jTableSource.getColumnModel().removeColumn(this.jTableSource.getColumnModel().getColumn(0));
        }
        for (i = 0; i < this.allColumns1.size(); ++i) {
            if (i >= this.model.columnVisible.length) {
                this.jTableSource.getColumnModel().addColumn(this.allColumns1.get(i));
                continue;
            }
            if (this.model.columnVisible[i] == null) {
                this.jTableSource.getColumnModel().addColumn(this.allColumns1.get(i));
                continue;
            }
            if (!this.model.columnVisible[i].booleanValue()) continue;
            if (i >= 13) {
                if (!this.config.doProfile || ((MemoryInformationTableModelSmall)this.jTableSource.getModel()).profiler == null) continue;
                this.jTableSource.getColumnModel().addColumn(this.allColumns1.get(i));
                continue;
            }
            this.jTableSource.getColumnModel().addColumn(this.allColumns1.get(i));
        }
        ((MemoryInformationTableModelSmall)this.jTableSource1.getModel()).initVisibity();
        while (this.jTableSource1.getColumnCount() > 0) {
            this.jTableSource1.getColumnModel().removeColumn(this.jTableSource1.getColumnModel().getColumn(0));
        }
        for (i = 0; i < this.allColumns2.size(); ++i) {
            if (i >= this.model1.columnVisible.length) {
                this.jTableSource1.getColumnModel().addColumn(this.allColumns2.get(i));
                continue;
            }
            if (this.model1.columnVisible[i] == null) {
                this.jTableSource1.getColumnModel().addColumn(this.allColumns2.get(i));
                continue;
            }
            if (!this.model1.columnVisible[i].booleanValue()) continue;
            if (i >= 13) {
                if (!this.config.doProfile || ((MemoryInformationTableModelSmall)this.jTableSource1.getModel()).profiler == null) continue;
                this.jTableSource1.getColumnModel().addColumn(this.allColumns2.get(i));
                continue;
            }
            this.jTableSource1.getColumnModel().addColumn(this.allColumns2.get(i));
        }
    }

    public CompareDissiPanel() {
        this.initComponents();
        panels.add(this);
        this.initTable();
        this.jLabel3.setVisible(false);
        this.setupKeyEvents();
        UIManager.addPropertyChangeListener(this.pListener);
        this.updateMyUI();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemCode = new JMenuItem();
        this.jMenuItemByte = new JMenuItem();
        this.jMenuItemWord = new JMenuItem();
        this.jMenuItemChar = new JMenuItem();
        this.jMenuItemUngroup = new JMenuItem();
        this.jMenuItemJoin = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItemC9 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItemRemove = new JMenuItem();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jButtonSearchNext = new JButton();
        this.jTextFieldSearch = new JTextField();
        this.jLabel2 = new JLabel();
        this.jButtonSearchPrevious = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jCheckBoxSourceMode = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jTextFieldTileFile = new JTextField();
        this.jButtonFileSelect1 = new JButton();
        this.jTextFieldTileFile1 = new JTextField();
        this.jButtonFileSelect2 = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTableSource = this.buildTable();
        this.jScrollPane4 = new JScrollPane();
        this.jTableSource1 = this.buildTable();
        this.jPanel3 = new JPanel();
        this.jTextFieldCurrentDifAdr = new JTextField();
        this.jLabel1 = new JLabel();
        this.jButtonDifNext = new JButton();
        this.jButtonDifPrevious = new JButton();
        this.jLabelDifsFound = new JLabel();
        this.jCheckBoxSync = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jPopupMenu1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                CompareDissiPanel.this.jPopupMenu1MouseExited(evt);
            }
        });
        this.jMenuItemCode.setText("cast to code");
        this.jMenuItemCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItemCodeActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemCode);
        this.jMenuItemByte.setText("cast to byte");
        this.jMenuItemByte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItemByteActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemByte);
        this.jMenuItemWord.setText("cast to word");
        this.jMenuItemWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItemWordActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemWord);
        this.jMenuItemChar.setText("cast to char");
        this.jMenuItemChar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItemCharActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemChar);
        this.jMenuItemUngroup.setText("ungroup");
        this.jMenuItemUngroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItemUngroupActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemUngroup);
        this.jMenuItemJoin.setText("join (same data types)");
        this.jMenuItemJoin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItemJoinActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemJoin);
        this.jMenu1.setText("join #");
        this.jMenuItem1.setText("2");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("3");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setText("4");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuItem4.setText("5");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem4);
        this.jMenuItem5.setText("6");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jPopupMenu1.add(this.jMenu1);
        this.jMenu2.setText("DP");
        this.jMenuItem6.setText("$C8");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem6);
        this.jMenuItemC9.setText("$C9");
        this.jMenuItemC9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItemC9ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItemC9);
        this.jMenuItem7.setText("$D0");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem7);
        this.jPopupMenu1.add(this.jMenu2);
        this.jMenuItemRemove.setText("remove");
        this.jMenuItemRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jMenuItemRemoveActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemRemove);
        this.setName("dissy");
        this.jCheckBox2.setSelected(true);
        this.jCheckBox2.setText("only full instructions");
        this.jCheckBox2.setToolTipText("Memory locations that \"belong\" to other mnemonics are not shown.");
        this.jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jCheckBox2ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("no unkown");
        this.jCheckBox1.setToolTipText("<html>Don't show locations that are \"unkown\" (not read from file), this <b>allways</b> includes RAM!<BR>(Since disassembled data is static)</html>\n");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonSearchNext.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_next.png")));
        this.jButtonSearchNext.setToolTipText("search forward");
        this.jButtonSearchNext.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSearchNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jButtonSearchNextActionPerformed(evt);
            }
        });
        this.jTextFieldSearch.setToolTipText("searches in labels and in comments (case independent)");
        this.jTextFieldSearch.setPreferredSize(new Dimension(200, 20));
        this.jTextFieldSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jTextFieldSearchActionPerformed(evt);
            }
        });
        this.jLabel2.setText("search:");
        this.jButtonSearchPrevious.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_previous.png")));
        this.jButtonSearchPrevious.setToolTipText("search backwards");
        this.jButtonSearchPrevious.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonSearchPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jButtonSearchPreviousActionPerformed(evt);
            }
        });
        this.jLabel3.setForeground(new Color(255, 51, 51));
        this.jLabel3.setText("not found");
        this.jLabel3.setPreferredSize(new Dimension(47, 21));
        this.jTextField1.setFont(new Font("Courier New", 1, 11));
        this.jTextField1.setText("$0000");
        this.jTextField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CompareDissiPanel.this.jTextField1FocusLost(evt);
            }
        });
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("start:");
        this.jLabel6.setHorizontalAlignment(11);
        this.jLabel6.setText("end:");
        this.jTextField2.setFont(new Font("Courier New", 1, 11));
        this.jTextField2.setText("$ffff");
        this.jTextField2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CompareDissiPanel.this.jTextField2FocusLost(evt);
            }
        });
        this.jTextField2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jTextField2ActionPerformed(evt);
            }
        });
        this.jTextField3.setEditable(false);
        this.jTextField3.setHorizontalAlignment(11);
        this.jLabel7.setHorizontalAlignment(11);
        this.jLabel7.setText("CRC32-A:");
        this.jLabel8.setHorizontalAlignment(11);
        this.jLabel8.setText("CRC32-B:");
        this.jTextField4.setEditable(false);
        this.jTextField4.setHorizontalAlignment(11);
        this.jCheckBoxSourceMode.setText("source mode");
        this.jCheckBoxSourceMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jCheckBoxSourceModeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSearch, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearchPrevious).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearchNext).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel4).addGap(3, 3, 3).addComponent(this.jTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addGap(2, 2, 2).addComponent(this.jTextField2, -2, -1, -2).addGap(29, 29, 29).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField3, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField4, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSourceMode).addContainerGap(65, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField4, -2, 21, -2).addComponent(this.jLabel8, -2, 21, -2).addComponent(this.jCheckBoxSourceMode)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField2, -2, 21, -2).addComponent(this.jLabel6, -2, 21, -2).addComponent(this.jTextField3, -2, 21, -2).addComponent(this.jLabel7, -2, 21, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField1, -2, 21, -2).addComponent(this.jLabel4, -2, 21, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSearchNext, GroupLayout.Alignment.TRAILING, -2, 21, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSearch, -2, 21, -2).addComponent(this.jLabel2, -2, 21, -2)))).addComponent(this.jButtonSearchPrevious, -2, 21, -2))));
        this.jLabel5.setText("Bin File");
        this.jTextFieldTileFile.setText("/Users/chrissalo/NetBeansProjects/Veccy/codelib/CompleteReleases/Ville Krumlinde/thrust.org/thrust.bin");
        this.jTextFieldTileFile.setPreferredSize(new Dimension(300, 21));
        this.jTextFieldTileFile.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CompareDissiPanel.this.jTextFieldTileFileFocusLost(evt);
            }
        });
        this.jTextFieldTileFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jTextFieldTileFileActionPerformed(evt);
            }
        });
        this.jButtonFileSelect1.setText("...");
        this.jButtonFileSelect1.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jButtonFileSelect1ActionPerformed(evt);
            }
        });
        this.jTextFieldTileFile1.setText("/Users/chrissalo/NetBeansProjects/Veccy/codelib/CompleteReleases/Ville Krumlinde/Thrust.bin");
        this.jTextFieldTileFile1.setPreferredSize(new Dimension(300, 21));
        this.jTextFieldTileFile1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                CompareDissiPanel.this.jTextFieldTileFile1FocusLost(evt);
            }
        });
        this.jTextFieldTileFile1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jTextFieldTileFile1ActionPerformed(evt);
            }
        });
        this.jButtonFileSelect2.setText("...");
        this.jButtonFileSelect2.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonFileSelect2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jButtonFileSelect2ActionPerformed(evt);
            }
        });
        this.jTableSource.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableSource.setShowHorizontalLines(false);
        this.jTableSource.setShowVerticalLines(false);
        this.jTableSource.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CompareDissiPanel.this.jTableSourceMousePressed(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableSource);
        this.jTableSource1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableSource1.setShowHorizontalLines(false);
        this.jTableSource1.setShowVerticalLines(false);
        this.jTableSource1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                CompareDissiPanel.this.jTableSource1MousePressed(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTableSource1);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jScrollPane2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 405, Short.MAX_VALUE).addComponent(this.jScrollPane4, -2, 0, Short.MAX_VALUE));
        this.jPanel3.setPreferredSize(new Dimension(25, 26));
        this.jTextFieldCurrentDifAdr.setEditable(false);
        this.jTextFieldCurrentDifAdr.setText("-");
        this.jTextFieldCurrentDifAdr.setToolTipText("address of difference");
        this.jTextFieldCurrentDifAdr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jTextFieldCurrentDifAdrActionPerformed(evt);
            }
        });
        this.jLabel1.setText("current dif:");
        this.jLabel1.setToolTipText("address of difference");
        this.jButtonDifNext.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_next.png")));
        this.jButtonDifNext.setToolTipText("next dif");
        this.jButtonDifNext.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDifNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jButtonDifNextActionPerformed(evt);
            }
        });
        this.jButtonDifPrevious.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/resultset_previous.png")));
        this.jButtonDifPrevious.setToolTipText("previous dif");
        this.jButtonDifPrevious.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonDifPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jButtonDifPreviousActionPerformed(evt);
            }
        });
        this.jLabelDifsFound.setText("difs found:");
        this.jCheckBoxSync.setSelected(true);
        this.jCheckBoxSync.setText("sync scroll");
        this.jCheckBoxSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompareDissiPanel.this.jCheckBoxSyncActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCurrentDifAdr, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDifPrevious).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDifNext).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelDifsFound, -2, 178, -2).addGap(18, 18, 18).addComponent(this.jCheckBoxSync, -2, 114, -2).addContainerGap(408, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jTextFieldCurrentDifAdr, -2, -1, -2)).addGroup(jPanel3Layout.createSequentialGroup().addGap(1, 1, 1).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonDifNext, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDifPrevious, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDifsFound, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxSync))))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jLabel9.setHorizontalAlignment(11);
        this.jLabel9.setText(" ");
        this.jLabel10.setText(" ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldTileFile, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect1).addGap(27, 27, 27).addComponent(this.jTextFieldTileFile1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFileSelect2).addGap(5, 5, 5).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox2).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jPanel3, -1, 1024, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel10, -2, 76, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel9, -2, 76, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox1).addComponent(this.jCheckBox2).addComponent(this.jTextFieldTileFile, -2, 21, -2).addComponent(this.jButtonFileSelect1).addComponent(this.jLabel5, -2, 21, -2).addComponent(this.jTextFieldTileFile1, -2, 21, -2).addComponent(this.jButtonFileSelect2)).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel10)).addGap(0, 0, 0).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -2, -1, -2)));
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.correctModel();
    }

    private void jCheckBox2ActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            this.model.setFullDisplay(!this.jCheckBox2.isSelected());
        }
        if (this.model1 != null) {
            this.model1.setFullDisplay(!this.jCheckBox2.isSelected());
        }
        this.correctModel();
    }

    private void jTableSourceMousePressed(MouseEvent evt) {
        this.popupSource = this.jTableSource;
        if (evt.getButton() == 3) {
            this.jPopupMenu1.show(this.jTableSource, evt.getX() - 20, evt.getY() - 20);
        }
        if (evt.getClickCount() == 2) {
            JTable table = (JTable)evt.getSource();
            Point p = evt.getPoint();
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            if (col == 8) {
                MemoryInformation memInfo = this.model.getValueAt(row);
                boolean bit8 = false;
                String adr = (String)this.model.getValueAt(row, col);
                if (adr.trim().length() < 1) {
                    return;
                }
                if (adr.trim().length() < 4) {
                    bit8 = true;
                }
                int a = DASM6809.toNumber(adr);
                int current = memInfo.address;
                if (bit8) {
                    a += current;
                }
                this.goAddress(a, true, true, true);
            }
        }
    }

    int getTopRow() {
        JViewport viewport = this.jScrollPane2.getViewport();
        Point p = viewport.getViewPosition();
        return this.jTableSource.rowAtPoint(p);
    }

    private void jPopupMenu1MouseExited(MouseEvent evt) {
        this.jPopupMenu1.setVisible(false);
    }

    private void jMenuItemByteActionPerformed(ActionEvent evt) {
        this.updateToNewType(this.popupSource, 1, 1);
    }

    private void jMenuItemCodeActionPerformed(ActionEvent evt) {
        this.updateToNewType(this.popupSource, 15, 1);
    }

    private void jMenuItemCharActionPerformed(ActionEvent evt) {
        this.updateToNewType(this.popupSource, 4, 1);
    }

    private void jMenuItemWordActionPerformed(ActionEvent evt) {
        this.updateToNewType(this.popupSource, 2, 2);
    }

    private void jMenuItemUngroupActionPerformed(ActionEvent evt) {
        this.joinData(this.popupSource, 1);
    }

    private void jMenuItemJoinActionPerformed(ActionEvent evt) {
        JTable table = this.popupSource;
        int[] selected = table.getSelectedRows();
        MemoryInformationTableModelSmall model = (MemoryInformationTableModelSmall)table.getModel();
        int max = 0;
        for (int row : selected) {
            MemoryInformation memInfo = model.getValueAt(row);
            int len = memInfo.length;
            for (int a = memInfo.address; a < memInfo.address + len; ++a) {
                ++max;
            }
        }
        this.joinData(table, max);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.joinData(this.popupSource, 2);
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.joinData(this.popupSource, 3);
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.joinData(this.popupSource, 4);
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.joinData(this.popupSource, 5);
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        this.joinData(this.popupSource, 6);
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        this.updateToNewDP(this.popupSource, 200);
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        this.updateToNewDP(this.popupSource, 208);
    }

    private void jMenuItemC9ActionPerformed(ActionEvent evt) {
        this.updateToNewDP(this.popupSource, 201);
    }

    private void jTextFieldSearchActionPerformed(ActionEvent evt) {
        this.jButtonSearchNextActionPerformed(null);
    }

    private void jButtonSearchPreviousActionPerformed(ActionEvent evt) {
        int adr;
        int row;
        this.jLabel3.setVisible(false);
        int searchStart = 0;
        String text = this.jTextFieldSearch.getText();
        if (text.trim().length() == 0) {
            return;
        }
        int[] selected = this.jTableSource.getSelectedRows();
        MemoryInformationTableModelSmall model = (MemoryInformationTableModelSmall)this.jTableSource.getModel();
        if (selected.length != 0) {
            searchStart = model.getValueAt((int)selected[0]).address - 1;
        }
        if (searchStart <= 0) {
            searchStart = 65535;
        }
        if ((row = model.getNearestVisibleRow(adr = this.searchForString(searchStart, text, false))) == -1) {
            return;
        }
        this.goRow(row, true);
    }

    private void jButtonSearchNextActionPerformed(ActionEvent evt) {
        int adr;
        int row;
        this.jLabel3.setVisible(false);
        int searchStart = 0;
        String text = this.jTextFieldSearch.getText();
        if (text.trim().length() == 0) {
            return;
        }
        int[] selected = this.jTableSource.getSelectedRows();
        MemoryInformationTableModelSmall model = (MemoryInformationTableModelSmall)this.jTableSource.getModel();
        if (selected.length != 0) {
            searchStart = model.getValueAt((int)selected[0]).address + 1;
        }
        if (searchStart >= 65536) {
            searchStart = 0;
        }
        if ((row = model.getNearestVisibleRow(adr = this.searchForString(searchStart, text, true))) == -1) {
            return;
        }
        this.goRow(row, true);
    }

    public void commandHistoryNext() {
        if (this.commandHistoryPosition == -1) {
            return;
        }
        if (this.commandHistoryPosition == this.commandHistory.size() - 1) {
            this.commandHistoryPosition = -1;
            return;
        }
        ++this.commandHistoryPosition;
    }

    public void commandHistoryPrevious() {
        if (this.commandHistoryPosition == 0) {
            return;
        }
        if (this.commandHistory.size() == 0) {
            return;
        }
        if (this.commandHistoryPosition == -1) {
            this.commandHistoryPosition = this.commandHistory.size() - 1;
            return;
        }
        --this.commandHistoryPosition;
    }

    private void jTextFieldCurrentDifAdrActionPerformed(ActionEvent evt) {
        this.commandHistoryPosition = -1;
        this.commandHistory.add(this.jTextFieldCurrentDifAdr.getText());
        String command = this.jTextFieldCurrentDifAdr.getText();
    }

    private void jTextFieldTileFileFocusLost(FocusEvent evt) {
        this.jTextFieldTileFileActionPerformed(null);
    }

    private void jTextFieldTileFileActionPerformed(ActionEvent evt) {
        String file = this.jTextFieldTileFile.getText().trim();
        String _class = "";
        String text = this.dis(this.jTextFieldTileFile.getText(), UtilityString.Int0(this.jTextFieldTileFile.getText()), false);
        this.correctModel();
        this.calcCRC();
    }

    private void jButtonFileSelect1ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (!this.config.useLastKnownDir || this.lastDir1 == null || this.lastDir1.length() == 0) {
            fc.setCurrentDirectory(new File(this.config.fileRequestHome));
        } else {
            fc.setCurrentDirectory(new File(this.lastDir1));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Binaries", "bin", "vec");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        String name = fc.getSelectedFile().getAbsolutePath();
        this.lastDir1 = fc.getCurrentDirectory().toString();
        this.jTextFieldTileFile.setText(name);
        this.jTextFieldCurrentDifAdr.setText("-");
        this.jTextFieldTileFileActionPerformed(null);
    }

    private void jTextFieldTileFile1ActionPerformed(ActionEvent evt) {
        String file = this.jTextFieldTileFile1.getText().trim();
        String _class = "";
        String text = this.dis(this.jTextFieldTileFile1.getText(), UtilityString.Int0(this.jTextFieldTileFile1.getText()), true);
        this.correctModel();
        this.calcCRC();
    }

    private void jButtonFileSelect2ActionPerformed(ActionEvent evt) {
        InternalFrameFileChoser fc = new InternalFrameFileChoser();
        if (!this.config.useLastKnownDir || this.lastDir2 == null || this.lastDir2.length() == 0) {
            fc.setCurrentDirectory(new File(this.config.fileRequestHome));
        } else {
            fc.setCurrentDirectory(new File(this.lastDir2));
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Binaries", "bin", "vec");
        fc.setFileFilter(filter);
        int r = fc.showOpenDialog(Configuration.getConfiguration().getMainFrame());
        if (r != 0) {
            return;
        }
        String name = fc.getSelectedFile().getAbsolutePath();
        this.lastDir2 = fc.getCurrentDirectory().toString();
        this.jTextFieldTileFile1.setText(name);
        this.jTextFieldCurrentDifAdr.setText("-");
        this.jTextFieldTileFile1ActionPerformed(null);
    }

    private void jTableSource1MousePressed(MouseEvent evt) {
        this.popupSource = this.jTableSource1;
        if (evt.getButton() == 3) {
            this.jPopupMenu1.show(this.jTableSource1, evt.getX() - 20, evt.getY() - 20);
        }
        if (evt.getClickCount() == 2) {
            JTable table = (JTable)evt.getSource();
            Point p = evt.getPoint();
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            if (col == 8) {
                MemoryInformation memInfo = this.model.getValueAt(row);
                boolean bit8 = false;
                String adr = (String)this.model.getValueAt(row, col);
                if (adr.trim().length() < 1) {
                    return;
                }
                if (adr.trim().length() < 4) {
                    bit8 = true;
                }
                int a = DASM6809.toNumber(adr);
                int current = memInfo.address;
                if (bit8) {
                    a += current;
                }
                this.goAddress(a, true, true, true);
            }
        }
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.calcCRC();
    }

    private void jTextField1FocusLost(FocusEvent evt) {
        this.calcCRC();
    }

    private void jTextField2ActionPerformed(ActionEvent evt) {
        this.calcCRC();
    }

    private void jTextField2FocusLost(FocusEvent evt) {
        this.calcCRC();
    }

    private void jMenuItemRemoveActionPerformed(ActionEvent evt) {
        JTable table = this.popupSource;
        int[] selected = table.getSelectedRows();
        MemoryInformationTableModelSmall model = (MemoryInformationTableModelSmall)table.getModel();
        for (int row : selected) {
            MemoryInformation memInfo = model.getValueAt(row);
            int len = memInfo.length;
            for (int a = memInfo.address; a < memInfo.address + len; ++a) {
                this.dasm.myMemory.memMap.get((Object)Integer.valueOf((int)a)).visible = false;
                this.dasm1.myMemory.memMap.get((Object)Integer.valueOf((int)a)).visible = false;
            }
        }
        this.correctModel();
    }

    private void jCheckBoxSourceModeActionPerformed(ActionEvent evt) {
        this.activeDif = -1;
        this.correctModel();
    }

    private void jButtonDifPreviousActionPerformed(ActionEvent evt) {
        this.setPrevDif();
    }

    private void jButtonDifNextActionPerformed(ActionEvent evt) {
        this.setNextDif();
    }

    private void jCheckBoxSyncActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxSync.isSelected()) {
            this.jScrollPane4.getVerticalScrollBar().setModel(this.sBar1Model);
        } else {
            this.jScrollPane4.getVerticalScrollBar().setModel(this.sBar2Model);
        }
    }

    private void jTextFieldTileFile1FocusLost(FocusEvent evt) {
        this.jTextFieldTileFile1ActionPerformed(null);
    }

    void spaceTo(StringBuilder s, int posNow, int upTo) {
        while (posNow++ < upTo) {
            s.append(" ");
        }
    }

    private int searchForString(int start, String text, boolean forward) {
        int foundAt = -1;
        int addi = forward ? 1 : -1;
        for (int i = start; (i & 0xFFFF) != 0 || i == start; i += addi) {
            MemoryInformation memInfo = this.dasm.myMemory.memMap.get(i);
            for (String l : memInfo.labels) {
                if (l.toLowerCase().indexOf(text.toLowerCase()) < 0) continue;
                foundAt = i;
                this.jLabel3.setVisible(true);
                this.jLabel3.setForeground(this.config.valueNotChanged);
                this.jLabel3.setText("Found in label at: " + String.format("$%04X", i & 0xFFFF));
                break;
            }
            if (foundAt != -1) break;
            for (String c : memInfo.comments) {
                if (c.toLowerCase().indexOf(text.toLowerCase()) < 0) continue;
                foundAt = i;
                this.jLabel3.setVisible(true);
                this.jLabel3.setForeground(this.config.valueNotChanged);
                this.jLabel3.setText("Found in comment at: " + String.format("$%04X", i & 0xFFFF));
                break;
            }
            if (foundAt != -1) break;
        }
        if (foundAt == -1) {
            this.jLabel3.setVisible(true);
            this.jLabel3.setForeground(this.config.valueChanged);
            this.jLabel3.setText("not found");
        }
        return foundAt;
    }

    void updateToNewDP(JTable table, int dp) {
        int[] selected = table.getSelectedRows();
        MemoryInformationTableModelSmall model = (MemoryInformationTableModelSmall)table.getModel();
        DASM6809 da = table == this.jTableSource ? this.dasm : this.dasm1;
        boolean max = false;
        for (int row : selected) {
            MemoryInformation memInfo = model.getValueAt(row);
            int len = memInfo.length;
            for (int a = memInfo.address; a < memInfo.address + len; ++a) {
                if (da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disType < 6) continue;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).directPageAddress = dp;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disType = 15;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).belongsToInstruction = null;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disassembledMnemonic = "";
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disassembledOperand = "";
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).page = -1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).hexDump = "";
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).isInstructionByte = 0;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).referingToAddress = -1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).referingAddressMode = -1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).length = 1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).done = false;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).familyBytes.clear();
            }
        }
        this.dasm.reDisassemble(true);
        this.updateTable();
    }

    void updateToNewType(JTable table, int type, int l) {
        int[] selected = table.getSelectedRows();
        MemoryInformationTableModelSmall model = (MemoryInformationTableModelSmall)table.getModel();
        DASM6809 da = table == this.jTableSource ? this.dasm : this.dasm1;
        for (int row : selected) {
            MemoryInformation memInfo = model.getValueAt(row);
            int len = memInfo.length;
            for (int a = memInfo.address; a < memInfo.address + len; ++a) {
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disType = type;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).belongsToInstruction = null;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disassembledMnemonic = "";
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disassembledOperand = "";
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).page = -1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).hexDump = "";
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).isInstructionByte = 0;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).referingToAddress = -1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).referingAddressMode = -1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).length = l;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).done = false;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).familyBytes.clear();
            }
        }
        da.reDisassemble(true);
        this.updateTable();
    }

    private void joinData(JTable table, int ll) {
        int[] selected = table.getSelectedRows();
        MemoryInformationTableModelSmall model = (MemoryInformationTableModelSmall)table.getModel();
        DASM6809 da = table == this.jTableSource ? this.dasm : this.dasm1;
        for (int row : selected) {
            MemoryInformation memInfo = model.getValueAt(row);
            int len = memInfo.length;
            for (int a = memInfo.address; a < memInfo.address + len; ++a) {
                if (da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disType >= 6) continue;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disTypeCollectionMax = ll;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disassembledMnemonic = "";
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).disassembledOperand = "";
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).page = -1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).hexDump = "";
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).isInstructionByte = 0;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).referingToAddress = -1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).referingAddressMode = -1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).length = 1;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).done = false;
                da.myMemory.memMap.get((Object)Integer.valueOf((int)a)).familyBytes.clear();
            }
        }
        da.reDisassemble(true);
        this.updateTable();
    }

    private void updateTable() {
        JViewport vp = (JViewport)this.jTableSource.getParent();
        Point pos = vp.getViewPosition();
        JViewport vp1 = (JViewport)this.jTableSource1.getParent();
        Point pos1 = vp1.getViewPosition();
        this.correctModel();
        vp.setViewPosition(pos);
        vp1.setViewPosition(pos1);
    }

    void doOnChange(boolean useSecondtable) {
        if (useSecondtable) {
            int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The file in table 2 changed - do you want to reload?", "COMPARE DISSI: File change...", 2, 2, null, null, null);
            if (answer == 0) {
                this.jTextFieldTileFile1ActionPerformed(null);
            }
        } else {
            int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The file in table 1 changed - do you want to reload?", "COMPARE DISSI: File change...", 2, 2, null, null, null);
            if (answer == 0) {
                this.jTextFieldTileFileActionPerformed(null);
            }
        }
    }

    void doOnDelete(boolean useSecondtable) {
        if (useSecondtable) {
            int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The file in table 2 was deleted - do you want to remove it?", "COMPARE DISSI: File delete...", 2, 2, null, null, null);
            if (answer == 0) {
                this.jTextFieldTileFile1ActionPerformed(null);
            }
        } else {
            int answer = JOptionPane.showOptionDialog(Configuration.getConfiguration().getMainFrame(), "The file in table 1 was deleted - do you want to remove it?", "COMPARE DISSI: File delete...", 2, 2, null, null, null);
            if (answer == 0) {
                this.jTextFieldTileFileActionPerformed(null);
            }
        }
    }

    public String dis(String name, int startAddress, boolean useSecondtable) {
        if (!useSecondtable) {
            if (this.watchLeft != null) {
                this.watchLeft.stopThread();
                this.watchLeft = null;
            }
            this.init = false;
            this.dasm.reset();
            this.loadedName = name;
            Path path = Paths.get(name, new String[0]);
            this.dasm.tryLoadList(name, 0);
            this.dasm.tryLoadCNT(name);
            this.dasm.setCreateLabels(this.createUnkownLabels);
            String ret = "";
            try {
                byte[] data2 = Files.readAllBytes(path);
                ret = this.dasm.disassemble(data2, startAddress, startAddress, this.assumeVectrex);
                this.jLabel10.setForeground(this.jLabel1.getForeground());
                this.jLabel10.setText("loaded");
                this.watchLeft = new FileWatcher(new File(name), useSecondtable, this);
                this.watchLeft.start();
            }
            catch (Throwable e) {
                this.jLabel10.setForeground(Color.RED);
                this.jLabel10.setText("not loaded!");
            }
            this.correctModel();
            this.init = true;
            return ret;
        }
        if (this.watchRight != null) {
            this.watchRight.stopThread();
            this.watchRight = null;
        }
        this.init1 = false;
        this.dasm1.reset();
        this.loadedName1 = name;
        Path path = null;
        try {
            path = Paths.get(name, new String[0]);
        }
        catch (Throwable ret) {
            // empty catch block
        }
        String ret = "";
        if (path != null) {
            this.dasm1.tryLoadList(name, 0);
            this.dasm1.tryLoadCNT(name);
            this.dasm1.setCreateLabels(this.createUnkownLabels);
            try {
                byte[] data3 = Files.readAllBytes(path);
                ret = this.dasm1.disassemble(data3, startAddress, startAddress, this.assumeVectrex);
                this.jLabel9.setForeground(this.jLabel1.getForeground());
                this.jLabel9.setText("loaded");
                this.watchRight = new FileWatcher(new File(name), useSecondtable, this);
                this.watchRight.start();
            }
            catch (Throwable e) {
                this.jLabel9.setForeground(Color.RED);
                this.jLabel9.setText("not loaded!");
            }
        }
        this.correctModel();
        this.init = true;
        return ret;
    }

    public boolean isInit() {
        return this.init;
    }

    private void buildDifs() {
        this.activeDif = -1;
        this.allDifCount = 0;
        this.byteDifs = new ArrayList();
        if (this.model == null) {
            return;
        }
        if (this.model1 == null) {
            return;
        }
        Memory data1 = this.model.getOrgData();
        Memory data2 = this.model1.getOrgData();
        for (int i = 0; i < 65536; ++i) {
            MemoryInformation memInfo1 = data1.memMap.get(i);
            MemoryInformation memInfo2 = data2.memMap.get(i);
            if (memInfo1.content == memInfo2.content) continue;
            this.byteDifs.add(i);
        }
        if (this.jCheckBoxSourceMode.isSelected()) {
            int difCount = 0;
            for (int aa = 0; aa < this.model.getRowCount(); ++aa) {
                boolean isDif;
                MemoryInformation memInfo = this.model.getValueAt(aa);
                String cmp1 = "";
                String cmp2 = "";
                if (aa < this.model1.getRowCount()) {
                    cmp1 = this.model1.getValueAt(aa, 2).toString();
                }
                if (aa < this.model.getRowCount()) {
                    cmp2 = this.model.getValueAt(aa, 2).toString();
                }
                String cmp3 = "";
                int arow = this.model1.getRowForAddress(memInfo.address);
                if (arow != -1) {
                    cmp3 = this.model1.getValueAt(arow, 2).toString();
                }
                boolean bl = isDif = !cmp2.equals(cmp3);
                if (!isDif) continue;
                ++difCount;
            }
            this.jLabelDifsFound.setText("difs found: " + difCount);
            this.allDifCount = difCount;
        } else {
            this.jLabelDifsFound.setText("difs found: " + this.byteDifs.size());
            this.allDifCount = this.byteDifs.size();
        }
    }

    int getColumnNameIndex1(String n) {
        for (int i = 0; i < this.model.columnNamesSmall.length; ++i) {
            if (!n.equals(this.model.columnNamesSmall[i])) continue;
            return i;
        }
        return -1;
    }

    int getColumnNameIndex2(String n) {
        for (int i = 0; i < this.model1.columnNamesSmall.length; ++i) {
            if (!n.equals(this.model1.columnNamesSmall[i])) continue;
            return i;
        }
        return -1;
    }

    public void correctModel() {
        int ci;
        String n;
        int colData;
        int i;
        this.jTextFieldCurrentDifAdr.setText("-");
        this.buildDifs();
        if (this.model != null) {
            this.model.showAll();
            if (this.jCheckBox1.isSelected()) {
                this.model.reduceUnkown();
            }
            if (this.jCheckBox2.isSelected()) {
                this.model.reduceCompleteInstructions();
            }
            this.model.reduceInvisible();
            this.jTableSource.tableChanged(null);
        }
        if (this.model1 != null) {
            this.model1.showAll();
            if (this.jCheckBox1.isSelected()) {
                this.model1.reduceUnkown();
            }
            if (this.jCheckBox2.isSelected()) {
                this.model1.reduceCompleteInstructions();
            }
            this.model1.reduceInvisible();
            this.jTableSource1.tableChanged(null);
        }
        this.setUpTableColumns();
        if (this.model != null) {
            this.jTableSource.setAutoResizeMode(3);
            for (i = 0; i < this.jTableSource.getColumnModel().getColumnCount(); ++i) {
                colData = i;
                n = this.jTableSource.getColumnModel().getColumn(i).getHeaderValue().toString();
                ci = this.getColumnNameIndex1(n);
                this.jTableSource.getColumnModel().getColumn(i).setPreferredWidth(this.model.getColWidth1(ci));
                this.jTableSource.getColumnModel().getColumn(i).setWidth(this.model.getColWidth1(ci));
            }
            this.jTableSource.setAutoResizeMode(2);
        }
        if (this.model1 != null) {
            this.jTableSource1.setAutoResizeMode(3);
            for (i = 0; i < this.jTableSource1.getColumnModel().getColumnCount(); ++i) {
                colData = i;
                n = this.jTableSource1.getColumnModel().getColumn(i).getHeaderValue().toString();
                ci = this.getColumnNameIndex2(n);
                this.jTableSource1.getColumnModel().getColumn(i).setPreferredWidth(this.model1.getColWidth2(ci));
                this.jTableSource1.getColumnModel().getColumn(i).setWidth(this.model1.getColWidth2(ci));
            }
            this.jTableSource1.setAutoResizeMode(2);
        }
    }

    public void updateTableOnly() {
        this.jTableSource.repaint();
        this.jTableSource1.repaint();
    }

    public void goRow(int row, boolean forceTopRow) {
        if (!this.init) {
            return;
        }
        this.jTableSource.setRowSelectionInterval(row, row);
        if (forceTopRow) {
            CompareDissiPanel.scrollToVisible(this.jTableSource, row, 0);
        }
        this.jTableSource.scrollRectToVisible(this.jTableSource.getCellRect(row, 0, true));
    }

    public void goAddress(int address, boolean forceTopRow, boolean userGo, boolean forceUpdate) {
        if (!this.init) {
            return;
        }
        if (!(forceUpdate || userGo || this.updateEnabled)) {
            return;
        }
        int row = this.model.getNearestVisibleRow(address);
        if (row == -1) {
            return;
        }
        this.jTableSource.setRowSelectionInterval(row, row);
        if (forceTopRow) {
            CompareDissiPanel.scrollToVisible(this.jTableSource, row, 0);
        }
        this.jTableSource.scrollRectToVisible(this.jTableSource.getCellRect(row, 0, true));
        if (!this.jCheckBoxSync.isSelected()) {
            row = this.model1.getNearestVisibleRow(address);
            if (row == -1) {
                return;
            }
            this.jTableSource1.setRowSelectionInterval(row, row);
            if (forceTopRow) {
                CompareDissiPanel.scrollToVisible(this.jTableSource1, row, 0);
            }
            this.jTableSource1.scrollRectToVisible(this.jTableSource1.getCellRect(row, 0, true));
        }
    }

    public static void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        JViewport vp = (JViewport)table.getParent();
        int bottomIndex = table.getModel().getRowCount() - 1;
        table.setRowSelectionInterval(bottomIndex, bottomIndex);
        table.changeSelection(bottomIndex, 0, false, false);
        Rectangle r = table.getCellRect(bottomIndex - 1, 0, true);
        int vph = vp.getExtentSize().height;
        r.y += vph;
        table.scrollRectToVisible(r);
        int currentSelectedRow = table.getSelectedRow();
        try {
            table.changeSelection(rowIndex, 0, false, false);
            if (rowIndex > currentSelectedRow) {
                r = table.getCellRect(rowIndex - 1, 0, true);
                vph = vp.getExtentSize().height;
                r.y += vph;
                table.scrollRectToVisible(r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getInstructionLengthAt(int address) {
        if (!this.init) {
            return 1;
        }
        return this.dasm.getInstructionLengthAt(address);
    }

    private void initTable() {
        int i;
        this.model = this.dasm.getTableModelSmall();
        this.jTableSource.setModel(this.model);
        this.jTableSource.tableChanged(null);
        this.jTableSource.setRowSelectionAllowed(true);
        this.jTableSource.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (table.getModel() instanceof MemoryInformationTableModelSmall) {
                    MemoryInformationTableModelSmall localModel = (MemoryInformationTableModelSmall)table.getModel();
                    MemoryInformationTableModelSmall otherModel = localModel.equals(CompareDissiPanel.this.model1) ? CompareDissiPanel.this.model : CompareDissiPanel.this.model1;
                    MemoryInformation memInfo = localModel.getValueAt(row);
                    boolean isDif = false;
                    if (!CompareDissiPanel.this.jCheckBoxSourceMode.isSelected()) {
                        int startAddress = DASM6809.toNumber(localModel.getValueAt(row, 0).toString());
                        int endAddress = startAddress + DASM6809.toNumber(localModel.getValueAt(row, 10).toString());
                        for (int aa = startAddress; aa < endAddress; ++aa) {
                            for (int dd = 0; dd < CompareDissiPanel.this.byteDifs.size(); ++dd) {
                                if (CompareDissiPanel.this.byteDifs.get(dd) != aa) continue;
                                isDif = true;
                            }
                        }
                    } else {
                        String cmp1 = "";
                        if (otherModel.getRowCount() > row) {
                            cmp1 = otherModel.getValueAt(row, 2).toString();
                        }
                        String cmp2 = "";
                        if (localModel.getRowCount() > row) {
                            cmp2 = localModel.getValueAt(row, 2).toString();
                        }
                        String cmp3 = "";
                        int arow = otherModel.getRowForAddress(memInfo.address);
                        if (arow != -1) {
                            cmp3 = otherModel.getValueAt(arow, 2).toString();
                        }
                        boolean bl = isDif = !cmp2.equals(cmp3);
                    }
                    if (isDif) {
                        this.setBackground(CompareDissiPanel.this.config.valueChanged);
                    } else if (isSelected) {
                        this.setBackground(table.getSelectionBackground());
                        this.setForeground(table.getSelectionForeground());
                    } else {
                        Color back = localModel.getBackground(row, col);
                        Color fore = localModel.getForeground(row, col);
                        if (back != null) {
                            this.setBackground(back);
                        } else {
                            this.setBackground(table.getBackground());
                        }
                        if (fore != null) {
                            this.setForeground(fore);
                        } else {
                            this.setForeground(table.getForeground());
                        }
                    }
                    if (col == 1) {
                        AttributeSet s = TokenStyles.getStyle("identifier");
                        this.setForeground(StyleConstants.getForeground(s));
                    }
                    if (col == 3) {
                        AttributeSet s = TokenStyles.getStyle("reservedWord");
                        AttributeSet _preprop = TokenStyles.getStyle("preprocessor");
                        String mnemonic = "";
                        if (value != null) {
                            mnemonic = value.toString().toLowerCase();
                        }
                        if (mnemonic.equals("db") || mnemonic.equals("dw")) {
                            this.setForeground(StyleConstants.getForeground(_preprop));
                        } else {
                            this.setForeground(StyleConstants.getForeground(s));
                        }
                    }
                }
                return this;
            }
        });
        if (this.allColumns1 == null) {
            this.allColumns1 = new ArrayList();
            for (i = 0; i < this.model.getColumnOrgCount(); ++i) {
                this.allColumns1.add(this.jTableSource.getColumnModel().getColumn(i));
            }
        }
        this.model.setSmallMode(true);
        this.model1 = this.dasm1.getTableModelSmall();
        this.jTableSource1.setModel(this.model1);
        this.jTableSource1.tableChanged(null);
        this.jTableSource1.setRowSelectionAllowed(true);
        this.jTableSource1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                if (table.getModel() instanceof MemoryInformationTableModelSmall) {
                    MemoryInformationTableModelSmall localModel = (MemoryInformationTableModelSmall)table.getModel();
                    MemoryInformationTableModelSmall otherModel = localModel.equals(CompareDissiPanel.this.model1) ? CompareDissiPanel.this.model : CompareDissiPanel.this.model1;
                    MemoryInformation memInfo = localModel.getValueAt(row);
                    boolean isDif = false;
                    if (!CompareDissiPanel.this.jCheckBoxSourceMode.isSelected()) {
                        int startAddress = DASM6809.toNumber(localModel.getValueAt(row, 0).toString());
                        int endAddress = startAddress + DASM6809.toNumber(localModel.getValueAt(row, 10).toString());
                        for (int aa = startAddress; aa < endAddress; ++aa) {
                            for (int dd = 0; dd < CompareDissiPanel.this.byteDifs.size(); ++dd) {
                                if (CompareDissiPanel.this.byteDifs.get(dd) != aa) continue;
                                isDif = true;
                            }
                        }
                    } else {
                        String cmp1 = "";
                        if (otherModel.getRowCount() > row) {
                            cmp1 = otherModel.getValueAt(row, 2).toString();
                        }
                        String cmp2 = "";
                        if (localModel.getRowCount() > row) {
                            cmp2 = localModel.getValueAt(row, 2).toString();
                        }
                        String cmp3 = "";
                        int arow = otherModel.getRowForAddress(memInfo.address);
                        if (arow != -1) {
                            cmp3 = otherModel.getValueAt(arow, 2).toString();
                        }
                        boolean bl = isDif = !cmp2.equals(cmp3);
                    }
                    if (isDif) {
                        this.setBackground(CompareDissiPanel.this.config.valueChanged);
                    } else if (isSelected) {
                        this.setBackground(table.getSelectionBackground());
                        this.setForeground(table.getSelectionForeground());
                    } else {
                        Color back = localModel.getBackground(row, col);
                        Color fore = localModel.getForeground(row, col);
                        if (back != null) {
                            this.setBackground(back);
                        } else {
                            this.setBackground(table.getBackground());
                        }
                        if (fore != null) {
                            this.setForeground(fore);
                        } else {
                            this.setForeground(table.getForeground());
                        }
                    }
                    if (col == 3) {
                        AttributeSet s = TokenStyles.getStyle("reservedWord");
                        AttributeSet _preprop = TokenStyles.getStyle("preprocessor");
                        String mnemonic = "";
                        if (value != null) {
                            mnemonic = value.toString().toLowerCase();
                        }
                        if (mnemonic.equals("db") || mnemonic.equals("dw")) {
                            this.setForeground(StyleConstants.getForeground(_preprop));
                        } else {
                            this.setForeground(StyleConstants.getForeground(s));
                        }
                    }
                    if (col == 1) {
                        AttributeSet s = TokenStyles.getStyle("identifier");
                        this.setForeground(StyleConstants.getForeground(s));
                    }
                }
                return this;
            }
        });
        if (this.allColumns2 == null) {
            this.allColumns2 = new ArrayList();
            for (i = 0; i < this.model1.getColumnOrgCount(); ++i) {
                this.allColumns2.add(this.jTableSource1.getColumnModel().getColumn(i));
            }
        }
        this.model1.setSmallMode(true);
        this.jTableSource.tableChanged(null);
        this.jTableSource1.tableChanged(null);
        CompareDissiPanel.configChanged();
        this.setUpTableColumns();
        this.sBar1Model = this.jScrollPane2.getVerticalScrollBar().getModel();
        this.sBar2Model = this.jScrollPane4.getVerticalScrollBar().getModel();
        this.jScrollPane4.getVerticalScrollBar().setModel(this.sBar1Model);
    }

    public int getCurrentAddress() {
        if (!this.init) {
            return -1;
        }
        int row = this.jTableSource.getSelectedRow();
        if (row == -1) {
            return -1;
        }
        MemoryInformationTableModelSmall model = (MemoryInformationTableModelSmall)this.jTableSource.getModel();
        MemoryInformation memInfo = model.getValueAt(row);
        return memInfo.address;
    }

    public MemoryInformation getMemoryInformation(int address) {
        return this.dasm.myMemory.memMap.get(address);
    }

    public Memory getMemory() {
        return this.dasm.myMemory;
    }

    @Override
    public String getID() {
        return SID;
    }

    @Override
    public String getFileID() {
        return UtilityString.replace(UtilityString.replaceWhiteSpaces(SID, ""), ":", "");
    }

    JTable buildTable() {
        JTable table = new JTable();
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        return table;
    }

    private void setupKeyEvents() {
        if (this.keyEventsAreSet) {
            return;
        }
        this.keyEventsAreSet = true;
        this.jTextFieldCurrentDifAdr.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0, false), "command next");
        this.jTextFieldCurrentDifAdr.getActionMap().put("command next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDissiPanel.this.commandHistoryNext();
            }
        });
        this.jTextFieldCurrentDifAdr.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0, false), "command previous");
        this.jTextFieldCurrentDifAdr.getActionMap().put("command previous", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDissiPanel.this.commandHistoryPrevious();
            }
        });
        new HotKey("dif next", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDissiPanel.this.jButtonDifNextActionPerformed(null);
            }
        }, this);
        new HotKey("dif previous", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareDissiPanel.this.jButtonDifPreviousActionPerformed(null);
            }
        }, this);
    }

    @Override
    public void updateValues(boolean forceUpdate) {
        if (!forceUpdate && !this.updateEnabled) {
            return;
        }
        this.updateTableOnly();
    }

    @Override
    public void setUpdateEnabled(boolean b) {
        this.updateEnabled = b;
    }

    int getLabelAddr(String label) {
        Memory mem = this.dasm.myMemory;
        for (int i = 0; i < 65536; ++i) {
            MemoryInformation memInfo = mem.memMap.get(i);
            for (String l : memInfo.labels) {
                if (!l.equals(label)) continue;
                return i;
            }
        }
        return 0;
    }

    public void printMessage(String s, String type) {
    }

    private void calcCRC() {
        int start = DASM6809.toNumber(this.jTextField1.getText());
        int end2 = DASM6809.toNumber(this.jTextField2.getText());
        this.jTextField3.setText("" + this.dasm.myMemory.getCRC(start, end2));
        this.jTextField4.setText("" + this.dasm1.myMemory.getCRC(start, end2));
    }

    public void removeUIListerner() {
        UIManager.removePropertyChangeListener(this.pListener);
    }

    void updateMyUI() {
        SwingUtilities.updateComponentTreeUI(this.jPopupMenu1);
        int fontSize = Theme.textFieldFont.getFont().getSize();
        int rowHeight = fontSize + 2;
        this.jTableSource.setRowHeight(rowHeight);
        this.jTableSource1.setRowHeight(rowHeight);
    }

    @Override
    public void deIconified() {
    }

    void setPrevDif() {
        if (this.allDifCount == 0) {
            int maxRow = 0;
            this.jTableSource.setRowSelectionInterval(maxRow, maxRow);
            this.jTableSource.scrollRectToVisible(this.jTableSource.getCellRect(maxRow, 0, true));
            this.jTextFieldCurrentDifAdr.setText("-");
            if (!this.jCheckBoxSync.isSelected()) {
                this.jTableSource1.setRowSelectionInterval(maxRow, maxRow);
                this.jTableSource1.scrollRectToVisible(this.jTableSource1.getCellRect(maxRow, 0, true));
            }
            return;
        }
        int address = -1;
        if (this.activeDif <= 0) {
            this.activeDif = -1;
            int maxRow = 0;
            this.jTableSource.setRowSelectionInterval(maxRow, maxRow);
            this.jTableSource.scrollRectToVisible(this.jTableSource.getCellRect(maxRow, 0, true));
            if (!this.jCheckBoxSync.isSelected()) {
                this.jTableSource1.setRowSelectionInterval(maxRow, maxRow);
                this.jTableSource1.scrollRectToVisible(this.jTableSource1.getCellRect(maxRow, 0, true));
            }
            this.jTextFieldCurrentDifAdr.setText("-");
            return;
        }
        --this.activeDif;
        if (this.jCheckBoxSourceMode.isSelected()) {
            int difCount = 0;
            for (int aa = 0; aa < this.model.getRowCount(); ++aa) {
                boolean isDif;
                MemoryInformation memInfo = this.model.getValueAt(aa);
                String cmp1 = "";
                String cmp2 = "";
                if (aa < this.model1.getRowCount()) {
                    cmp1 = this.model1.getValueAt(aa, 2).toString();
                }
                if (aa < this.model.getRowCount()) {
                    cmp2 = this.model.getValueAt(aa, 2).toString();
                }
                String cmp3 = "";
                int arow = this.model1.getRowForAddress(memInfo.address);
                if (arow != -1) {
                    cmp3 = this.model1.getValueAt(arow, 2).toString();
                }
                boolean bl = isDif = !cmp2.equals(cmp3);
                if (!isDif) continue;
                if (difCount == this.activeDif) {
                    address = memInfo.address;
                    break;
                }
                ++difCount;
            }
        } else if (this.activeDif >= 0) {
            address = this.byteDifs.get(this.activeDif);
        }
        if (address != -1) {
            this.goAddress(address, false, true, true);
            this.jTextFieldCurrentDifAdr.setText("" + (this.activeDif + 1) + ": " + String.format("$%04X", address & 0xFFFF));
        } else {
            this.jTextFieldCurrentDifAdr.setText("-");
        }
    }

    void setNextDif() {
        if (this.allDifCount == 0) {
            int maxRow = this.model.getRowCount() - 1;
            this.jTableSource.setRowSelectionInterval(maxRow, maxRow);
            this.jTableSource.scrollRectToVisible(this.jTableSource.getCellRect(maxRow, 0, true));
            if (!this.jCheckBoxSync.isSelected()) {
                maxRow = this.model1.getRowCount() - 1;
                this.jTableSource1.setRowSelectionInterval(maxRow, maxRow);
                this.jTableSource1.scrollRectToVisible(this.jTableSource1.getCellRect(maxRow, 0, true));
            }
            return;
        }
        int address = -1;
        ++this.activeDif;
        if (this.jCheckBoxSourceMode.isSelected()) {
            int difCount = 0;
            for (int aa = 0; aa < this.model.getRowCount(); ++aa) {
                boolean isDif;
                MemoryInformation memInfo = this.model.getValueAt(aa);
                String cmp1 = "";
                String cmp2 = "";
                if (aa < this.model1.getRowCount()) {
                    cmp1 = this.model1.getValueAt(aa, 2).toString();
                }
                if (aa < this.model.getRowCount()) {
                    cmp2 = this.model.getValueAt(aa, 2).toString();
                }
                String cmp3 = "";
                int arow = this.model1.getRowForAddress(memInfo.address);
                if (arow != -1) {
                    cmp3 = this.model1.getValueAt(arow, 2).toString();
                }
                boolean bl = isDif = !cmp2.equals(cmp3);
                if (!isDif) continue;
                if (difCount == this.activeDif) {
                    address = memInfo.address;
                    break;
                }
                ++difCount;
            }
        } else {
            if (this.activeDif >= this.byteDifs.size()) {
                while (this.activeDif >= this.byteDifs.size()) {
                    --this.activeDif;
                }
                ++this.activeDif;
                int maxRow = this.model.getRowCount() - 1;
                this.jTableSource.setRowSelectionInterval(maxRow, maxRow);
                this.jTableSource.scrollRectToVisible(this.jTableSource.getCellRect(maxRow, 0, true));
                if (!this.jCheckBoxSync.isSelected()) {
                    maxRow = this.model1.getRowCount() - 1;
                    this.jTableSource1.setRowSelectionInterval(maxRow, maxRow);
                    this.jTableSource1.scrollRectToVisible(this.jTableSource1.getCellRect(maxRow, 0, true));
                }
                this.jTextFieldCurrentDifAdr.setText("-");
                return;
            }
            if (this.activeDif >= 0) {
                address = this.byteDifs.get(this.activeDif);
            }
        }
        if (address != -1) {
            this.goAddress(address, false, true, true);
            this.jTextFieldCurrentDifAdr.setText("" + (this.activeDif + 1) + ": " + String.format("$%04X", address & 0xFFFF));
        } else {
            this.jTextFieldCurrentDifAdr.setText("-");
        }
    }

    @Override
    public Serializable getAdditionalStateinfo() {
        int ci;
        String n;
        TableColumn tcol;
        int i;
        this.s = new DisCompareFileStrings();
        this.s.s1 = this.jTextFieldTileFile.getText();
        this.s.s2 = this.jTextFieldTileFile1.getText();
        this.s.lastDir1 = this.lastDir1;
        this.s.lastDir2 = this.lastDir2;
        this.s.synced = this.jCheckBoxSync.isSelected();
        for (i = 0; i < this.jTableSource.getColumnCount(); ++i) {
            tcol = this.jTableSource.getColumnModel().getColumn(i);
            n = this.jTableSource.getColumnModel().getColumn(i).getHeaderValue().toString();
            ci = this.getColumnNameIndex1(n);
            MemoryInformationTableModelSmall.columnWidthSmall1[ci] = tcol.getWidth();
        }
        for (i = 0; i < this.jTableSource1.getColumnCount(); ++i) {
            tcol = this.jTableSource1.getColumnModel().getColumn(i);
            n = this.jTableSource1.getColumnModel().getColumn(i).getHeaderValue().toString();
            ci = this.getColumnNameIndex2(n);
            MemoryInformationTableModelSmall.columnWidthSmall2[ci] = tcol.getWidth();
        }
        for (i = 0; i < MemoryInformationTableModelSmall.columnVisibleALL.length; ++i) {
            this.s.columnVisibleALL[i] = MemoryInformationTableModelSmall.columnVisibleALL[i];
        }
        for (i = 0; i < MemoryInformationTableModelSmall.columnWidthSmall1.length; ++i) {
            this.s.columnWidthSmall1[i] = MemoryInformationTableModelSmall.columnWidthSmall1[i];
        }
        for (i = 0; i < MemoryInformationTableModelSmall.columnWidthSmall2.length; ++i) {
            this.s.columnWidthSmall2[i] = MemoryInformationTableModelSmall.columnWidthSmall2[i];
        }
        return this.s;
    }

    @Override
    public void setAdditionalStateinfo(Serializable ser) {
        int i;
        if (ser == null) {
            return;
        }
        if (!(ser instanceof DisCompareFileStrings)) {
            return;
        }
        this.s = (DisCompareFileStrings)ser;
        this.jTextFieldTileFile.setText(this.s.s1);
        this.jTextFieldTileFileActionPerformed(null);
        this.jTextFieldTileFile1.setText(this.s.s2);
        this.jTextFieldTileFile1ActionPerformed(null);
        this.jCheckBoxSync.setSelected(this.s.synced);
        this.lastDir1 = this.s.lastDir1;
        this.lastDir2 = this.s.lastDir2;
        MemoryInformationTableModelSmall.columnVisibleALL = new Boolean[MemoryInformationTableModelSmall.columnVisibleALL.length];
        MemoryInformationTableModelSmall.columnWidthSmall1 = new int[MemoryInformationTableModelSmall.columnWidthSmall1.length];
        MemoryInformationTableModelSmall.columnWidthSmall2 = new int[MemoryInformationTableModelSmall.columnWidthSmall2.length];
        for (i = 0; i < MemoryInformationTableModelSmall.columnWidthSmall1.length; ++i) {
            MemoryInformationTableModelSmall.columnWidthSmall1[i] = 100;
        }
        for (i = 0; i < MemoryInformationTableModelSmall.columnWidthSmall2.length; ++i) {
            MemoryInformationTableModelSmall.columnWidthSmall2[i] = 100;
        }
        for (i = 0; i < this.s.columnVisibleALL.length; ++i) {
            MemoryInformationTableModelSmall.columnVisibleALL[i] = this.s.columnVisibleALL[i];
        }
        for (i = 0; i < this.s.columnWidthSmall1.length; ++i) {
            MemoryInformationTableModelSmall.columnWidthSmall1[i] = this.s.columnWidthSmall1[i];
        }
        for (i = 0; i < this.s.columnWidthSmall2.length; ++i) {
            MemoryInformationTableModelSmall.columnWidthSmall2[i] = this.s.columnWidthSmall2[i];
        }
        MemoryInformationTableModelSmall.wasInit = true;
        CompareDissiPanel.configChanged();
        this.correctModel();
        this.jCheckBoxSyncActionPerformed(null);
    }

    static class SplitterLocation
    implements Serializable {
        int pos = 0;

        SplitterLocation() {
        }
    }

    class FileWatcher
    extends Thread {
        CompareDissiPanel parent;
        private final File file;
        private AtomicBoolean stop = new AtomicBoolean(false);
        private boolean useSecondtable = false;

        public FileWatcher(File file, boolean us, CompareDissiPanel p) {
            this.file = file;
            this.useSecondtable = us;
            this.parent = p;
        }

        public boolean isStopped() {
            return this.stop.get();
        }

        public void stopThread() {
            this.stop.set(true);
        }

        public synchronized void doOnChange() {
            this.parent.doOnChange(this.useSecondtable);
        }

        public synchronized void doOnDelete() {
            this.parent.doOnDelete(this.useSecondtable);
        }

        @Override
        public void run() {
            try (WatchService watcher = FileSystems.getDefault().newWatchService();){
                Path path = this.file.toPath().getParent();
                path.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                while (!this.isStopped()) {
                    WatchKey key;
                    try {
                        key = watcher.poll(25L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        if (watcher != null) {
                            if (var2_3 != null) {
                                try {
                                    watcher.close();
                                }
                                catch (Throwable throwable) {
                                    var2_3.addSuppressed(throwable);
                                }
                            } else {
                                watcher.close();
                            }
                        }
                        return;
                    }
                    if (key == null) {
                        Thread.yield();
                        continue;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        boolean valid;
                        WatchEvent.Kind<?> kind = event.kind();
                        WatchEvent<?> ev = event;
                        Path filename = (Path)ev.context();
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            Thread.yield();
                            continue;
                        }
                        if (kind == StandardWatchEventKinds.ENTRY_MODIFY && filename.toString().equals(this.file.getName())) {
                            this.doOnChange();
                        } else if (kind == StandardWatchEventKinds.ENTRY_DELETE && filename.toString().equals(this.file.getName())) {
                            this.doOnDelete();
                        }
                        if (valid = key.reset()) continue;
                        break;
                    }
                    Thread.yield();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

