/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.dissy;

import de.malban.vide.dissy.MemoryInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.CRC32;

public class Memory {
    public HashMap<Integer, MemoryInformation> memMap;
    public HashMap<Integer, HashMap<Integer, String>> directLabels;
    int maxBank = 1;
    int currentBank = 0;
    int highestUserRAM = -1;
    ArrayList<OneBank> allBanks = new ArrayList();

    public Memory() {
        this.allBanks.add(new OneBank());
        this.setBank(0);
    }

    public void resetAllBreakPoints() {
        for (OneBank bank2 : this.allBanks) {
            for (int a = 0; a < 65536; ++a) {
                MemoryInformation memInfo = this.memMap.get(a);
                if (memInfo == null) continue;
                memInfo.resetBreakPoints();
            }
        }
    }

    public int getCurrentBank() {
        return this.currentBank;
    }

    public void setBank(int b) {
        this.setBank(b, false);
    }

    public int getMaxBank() {
        return this.maxBank;
    }

    public HashMap<Integer, MemoryInformation> getBankMemory(int bank2) {
        if (bank2 > this.maxBank - 1) {
            return null;
        }
        HashMap<Integer, MemoryInformation> memMap2 = this.allBanks.get((int)bank2).memMap;
        return memMap2;
    }

    public void setToAllBanks(byte b, int address) {
        for (OneBank bank2 : this.allBanks) {
            MemoryInformation memInfo = this.memMap.get(address);
            if (memInfo == null) {
                this.memMap.put(address, new MemoryInformation(address, b));
                memInfo = this.memMap.get(address);
            }
            memInfo.content = b;
        }
    }

    public void setBank(int b, boolean addBank) {
        if (b > this.maxBank - 1 && addBank) {
            if (b > this.maxBank) {
                return;
            }
            this.allBanks.add(new OneBank());
            ++this.maxBank;
            this.currentBank = b % this.maxBank;
            this.memMap = this.allBanks.get((int)this.currentBank).memMap;
            this.directLabels = this.allBanks.get((int)this.currentBank).directLabels;
            this.init();
            return;
        }
        this.currentBank = b % this.maxBank;
        this.memMap = this.allBanks.get((int)this.currentBank).memMap;
        this.directLabels = this.allBanks.get((int)this.currentBank).directLabels;
    }

    public MemoryInformation get(int adr, int bank2) {
        while (bank2 > this.maxBank - 1) {
            int saveCurrent = this.currentBank;
            this.allBanks.add(new OneBank());
            ++this.maxBank;
            this.currentBank = bank2 % this.maxBank;
            this.memMap = this.allBanks.get((int)this.currentBank).memMap;
            this.directLabels = this.allBanks.get((int)this.currentBank).directLabels;
            this.init();
            this.currentBank = saveCurrent;
            this.memMap = this.allBanks.get((int)this.currentBank).memMap;
            this.directLabels = this.allBanks.get((int)this.currentBank).directLabels;
        }
        return this.allBanks.get((int)bank2).memMap.get(adr);
    }

    public void reset() {
        this.maxBank = 1;
        this.allBanks.clear();
        this.allBanks.add(new OneBank());
        this.setBank(0);
    }

    public MemoryInformation buildMemInfo(int adr, byte mem) {
        if (this.memMap.get(adr) == null) {
            this.memMap.put(adr, new MemoryInformation(adr, mem));
        } else {
            this.memMap.get((Object)Integer.valueOf((int)adr)).content = mem;
        }
        if (adr < 57344 && this.memMap.get((Object)Integer.valueOf((int)adr)).disType == 0) {
            this.memMap.get((Object)Integer.valueOf((int)adr)).disType = -2;
        }
        if (adr > 49152) {
            this.memMap.get((Object)Integer.valueOf((int)adr)).disTypeCollectionMax = 1;
        }
        return this.memMap.get(adr);
    }

    public void init() {
        for (int i = 0; i < 65536; ++i) {
            this.buildMemInfo(i);
        }
    }

    public MemoryInformation buildMemInfo(int adr) {
        if (this.memMap.get(adr) == null) {
            this.memMap.put(adr, new MemoryInformation(adr, 0));
            if (adr > 49152) {
                this.memMap.get((Object)Integer.valueOf((int)adr)).disTypeCollectionMax = 1;
            }
        }
        return this.memMap.get(adr);
    }

    public MemoryInformation buildMemInfo(int adr, int bank2) {
        while (bank2 > this.maxBank - 1) {
            int saveCurrent = this.currentBank;
            this.allBanks.add(new OneBank());
            ++this.maxBank;
            this.currentBank = bank2 % this.maxBank;
            this.memMap = this.allBanks.get((int)this.currentBank).memMap;
            this.directLabels = this.allBanks.get((int)this.currentBank).directLabels;
            this.init();
            this.currentBank = saveCurrent;
            this.memMap = this.allBanks.get((int)this.currentBank).memMap;
            this.directLabels = this.allBanks.get((int)this.currentBank).directLabels;
        }
        if (this.allBanks.get((int)bank2).memMap.get(adr) == null) {
            this.allBanks.get((int)bank2).memMap.put(adr, new MemoryInformation(adr, 0));
        }
        return this.allBanks.get((int)bank2).memMap.get(adr);
    }

    public long getCRC(int start, int end2) {
        if (end2 <= start) {
            return -1L;
        }
        if (start < 0) {
            return -1L;
        }
        CRC32 localCRC32 = new CRC32();
        for (int i = start; i < end2; ++i) {
            localCRC32.update(this.memMap.get((Object)Integer.valueOf((int)i)).content);
        }
        return localCRC32.getValue();
    }

    public boolean labelsChanged(MemoryInformation memInfo, ArrayList<String> oldLabels) {
        boolean changeRelevant = false;
        ArrayList<String> newLabels = memInfo.labels;
        for (String oldLabel : oldLabels) {
            if (newLabels.contains(oldLabel)) continue;
            changeRelevant = true;
            this.invalidateLabel(oldLabel);
        }
        for (String oldLabel : newLabels) {
            if (oldLabels.contains(oldLabel)) continue;
            changeRelevant = true;
        }
        if (!changeRelevant) {
            return false;
        }
        return changeRelevant;
    }

    private void invalidateLabel(String oldLabel) {
        for (int i = 0; i < 65536; ++i) {
            MemoryInformation memInfo = this.memMap.get(i);
            if (memInfo == null || memInfo.disType == 0 || !memInfo.disassembledOperand.contains(oldLabel)) continue;
            memInfo.done = false;
            memInfo.disassembledMnemonic = "";
            memInfo.disassembledOperand = "";
            if (memInfo.disType < 6) continue;
            memInfo.disType = 15;
        }
    }

    class OneBank {
        public HashMap<Integer, MemoryInformation> memMap = new HashMap();
        public HashMap<Integer, HashMap<Integer, String>> directLabels = new HashMap();

        OneBank() {
        }
    }
}

