/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.dissy;

import de.malban.vide.vecx.Breakpoint;
import java.util.ArrayList;

public class MemoryInformation {
    public static final int MEM_TYPE_RAM = 0;
    public static final int MEM_TYPE_ROM = 1;
    public static final int MEM_TYPE_IO = 2;
    public static final int MEM_TYPE_BAD = 3;
    public static final int DIS_TYPE_DATA_DECIMAL = -3;
    public static final int DIS_TYPE_LOADED = -2;
    public static final int DIS_TYPE_CODE = -1;
    public static final int DIS_TYPE_UNKOWN = 0;
    public static final int DIS_TYPE_DATA_BYTE = 1;
    public static final int DIS_TYPE_DATA_WORD = 2;
    public static final int DIS_TYPE_DATA_WORD_POINTER = 3;
    public static final int DIS_TYPE_DATA_CHAR = 4;
    public static final int DIS_TYPE_DATA_BINARY = 5;
    public static final int DIS_TYPE_DATA_INSTRUCTION_1_LENGTH = 6;
    public static final int DIS_TYPE_DATA_INSTRUCTION_2_LENGTH = 7;
    public static final int DIS_TYPE_DATA_INSTRUCTION_3_LENGTH = 8;
    public static final int DIS_TYPE_DATA_INSTRUCTION_4_LENGTH = 9;
    public static final int DIS_TYPE_DATA_INSTRUCTION_5_LENGTH = 10;
    public static final int DIS_TYPE_DATA_BELONGSTO_INSTRUCTION_POS_1 = 11;
    public static final int DIS_TYPE_DATA_BELONGSTO_INSTRUCTION_POS_2 = 12;
    public static final int DIS_TYPE_DATA_BELONGSTO_INSTRUCTION_POS_3 = 13;
    public static final int DIS_TYPE_DATA_BELONGSTO_INSTRUCTION_POS_4 = 14;
    public static final int DIS_TYPE_DATA_INSTRUCTION_GENERAL = 15;
    public static String[] disTypeString = new String[]{"UNKOWN", "DB Byte", "DB Word", "DB Ptr", "DB Char", "DB Bin", "INS 1", "INS 2", "INS 3", "INS 4", "INS 5", "INSPart 2", "INSPart 3", "INSPart 4", "INSPart 5", "INS UNKOWN", "GENERAL (error)"};
    public final int address;
    public byte content;
    public int length = 1;
    public int memType = 1;
    public int disType = 0;
    public boolean visible = true;
    public int directPageAddress = -1;
    public String disassemblerInfoText = "";
    public boolean ramInit = false;
    public int disTypeCollectionMax = 4;
    public int referingAddressMode = -1;
    public int referingToAddress = -1;
    public boolean referingToShort = false;
    public boolean contentUnkown = true;
    public boolean typeWasSet = false;
    public String forcedSymbol = null;
    public ArrayList<String> labels = new ArrayList();
    public ArrayList<String> immediateLabels = new ArrayList();
    public ArrayList<String> comments = new ArrayList();
    public int page = -1;
    public int indexInOpcodeTablePage0 = -1;
    public int indexInOpcodeTablePage1 = -1;
    public int indexInOpcodeTablePage2 = -1;
    public String hexDump = "";
    public String disassembledMnemonic = "";
    public String disassembledOperand = "";
    public boolean done = false;
    public boolean codeScanDone = false;
    public int isInstructionByte = 0;
    public MemoryInformation belongsToInstruction = null;
    public ArrayList<MemoryInformation> familyBytes = new ArrayList();
    private ArrayList<Breakpoint> breakpoints = null;
    public MemCInfoBlock cInfo = null;
    public int myRow = -1;
    public int cInfoRow = -1;
    int cycles = -1;

    public boolean isCInfo() {
        return this.cInfo != null;
    }

    public boolean isCInfo(int row) {
        if (this.cInfo == null) {
            return false;
        }
        return row == this.cInfoRow;
    }

    public MemoryInformation(int adr, byte mem) {
        this.address = adr;
        this.content = mem;
        this.contentUnkown = false;
    }

    public boolean hasImmediateLabel(String la) {
        for (String l : this.immediateLabels) {
            if (!l.trim().equals(la.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean hasLabel(String la) {
        for (String l : this.labels) {
            if (!l.trim().equals(la.trim())) continue;
            return true;
        }
        return false;
    }

    public boolean hasComment(String co) {
        for (String c : this.comments) {
            if (!c.trim().equals(co.trim())) continue;
            return true;
        }
        return false;
    }

    public void addBreakpoint(Breakpoint bp) {
        if (this.breakpoints == null) {
            this.breakpoints = new ArrayList();
        }
        this.breakpoints.add(bp);
    }

    public void removeBreakpoint(Breakpoint bp) {
        if (this.breakpoints == null) {
            return;
        }
        while (this.breakpoints.remove(bp)) {
        }
    }

    public boolean hasBreakpoint() {
        if (this.breakpoints == null) {
            return false;
        }
        return this.breakpoints.size() != 0;
    }

    public boolean removeSameBreakPoint(Breakpoint bp) {
        boolean ret = false;
        ArrayList<Breakpoint> toRemove = new ArrayList<Breakpoint>();
        if (this.breakpoints == null) {
            this.breakpoints = new ArrayList();
        }
        for (Breakpoint p : this.breakpoints) {
            if (bp.targetAddress != p.targetAddress || bp.targetBank != p.targetBank || bp.targetType != p.targetType || bp.targetSubType != p.targetSubType || bp.type != p.type || bp.compareValue != p.compareValue) continue;
            toRemove.add(p);
            ret = true;
        }
        for (Breakpoint p : toRemove) {
            this.breakpoints.remove(p);
        }
        return ret;
    }

    public ArrayList<Breakpoint> getBreakpoints() {
        return this.breakpoints;
    }

    public void resetBreakPoints() {
        if (this.breakpoints == null) {
            return;
        }
        this.breakpoints.clear();
    }

    public Breakpoint hasBreakpoint(Breakpoint bp) {
        if (this.breakpoints == null) {
            return null;
        }
        for (Breakpoint breakpoint : this.breakpoints) {
            if (!breakpoint.addressEquals(bp)) continue;
            return breakpoint;
        }
        return null;
    }

    public void reset() {
        this.disType = this.disType >= 6 ? 15 : -2;
        this.disassembledMnemonic = "";
        this.disassembledOperand = "";
        this.disTypeCollectionMax = 1;
        this.done = false;
        this.length = 1;
        this.indexInOpcodeTablePage0 = -1;
        this.indexInOpcodeTablePage1 = -1;
        this.indexInOpcodeTablePage2 = -1;
        this.page = -1;
        this.belongsToInstruction = null;
        for (MemoryInformation mi : this.familyBytes) {
            mi.isInstructionByte = 0;
            mi.hexDump = "";
            mi.belongsToInstruction = null;
            mi.disType = -2;
            mi.disTypeCollectionMax = 1;
        }
        this.familyBytes.clear();
        this.disassemblerInfoText = "";
    }

    static class MemCInfoBlock {
        int lineNo = 0;
        String file = "";
        String lineString = "";
        int address = 0;

        MemCInfoBlock() {
        }
    }
}

