/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.script;

import de.malban.Global;
import de.malban.gui.HotKey;
import de.malban.util.syntax.Syntax.HighlightedDocument;
import de.malban.vide.script.ExecutionDescriptor;
import de.malban.vide.script.ExportData;
import de.malban.vide.script.ExportDataPool;
import de.malban.vide.script.ScriptEnvironment;
import de.malban.vide.veccy.VeccyPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;

public class ExportDataPanel
extends JPanel {
    private HighlightedDocument document = new HighlightedDocument(-1);
    private ExportData mExportData = new ExportData();
    private ExportDataPool mExportDataPool;
    private int mClassSetting = 0;
    private String mType = "NONE";
    public static final int EXPORT = 0;
    public static final int IMPORT = 1;
    public int type = 0;
    JFrame frame = null;
    Collection mCollection = null;
    VeccyPanel vecci = null;
    int savedCaretPosition = 0;
    private JButton jButton2;
    private JButton jButtonDelete;
    private JButton jButtonExecute;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JEditorPane jEditorLog;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JTextArea jTextAreaComment;
    private JTextArea jTextAreaOutput;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldName;
    private JTextPane jTextPaneScript;

    public ExportDataPanel() {
        this.initComponents();
        this.jTextPaneScript.setDocument(this.document);
        this.document.setHighlightStyle(HighlightedDocument.JAVA_STYLE);
        this.document.start();
        this.mExportDataPool = new ExportDataPool();
        this.resetConfigPool(null, "");
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldName);
            HotKey.addMacDefaults(this.jTextAreaComment);
            HotKey.addMacDefaults(this.jTextPaneScript);
            HotKey.addMacDefaults(this.jTextFieldKlasse);
            HotKey.addMacDefaults(this.jTextAreaOutput);
        }
    }

    public void setData(VeccyPanel v, int t, JFrame f) {
        this.frame = f;
        this.vecci = v;
        this.type = t;
        this.mType = this.type == 0 ? "Vecci Export" : "Vecci Import";
        this.jTextPaneScript.setDocument(this.document);
        this.document.setHighlightStyle(HighlightedDocument.JAVA_STYLE);
        this.document.start();
        this.mExportDataPool = new ExportDataPool();
        this.resetConfigPool(null, this.mType);
    }

    private void resetConfigPool(String selectName, String klasseToSet) {
        ++this.mClassSetting;
        this.jComboBoxKlasse.removeAllItems();
        this.jComboBoxKlasse.addItem(klasseToSet);
        this.jTextFieldKlasse.setText(klasseToSet);
        this.jComboBoxKlasse.setSelectedIndex(0);
        Collection<ExportData> colC = this.mExportDataPool.getMapForKlasse(klasseToSet).values();
        Iterator<ExportData> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        int i = 0;
        int toSelect = -1;
        while (iterC.hasNext()) {
            ExportData item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (selectName != null && item.mName.equals(selectName)) {
                toSelect = i;
            }
            ++i;
        }
        this.jComboBoxName.setSelectedIndex(toSelect);
        if (toSelect != -1) {
            this.mExportData = this.mExportDataPool.get(selectName);
            this.setAllFromCurrent();
        }
        --this.mClassSetting;
    }

    private void resetConfigPool(boolean b, String klasseToSet) {
        if (!b) {
            this.resetConfigPool(null, klasseToSet);
            return;
        }
        Collection<ExportData> colC = this.mExportDataPool.getMapForKlasse(klasseToSet).values();
        Iterator<ExportData> iterC = colC.iterator();
        Object name = null;
        if (iterC.hasNext()) {
            ExportData item = iterC.next();
            this.resetConfigPool(item.mName, klasseToSet);
            return;
        }
        this.resetConfigPool(null, klasseToSet);
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mExportData = new ExportData();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxName.setSelectedItem(this.mExportData.mName);
        this.jTextFieldName.setText(this.mExportData.mName);
        this.jTextAreaComment.setText(this.mExportData.mComment);
        this.jTextPaneScript.setText(this.mExportData.mScript);
        this.jTextAreaOutput.setText("");
        this.document.stopColoring();
        this.document.colorAllDirect();
        this.document.startColoring();
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mExportData.mClass = this.jTextFieldKlasse.getText();
        this.mExportData.mName = this.jTextFieldName.getText();
        this.mExportData.mComment = this.jTextAreaComment.getText();
        this.mExportData.mScript = this.jTextPaneScript.getText();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxKlasse = new JComboBox();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldKlasse = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jButton2 = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jButtonExecute = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jEditorLog = new JEditorPane();
        this.jLabel7 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.jTextPaneScript = new JTextPane();
        this.jPanel4 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaOutput = new JTextArea();
        this.setPreferredSize(new Dimension(100, 21));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxKlasse.setEnabled(false);
        this.jComboBoxKlasse.setPreferredSize(new Dimension(170, 21));
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jComboBoxName.setPreferredSize(new Dimension(170, 21));
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jLabel4.setText("Class");
        this.jTextFieldName.setPreferredSize(new Dimension(170, 21));
        this.jTextFieldKlasse.setEditable(false);
        this.jTextFieldKlasse.setEnabled(false);
        this.jTextFieldKlasse.setPreferredSize(new Dimension(170, 21));
        this.jButtonNew.setText("New");
        this.jButtonNew.setPreferredSize(new Dimension(100, 21));
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setPreferredSize(new Dimension(100, 21));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.setPreferredSize(new Dimension(100, 21));
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setPreferredSize(new Dimension(100, 21));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButton2.setText("Help");
        this.jButton2.setPreferredSize(new Dimension(100, 21));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(16, 16, 16).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldKlasse, -1, -1, -2).addComponent(this.jTextFieldName, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxKlasse, 0, -1, -2).addComponent(this.jComboBoxName, 0, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jButtonNew, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSaveAsNew, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDelete, -2, -1, -2).addGap(53, 53, 53).addComponent(this.jButton2, -2, -1, -2))).addContainerGap(66, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDelete, -2, -1, -2).addComponent(this.jButton2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jButtonSaveAsNew, -2, -1, -2))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxKlasse, -2, -1, -2).addComponent(this.jButtonNew, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxName, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jTextFieldKlasse, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -1, -1, Short.MAX_VALUE)))))));
        this.jLabel2.setText("Comment");
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jButtonExecute.setText("Execute");
        this.jButtonExecute.setPreferredSize(new Dimension(100, 21));
        this.jButtonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportDataPanel.this.jButtonExecuteActionPerformed(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jEditorLog);
        this.jLabel7.setText("Log");
        this.jSplitPane1.setDividerLocation(700);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jLabel5.setText("Script");
        this.jTextPaneScript.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ExportDataPanel.this.jTextPaneScriptFocusLost(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTextPaneScript);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(0, 667, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(0, 0, 0).addComponent(this.jScrollPane4).addGap(0, 0, 0)));
        this.jSplitPane1.setLeftComponent(this.jPanel3);
        this.jLabel6.setText("Output");
        this.jTextAreaOutput.setColumns(20);
        this.jTextAreaOutput.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextAreaOutput);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 124, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(0, 0, 0).addComponent(this.jScrollPane2, -1, 282, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.jSplitPane1.setRightComponent(this.jPanel4);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addGap(90, 90, 90).addComponent(this.jButtonExecute, -2, -1, -2)).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.jSplitPane1, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addGap(6, 6, 6)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(0, 0, 0).addComponent(this.jScrollPane1, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 299, Short.MAX_VALUE).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jButtonExecute, -2, -1, -2)).addGap(2, 2, 2).addComponent(this.jScrollPane3, -2, 157, -2).addGap(6, 6, 6)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mExportData = new ExportData();
        this.clearAll();
        this.resetConfigPool(null, this.jTextFieldKlasse.getText());
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        String klasse = this.jTextFieldKlasse.getText();
        String currentName = this.mExportData.mName;
        this.savePos();
        this.readAllToCurrent();
        this.mExportDataPool.put(this.mExportData);
        this.mExportDataPool.save();
        ++this.mClassSetting;
        this.resetConfigPool(currentName, klasse);
        this.document.stopColoring();
        this.document.colorAllDirect();
        this.document.startColoring();
        this.restorePos();
        --this.mClassSetting;
    }

    void savePos() {
        this.savedCaretPosition = this.jTextPaneScript.getCaretPosition();
    }

    void restorePos() {
        if (this.savedCaretPosition > this.jTextPaneScript.getDocument().getLength()) {
            return;
        }
        this.jTextPaneScript.setCaretPosition(this.savedCaretPosition);
        this.jTextPaneScript.requestFocusInWindow();
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.savePos();
        this.mExportData = new ExportData();
        this.readAllToCurrent();
        this.mExportDataPool.putAsNew(this.mExportData);
        this.mExportDataPool.save();
        ++this.mClassSetting;
        String name = this.mExportData.mName;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(name, klasse);
        this.document.stopColoring();
        this.document.colorAllDirect();
        this.document.startColoring();
        this.restorePos();
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mExportDataPool.remove(this.mExportData);
        this.mExportDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mExportData = this.mExportDataPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mExportData = this.mExportDataPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mExportData = this.mExportDataPool.get(key);
        this.setAllFromCurrent();
    }

    private void jTextPaneScriptFocusLost(FocusEvent evt) {
    }

    private void jButtonExecuteActionPerformed(ActionEvent evt) {
        String script = this.jTextPaneScript.getText();
        ScriptEnvironment ev = new ScriptEnvironment(script);
        ExecutionDescriptor ed = this.type == 0 ? new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_VECCY_EXPORT, "", "", "ExportDaraPanel", "") : new ExecutionDescriptor(ExecutionDescriptor.ED_TYPE_VECCY_IMPORT, "", "", "ExportDaraPanel", "");
        ev.setData(this.vecci, (Frame)this.frame, ed);
        ev.execute();
        this.jTextAreaOutput.setText(ev.getOutString());
        this.jEditorLog.setText(ev.getErrorString());
    }
}

