/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.script;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import de.malban.config.Configuration;
import de.malban.config.Logable;
import de.malban.util.UtilityString;
import de.malban.vide.script.InterpreterReturn;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class InterpreterUtility {
    public static boolean scriptCheck(String s) {
        Logable D = Configuration.getConfiguration().getDebugEntity();
        String[] badWords = new String[]{};
        for (int i = 0; i < badWords.length; ++i) {
            if (s.toUpperCase().indexOf(badWords[i].toUpperCase()) == -1) continue;
            D.addLog("Script not acceptable, contains word: \"" + badWords[i] + "\"", 0);
            return false;
        }
        return true;
    }

    public static InterpreterReturn askScript(Interpreter i, String script) {
        return InterpreterUtility.askScript(i, script, true);
    }

    public static InterpreterReturn askScript(Interpreter i, String script, boolean recallTest) {
        Logable D = Configuration.getConfiguration().getDebugEntity();
        String mSkriptDebug = "";
        InterpreterReturn ret = new InterpreterReturn();
        if (script == null) {
            ret.bScriptAvailable = false;
            return ret;
        }
        if (!InterpreterUtility.scriptCheck(script = InterpreterUtility.doImports(script))) {
            script = "";
        }
        if (script.trim().length() == 0) {
            ret.bScriptAvailable = false;
            return ret;
        }
        try {
            Object re;
            ret.bScriptAvailable = true;
            D.addLog("Going to execute script:\n" + script, 4);
            i.set("thisScript", (Object)script);
            ret.scriptExecuted = script;
            i.eval(script);
            Object r = i.get("bRet");
            if (r != null) {
                ret.bRet = (Boolean)r;
                ret.bReturnGot = true;
                D.addLog("Boolean return got: " + ret.bRet, 3);
            }
            if ((re = i.get("reason")) != null) {
                ret.reason = (String)re;
                D.addLog("Reason: " + ret.reason, 3);
            }
            if ((re = i.get("bCancel")) != null) {
                ret.bCancel = (Boolean)re;
                D.addLog("Cancel: " + ret.bCancel, 3);
            }
            if ((re = i.get("bCommunication")) != null) {
                ret.bCommunication = (Boolean)re;
                D.addLog("Communication: " + ret.bCommunication, 3);
            }
            if ((re = i.get("data")) != null) {
                ret.data = re;
                D.addLog("data: " + ret.data, 3);
            }
            if ((mSkriptDebug = (String)i.get("debug")) != null) {
                D.addLog("Debug Info:" + mSkriptDebug, 3);
            }
        }
        catch (TargetError e) {
            Throwable t = e.getTarget();
            D.addLog(mSkriptDebug, 0);
            D.addLog("In Script(1): \n" + InterpreterUtility.addLineNumbers(script), 0);
            D.addLog(e, 0);
            D.addLog("\n" + t, 0);
            ret.error = true;
            ret.e = e;
        }
        catch (ParseException e) {
            D.addLog(mSkriptDebug, 0);
            D.addLog("In Script(2): \n" + InterpreterUtility.addLineNumbers(script), 0);
            D.addLog(e, 0);
            ret.error = true;
            ret.e = e;
        }
        catch (EvalError e) {
            D.addLog(mSkriptDebug, 0);
            D.addLog("In Script(3): \n" + InterpreterUtility.addLineNumbers(script), 0);
            D.addLog(e, 0);
            ret.error = true;
            ret.e = e;
        }
        catch (Throwable e) {
            D.addLog(mSkriptDebug, 0);
            D.addLog("In Script(4): \n" + InterpreterUtility.addLineNumbers(script), 0);
            D.addLog(e, 0);
            ret.error = true;
            ret.e = e;
        }
        return ret;
    }

    private static String doImports(String s) {
        boolean importDone = false;
        Logable D = Configuration.getConfiguration().getDebugEntity();
        int pos = s.indexOf("//#import");
        if (pos != -1) {
            String s1 = s.substring(0, pos + 2);
            String s2 = s.substring(pos + 2);
            s = s1 + "(import done)" + s2;
            String pathName = "";
            int start = s.indexOf("\"", pos + 8);
            pathName = s.substring(start + 1);
            int end2 = pathName.indexOf("\"");
            pathName = pathName.substring(0, end2);
            String im = InterpreterUtility.getImportScript(pathName);
            int lineEnd = s.indexOf("\n", pos + 8);
            String part1 = s.substring(0, lineEnd + 1);
            String part2 = s.substring(lineEnd + 1);
            s = part1 + im + "\n" + part2;
            importDone = true;
        }
        if (importDone) {
            s = InterpreterUtility.doImports(s);
        }
        return s;
    }

    private static String getImportScript(String name) {
        Logable D = Configuration.getConfiguration().getDebugEntity();
        String ret = "";
        name = UtilityString.cleanFileString(name);
        D.addLog("Try loading script import: \"" + name + "\"", 3);
        File f = new File(name);
        try {
            InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), "ISO-8859-1");
            BufferedReader reader = new BufferedReader(r);
            String zeile = null;
            do {
                if ((zeile = reader.readLine()) == null) continue;
                ret = ret + zeile + "\n";
            } while (zeile != null);
            reader.close();
        }
        catch (IOException e) {
            System.err.println("Error reading import file.");
            e.printStackTrace();
            D.addLog("Error reading import file.", 3);
        }
        return ret;
    }

    static String addLineNumbers(String s) {
        String ret = "";
        String[] splitter = s.split("\n");
        for (int j = 0; j < splitter.length; ++j) {
            String string = splitter[j];
            ret = ret + "" + (j + 1) + ":  " + string + "\n";
        }
        return ret;
    }
}

