/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.script;

import de.malban.Global;
import de.malban.gui.HotKey;
import de.malban.util.syntax.Syntax.HighlightedDocument;
import de.malban.vide.codi.CodeLibraryPanel;
import de.malban.vide.script.ExecutionDescriptor;
import de.malban.vide.script.ExportData;
import de.malban.vide.script.ExportDataPool;
import de.malban.vide.script.ScriptEnvironment;
import de.malban.vide.veccy.VeccyPanel;
import de.malban.vide.vedi.VEdiFoundationPanel;
import de.malban.vide.vedi.VediPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;

public class ScriptDataPanel
extends JPanel {
    private HighlightedDocument document = new HighlightedDocument(-1);
    private ExportData mExportData = new ExportData();
    private ExportDataPool mExportDataPool;
    private int mClassSetting = 0;
    private String mType = "NONE";
    public static final int EXPORT = 0;
    public static final int IMPORT = 1;
    public int type = 0;
    JFrame frame = null;
    Collection mCollection = null;
    VeccyPanel vecci = null;
    VediPanel vedi = null;
    ExecutionDescriptor ed;
    private JButton jButton2;
    private JButton jButtonDelete;
    private JButton jButtonExecute;
    private JButton jButtonNew;
    private JButton jButtonNew1;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JComboBox jComboBoxKlasse;
    private JComboBox jComboBoxName;
    private JEditorPane jEditorLog;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTextArea jTextAreaComment;
    private JTextArea jTextAreaOutput;
    private JTextField jTextFieldKlasse;
    private JTextField jTextFieldName;
    private JTextPane jTextPaneScript;

    public ScriptDataPanel() {
        this.initComponents();
        this.jTextPaneScript.setDocument(this.document);
        this.document.setHighlightStyle(HighlightedDocument.JAVA_STYLE);
        this.document.start();
        this.mExportDataPool = new ExportDataPool();
        this.resetConfigPool(false, "");
        if (Global.getOSName().toUpperCase().contains("MAC")) {
            HotKey.addMacDefaults(this.jTextFieldName);
            HotKey.addMacDefaults(this.jTextAreaComment);
            HotKey.addMacDefaults(this.jTextPaneScript);
            HotKey.addMacDefaults(this.jTextFieldKlasse);
            HotKey.addMacDefaults(this.jTextAreaOutput);
        }
    }

    public void setVedi(VediPanel v) {
        this.vedi = v;
    }

    private void resetConfigPool(boolean select, String klasseToSet) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mExportDataPool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "";
        this.jComboBoxKlasse.removeAllItems();
        while (iterKlasse.hasNext()) {
            String item = iterKlasse.next();
            this.jComboBoxKlasse.addItem(item);
            if (select) {
                if (klasseToSet.length() == 0) {
                    if (i == 0) {
                        this.jComboBoxKlasse.setSelectedIndex(i);
                        this.jTextFieldKlasse.setText(item);
                        klasse = item;
                    }
                } else if (klasseToSet.equalsIgnoreCase(item)) {
                    this.jComboBoxKlasse.setSelectedIndex(i);
                    this.jTextFieldKlasse.setText(item);
                    klasse = item;
                }
            }
            ++i;
        }
        if (select && klasse.length() == 0 && this.jComboBoxKlasse.getItemCount() > 0) {
            this.jComboBoxKlasse.setSelectedIndex(0);
            this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
            klasse = this.jComboBoxKlasse.getSelectedItem().toString();
        }
        if (!select) {
            this.jComboBoxKlasse.setSelectedIndex(-1);
        }
        Collection<ExportData> colC = this.mExportDataPool.getMapForKlasse(klasse).values();
        Iterator<ExportData> iterC = colC.iterator();
        Vector<String> nnames = new Vector<String>();
        while (iterC.hasNext()) {
            nnames.addElement(iterC.next().mName);
        }
        Collections.sort(nnames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        this.jComboBoxName.removeAllItems();
        i = 0;
        for (int j = 0; j < nnames.size(); ++j) {
            String name = (String)nnames.elementAt(j);
            this.jComboBoxName.addItem(name);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mExportData = this.mExportDataPool.get(name);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mExportData = new ExportData();
        --this.mClassSetting;
        this.setAllFromCurrent();
    }

    private void setAllFromCurrent() {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        this.jComboBoxName.setSelectedItem(this.mExportData.mName);
        this.jTextFieldName.setText(this.mExportData.mName);
        this.jTextAreaComment.setText(this.mExportData.mComment);
        this.jTextPaneScript.setText(this.mExportData.mScript);
        this.jTextAreaOutput.setText("");
        this.document.startColoring();
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mExportData.mClass = this.jTextFieldKlasse.getText();
        this.mExportData.mName = this.jTextFieldName.getText();
        this.mExportData.mComment = this.jTextAreaComment.getText();
        this.mExportData.mScript = this.jTextPaneScript.getText();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxKlasse = new JComboBox();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldKlasse = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonNew1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jLabel5 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.jTextPaneScript = new JTextPane();
        this.jLabel6 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaOutput = new JTextArea();
        this.jButtonExecute = new JButton();
        this.jButton2 = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jEditorLog = new JEditorPane();
        this.jLabel7 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxKlasse.setPreferredSize(new Dimension(170, 21));
        this.jComboBoxKlasse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptDataPanel.this.jComboBoxKlasseActionPerformed(evt);
            }
        });
        this.jComboBoxName.setPreferredSize(new Dimension(170, 21));
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptDataPanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jLabel4.setText("Class");
        this.jTextFieldName.setPreferredSize(new Dimension(170, 21));
        this.jTextFieldKlasse.setPreferredSize(new Dimension(170, 21));
        this.jButtonNew.setText("New");
        this.jButtonNew.setPreferredSize(new Dimension(130, 21));
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptDataPanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setPreferredSize(new Dimension(130, 21));
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptDataPanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.setPreferredSize(new Dimension(130, 21));
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptDataPanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setPreferredSize(new Dimension(130, 21));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptDataPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonNew1.setText("done");
        this.jButtonNew1.setPreferredSize(new Dimension(130, 21));
        this.jButtonNew1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptDataPanel.this.jButtonNew1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addGap(16, 16, 16).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldKlasse, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldName, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBoxKlasse, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxName, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jButtonNew, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonSaveAsNew, -2, -1, -2).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonDelete, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonNew1, -2, 65, -2)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDelete, -2, -1, -2).addComponent(this.jButtonNew1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSave, -2, -1, -2).addComponent(this.jButtonSaveAsNew, -2, -1, -2))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonNew, -2, -1, -2).addComponent(this.jComboBoxKlasse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxName, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldKlasse, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -2, -1, -2)))))));
        this.jLabel2.setText("Comment");
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jLabel5.setText("Script");
        this.jTextPaneScript.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ScriptDataPanel.this.jTextPaneScriptFocusLost(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTextPaneScript);
        this.jLabel6.setText("Output");
        this.jTextAreaOutput.setColumns(20);
        this.jTextAreaOutput.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextAreaOutput);
        this.jButtonExecute.setText("Execute");
        this.jButtonExecute.setPreferredSize(new Dimension(130, 21));
        this.jButtonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptDataPanel.this.jButtonExecuteActionPerformed(evt);
            }
        });
        this.jButton2.setText("Help");
        this.jButton2.setPreferredSize(new Dimension(130, 21));
        this.jScrollPane3.setViewportView(this.jEditorLog);
        this.jLabel7.setText("Log");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel5).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 298, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonExecute, -2, -1, -2).addComponent(this.jButton2, -2, -1, -2)))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jScrollPane2, -1, 394, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -2, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButton2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExecute, -2, -1, -2)).addComponent(this.jScrollPane1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 327, -2).addComponent(this.jScrollPane4, -2, 327, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addGap(5, 5, 5).addComponent(this.jScrollPane3, -2, 157, -2).addContainerGap()));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mExportData = new ExportData();
        this.clearAll();
        this.resetConfigPool(false, this.jTextFieldKlasse.getText());
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mExportDataPool.put(this.mExportData);
        String name = this.mExportData.mName;
        this.mExportDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        --this.mClassSetting;
        this.jComboBoxName.setSelectedItem(name);
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mExportData = new ExportData();
        this.readAllToCurrent();
        this.mExportDataPool.putAsNew(this.mExportData);
        String name = this.mExportData.mName;
        this.mExportDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        --this.mClassSetting;
        this.jComboBoxName.setSelectedItem(name);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mExportDataPool.remove(this.mExportData);
        this.mExportDataPool.save();
        ++this.mClassSetting;
        String klasse = this.jTextFieldKlasse.getText();
        this.resetConfigPool(true, klasse);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mExportData = this.mExportDataPool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxKlasseActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        ++this.mClassSetting;
        String selected = this.jComboBoxKlasse.getSelectedItem().toString();
        this.clearAll();
        this.resetConfigPool(true, selected);
        this.jTextFieldKlasse.setText(this.jComboBoxKlasse.getSelectedItem().toString());
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mExportData = this.mExportDataPool.get(key);
        --this.mClassSetting;
        this.setAllFromCurrent();
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mExportData = this.mExportDataPool.get(key);
        this.setAllFromCurrent();
    }

    private void jTextPaneScriptFocusLost(FocusEvent evt) {
    }

    private void jButtonExecuteActionPerformed(ActionEvent evt) {
        String script = this.jTextPaneScript.getText();
        ScriptEnvironment ev = new ScriptEnvironment(script);
        if (this.vedi != null) {
            ev.setData(this.vedi, (Frame)this.frame, this.ed);
        } else {
            ev.setData(this.vecci, (Frame)this.frame, this.ed);
        }
        ev.execute();
        this.jTextAreaOutput.setText(ev.getOutString());
        this.jEditorLog.setText(ev.getErrorString());
    }

    private void jButtonNew1ActionPerformed(ActionEvent evt) {
    }

    public String getSelectedName() {
        return this.jTextFieldName.getText();
    }

    public String getSelectedClass() {
        return this.jTextFieldKlasse.getText();
    }

    public void setSelected(String c, String n, ExecutionDescriptor e_d) {
        this.ed = e_d;
        this.jComboBoxKlasse.setSelectedItem(c);
        this.jComboBoxName.setSelectedItem(n);
    }

    public static boolean executeScript(String c, String n, VEdiFoundationPanel l, ExecutionDescriptor ed) {
        if (c == null || n == null) {
            return true;
        }
        if (c.length() == 0 || n.length() == 0) {
            return true;
        }
        ExportDataPool exportDataPool = new ExportDataPool();
        ExportData data2 = exportDataPool.getHashMap().get(n);
        if (data2 == null) {
            l.printWarning("Script not found... (" + c + "->" + n + ")");
            return false;
        }
        String script = data2.mScript;
        ScriptEnvironment ev = new ScriptEnvironment(script);
        ev.setData(l, (Frame)l.getFrame(), ed);
        ev.execute();
        String o = ev.getOutString();
        if (o.trim().length() != 4) {
            l.printMessage(o);
        }
        if (!(o = ev.getErrorString()).equals("Execution ok!")) {
            l.printError(ev.getErrorString());
        }
        return true;
    }

    public static boolean executeScript(String c, String n, CodeLibraryPanel l, ExecutionDescriptor ed) {
        if (c == null || n == null) {
            return true;
        }
        if (c.length() == 0 || n.length() == 0) {
            return true;
        }
        ExportDataPool exportDataPool = new ExportDataPool();
        ExportData data2 = exportDataPool.getHashMap().get(n);
        if (data2 == null) {
            l.printWarning("Script not found... (" + c + "->" + n + ")");
            return false;
        }
        String script = data2.mScript;
        ScriptEnvironment ev = new ScriptEnvironment(script);
        ev.setData(l, (Frame)l.getFrame(), ed);
        ev.execute();
        String o = ev.getOutString();
        if (o.trim().length() != 4) {
            l.printMessage(o);
        }
        if (!(o = ev.getErrorString()).equals("Execution ok!")) {
            l.printError(ev.getErrorString());
        }
        return true;
    }

    public void setData(VeccyPanel v, int t, JFrame f) {
        this.frame = f;
        this.vecci = v;
        this.type = t;
        this.mType = this.type == 0 ? "Vecci Export" : "Vecci Import";
        this.jTextPaneScript.setDocument(this.document);
        this.document.setHighlightStyle(HighlightedDocument.JAVA_STYLE);
        this.document.start();
        this.mExportDataPool = new ExportDataPool();
        this.resetConfigPool(false, this.mType);
    }
}

