/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.script;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.ParseException;
import bsh.TargetError;
import de.malban.config.Configuration;
import de.malban.util.Utility;
import de.malban.util.UtilityString;
import de.malban.vide.codi.CodeLibraryPanel;
import de.malban.vide.script.ExecutionDescriptor;
import de.malban.vide.script.InterpreterReturn;
import de.malban.vide.script.InterpreterUtility;
import de.malban.vide.veccy.VeccyPanel;
import de.malban.vide.vedi.VEdiFoundationPanel;
import de.malban.vide.vedi.VediPanel;
import java.awt.Frame;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;

public class ScriptEnvironment {
    public static final int SCRIPT_NOT_EXECUTED = 0;
    public static final int SCRIPT_EMPTY = 1;
    public static final int SCRIPT_EXECUTED = 2;
    public static final int SCRIPT_EXCEPTION = 3;
    public static final String[] STATE_STRINGS = new String[]{"SCRIPT_NOT_EXECUTED", "SCRIPT_EMPTY", "SCRIPT_EXECUTED", "SCRIPT_EXCEPTION"};
    public String script = "";
    public InterpreterReturn iRet = new InterpreterReturn();
    public int status = 0;
    boolean dataSet = false;
    private Interpreter i = new Interpreter();
    Collection mCollection = null;
    VeccyPanel vecci;
    Frame frame;
    VEdiFoundationPanel vedi;
    CodeLibraryPanel codi;
    ExecutionDescriptor ed;
    String out = "";
    String add = "";
    String error = "";

    public String toString() {
        String ret = "";
        return ret;
    }

    public ScriptEnvironment(String singleScript) {
        this.script = singleScript;
    }

    public void setData(VEdiFoundationPanel ise, Frame f, ExecutionDescriptor e_d) {
        this.frame = f;
        this.vedi = ise;
        this.ed = e_d;
        this.status = 0;
        try {
            this.i.set("vedi", (Object)this.vedi);
            this.i.set("frame", (Object)this.frame);
            this.i.set("ed", (Object)this.ed);
        }
        catch (Throwable e) {
            this.status = 3;
            Configuration.getConfiguration().getDebugEntity().addLog("Script Exception!", 0);
            Configuration.getConfiguration().getDebugEntity().addLog(e, 0);
        }
        this.dataSet = true;
    }

    public void setData(CodeLibraryPanel ise, Frame f, ExecutionDescriptor e_d) {
        this.frame = f;
        this.codi = ise;
        this.ed = e_d;
        this.status = 0;
        try {
            this.i.set("codi", (Object)this.codi);
            this.i.set("frame", (Object)this.frame);
            this.i.set("ed", (Object)this.ed);
        }
        catch (Throwable e) {
            this.status = 3;
            Configuration.getConfiguration().getDebugEntity().addLog("Script Exception!", 0);
            Configuration.getConfiguration().getDebugEntity().addLog(e, 0);
        }
        this.dataSet = true;
    }

    public void setData(VeccyPanel ise, Frame f, ExecutionDescriptor e_d) {
        this.frame = f;
        this.vecci = ise;
        this.ed = e_d;
        this.status = 0;
        try {
            this.i.set("vecci", (Object)this.vecci);
            this.i.set("frame", (Object)this.frame);
            this.i.set("ed", (Object)this.ed);
        }
        catch (Throwable e) {
            this.status = 3;
            Configuration.getConfiguration().getDebugEntity().addLog("Script Exception!", 0);
            Configuration.getConfiguration().getDebugEntity().addLog(e, 0);
        }
        this.dataSet = true;
    }

    public void setData(VediPanel v, Frame f, ExecutionDescriptor e_d) {
        this.frame = f;
        this.vedi = v;
        this.ed = e_d;
        this.status = 0;
        try {
            this.i.set("vedi", (Object)this.vedi);
            this.i.set("frame", (Object)this.frame);
            this.i.set("ed", (Object)this.ed);
        }
        catch (Throwable e) {
            this.status = 3;
            Configuration.getConfiguration().getDebugEntity().addLog("Script Exception!", 0);
            Configuration.getConfiguration().getDebugEntity().addLog(e, 0);
        }
        this.dataSet = true;
    }

    public String addException(Throwable e) {
        this.add = "Exception!!! \n";
        PrintStream p = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                char[] c = new char[]{(char)b};
                String s = new String(c);
                ScriptEnvironment.this.add = ScriptEnvironment.this.add + s;
            }
        });
        e.printStackTrace(p);
        p.flush();
        if (e instanceof EvalError || e instanceof TargetError || e instanceof ParseException) {
            this.add = UtilityString.replace(this.add, ";", ";\n");
            this.add = UtilityString.replace(this.add, "'' :", ":\n");
            this.add = UtilityString.replace(this.add, "invocation: Method", "invocation: Method\n\t");
            this.add = UtilityString.replace(this.add, "not found ", "\nnot found ");
            this.add = UtilityString.replace(this.add, "evaluation of: ``", "evaluation of: \n ");
        }
        return this.add;
    }

    public String getOutString() {
        String results = "";
        try {
            Object r = this.i.get("out");
            if (r != null) {
                String _out = (String)r;
                results = results + "out:\n" + _out + "\n";
            }
        }
        catch (Throwable e) {
            results = results + "Error evaluating results further:\n";
            results = results + Utility.getStackTrace(e) + "\n---\n";
        }
        if (this.iRet.error) {
            results = results + "ERROR!\n";
            results = results + this.addException(this.iRet.e) + "\n\n";
            return results;
        }
        return results;
    }

    public void execute() {
        if (!this.dataSet) {
            return;
        }
        if (this.script.trim().length() == 0) {
            return;
        }
        if (this.status == 3) {
            return;
        }
        try {
            this.out = "";
            this.i.set("out", (Object)this.out);
            String imports = "";
            imports = imports + "import de.malban.graphics.GFXVector;\n";
            imports = imports + "import de.malban.graphics.Vertex;\n";
            imports = imports + "import de.malban.util.*;\n";
            imports = imports + "import de.malban.vide.*;\n";
            imports = imports + "import de.malban.vide.script.*;\n";
            this.iRet = InterpreterUtility.askScript(this.i, imports + this.script);
            this.status = 2;
            this.error = "Execution ok!";
        }
        catch (Throwable e) {
            this.status = 3;
            Configuration.getConfiguration().getDebugEntity().addLog("Script Exception!", 0);
            Configuration.getConfiguration().getDebugEntity().addLog(e, 0);
            this.error = "Execution error!\n" + e.toString();
        }
    }

    public String getErrorString() {
        return this.error;
    }
}

