/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.ActionResultDataXMLHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class ActionResultData {
    protected String mClass = "";
    public String mName = "";
    protected Vector<String> mresultType = new Vector();
    protected Vector<String> mresultActionID = new Vector();
    protected Vector<String> mresultSpriteID = new Vector();
    protected Vector<String> mresultY = new Vector();
    protected Vector<String> mresultX = new Vector();
    private static ActionResultDataXMLHandler XMLHANDLER = new ActionResultDataXMLHandler();

    public String getName() {
        return this.mName;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public String getCClass() {
        return this.mClass;
    }

    public void setCClass(String c) {
        this.mClass = c;
    }

    public Vector<String> getresultType() {
        return this.mresultType;
    }

    public void setresultType(Vector<String> resultType) {
        this.mresultType = resultType;
    }

    public Vector<String> getresultActionID() {
        return this.mresultActionID;
    }

    public void setresultActionID(Vector<String> resultActionID) {
        this.mresultActionID = resultActionID;
    }

    public Vector<String> getresultSpriteID() {
        return this.mresultSpriteID;
    }

    public void setresultSpriteID(Vector<String> resultSpriteID) {
        this.mresultSpriteID = resultSpriteID;
    }

    public Vector<String> getresultY() {
        return this.mresultY;
    }

    public void setresultY(Vector<String> resultY) {
        this.mresultY = resultY;
    }

    public Vector<String> getresultX() {
        return this.mresultX;
    }

    public void setresultX(Vector<String> resultX) {
        this.mresultX = resultX;
    }

    private String exportXML() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append("\t<ActionResultData>\n");
        s.append("\t\t<Class>" + UtilityString.toXML(this.mClass) + "</Class>\n");
        s.append("\t\t<Name>" + UtilityString.toXML(this.mName) + "</Name>\n");
        s.append("\t\t<resultTypes>\n");
        for (i = 0; i < this.mresultType.size(); ++i) {
            s.append("\t\t\t<resultType>" + UtilityString.toXML(this.mresultType.elementAt(i)) + "</resultType>\n");
        }
        s.append("\t\t</resultTypes>\n");
        s.append("\t\t<resultActionIDs>\n");
        for (i = 0; i < this.mresultActionID.size(); ++i) {
            s.append("\t\t\t<resultActionID>" + UtilityString.toXML(this.mresultActionID.elementAt(i)) + "</resultActionID>\n");
        }
        s.append("\t\t</resultActionIDs>\n");
        s.append("\t\t<resultSpriteIDs>\n");
        for (i = 0; i < this.mresultSpriteID.size(); ++i) {
            s.append("\t\t\t<resultSpriteID>" + UtilityString.toXML(this.mresultSpriteID.elementAt(i)) + "</resultSpriteID>\n");
        }
        s.append("\t\t</resultSpriteIDs>\n");
        s.append("\t\t<resultYs>\n");
        for (i = 0; i < this.mresultY.size(); ++i) {
            s.append("\t\t\t<resultY>" + UtilityString.toXML(this.mresultY.elementAt(i)) + "</resultY>\n");
        }
        s.append("\t\t</resultYs>\n");
        s.append("\t\t<resultXs>\n");
        for (i = 0; i < this.mresultX.size(); ++i) {
            s.append("\t\t\t<resultX>" + UtilityString.toXML(this.mresultX.elementAt(i)) + "</resultX>\n");
        }
        s.append("\t\t</resultXs>\n");
        s.append("\t</ActionResultData>\n");
        return s.toString();
    }

    public String toString() {
        return this.mName;
    }

    public static ActionResultDataXMLHandler getXMLParseHandler() {
        return XMLHANDLER;
    }

    public static boolean saveCollectionAsXML(String filename, Collection<ActionResultData> col) {
        return ActionResultData.saveCollectionAsXML(Global.mBaseDir, filename, col);
    }

    public static boolean saveCollectionAsXML(String pathName, String filename, Collection<ActionResultData> col) {
        try {
            PrintWriter pw = new PrintWriter(pathName + filename, "UTF-8");
            pw.print("<?xml version=\"1.0\"?>\n");
            pw.print("<AllActionResultData>\n");
            for (ActionResultData item : col) {
                pw.print(item.exportXML());
            }
            pw.print("</AllActionResultData>\n");
            pw.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
        return true;
    }

    public static HashMap<String, ActionResultData> getHashMapFromXML(String filename) {
        HashMap<String, ActionResultData> filters = new HashMap<String, ActionResultData>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ActionResultDataXMLHandler h = ActionResultData.getXMLParseHandler();
            saxParser.parse(Global.mBaseDir + filename, (DefaultHandler)h);
            filters = h.getLastHashMap();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.toString(), "ActionResultData Load Error...", 1);
        }
        return filters;
    }
}

