/*
 * Decompiled with CFR 0.152.
 */
package de.malban.vide.veccy;

import de.malban.Global;
import de.malban.graphics.GFXVectorAnimation;
import de.malban.graphics.GFXVectorList;
import de.malban.graphics.Single3dDisplayPanel;
import de.malban.util.Utility;
import de.malban.util.UtilityString;
import de.malban.vide.veccy.BackGroundScene;
import de.malban.vide.veccy.BackGroundScenePool;
import de.malban.vide.veccy.VectorListFileChoserJPanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BackGroundScenePanel
extends JPanel {
    private BackGroundScene mBackGroundScene = new BackGroundScene();
    private BackGroundScenePool mBackGroundScenePool;
    private GFXVectorAnimation currentAnimation = new GFXVectorAnimation();
    private int inGuiUpdate = 0;
    private int mClassSetting = 0;
    private Single3dDisplayPanel actionAnimation;
    private JButton jButtonDelete;
    private JButton jButtonLoad2;
    private JButton jButtonNew;
    private JButton jButtonSave;
    private JButton jButtonSaveAsNew;
    private JComboBox jComboBoxName;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider jSliderSourceScale1;
    private JTextField jTextFieldAnimationName;
    private JTextField jTextFieldIntensity;
    private JTextField jTextFieldName;
    private JTextField jTextFieldScale;
    private JTextField jTextFieldXpos;
    private JTextField jTextFieldYpos;

    public BackGroundScenePanel() {
        this.initComponents();
        this.mBackGroundScenePool = new BackGroundScenePool();
        this.resetConfigPool(false);
        this.actionAnimation.setSingleRepaint(true);
        this.actionAnimation.setScale(40.0);
        this.actionAnimation.setAngleX(0);
        this.actionAnimation.setAngleY(0);
        this.actionAnimation.setAngleZ(0);
        this.actionAnimation.setAxisAngleX(0);
        this.actionAnimation.setAxisAngleY(0);
        this.actionAnimation.setAxisAngleZ(0);
        this.jSliderSourceScale1StateChanged(null);
    }

    private void resetConfigPool(boolean select) {
        ++this.mClassSetting;
        Collection<String> collectionKlasse = this.mBackGroundScenePool.getKlassenHashMap().values();
        Iterator<String> iterKlasse = collectionKlasse.iterator();
        int i = 0;
        String klasse = "AllScenes";
        Collection<BackGroundScene> colC = this.mBackGroundScenePool.getMapForKlasse(klasse).values();
        Iterator<BackGroundScene> iterC = colC.iterator();
        this.jComboBoxName.removeAllItems();
        i = 0;
        while (iterC.hasNext()) {
            BackGroundScene item = iterC.next();
            this.jComboBoxName.addItem(item.mName);
            if (i == 0 && select) {
                this.jComboBoxName.setSelectedIndex(0);
                this.mBackGroundScene = this.mBackGroundScenePool.get(item.mName);
                this.setAllFromCurrent();
            }
            ++i;
        }
        if (!select) {
            this.jComboBoxName.setSelectedIndex(-1);
        }
        --this.mClassSetting;
    }

    private void clearAll() {
        ++this.mClassSetting;
        this.mBackGroundScene = new BackGroundScene();
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void setAllFromCurrent() {
        ++this.mClassSetting;
        this.jComboBoxName.setSelectedItem(this.mBackGroundScene.mName);
        this.jTextFieldName.setText(this.mBackGroundScene.mName);
        this.jTextFieldAnimationName.setText(this.mBackGroundScene.msceneFile);
        this.jTextFieldYpos.setText("" + this.mBackGroundScene.myPos);
        this.jTextFieldXpos.setText("" + this.mBackGroundScene.mxPos);
        this.jTextFieldScale.setText("" + this.mBackGroundScene.mscale);
        this.jTextFieldIntensity.setText("" + this.mBackGroundScene.mintensity);
        this.loadAnimationFromElement(this.mBackGroundScene.msceneFile);
        --this.mClassSetting;
    }

    private void readAllToCurrent() {
        this.mBackGroundScene.mName = this.jTextFieldName.getText();
        this.mBackGroundScene.mClass = "AllScenes";
        this.mBackGroundScene.msceneFile = this.jTextFieldAnimationName.getText();
        this.mBackGroundScene.myPos = UtilityString.Int0(this.jTextFieldYpos.getText());
        this.mBackGroundScene.mxPos = UtilityString.Int0(this.jTextFieldXpos.getText());
        this.mBackGroundScene.mscale = UtilityString.Int0(this.jTextFieldScale.getText());
        this.mBackGroundScene.mintensity = UtilityString.Int0(this.jTextFieldIntensity.getText());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jComboBoxName = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonNew = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonSaveAsNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.actionAnimation = new Single3dDisplayPanel();
        this.jTextFieldXpos = new JTextField();
        this.jTextFieldYpos = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jTextFieldScale = new JTextField();
        this.jTextFieldIntensity = new JTextField();
        this.jLabel16 = new JLabel();
        this.jTextFieldAnimationName = new JTextField();
        this.jButtonLoad2 = new JButton();
        this.jLabel5 = new JLabel();
        this.jSliderSourceScale1 = new JSlider();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jComboBoxName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jComboBoxNameActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Name");
        this.jButtonNew.setText("New");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonSaveAsNew.setText("Save as new");
        this.jButtonSaveAsNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jButtonSaveAsNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addGap(16, 16, 16).addComponent(this.jTextFieldName, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxName, -2, 176, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSaveAsNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 32, Short.MAX_VALUE).addComponent(this.jButtonDelete).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jComboBoxName, -2, -1, -2).addComponent(this.jButtonNew).addComponent(this.jButtonSave).addComponent(this.jButtonSaveAsNew).addComponent(this.jButtonDelete)).addContainerGap(34, Short.MAX_VALUE)));
        this.actionAnimation.setMaximumSize(new Dimension(150, 150));
        this.actionAnimation.setMinimumSize(new Dimension(150, 150));
        GroupLayout actionAnimationLayout = new GroupLayout(this.actionAnimation);
        this.actionAnimation.setLayout(actionAnimationLayout);
        actionAnimationLayout.setHorizontalGroup(actionAnimationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 221, Short.MAX_VALUE));
        actionAnimationLayout.setVerticalGroup(actionAnimationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jTextFieldXpos.setHorizontalAlignment(11);
        this.jTextFieldXpos.setText("0");
        this.jTextFieldXpos.setToolTipText("update position x while active");
        this.jTextFieldXpos.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BackGroundScenePanel.this.jTextFieldXposFocusLost(evt);
            }
        });
        this.jTextFieldXpos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jTextFieldXposActionPerformed(evt);
            }
        });
        this.jTextFieldYpos.setHorizontalAlignment(11);
        this.jTextFieldYpos.setText("0");
        this.jTextFieldYpos.setToolTipText("update position y while active");
        this.jTextFieldYpos.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BackGroundScenePanel.this.jTextFieldYposFocusLost(evt);
            }
        });
        this.jTextFieldYpos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jTextFieldYposActionPerformed(evt);
            }
        });
        this.jLabel14.setText("y, x");
        this.jLabel14.setToolTipText("while the action is active change y and x position");
        this.jLabel15.setText("scale");
        this.jLabel15.setToolTipText("while the action is active change y and x position");
        this.jTextFieldScale.setHorizontalAlignment(11);
        this.jTextFieldScale.setText("0");
        this.jTextFieldScale.setToolTipText("update position y while active");
        this.jTextFieldScale.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BackGroundScenePanel.this.jTextFieldScaleFocusLost(evt);
            }
        });
        this.jTextFieldScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jTextFieldScaleActionPerformed(evt);
            }
        });
        this.jTextFieldIntensity.setHorizontalAlignment(11);
        this.jTextFieldIntensity.setText("0");
        this.jTextFieldIntensity.setToolTipText("update position y while active");
        this.jTextFieldIntensity.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BackGroundScenePanel.this.jTextFieldIntensityFocusLost(evt);
            }
        });
        this.jTextFieldIntensity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jTextFieldIntensityActionPerformed(evt);
            }
        });
        this.jLabel16.setText("intensity");
        this.jLabel16.setToolTipText("while the action is active change y and x position");
        this.jTextFieldAnimationName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jTextFieldAnimationNameActionPerformed(evt);
            }
        });
        this.jButtonLoad2.setIcon(new ImageIcon(this.getClass().getResource("/de/malban/vide/images/page_go.png")));
        this.jButtonLoad2.setToolTipText("load animation");
        this.jButtonLoad2.setMargin(new Insets(0, 1, 0, -1));
        this.jButtonLoad2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackGroundScenePanel.this.jButtonLoad2ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("scene file");
        this.jSliderSourceScale1.setMajorTickSpacing(1);
        this.jSliderSourceScale1.setMaximum(50);
        this.jSliderSourceScale1.setMinimum(1);
        this.jSliderSourceScale1.setMinorTickSpacing(1);
        this.jSliderSourceScale1.setOrientation(1);
        this.jSliderSourceScale1.setValue(20);
        this.jSliderSourceScale1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BackGroundScenePanel.this.jSliderSourceScale1StateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.actionAnimation, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderSourceScale1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, -2, 69, -2).addComponent(this.jLabel16, -2, 69, -2).addComponent(this.jLabel14, -2, 69, -2).addComponent(this.jLabel5)).addGap(23, 23, 23).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldAnimationName, -2, 234, -2).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldYpos, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldXpos, -2, 40, -2)).addComponent(this.jTextFieldScale, -2, 40, -2).addComponent(this.jTextFieldIntensity, -2, 40, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad2).addGap(0, 127, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(8, 8, 8).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAnimationName, -2, -1, -2).addComponent(this.jLabel5)).addComponent(this.jButtonLoad2, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldYpos, -2, -1, -2).addComponent(this.jTextFieldXpos, -2, -1, -2).addComponent(this.jLabel14)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldScale, -2, -1, -2).addComponent(this.jLabel15)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldIntensity, -2, -1, -2).addComponent(this.jLabel16)).addContainerGap(298, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.actionAnimation, -1, -1, Short.MAX_VALUE).addComponent(this.jSliderSourceScale1, -1, 213, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)));
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        ++this.mClassSetting;
        this.mBackGroundScene = new BackGroundScene();
        this.clearAll();
        this.resetConfigPool(false);
        --this.mClassSetting;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mBackGroundScenePool.put(this.mBackGroundScene);
        this.mBackGroundScenePool.save();
        ++this.mClassSetting;
        this.resetConfigPool(true);
        this.jComboBoxName.setSelectedItem(this.mBackGroundScene.mName);
        --this.mClassSetting;
    }

    private void jButtonSaveAsNewActionPerformed(ActionEvent evt) {
        this.mBackGroundScene = new BackGroundScene();
        this.readAllToCurrent();
        this.mBackGroundScenePool.putAsNew(this.mBackGroundScene);
        this.mBackGroundScenePool.save();
        ++this.mClassSetting;
        this.resetConfigPool(true);
        this.jComboBoxName.setSelectedItem(this.mBackGroundScene.mName);
        --this.mClassSetting;
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.readAllToCurrent();
        this.mBackGroundScenePool.remove(this.mBackGroundScene);
        this.mBackGroundScenePool.save();
        ++this.mClassSetting;
        this.resetConfigPool(true);
        if (this.jComboBoxName.getSelectedIndex() == -1) {
            this.clearAll();
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mBackGroundScene = this.mBackGroundScenePool.get(key);
        this.setAllFromCurrent();
        --this.mClassSetting;
    }

    private void jComboBoxNameActionPerformed(ActionEvent evt) {
        if (this.mClassSetting > 0) {
            return;
        }
        String key = this.jComboBoxName.getSelectedItem().toString();
        this.mBackGroundScene = this.mBackGroundScenePool.get(key);
        this.setAllFromCurrent();
    }

    private void jTextFieldXposFocusLost(FocusEvent evt) {
    }

    private void jTextFieldXposActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldYposFocusLost(FocusEvent evt) {
    }

    private void jTextFieldYposActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldScaleFocusLost(FocusEvent evt) {
    }

    private void jTextFieldScaleActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldIntensityFocusLost(FocusEvent evt) {
    }

    private void jTextFieldIntensityActionPerformed(ActionEvent evt) {
    }

    private void jTextFieldAnimationNameActionPerformed(ActionEvent evt) {
    }

    private void jButtonLoad2ActionPerformed(ActionEvent evt) {
        this.loadAnimation();
    }

    boolean loadAnimation() {
        String filename = Global.mainPathPrefix + "xml" + File.separator + "vectoranimation";
        filename = VectorListFileChoserJPanel.showSavePanel(filename, "Load Vector-Animation", true);
        return this.loadAnimationFromElement(filename);
    }

    boolean loadAnimationFromElement(String loadName) {
        boolean ok = false;
        if (loadName != null) {
            if (!loadName.toUpperCase().endsWith(".XML")) {
                loadName = loadName + ".xml";
            }
            GFXVectorAnimation anim = new GFXVectorAnimation();
            ok = anim.loadFromXML(loadName);
            GFXVectorList vl = new GFXVectorList();
            for (int i = 0; i < anim.size(); ++i) {
                vl.add(anim.get(i));
            }
            vl.connectWherePossible(false);
            vl.resetDisplay();
            this.actionAnimation.setForegroundVectorList(vl);
            this.actionAnimation.setDelay(-1);
            if (ok && this.inGuiUpdate == 0) {
                this.readAllToCurrent();
            }
        }
        loadName = Utility.makeVideRelative(loadName);
        this.jTextFieldAnimationName.setText(loadName);
        return ok;
    }

    public GFXVectorAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public void setCurrentAnimation(GFXVectorAnimation currentAnimation) {
        this.currentAnimation = currentAnimation;
        this.actionAnimation.setAnimation(currentAnimation);
        this.actionAnimation.setDelay(50);
    }

    private void jSliderSourceScale1StateChanged(ChangeEvent evt) {
        int value = this.jSliderSourceScale1.getValue();
        int max = this.jSliderSourceScale1.getMaximum();
        double scale = value - (max - 1) / 2;
        if (value < max / 2 + 1) {
            int invScale;
            scale = (invScale = max / 2 - --value) == 0 ? 1.0 : 1.0 / (double)invScale;
        }
        if (scale > 1.0) {
            scale -= 0.75;
        }
        if (scale > 2.0) {
            scale -= 0.5;
        }
        if (scale > 2.5) {
            scale -= 0.25;
        }
        if (scale > 2.75) {
            scale -= 0.5;
        }
        this.actionAnimation.setScale(scale);
    }
}

